/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATermAppl;
import java.util.Arrays;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.utils.ATermUtils;

public abstract class WME {
    public abstract Node getArg(int var1);

    public abstract DependencySet getDepends();

    public boolean dependsOn(int branch) {
        return this.getDepends().max() > branch;
    }

    public abstract Kind getKind();

    public static TypeWME createType(Individual arg, ATermAppl type, DependencySet depends) {
        return new TypeWME(arg, type, depends);
    }

    public static DiffFrom createDiffFrom(Individual subject, Individual object, DependencySet depends) {
        return new DiffFrom(subject, object, depends);
    }

    public static WME createEdge(Edge edge) {
        return new EdgeWME(edge, EdgeDirection.FORWARD);
    }

    public static WME createEdge(Edge edge, EdgeDirection dir) {
        return new EdgeWME(edge, dir);
    }

    public static WME createBuiltin(Literal[] literals, DependencySet ds) {
        return new BuiltinWME(literals, ds);
    }

    public static enum EdgeDirection {
        FORWARD,
        BACKWARD,
        BOTH;

    }

    public static class BuiltinWME
    extends WME {
        private final Literal[] literals;
        private final DependencySet depends;

        public BuiltinWME(Literal[] literals, DependencySet depends) {
            this.literals = literals;
            this.depends = depends;
        }

        @Override
        public Kind getKind() {
            return Kind.BUILT_IN;
        }

        @Override
        public Node getArg(int index) {
            return this.literals[index];
        }

        @Override
        public DependencySet getDepends() {
            return this.depends;
        }

        public String toString() {
            return (Object)((Object)this.getKind()) + Arrays.toString(this.literals);
        }
    }

    public static class EdgeWME
    extends WME {
        private final Edge edge;
        private final EdgeDirection dir;

        public EdgeWME(Edge edge, EdgeDirection dir) {
            if (dir == null || dir == EdgeDirection.BOTH) {
                throw new IllegalArgumentException();
            }
            this.edge = edge;
            this.dir = dir;
        }

        @Override
        public Kind getKind() {
            return Kind.EDGE;
        }

        @Override
        public Node getArg(int index) {
            assert (index == 0 || index == 1);
            return index == (this.dir == EdgeDirection.FORWARD ? 0 : 1) ? this.edge.getFrom() : this.edge.getTo();
        }

        @Override
        public DependencySet getDepends() {
            return this.edge.getDepends();
        }

        public String toString() {
            boolean isFwd = this.dir == EdgeDirection.FORWARD;
            return String.format("%s%s-%s-%s%s %s", this.edge.getFrom(), isFwd ? "" : "<", this.edge.getRole(), isFwd ? ">" : "", this.edge.getTo(), this.edge.getDepends());
        }
    }

    public static class DiffFrom
    extends BinaryWME {
        public DiffFrom(Individual subject, Individual object, DependencySet depends) {
            super(subject, object, depends);
        }

        @Override
        public Kind getKind() {
            return Kind.DIFF_FROM;
        }
    }

    public static class SameAs
    extends BinaryWME {
        public SameAs(Individual subject, Individual object, DependencySet depends) {
            super(subject, object, depends);
        }

        @Override
        public Kind getKind() {
            return Kind.SAME_AS;
        }
    }

    public static class TypeWME
    extends AbstractWME {
        private final ATermAppl type;

        public TypeWME(Individual subject, ATermAppl type, DependencySet depends) {
            super(subject, depends);
            this.type = type;
        }

        @Override
        public Kind getKind() {
            return Kind.TYPE;
        }

        @Override
        public Node getArg(int index) {
            assert (index == 0);
            return this.subject;
        }

        public String toString() {
            return ATermUtils.toString(this.type) + "(" + this.subject + ")";
        }
    }

    private static abstract class BinaryWME
    extends AbstractWME {
        private final Individual object;

        public BinaryWME(Individual subject, Individual object, DependencySet depends) {
            super(subject, depends);
            this.object = object;
        }

        @Override
        public Node getArg(int index) {
            assert (index == 0 || index == 1);
            return index == 0 ? this.subject : this.object;
        }

        public String toString() {
            return (Object)((Object)this.getKind()) + "(" + this.subject + ", " + this.object + ")";
        }
    }

    private static abstract class AbstractWME
    extends WME {
        protected final Individual subject;
        private final DependencySet depends;

        public AbstractWME(Individual subject, DependencySet depends) {
            this.subject = subject;
            this.depends = depends;
        }

        @Override
        public DependencySet getDepends() {
            return this.depends;
        }
    }

    public static enum Kind {
        TYPE,
        EDGE,
        SAME_AS,
        DIFF_FROM,
        BUILT_IN;

    }
}

