/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.ATermAppl;
import com.clarkparsia.pellet.el.ConceptInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.ATermUtils;

class ELTaxonomyBuilder {
    private Taxonomy<ATermAppl> taxonomy;

    ELTaxonomyBuilder() {
    }

    public Taxonomy<ATermAppl> build(Map<ATermAppl, ConceptInfo> concepts) {
        this.taxonomy = new Taxonomy<ATermAppl>(null, ATermUtils.TOP, ATermUtils.BOTTOM);
        for (ConceptInfo ci : concepts.get(ATermUtils.TOP).getSuperClasses()) {
            ATermAppl eq = ci.getConcept();
            if (!ATermUtils.isPrimitive(eq)) continue;
            this.taxonomy.addEquivalentNode(eq, this.taxonomy.getTop());
        }
        ConceptInfo BOTTOM = concepts.get(ATermUtils.BOTTOM);
        for (ConceptInfo ci : concepts.values()) {
            ATermAppl c = ci.getConcept();
            if (!ATermUtils.isPrimitive(c)) continue;
            if (ci.getSuperClasses().contains(BOTTOM)) {
                this.taxonomy.addEquivalentNode(c, this.taxonomy.getBottom());
                continue;
            }
            this.classify(ci);
        }
        return this.taxonomy;
    }

    private TaxonomyNode<ATermAppl> classify(ConceptInfo ci) {
        ATermAppl c = ci.getConcept();
        TaxonomyNode<ATermAppl> node = this.taxonomy.getNode(c);
        if (node == null) {
            HashSet<ConceptInfo> equivalents = new HashSet<ConceptInfo>();
            HashSet<TaxonomyNode<ATermAppl>> subsumers = new HashSet<TaxonomyNode<ATermAppl>>();
            for (ConceptInfo subsumer : ci.getSuperClasses()) {
                if (!ATermUtils.isPrimitive(subsumer.getConcept()) || ci.equals(subsumer)) continue;
                if (subsumer.hasSuperClass(ci)) {
                    equivalents.add(subsumer);
                    continue;
                }
                TaxonomyNode<ATermAppl> supNode = this.classify(subsumer);
                if (supNode == null) continue;
                subsumers.add(supNode);
            }
            node = this.add(ci, subsumers);
            for (ConceptInfo eqInfo : equivalents) {
                ATermAppl eq = eqInfo.getConcept();
                this.taxonomy.addEquivalentNode(eq, node);
            }
        }
        return node;
    }

    private TaxonomyNode<ATermAppl> add(ConceptInfo ci, Set<TaxonomyNode<ATermAppl>> subsumers) {
        ATermAppl c = ci.getConcept();
        HashSet<TaxonomyNode<ATermAppl>> parents = new HashSet<TaxonomyNode<ATermAppl>>(subsumers);
        HashSet<Object> supers = new HashSet<Object>();
        Set<ATermAppl> subs = Collections.singleton(ATermUtils.BOTTOM);
        for (TaxonomyNode<ATermAppl> taxonomyNode : subsumers) {
            parents.removeAll(taxonomyNode.getSupers());
        }
        for (TaxonomyNode<Object> taxonomyNode : parents) {
            supers.add(taxonomyNode.getName());
            taxonomyNode.removeSub(this.taxonomy.getBottom());
        }
        return this.taxonomy.addNode(Collections.singleton(c), supers, subs, false);
    }
}

