/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.lang.ref.WeakReference;
import shared.SharedObject;
import shared.SharedObjectWithID;

public class SharedObjectFactory {
    private static final int DEFAULT_NR_OF_SEGMENTS_BITSIZE = 5;
    private final Segment[] segments = new Segment[32];

    public SharedObjectFactory() {
        for (int i = this.segments.length - 1; i >= 0; --i) {
            this.segments[i] = new Segment(i);
        }
    }

    public SharedObjectFactory(int initialLogSize) {
        this();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        for (int i = this.segments.length - 1; i >= 0; --i) {
            Segment segment;
            Segment segment2 = segment = this.segments[i];
            synchronized (segment2) {
                segment.cleanup();
                continue;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int nrOfSegments = this.segments.length;
        for (int i = 0; i < nrOfSegments; ++i) {
            int startHash = i << 27;
            int endHash = (i + 1 << 27) - 1;
            sb.append("Segment hash range: ");
            sb.append(startHash);
            sb.append(" till ");
            sb.append(endHash);
            sb.append(" | ");
            sb.append(this.segments[i].toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public SharedObject build(SharedObject prototype) {
        int hash = prototype.hashCode();
        int segmentNr = hash >>> 27;
        return this.segments[segmentNr].get(prototype, hash);
    }

    public boolean contains(SharedObject object) {
        int hash = object.hashCode();
        int segmentNr = hash >>> 27;
        return this.segments[segmentNr].contains(object, hash);
    }

    private static final class Segment {
        private static final int MAX_SEGMENT_BITSIZE = 27;
        private static final int DEFAULT_SEGMENT_BITSIZE = 5;
        private static final float DEFAULT_LOAD_FACTOR = 2.0f;
        private volatile Entry[] entries;
        private int bitSize;
        private int threshold;
        private int load;
        private volatile boolean flaggedForCleanup;
        private volatile WeakReference<GarbageCollectionDetector> garbageCollectionDetector;
        private int cleanupScaler;
        private int cleanupThreshold;
        private final int segmentID;
        private int numberOfFreeIDs;
        private int[] freeIDs;
        private int freeIDsIndex;
        private int nextFreeID;
        private final int maxFreeIDPlusOne;

        public Segment(int segmentID) {
            this.segmentID = segmentID;
            this.bitSize = 5;
            int nrOfEntries = 1 << this.bitSize;
            this.entries = new Entry[nrOfEntries];
            this.threshold = (int)((float)nrOfEntries * 2.0f);
            this.load = 0;
            this.flaggedForCleanup = false;
            this.garbageCollectionDetector = new WeakReference<GarbageCollectionDetector>(new GarbageCollectionDetector(this));
            this.cleanupThreshold = this.cleanupScaler = 50;
            this.numberOfFreeIDs = 1 << this.bitSize;
            this.freeIDs = new int[this.numberOfFreeIDs];
            this.freeIDsIndex = 0;
            this.nextFreeID = segmentID << 27;
            this.maxFreeIDPlusOne = segmentID + 1 << 27;
        }

        private void cleanup() {
            Entry[] table = this.entries;
            int newLoad = this.load;
            for (int i = this.entries.length - 1; i >= 0; --i) {
                Entry next;
                Entry e = table[i];
                if (e == null) continue;
                Entry previous = null;
                do {
                    next = e.next;
                    if (e.get() == null) {
                        if (previous == null) {
                            table[i] = next;
                        } else {
                            previous.next = next;
                        }
                        --newLoad;
                        if (!(e instanceof EntryWithID)) continue;
                        EntryWithID ewid = (EntryWithID)e;
                        this.releaseID(ewid.id);
                        continue;
                    }
                    previous = e;
                } while ((e = next) != null);
            }
            this.load = newLoad;
            this.entries = table;
        }

        private void rehash() {
            int nrOfEntries = 1 << ++this.bitSize;
            int newHashMask = nrOfEntries - 1;
            Entry[] oldEntries = this.entries;
            Entry[] newEntries = new Entry[nrOfEntries];
            Entry currentEntryRoot = new Entry(null, null, 0);
            Entry shiftedEntryRoot = new Entry(null, null, 0);
            int newLoad = this.load;
            int oldSize = oldEntries.length;
            for (int i = oldSize - 1; i >= 0; --i) {
                Entry e = oldEntries[i];
                if (e == null) continue;
                Entry lastCurrentEntry = currentEntryRoot;
                Entry lastShiftedEntry = shiftedEntryRoot;
                do {
                    if (e.get() != null) {
                        int position = e.hash & newHashMask;
                        if (position == i) {
                            lastCurrentEntry.next = e;
                            lastCurrentEntry = e;
                            continue;
                        }
                        lastShiftedEntry.next = e;
                        lastShiftedEntry = e;
                        continue;
                    }
                    --newLoad;
                    if (!(e instanceof EntryWithID)) continue;
                    EntryWithID ewid = (EntryWithID)e;
                    this.releaseID(ewid.id);
                } while ((e = e.next) != null);
                lastCurrentEntry.next = null;
                lastShiftedEntry.next = null;
                newEntries[i] = currentEntryRoot.next;
                newEntries[i | oldSize] = shiftedEntryRoot.next;
            }
            this.load = newLoad;
            this.threshold <<= 1;
            this.entries = newEntries;
        }

        private void ensureCapacity() {
            if (this.load > this.threshold && this.bitSize < 27) {
                this.rehash();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryCleanup() {
            if (this.flaggedForCleanup) {
                Segment segment = this;
                synchronized (segment) {
                    if (this.garbageCollectionDetector == null) {
                        this.flaggedForCleanup = false;
                        if (this.cleanupThreshold > 8) {
                            int oldLoad = this.load;
                            this.cleanup();
                            int cleanupPercentate = oldLoad == 0 ? 50 : 100 - this.load * 100 / oldLoad;
                            this.cleanupScaler = this.cleanupScaler * 25 + cleanupPercentate * 7 >> 5;
                            this.cleanupThreshold = this.cleanupScaler > 0 ? this.cleanupScaler : 1;
                        } else {
                            this.cleanupThreshold <<= 1;
                        }
                        this.garbageCollectionDetector = new WeakReference<GarbageCollectionDetector>(new GarbageCollectionDetector(this));
                    }
                }
            }
        }

        private void put(SharedObject object, int hash) {
            Entry[] table = this.entries;
            int hashMask = table.length - 1;
            int position = hash & hashMask;
            Entry next = table[position];
            if (object instanceof SharedObjectWithID) {
                SharedObjectWithID sharedObjectWithID = (SharedObjectWithID)object;
                int id = this.generateID();
                sharedObjectWithID.setUniqueIdentifier(id);
                table[position] = new EntryWithID(next, sharedObjectWithID, hash, id);
            } else {
                table[position] = new Entry(next, object, hash);
            }
            ++this.load;
            this.entries = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(SharedObject prototype, int hash) {
            Entry[] currentEntries = this.entries;
            int hashMask = currentEntries.length - 1;
            int position = hash & hashMask;
            Entry e = currentEntries[position];
            if (e != null) {
                do {
                    if (e.get() != prototype) continue;
                    return true;
                } while ((e = e.next) != null);
            }
            Segment segment = this;
            synchronized (segment) {
                currentEntries = this.entries;
                hashMask = currentEntries.length - 1;
                position = hash & hashMask;
                e = currentEntries[position];
                if (e != null) {
                    do {
                        if (e.get() != prototype) continue;
                        return true;
                    } while ((e = e.next) != null);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final SharedObject get(SharedObject prototype, int hash) {
            this.tryCleanup();
            Entry[] currentEntries = this.entries;
            int hashMask = currentEntries.length - 1;
            int position = hash & hashMask;
            Entry e = currentEntries[position];
            if (e != null) {
                do {
                    SharedObject object;
                    if (hash != e.hash || (object = (SharedObject)e.get()) == null || !prototype.equivalent(object)) continue;
                    return object;
                } while ((e = e.next) != null);
            }
            Segment segment = this;
            synchronized (segment) {
                currentEntries = this.entries;
                hashMask = currentEntries.length - 1;
                position = hash & hashMask;
                e = currentEntries[position];
                if (e != null) {
                    do {
                        SharedObject object;
                        if (hash != e.hash || (object = (SharedObject)e.get()) == null || !prototype.equivalent(object)) continue;
                        return object;
                    } while ((e = e.next) != null);
                }
                this.ensureCapacity();
                SharedObject result = prototype.duplicate();
                this.put(result, hash);
                return result;
            }
        }

        private int generateID() {
            if (this.freeIDsIndex > 0) {
                if (this.freeIDsIndex < this.numberOfFreeIDs >> 2 && this.numberOfFreeIDs > 32) {
                    int newNumberOfFreeIDs = this.numberOfFreeIDs >> 1;
                    int[] newFreeIds = new int[newNumberOfFreeIDs];
                    System.arraycopy(this.freeIDs, 0, newFreeIds, 0, newNumberOfFreeIDs);
                    this.freeIDs = newFreeIds;
                    this.numberOfFreeIDs = newNumberOfFreeIDs;
                }
                return this.freeIDs[--this.freeIDsIndex];
            }
            if (this.nextFreeID != this.maxFreeIDPlusOne) {
                return this.nextFreeID++;
            }
            this.cleanup();
            if (this.freeIDsIndex > 0) {
                return this.freeIDs[--this.freeIDsIndex];
            }
            throw new RuntimeException("No more unique identifiers available for segment(" + this.segmentID + ").");
        }

        private void releaseID(int id) {
            if (this.freeIDsIndex == this.numberOfFreeIDs) {
                int newNumberOfFreeIDs = this.numberOfFreeIDs << 1;
                int[] newFreeIds = new int[newNumberOfFreeIDs];
                System.arraycopy(this.freeIDs, 0, newFreeIds, 0, this.numberOfFreeIDs);
                this.freeIDs = newFreeIds;
                this.numberOfFreeIDs = newNumberOfFreeIDs;
            }
            this.freeIDs[this.freeIDsIndex++] = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Segment segment = this;
            synchronized (segment) {
                Entry[] table = this.entries;
                int tableSize = table.length;
                sb.append("Table size: ");
                sb.append(tableSize);
                sb.append(", ");
                sb.append("Number of entries: ");
                sb.append(this.load);
                sb.append(", ");
                sb.append("Threshold: ");
                sb.append(this.threshold);
                sb.append(", ");
                int nrOfFilledBuckets = 0;
                int totalNrOfCollisions = 0;
                int maxBucketLength = 0;
                for (int i = 0; i < tableSize; ++i) {
                    Entry e = table[i];
                    if (e == null) continue;
                    ++nrOfFilledBuckets;
                    int bucketLength = 1;
                    while ((e = e.next) != null) {
                        ++bucketLength;
                    }
                    if (bucketLength > maxBucketLength) {
                        maxBucketLength = bucketLength;
                    }
                    totalNrOfCollisions += bucketLength - 1;
                }
                double averageBucketLength = 0.0;
                double distribution = 100.0;
                if (nrOfFilledBuckets != 0) {
                    averageBucketLength = (double)(totalNrOfCollisions * 1000 / nrOfFilledBuckets) / 1000.0 + 1.0;
                    distribution = 100.0 - (double)((float)(totalNrOfCollisions * 1000 / nrOfFilledBuckets) / 2.0f) / 10.0;
                }
                sb.append("Number of filled buckets: ");
                sb.append(nrOfFilledBuckets);
                sb.append(", ");
                sb.append("Load factor: ");
                sb.append(2.0f);
                sb.append(", ");
                sb.append("Distribution (collisions vs filled buckets): ");
                sb.append(distribution);
                sb.append("%, ");
                sb.append("Total number of collisions: ");
                sb.append(totalNrOfCollisions);
                sb.append(", ");
                sb.append("Average (filled) bucket length: ");
                sb.append(averageBucketLength);
                sb.append(", ");
                sb.append("Maximal bucket length: ");
                sb.append(maxBucketLength);
                sb.append(", ");
                sb.append("Cleanup scaler: ");
                sb.append(this.cleanupScaler);
                sb.append("%");
            }
            return sb.toString();
        }

        private static class EntryWithID
        extends Entry {
            public final int id;

            public EntryWithID(Entry next, SharedObjectWithID sharedObjectWithID, int hash, int id) {
                super(next, sharedObjectWithID, hash);
                this.id = id;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Entry
        extends WeakReference<SharedObject> {
            public final int hash;
            public volatile Entry next;

            public Entry(Entry next, SharedObject sharedObject, int hash) {
                super(sharedObject);
                this.next = next;
                this.hash = hash;
            }
        }

        private static class GarbageCollectionDetector {
            private Segment segment;

            public GarbageCollectionDetector(Segment segment) {
                this.segment = segment;
            }

            public void finalize() {
                this.segment.garbageCollectionDetector = null;
                this.segment.flaggedForCleanup = true;
            }
        }
    }
}

