/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.axiom;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellint.format.CompactClassLintFormat;
import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.lintpattern.axiom.AxiomLintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFixer;
import java.util.Collections;
import java.util.HashSet;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;

public class EquivalentToTopPattern
extends AxiomLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new CompactClassLintFormat();

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getDescription() {
        return "Top is equivalent to some concept or is part of an equivalent classes axiom";
    }

    @Override
    public boolean isFixable() {
        return true;
    }

    @Override
    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (axiom.getClassExpressions().contains(OWL.Thing)) {
            Lint lint = this.makeLint();
            lint.addParticipatingAxiom((OWLClassAxiom)axiom);
            LintFixer fixer = new LintFixer(Collections.singleton(axiom), new HashSet());
            lint.setLintFixer(fixer);
            this.setLint(lint);
        }
    }
}

