/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermBlob;
import aterm.ATermList;
import aterm.ATermPlaceholder;
import aterm.Visitable;
import aterm.Visitor;
import aterm.pure.ATermImpl;
import aterm.pure.PureFactory;
import java.util.List;
import jjtraveler.VisitFailure;
import shared.HashFunctions;
import shared.SharedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATermBlobImpl
extends ATermImpl
implements ATermBlob {
    private byte[] data;

    protected ATermBlobImpl(PureFactory factory) {
        super(factory);
    }

    protected ATermBlobImpl(PureFactory factory, ATermList annos, byte[] data) {
        super(factory, annos);
        this.data = data;
        this.setHashCode(HashFunctions.doobs((Object[])new Object[]{annos, data}));
    }

    @Override
    public int getType() {
        return 6;
    }

    protected void init(int hashCode, ATermList annos, byte[] data) {
        super.init(hashCode, annos);
        this.data = data;
    }

    public SharedObject duplicate() {
        return this;
    }

    public boolean equivalent(SharedObject obj) {
        if (obj instanceof ATermBlob) {
            ATermBlob peer = (ATermBlob)obj;
            if (peer.getType() != this.getType()) {
                return false;
            }
            return peer.getBlobData() == this.data && peer.getAnnotations().equals(this.getAnnotations());
        }
        return false;
    }

    @Override
    protected boolean match(ATerm pattern, List<Object> list) {
        ATermAppl appl;
        AFun afun;
        ATerm type;
        if (this.equals(pattern)) {
            return true;
        }
        if (pattern.getType() == 5 && (type = ((ATermPlaceholder)pattern).getPlaceholder()).getType() == 1 && (afun = (appl = (ATermAppl)type).getAFun()).getName().equals("blob") && afun.getArity() == 0 && !afun.isQuoted()) {
            list.add(this.data);
            return true;
        }
        return super.match(pattern, list);
    }

    @Override
    public byte[] getBlobData() {
        return this.data;
    }

    @Override
    public int getBlobSize() {
        return this.data.length;
    }

    @Override
    public ATerm setAnnotations(ATermList annos) {
        return this.getPureFactory().makeBlob(this.data, annos);
    }

    @Override
    public Visitable accept(Visitor v) throws VisitFailure {
        return v.visitBlob(this);
    }
}

