/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.model;

import com.clarkparsia.pellet.sparqldl.model.Filter;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;

public class MultiFilterWrapper
implements Filter {
    private FilterType type;
    private Filter[] filters;

    private MultiFilterWrapper(FilterType m, Filter ... filters) {
        this.type = m;
        this.filters = filters;
    }

    @Override
    public boolean accept(ResultBinding binding) {
        switch (this.type) {
            case AND: {
                for (Filter f : this.filters) {
                    if (f.accept(binding)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (Filter f : this.filters) {
                    if (!f.accept(binding)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("Filter type not supported : " + (Object)((Object)this.type));
    }

    public static Filter and(Filter ... filters) {
        return new MultiFilterWrapper(FilterType.AND, filters);
    }

    public static Filter or(Filter ... filters) {
        return new MultiFilterWrapper(FilterType.OR, filters);
    }

    private static enum FilterType {
        AND,
        OR;

    }
}

