/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.jena;

import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.jena.SlicedResultSet;
import com.clarkparsia.pellet.sparqldl.jena.SortedResultSet;
import com.clarkparsia.pellet.sparqldl.jena.SparqlDLResultSet;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryParameters;
import com.clarkparsia.pellet.sparqldl.parser.ARQParser;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.jena.PelletInfGraph;

class SparqlDLExecution
implements QueryExecution {
    public static Logger log = Logger.getLogger(SparqlDLExecution.class.getName());
    private com.hp.hpl.jena.query.Query query;
    private Dataset source;
    private QuerySolution initialBinding;
    private boolean purePelletQueryExec = false;
    private boolean handleVariableSPO = true;

    public SparqlDLExecution(String query, Model source) {
        this(QueryFactory.create((String)query), source);
    }

    public SparqlDLExecution(com.hp.hpl.jena.query.Query query, Model source) {
        this(query, DatasetFactory.create((Model)source));
    }

    public SparqlDLExecution(com.hp.hpl.jena.query.Query query, Dataset source) {
        this(query, source, true);
    }

    public SparqlDLExecution(com.hp.hpl.jena.query.Query query, Dataset source, boolean handleVariableSPO) {
        this.query = query;
        this.source = source;
        this.handleVariableSPO = handleVariableSPO;
        Graph graph = source.getDefaultModel().getGraph();
        if (!(graph instanceof PelletInfGraph)) {
            throw new QueryException("PelletQueryExecution can only be used with Pellet-backed models");
        }
        if (PelletOptions.FULL_SIZE_ESTIMATE) {
            ((PelletInfGraph)graph).getKB().getSizeEstimate().computeAll();
        }
    }

    public Model execDescribe() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public Model execDescribe(Model model) {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public Model execConstruct() {
        Model model = ModelFactory.createDefaultModel();
        this.execConstruct(model);
        return model;
    }

    public Model execConstruct(Model model) {
        this.ensureQueryType(QueryType.CONSTRUCT);
        ResultSet results = this.exec();
        if (results == null) {
            QueryExecutionFactory.create((com.hp.hpl.jena.query.Query)this.query, (Dataset)this.source, (QuerySolution)this.initialBinding).execConstruct(model);
        } else {
            model.setNsPrefixes((PrefixMapping)this.source.getDefaultModel());
            model.setNsPrefixes(this.query.getPrefixMapping());
            HashSet set = new HashSet();
            Template template = this.query.getConstructTemplate();
            while (results.hasNext()) {
                HashMap bNodeMap = new HashMap();
                Binding binding = results.nextBinding();
                template.subst(set, bNodeMap, binding);
            }
            for (Triple t : set) {
                Statement stmt = ModelUtils.tripleToStatement((Model)model, (Triple)t);
                if (stmt == null) continue;
                model.add(stmt);
            }
            this.close();
        }
        return model;
    }

    public boolean execAsk() {
        this.ensureQueryType(QueryType.ASK);
        ResultSet results = this.exec();
        return results != null ? results.hasNext() : QueryExecutionFactory.create((com.hp.hpl.jena.query.Query)this.query, (Dataset)this.source, (QuerySolution)this.initialBinding).execAsk();
    }

    public ResultSet execSelect() {
        this.ensureQueryType(QueryType.SELECT);
        ResultSet results = this.exec();
        return results != null ? results : QueryExecutionFactory.create((com.hp.hpl.jena.query.Query)this.query, (Dataset)this.source, (QuerySolution)this.initialBinding).execSelect();
    }

    private ResultSet exec() {
        try {
            if (this.source.listNames().hasNext()) {
                throw new UnsupportedQueryException("Named graphs is not supported by Pellet");
            }
            PelletInfGraph pelletInfGraph = (PelletInfGraph)this.source.getDefaultModel().getGraph();
            KnowledgeBase kb = pelletInfGraph.getKB();
            pelletInfGraph.prepare();
            QueryParameters queryParameters = new QueryParameters(this.initialBinding);
            ARQParser parser = new ARQParser(this.handleVariableSPO);
            parser.setInitialBinding(this.initialBinding);
            Query q = parser.parse(this.query, kb);
            q.setQueryParameters(queryParameters);
            Object results = new SparqlDLResultSet(QueryEngine.exec(q), this.source.getDefaultModel(), queryParameters);
            List sortConditions = this.query.getOrderBy();
            if (sortConditions != null && !sortConditions.isEmpty()) {
                results = new SortedResultSet((ResultSet)results, sortConditions);
            }
            if (this.query.hasOffset() || this.query.hasLimit()) {
                long offset = this.query.hasOffset() ? this.query.getOffset() : 0L;
                long limit = this.query.hasLimit() ? this.query.getLimit() : Long.MAX_VALUE;
                results = new SlicedResultSet((ResultSet)results, offset, limit);
            }
            return results;
        }
        catch (UnsupportedQueryException e) {
            log.log(this.purePelletQueryExec ? Level.INFO : Level.FINE, "This is not a SPARQL-DL query: " + e.getMessage());
            if (this.purePelletQueryExec) {
                throw e;
            }
            log.fine("Falling back to Jena query engine");
            return null;
        }
    }

    public void abort() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public void close() {
        log.fine("Closing PelletQueryExecution '" + this.hashCode() + "'.");
    }

    public void setInitialBinding(QuerySolution startSolution) {
        this.initialBinding = startSolution;
    }

    public Context getContext() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public Dataset getDataset() {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    private void ensureQueryType(QueryType expectedType) throws QueryExecException {
        QueryType actualType = SparqlDLExecution.getQueryType(this.query);
        if (actualType != expectedType) {
            throw new QueryExecException("Attempt to execute a " + (Object)((Object)actualType) + " query as a " + (Object)((Object)expectedType) + " query");
        }
    }

    private static QueryType getQueryType(com.hp.hpl.jena.query.Query query) {
        if (query.isSelectType()) {
            return QueryType.SELECT;
        }
        if (query.isConstructType()) {
            return QueryType.CONSTRUCT;
        }
        if (query.isDescribeType()) {
            return QueryType.DESCRIBE;
        }
        if (query.isAskType()) {
            return QueryType.ASK;
        }
        return null;
    }

    public boolean isPurePelletQueryExec() {
        return this.purePelletQueryExec;
    }

    public void setPurePelletQueryExec(boolean purePelletQueryExec) {
        this.purePelletQueryExec = purePelletQueryExec;
    }

    public Iterator<Triple> execConstructTriples() {
        return ModelUtils.statementsToTriples((Iterator)this.execConstruct().listStatements());
    }

    public Iterator<Triple> execDescribeTriples() {
        return ModelUtils.statementsToTriples((Iterator)this.execDescribe().listStatements());
    }

    public com.hp.hpl.jena.query.Query getQuery() {
        return this.query;
    }

    public long getTimeout1() {
        return -1L;
    }

    public long getTimeout2() {
        return -1L;
    }

    public void setTimeout(long arg0) {
    }

    public void setTimeout(long arg0, TimeUnit arg1) {
    }

    public void setTimeout(long arg0, long arg1) {
    }

    public void setTimeout(long arg0, TimeUnit arg1, long arg2, TimeUnit arg3) {
    }

    public boolean isClosed() {
        return false;
    }

    private static enum QueryType {
        ASK,
        CONSTRUCT,
        DESCRIBE,
        SELECT;

    }
}

