/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.List;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;

public class QuerySubsumption {
    public static boolean isEquivalentTo(Query q1, Query q2) {
        return QuerySubsumption.isSubsumedBy(q1, q2) && QuerySubsumption.isSubsumedBy(q2, q1);
    }

    public static boolean isSubsumedBy(Query sub, Query sup) {
        return !QuerySubsumption.getSubsumptionMappings(sub, sup).isEmpty();
    }

    public static QueryResult getSubsumptionMappings(Query sub, Query sup) {
        KnowledgeBase kb = sup.getKB().copy(true);
        List<QueryAtom> queryAtoms = sub.getAtoms();
        block6: for (QueryAtom queryAtom : queryAtoms) {
            List<ATermAppl> arguments = queryAtom.getArguments();
            ATermAppl ind1 = null;
            ATermAppl ind2 = null;
            ATermAppl pr = null;
            ATermAppl cl = null;
            switch (queryAtom.getPredicate()) {
                case Type: {
                    ind1 = TermFactory.term((String)arguments.get(0).toString());
                    cl = arguments.get(1);
                    kb.addIndividual(ind1);
                    kb.addType(ind1, cl);
                    continue block6;
                }
                case PropertyValue: {
                    ind1 = TermFactory.term((String)arguments.get(0).toString());
                    pr = arguments.get(1);
                    ind2 = TermFactory.term((String)arguments.get(2).toString());
                    kb.addIndividual(ind1);
                    kb.addIndividual(ind2);
                    kb.addPropertyValue(pr, ind1, ind2);
                    continue block6;
                }
                case SameAs: {
                    ind1 = TermFactory.term((String)arguments.get(0).toString());
                    ind2 = TermFactory.term((String)arguments.get(1).toString());
                    kb.addIndividual(ind1);
                    kb.addIndividual(ind2);
                    kb.addSame(ind1, ind2);
                    continue block6;
                }
                case DifferentFrom: {
                    ind1 = TermFactory.term((String)arguments.get(0).toString());
                    ind2 = TermFactory.term((String)arguments.get(1).toString());
                    kb.addIndividual(ind1);
                    kb.addIndividual(ind2);
                    kb.addDifferent(ind1, ind2);
                    continue block6;
                }
            }
            throw new UnsupportedQueryException("Unsupported atom type : " + queryAtom.getPredicate().toString());
        }
        kb.isConsistent();
        sup.setKB(kb);
        QueryResult results = QueryEngine.exec(sup);
        sup.setKB(sup.getKB());
        return results;
    }
}

