/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MultiIterator<T>
implements Iterator<T> {
    private List<Iterator<? extends T>> list = new ArrayList<Iterator<? extends T>>(2);
    private int index = 0;
    private Iterator<? extends T> curr;

    public MultiIterator(Iterator<? extends T> first) {
        this.curr = first;
    }

    public MultiIterator(Iterator<? extends T> first, Iterator<? extends T> second) {
        this.curr = first;
        this.list.add(second);
    }

    @Override
    public boolean hasNext() {
        while (!this.curr.hasNext() && this.index < this.list.size()) {
            this.curr = this.list.get(this.index++);
        }
        return this.curr.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("multi iterator");
        }
        return this.curr.next();
    }

    public void append(Iterator<? extends T> other) {
        if (other.hasNext()) {
            if (other instanceof MultiIterator) {
                this.list.addAll(((MultiIterator)other).list);
            } else {
                this.list.add(other);
            }
        }
    }

    @Override
    public void remove() {
        this.curr.remove();
    }
}

