/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.PartialOrderComparator;

public class PartialOrderBuilder<T> {
    private static final boolean CHILDREN_SEARCH = false;
    private static final boolean PARENTS_SEARCH = true;
    private PartialOrderComparator<T> comparator;
    private Taxonomy<T> taxonomy;

    public static <T> Taxonomy<T> build(Collection<? extends T> elements, PartialOrderComparator<T> comparator) {
        return PartialOrderBuilder.build(elements, comparator, null, null);
    }

    public static <T> Taxonomy<T> build(Collection<? extends T> elements, PartialOrderComparator<T> comparator, T top, T bottom) {
        Taxonomy<T> hierarchy = new Taxonomy<T>(null, top, bottom);
        PartialOrderBuilder<? extends T> builder = new PartialOrderBuilder<T>(hierarchy, comparator);
        builder.addAll(elements);
        return hierarchy;
    }

    public PartialOrderBuilder(Taxonomy<T> taxonomy, PartialOrderComparator<T> comparator) {
        this.taxonomy = taxonomy;
        this.comparator = comparator;
    }

    public void add(T toAdd) {
        this.add(toAdd, false);
    }

    public void add(T toAdd, boolean hidden) {
        Set<T> elements = this.taxonomy.getClasses();
        int nElements = elements.size();
        if (nElements == 0) {
            Set empty = Collections.emptySet();
            this.taxonomy.addNode(Collections.singleton(toAdd), empty, empty, false);
        } else {
            ArrayList<T> maxElements = new ArrayList<T>();
            for (TaxonomyNode<T> n : this.taxonomy.getTop().getSubs()) {
                maxElements.add(n.getName());
            }
            Collection<T> parents = this.search(this.taxonomy, toAdd, maxElements, this.comparator, true);
            if (parents == null) {
                return;
            }
            ArrayList<Object> leaves = new ArrayList<Object>();
            HashSet visited = new HashSet();
            LinkedList<Set<Object>> toVisit = new LinkedList<Set<Object>>();
            if (parents.isEmpty()) {
                for (TaxonomyNode taxonomyNode : this.taxonomy.getBottom().getSupers()) {
                    leaves.add(taxonomyNode.getName());
                }
            } else {
                for (Object object : parents) {
                    Set<Set<Object>> subs = this.taxonomy.getSubs(object, true);
                    if (subs.isEmpty()) continue;
                    toVisit.addAll(subs);
                }
            }
            Set<Set<T>> bottoms = Collections.singleton(this.taxonomy.getBottom().getEquivalents());
            while (!toVisit.isEmpty()) {
                Set set = (Set)toVisit.remove();
                assert (!set.isEmpty());
                Object rep = set.iterator().next();
                if (visited.contains(rep)) continue;
                visited.addAll(set);
                Set<Set<T>> subs = this.taxonomy.getSubs(rep, true);
                if (subs.equals(bottoms)) {
                    leaves.add(rep);
                    continue;
                }
                toVisit.addAll(subs);
            }
            Collection<T> children = this.search(this.taxonomy, toAdd, leaves, this.comparator, false);
            if (children == null) {
                return;
            }
            this.taxonomy.addNode(Collections.singleton(toAdd), parents, children, hidden);
        }
    }

    public void addAll(Collection<? extends T> elements) {
        for (T toInsert : elements) {
            this.add(toInsert);
        }
    }

    public PartialOrderComparator<T> getComparator() {
        return this.comparator;
    }

    public Taxonomy<T> getTaxonomy() {
        return this.taxonomy;
    }

    private Collection<T> search(Taxonomy<T> tax, T toInsert, Collection<T> from, PartialOrderComparator<T> comparator, boolean direction) {
        ArrayList retSet = new ArrayList();
        LinkedList<Map<Object, Collection<Object>>> pending = new LinkedList<Map<Object, Collection<Object>>>();
        pending.add(Collections.singletonMap(null, from));
        HashSet<T> visited = new HashSet<T>();
        while (!pending.isEmpty()) {
            Map.Entry pair = ((Map)pending.remove()).entrySet().iterator().next();
            Object candidate = pair.getKey();
            if (candidate != null) {
                if (visited.contains(candidate)) continue;
                visited.addAll(tax.getAllEquivalents(candidate));
            }
            boolean hasSuccessors = false;
            Collection candidatesChildren = (Collection)pair.getValue();
            for (Object child : candidatesChildren) {
                switch (comparator.compare(toInsert, child)) {
                    case LESS: {
                        if (!direction) break;
                        Set<Set<T>> subs = tax.getSubs(child, true);
                        ArrayList<T> next = new ArrayList(subs.size());
                        for (Set<T> sub : subs) {
                            next.add(sub.iterator().next());
                        }
                        pending.add(Collections.singletonMap(child, next));
                        hasSuccessors = true;
                        break;
                    }
                    case EQUAL: {
                        tax.addEquivalents(child, Collections.singleton(toInsert));
                        return null;
                    }
                    case GREATER: {
                        if (direction) break;
                        Set<Set<T>> sups = tax.getSupers(child, true);
                        ArrayList<T> next = new ArrayList<T>(sups.size());
                        for (Set<T> sup : sups) {
                            next.add(sup.iterator().next());
                        }
                        pending.add(Collections.singletonMap(child, next));
                        hasSuccessors = true;
                        break;
                    }
                }
            }
            if (hasSuccessors || candidate == null) continue;
            retSet.add(candidate);
        }
        return retSet;
    }

    public void setComparator(PartialOrderComparator<T> comparator) {
        this.comparator = comparator;
    }

    public void setTaxonomy(Taxonomy<T> taxonomy) {
        this.taxonomy = taxonomy;
    }
}

