/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.taxonomy.AbstractDefinitionOrder;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.ATermUtils;

public class TaxonomyBasedDefinitionOrder
extends AbstractDefinitionOrder {
    private Taxonomy<ATermAppl> definitionOrderTaxonomy;

    public TaxonomyBasedDefinitionOrder(KnowledgeBase kb, Comparator<ATerm> comparator) {
        super(kb, comparator);
    }

    @Override
    protected void initialize() {
        this.definitionOrderTaxonomy = new Taxonomy<ATermAppl>(this.kb.getClasses(), ATermUtils.TOP, ATermUtils.BOTTOM);
    }

    @Override
    protected void addUses(ATermAppl c, ATermAppl d) {
        if (this.definitionOrderTaxonomy.isEquivalent(c, d).isTrue()) {
            return;
        }
        TaxonomyNode<ATermAppl> cNode = this.definitionOrderTaxonomy.getNode(c);
        TaxonomyNode<ATermAppl> dNode = this.definitionOrderTaxonomy.getNode(d);
        if (cNode == null) {
            throw new InternalReasonerException(c + " is not in the definition order");
        }
        if (cNode.equals(this.definitionOrderTaxonomy.getTop())) {
            this.definitionOrderTaxonomy.merge(cNode, dNode);
        } else {
            this.definitionOrderTaxonomy.addSuper(c, d);
            this.definitionOrderTaxonomy.removeCycles(cNode);
        }
    }

    @Override
    protected Set<ATermAppl> computeCycles() {
        Set<ATermAppl> cyclicConcepts = CollectionUtils.makeIdentitySet();
        for (TaxonomyNode<ATermAppl> node : this.definitionOrderTaxonomy.getNodes()) {
            Set<ATermAppl> names = node.getEquivalents();
            if (names.size() <= 1) continue;
            cyclicConcepts.addAll(names);
        }
        return cyclicConcepts;
    }

    @Override
    protected List<ATermAppl> computeDefinitionOrder() {
        this.definitionOrderTaxonomy.assertValid();
        return this.definitionOrderTaxonomy.topologocialSort(true, this.comparator);
    }
}

