/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.taxonomy.DefinitionOrder;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;

public abstract class AbstractDefinitionOrder
implements DefinitionOrder {
    protected KnowledgeBase kb;
    protected Comparator<ATerm> comparator;
    private Set<ATermAppl> cyclicConcepts;
    private List<ATermAppl> definitionOrder;

    public AbstractDefinitionOrder(KnowledgeBase kb, Comparator<ATerm> comparator) {
        this.kb = kb;
        this.comparator = comparator;
        this.cyclicConcepts = CollectionUtils.makeIdentitySet();
        this.definitionOrder = new ArrayList<ATermAppl>(kb.getClasses().size() + 2);
        this.initialize();
        this.processDefinitions();
        this.cyclicConcepts = this.computeCycles();
        this.definitionOrder = this.computeDefinitionOrder();
    }

    protected abstract void initialize();

    protected abstract Set<ATermAppl> computeCycles();

    protected abstract List<ATermAppl> computeDefinitionOrder();

    protected void processDefinitions() {
        boolean hasInverses = this.kb.getExpressivity().hasInverse();
        TBox tbox = this.kb.getTBox();
        for (ATermAppl c : this.kb.getClasses()) {
            Iterator<Unfolding> unfoldingList = tbox.unfold(c);
            while (unfoldingList.hasNext()) {
                Unfolding unf = unfoldingList.next();
                Set<ATermAppl> usedByC = ATermUtils.findPrimitives(unf.getResult(), !hasInverses, true);
                for (ATermAppl used : usedByC) {
                    if (!this.kb.getClasses().contains(used)) continue;
                    this.addUses(c, used);
                }
            }
        }
    }

    protected abstract void addUses(ATermAppl var1, ATermAppl var2);

    @Override
    public boolean isCyclic(ATermAppl concept) {
        return this.cyclicConcepts.contains(concept);
    }

    @Override
    public Iterator<ATermAppl> iterator() {
        return this.definitionOrder.iterator();
    }
}

