/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.cache;

import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.HashSet;
import java.util.Map;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.cache.CachedEdge;
import org.mindswap.pellet.tableau.cache.CachedInEdge;
import org.mindswap.pellet.tableau.cache.CachedNode;
import org.mindswap.pellet.tableau.cache.CachedOutEdge;
import org.mindswap.pellet.utils.ATermUtils;

public class CachedConceptNode
implements CachedNode {
    private ATermAppl name;
    private EdgeList inEdges;
    private EdgeList outEdges;
    private Map<ATermAppl, DependencySet> types;
    private boolean isIndependent;

    public CachedConceptNode(ATermAppl name, Individual node) {
        this.name = name;
        this.isIndependent = node.getMergeDependency(true).isIndependent();
        node = node.getSame();
        this.outEdges = this.copyEdgeList(node, true);
        this.inEdges = this.copyEdgeList(node, false);
        if (node.getABox().getKB().getExpressivity().hasNominal()) {
            this.collectComplexPropertyValues(node);
        }
        this.types = CollectionUtils.makeIdentityMap(node.getDepends());
        for (Map.Entry<ATermAppl, DependencySet> e : this.types.entrySet()) {
            e.setValue(e.getValue().cache());
        }
    }

    private void collectComplexPropertyValues(Individual subj) {
        Role role;
        HashSet<Role> collected = new HashSet<Role>();
        for (Edge edge : subj.getOutEdges()) {
            role = edge.getRole();
            if (role.isSimple() || !collected.add(role)) continue;
            collected.add(role);
            this.collectComplexPropertyValues(subj, role);
        }
        for (Edge edge : subj.getInEdges()) {
            role = edge.getRole().getInverse();
            if (role.isSimple() || !collected.add(role)) continue;
            this.collectComplexPropertyValues(subj, role);
        }
    }

    private void collectComplexPropertyValues(Individual subj, Role role) {
        HashSet<ATermAppl> knowns = new HashSet<ATermAppl>();
        HashSet<ATermAppl> unknowns = new HashSet<ATermAppl>();
        subj.getABox().getObjectPropertyValues(subj.getName(), role, knowns, unknowns, false);
        for (ATermAppl val : knowns) {
            this.outEdges.addEdge(new CachedOutEdge(role, val, DependencySet.INDEPENDENT));
        }
        for (ATermAppl val : unknowns) {
            this.outEdges.addEdge(new CachedOutEdge(role, val, DependencySet.DUMMY));
        }
    }

    private EdgeList copyEdgeList(Individual node, boolean out) {
        EdgeList edgeList = out ? node.getOutEdges() : node.getInEdges();
        EdgeList cachedEdges = new EdgeList(edgeList.size());
        for (Edge edge : edgeList) {
            CachedEdge cachedEdge = out ? new CachedOutEdge(edge) : new CachedInEdge(edge);
            cachedEdges.addEdge(cachedEdge);
            if (!PelletOptions.CHECK_NOMINAL_EDGES) continue;
            Node neighbor = edge.getNeighbor(node);
            Map<Node, DependencySet> mergedNodes = neighbor.getAllMerged();
            DependencySet edgeDepends = edge.getDepends();
            for (Map.Entry<Node, DependencySet> entry : mergedNodes.entrySet()) {
                Node mergedNode = entry.getKey();
                if (!mergedNode.isRootNominal() || mergedNode.equals(neighbor)) continue;
                Role r = edge.getRole();
                ATermAppl n = mergedNode.getName();
                DependencySet ds = edgeDepends.union(entry.getValue(), false).cache();
                CachedEdge e = out ? new CachedOutEdge(r, n, ds) : new CachedInEdge(r, n, ds);
                cachedEdges.addEdge(e);
            }
        }
        return cachedEdges;
    }

    @Override
    public boolean isIndependent() {
        return this.isIndependent;
    }

    @Override
    public EdgeList getInEdges() {
        return this.inEdges;
    }

    @Override
    public EdgeList getOutEdges() {
        return this.outEdges;
    }

    @Override
    public Map<ATermAppl, DependencySet> getDepends() {
        return this.types;
    }

    @Override
    public boolean hasRNeighbor(Role role) {
        return this.outEdges.hasEdge(role) || role.isObjectRole() && this.inEdges.hasEdge(role.getInverse());
    }

    @Override
    public boolean isBottom() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean isNamedIndividual() {
        return false;
    }

    @Override
    public boolean isTop() {
        return false;
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    public String toString() {
        return ATermUtils.toString(this.name);
    }
}

