/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.blocking;

import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;

public class BlockingContext {
    Individual blocked;
    Individual blocker;
    Set<Role> rolesToBlocked;

    public BlockingContext(Individual blocked) {
        this.blocked = blocked;
        this.blocker = blocked;
    }

    public boolean moveBlockerUp() {
        this.blocker = this.blocker.getParent();
        this.rolesToBlocked = null;
        return !this.blocker.isRoot();
    }

    public boolean moveBlockerDown(Node child) {
        if (child.isLiteral() || child.isRoot() || child.isPruned() || child.isMerged() || ((Individual)child).isBlocked() || child.equals(this.blocker)) {
            return false;
        }
        this.blocker = (Individual)child;
        this.rolesToBlocked = null;
        return true;
    }

    public boolean isRSuccessor(Role r) {
        return this.getIncomingRoles().contains(r);
    }

    public boolean isInvSuccessor() {
        for (Role role : this.getIncomingRoles()) {
            if (!role.isAnon()) continue;
            return true;
        }
        return false;
    }

    protected Set<Role> getIncomingRoles() {
        if (this.rolesToBlocked == null) {
            this.rolesToBlocked = BlockingContext.getIncomingRoles(this.blocked);
            assert (this.rolesToBlocked != null);
        }
        return this.rolesToBlocked;
    }

    protected static Set<Role> getIncomingRoles(Individual ind) {
        Set<Role> rolesToBlocked = null;
        for (Edge e : ind.getInEdges()) {
            if (!e.getFrom().equals(ind.getParent())) continue;
            if (rolesToBlocked == null) {
                rolesToBlocked = e.getRole().getSuperRoles();
                continue;
            }
            if (rolesToBlocked.contains(e.getRole())) continue;
            rolesToBlocked = new HashSet<Role>(rolesToBlocked);
            rolesToBlocked.addAll(e.getRole().getSuperRoles());
        }
        return rolesToBlocked;
    }

    public String toString() {
        return this.blocked + " blocked by " + this.blocker;
    }
}

