/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.rete.BetaNode;
import com.clarkparsia.pellet.rules.rete.ReteNode;
import com.clarkparsia.pellet.rules.rete.WME;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.utils.ATermUtils;

public abstract class AlphaNode
extends ReteNode {
    protected static final Iterator<WME> NO_MATCH = Collections.emptyList().iterator();
    protected boolean doExplanation;
    protected final ABox abox;

    public AlphaNode(ABox abox) {
        this.abox = abox;
    }

    public abstract Iterator<WME> getMatches(int var1, Node var2);

    public abstract Iterator<WME> getMatches();

    public abstract boolean matches(RuleAtom var1);

    protected Node initNode(ATermAppl name) {
        if (ATermUtils.isLiteral(name)) {
            return this.abox.addLiteral(name);
        }
        this.abox.copyOnWrite();
        return this.abox.getIndividual((ATerm)name);
    }

    protected void activate(WME wme) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Activate alpha " + wme);
        }
        for (BetaNode beta : this.getBetas()) {
            beta.activate(wme);
        }
    }

    public void setDoExplanation(boolean doExplanation) {
        this.doExplanation = doExplanation;
    }

    @Override
    public void print(String indent) {
        for (BetaNode node : this.getBetas()) {
            if (!node.isTop()) continue;
            node.print(indent);
        }
    }
}

