/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.RemappingIndividualProvider;

public class OWLObjectDuplicator
implements OWLObjectVisitor,
SWRLObjectVisitor {
    @Nonnull
    private final OWLDataFactory dataFactory;
    private Object obj;
    @Nonnull
    private final Map<OWLEntity, IRI> replacementMap;
    @Nonnull
    private final Map<OWLLiteral, OWLLiteral> replacementLiterals;
    protected RemappingIndividualProvider anonProvider;

    public OWLObjectDuplicator(@Nonnull OWLDataFactory dataFactory) {
        this(new HashMap<OWLEntity, IRI>(), dataFactory);
    }

    public OWLObjectDuplicator(@Nonnull OWLDataFactory dataFactory, @Nonnull Map<IRI, IRI> iriReplacementMap) {
        this(dataFactory, iriReplacementMap, Collections.emptyMap());
    }

    public OWLObjectDuplicator(@Nonnull OWLDataFactory dataFactory, @Nonnull Map<IRI, IRI> iriReplacementMap, @Nonnull Map<OWLLiteral, OWLLiteral> literals) {
        this.dataFactory = OWLAPIPreconditions.checkNotNull(dataFactory, "dataFactory cannot be null");
        OWLAPIPreconditions.checkNotNull(iriReplacementMap, "iriReplacementMap cannot be null");
        OWLAPIPreconditions.checkNotNull(literals, "literals cannot be null");
        this.replacementLiterals = new HashMap<OWLLiteral, OWLLiteral>(literals);
        this.replacementMap = new HashMap<OWLEntity, IRI>();
        for (Map.Entry<IRI, IRI> e : iriReplacementMap.entrySet()) {
            IRI iri = e.getKey();
            IRI repIRI = e.getValue();
            this.replacementMap.put(dataFactory.getOWLClass(iri), repIRI);
            this.replacementMap.put(dataFactory.getOWLObjectProperty(iri), repIRI);
            this.replacementMap.put(dataFactory.getOWLDataProperty(iri), repIRI);
            this.replacementMap.put(dataFactory.getOWLNamedIndividual(iri), repIRI);
            this.replacementMap.put(dataFactory.getOWLDatatype(iri), repIRI);
            this.replacementMap.put(dataFactory.getOWLAnnotationProperty(iri), repIRI);
        }
    }

    public OWLObjectDuplicator(@Nonnull Map<OWLEntity, IRI> entityIRIReplacementMap, @Nonnull OWLDataFactory dataFactory) {
        this(entityIRIReplacementMap, dataFactory, Collections.emptyMap());
    }

    public OWLObjectDuplicator(@Nonnull Map<OWLEntity, IRI> entityIRIReplacementMap, @Nonnull OWLDataFactory dataFactory, @Nonnull Map<OWLLiteral, OWLLiteral> literals) {
        this.dataFactory = OWLAPIPreconditions.checkNotNull(dataFactory, "dataFactory cannot be null");
        this.anonProvider = new RemappingIndividualProvider(this.dataFactory);
        this.replacementMap = new HashMap<OWLEntity, IRI>(OWLAPIPreconditions.checkNotNull(entityIRIReplacementMap, "entityIRIReplacementMap cannot be null"));
        OWLAPIPreconditions.checkNotNull(literals, "literals cannot be null");
        this.replacementLiterals = new HashMap<OWLLiteral, OWLLiteral>(literals);
    }

    @Nonnull
    public <O extends OWLObject> O duplicateObject(@Nonnull OWLObject object) {
        OWLAPIPreconditions.checkNotNull(object, "object cannot be null");
        object.accept(this);
        return (O)((OWLObject)this.getLastObject());
    }

    protected void setLastObject(@Nonnull Object obj) {
        this.obj = obj;
    }

    @Nonnull
    protected <O> O getLastObject() {
        return (O)this.obj;
    }

    @Nonnull
    private IRI getIRI(@Nonnull OWLEntity entity) {
        OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null");
        IRI replacement = this.replacementMap.get(entity);
        if (replacement != null) {
            return replacement;
        }
        return entity.getIRI();
    }

    @Nonnull
    private Set<OWLAnnotation> duplicateAxiomAnnotations(@Nonnull OWLAxiom axiom) {
        OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null");
        HashSet<OWLAnnotation> duplicatedAnnos = new HashSet<OWLAnnotation>();
        for (OWLAnnotation anno : axiom.getAnnotations()) {
            anno.accept(this);
            duplicatedAnnos.add((OWLAnnotation)this.getLastObject());
        }
        return duplicatedAnnos;
    }

    @Override
    public void visit(@Nonnull OWLAsymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.obj = this.dataFactory.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.getLastObject(), this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLClassAssertionAxiom axiom) {
        axiom.getIndividual().accept(this);
        OWLIndividual ind = (OWLIndividual)this.getLastObject();
        axiom.getClassExpression().accept(this);
        OWLClassExpression type = (OWLClassExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLClassAssertionAxiom(type, ind, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        OWLIndividual subj = (OWLIndividual)this.getLastObject();
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.getLastObject();
        ((OWLLiteral)axiom.getObject()).accept(this);
        OWLLiteral con = (OWLLiteral)this.getLastObject();
        this.obj = this.dataFactory.getOWLDataPropertyAssertionAxiom(prop, subj, con, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLDataPropertyDomainAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.getLastObject();
        axiom.getDomain().accept(this);
        OWLClassExpression domain = (OWLClassExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLDataPropertyDomainAxiom(prop, domain, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLDataPropertyRangeAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.getLastObject();
        ((OWLDataRange)axiom.getRange()).accept(this);
        OWLDataRange range = (OWLDataRange)this.getLastObject();
        this.obj = this.dataFactory.getOWLDataPropertyRangeAxiom(prop, range, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLSubDataPropertyOfAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        OWLDataPropertyExpression subProp = (OWLDataPropertyExpression)this.getLastObject();
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        OWLDataPropertyExpression supProp = (OWLDataPropertyExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLSubDataPropertyOfAxiom(subProp, supProp, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLDeclarationAxiom axiom) {
        axiom.getEntity().accept(this);
        OWLEntity ent = (OWLEntity)this.getLastObject();
        this.obj = this.dataFactory.getOWLDeclarationAxiom(ent, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLDifferentIndividualsAxiom axiom) {
        Set<OWLIndividual> inds = this.duplicateSet(axiom.getIndividuals());
        this.obj = this.dataFactory.getOWLDifferentIndividualsAxiom(inds, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLDisjointClassesAxiom axiom) {
        Set<OWLClassExpression> descs = this.duplicateSet(axiom.getClassExpressions());
        this.obj = this.dataFactory.getOWLDisjointClassesAxiom(descs, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLDisjointDataPropertiesAxiom axiom) {
        Set props = this.duplicateSet(axiom.getProperties());
        this.obj = this.dataFactory.getOWLDisjointDataPropertiesAxiom(props, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLDisjointObjectPropertiesAxiom axiom) {
        Set props = this.duplicateSet(axiom.getProperties());
        this.obj = this.dataFactory.getOWLDisjointObjectPropertiesAxiom(props, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLDisjointUnionAxiom axiom) {
        axiom.getOWLClass().accept(this);
        OWLClass cls = (OWLClass)this.getLastObject();
        Set<OWLClassExpression> ops = this.duplicateSet(axiom.getClassExpressions());
        this.obj = this.dataFactory.getOWLDisjointUnionAxiom(cls, ops, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLAnnotationAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        OWLAnnotationSubject subject = (OWLAnnotationSubject)this.getLastObject();
        axiom.getProperty().accept(this);
        OWLAnnotationProperty prop = (OWLAnnotationProperty)this.getLastObject();
        axiom.getValue().accept(this);
        OWLAnnotationValue value = (OWLAnnotationValue)this.getLastObject();
        this.obj = this.dataFactory.getOWLAnnotationAssertionAxiom(prop, subject, value, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLEquivalentClassesAxiom axiom) {
        Set<OWLClassExpression> descs = this.duplicateSet(axiom.getClassExpressions());
        this.obj = this.dataFactory.getOWLEquivalentClassesAxiom(descs, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLEquivalentDataPropertiesAxiom axiom) {
        Set props = this.duplicateSet(axiom.getProperties());
        this.obj = this.dataFactory.getOWLEquivalentDataPropertiesAxiom(props, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLEquivalentObjectPropertiesAxiom axiom) {
        Set props = this.duplicateSet(axiom.getProperties());
        this.obj = this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(props, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLFunctionalDataPropertyAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        OWLDataPropertyExpression obj2 = (OWLDataPropertyExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLFunctionalDataPropertyAxiom(obj2, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLFunctionalObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression obj2 = (OWLObjectPropertyExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLFunctionalObjectPropertyAxiom(obj2, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLInverseFunctionalObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression obj2 = (OWLObjectPropertyExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(obj2, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLInverseObjectPropertiesAxiom axiom) {
        axiom.getFirstProperty().accept(this);
        OWLObjectPropertyExpression propA = (OWLObjectPropertyExpression)this.getLastObject();
        axiom.getSecondProperty().accept(this);
        OWLObjectPropertyExpression propB = (OWLObjectPropertyExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLInverseObjectPropertiesAxiom(propA, propB, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLIrreflexiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression obj2 = (OWLObjectPropertyExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(obj2, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLNegativeDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        OWLIndividual ind = (OWLIndividual)this.getLastObject();
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.getLastObject();
        ((OWLLiteral)axiom.getObject()).accept(this);
        OWLLiteral con = (OWLLiteral)this.getLastObject();
        this.obj = this.dataFactory.getOWLNegativeDataPropertyAssertionAxiom(prop, ind, con, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLNegativeObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        OWLIndividual ind = (OWLIndividual)this.getLastObject();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        ((OWLIndividual)axiom.getObject()).accept(this);
        OWLIndividual ind2 = (OWLIndividual)this.getLastObject();
        this.obj = this.dataFactory.getOWLNegativeObjectPropertyAssertionAxiom(prop, ind, ind2, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        OWLIndividual ind = (OWLIndividual)this.getLastObject();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        ((OWLIndividual)axiom.getObject()).accept(this);
        OWLIndividual ind2 = (OWLIndividual)this.getLastObject();
        this.obj = this.dataFactory.getOWLObjectPropertyAssertionAxiom(prop, ind, ind2, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLSubPropertyChainOfAxiom axiom) {
        axiom.getSuperProperty().accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        ArrayList<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>();
        for (OWLObjectPropertyExpression p : axiom.getPropertyChain()) {
            p.accept(this);
            chain.add((OWLObjectPropertyExpression)this.getLastObject());
        }
        this.obj = this.dataFactory.getOWLSubPropertyChainOfAxiom(chain, prop, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLObjectPropertyDomainAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        axiom.getDomain().accept(this);
        OWLClassExpression domain = (OWLClassExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLObjectPropertyDomainAxiom(prop, domain, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLObjectPropertyRangeAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        ((OWLClassExpression)axiom.getRange()).accept(this);
        OWLClassExpression range = (OWLClassExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, range, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLSubObjectPropertyOfAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        OWLObjectPropertyExpression subProp = (OWLObjectPropertyExpression)this.getLastObject();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        OWLObjectPropertyExpression supProp = (OWLObjectPropertyExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLSubObjectPropertyOfAxiom(subProp, supProp, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLReflexiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLSameIndividualAxiom axiom) {
        Set<OWLIndividual> individuals = this.duplicateSet(axiom.getIndividuals());
        this.obj = this.dataFactory.getOWLSameIndividualAxiom(individuals, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLSubClassOfAxiom axiom) {
        axiom.getSubClass().accept(this);
        OWLClassExpression subClass = (OWLClassExpression)this.getLastObject();
        axiom.getSuperClass().accept(this);
        OWLClassExpression supClass = (OWLClassExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLSubClassOfAxiom(subClass, supClass, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLSymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLTransitiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLClass ce) {
        IRI uri = this.getIRI(ce);
        this.obj = this.dataFactory.getOWLClass(uri);
    }

    @Override
    public void visit(@Nonnull OWLDataAllValuesFrom ce) {
        ce.getProperty().accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.getLastObject();
        ((OWLDataRange)ce.getFiller()).accept(this);
        OWLDataRange filler = (OWLDataRange)this.getLastObject();
        this.obj = this.dataFactory.getOWLDataAllValuesFrom(prop, filler);
    }

    @Override
    public void visit(@Nonnull OWLDataExactCardinality ce) {
        ce.getProperty().accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.getLastObject();
        ((OWLDataRange)ce.getFiller()).accept(this);
        OWLDataRange filler = (OWLDataRange)this.getLastObject();
        this.obj = this.dataFactory.getOWLDataExactCardinality(ce.getCardinality(), prop, filler);
    }

    @Override
    public void visit(@Nonnull OWLDataMaxCardinality ce) {
        ce.getProperty().accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.getLastObject();
        ((OWLDataRange)ce.getFiller()).accept(this);
        OWLDataRange filler = (OWLDataRange)this.getLastObject();
        this.obj = this.dataFactory.getOWLDataMaxCardinality(ce.getCardinality(), prop, filler);
    }

    @Override
    public void visit(@Nonnull OWLDataMinCardinality ce) {
        ce.getProperty().accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.getLastObject();
        ((OWLDataRange)ce.getFiller()).accept(this);
        OWLDataRange filler = (OWLDataRange)this.getLastObject();
        this.obj = this.dataFactory.getOWLDataMinCardinality(ce.getCardinality(), prop, filler);
    }

    @Override
    public void visit(@Nonnull OWLDataSomeValuesFrom ce) {
        ce.getProperty().accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.getLastObject();
        ((OWLDataRange)ce.getFiller()).accept(this);
        OWLDataRange filler = (OWLDataRange)this.getLastObject();
        this.obj = this.dataFactory.getOWLDataSomeValuesFrom(prop, filler);
    }

    @Override
    public void visit(@Nonnull OWLDataHasValue ce) {
        ce.getProperty().accept(this);
        OWLDataPropertyExpression prop = (OWLDataPropertyExpression)this.getLastObject();
        ((OWLLiteral)ce.getFiller()).accept(this);
        OWLLiteral val = (OWLLiteral)this.getLastObject();
        this.obj = this.dataFactory.getOWLDataHasValue(prop, val);
    }

    @Override
    public void visit(@Nonnull OWLObjectAllValuesFrom ce) {
        ce.getProperty().accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        ((OWLClassExpression)ce.getFiller()).accept(this);
        OWLClassExpression filler = (OWLClassExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLObjectAllValuesFrom(prop, filler);
    }

    @Override
    public void visit(@Nonnull OWLObjectComplementOf ce) {
        ce.getOperand().accept(this);
        OWLClassExpression op = (OWLClassExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLObjectComplementOf(op);
    }

    @Override
    public void visit(@Nonnull OWLObjectExactCardinality ce) {
        ce.getProperty().accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        ((OWLClassExpression)ce.getFiller()).accept(this);
        OWLClassExpression filler = (OWLClassExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLObjectExactCardinality(ce.getCardinality(), prop, filler);
    }

    @Override
    public void visit(@Nonnull OWLObjectIntersectionOf ce) {
        Set<OWLClassExpression> ops = this.duplicateSet(ce.getOperands());
        this.obj = this.dataFactory.getOWLObjectIntersectionOf(ops);
    }

    @Override
    public void visit(@Nonnull OWLObjectMaxCardinality ce) {
        ce.getProperty().accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        ((OWLClassExpression)ce.getFiller()).accept(this);
        OWLClassExpression filler = (OWLClassExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLObjectMaxCardinality(ce.getCardinality(), prop, filler);
    }

    @Override
    public void visit(@Nonnull OWLObjectMinCardinality ce) {
        ce.getProperty().accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        ((OWLClassExpression)ce.getFiller()).accept(this);
        OWLClassExpression filler = (OWLClassExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLObjectMinCardinality(ce.getCardinality(), prop, filler);
    }

    @Override
    public void visit(@Nonnull OWLObjectOneOf ce) {
        Set<OWLIndividual> inds = this.duplicateSet(ce.getIndividuals());
        this.obj = this.dataFactory.getOWLObjectOneOf(inds);
    }

    @Override
    public void visit(@Nonnull OWLObjectHasSelf ce) {
        ce.getProperty().accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLObjectHasSelf(prop);
    }

    @Override
    public void visit(@Nonnull OWLObjectSomeValuesFrom ce) {
        ce.getProperty().accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        ((OWLClassExpression)ce.getFiller()).accept(this);
        OWLClassExpression filler = (OWLClassExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLObjectSomeValuesFrom(prop, filler);
    }

    @Override
    public void visit(@Nonnull OWLObjectUnionOf ce) {
        Set<OWLClassExpression> ops = this.duplicateSet(ce.getOperands());
        this.obj = this.dataFactory.getOWLObjectUnionOf(ops);
    }

    @Override
    public void visit(@Nonnull OWLObjectHasValue ce) {
        ce.getProperty().accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        ((OWLIndividual)ce.getFiller()).accept(this);
        OWLIndividual value = (OWLIndividual)this.getLastObject();
        this.obj = this.dataFactory.getOWLObjectHasValue(prop, value);
    }

    @Override
    public void visit(@Nonnull OWLDataComplementOf node) {
        node.getDataRange().accept(this);
        OWLDataRange dr = (OWLDataRange)this.getLastObject();
        this.obj = this.dataFactory.getOWLDataComplementOf(dr);
    }

    @Override
    public void visit(@Nonnull OWLDataOneOf node) {
        Set<OWLLiteral> vals = this.duplicateSet(node.getValues());
        this.obj = this.dataFactory.getOWLDataOneOf(vals);
    }

    @Override
    public void visit(@Nonnull OWLDatatype node) {
        IRI iri = this.getIRI(node);
        this.obj = this.dataFactory.getOWLDatatype(iri);
    }

    @Override
    public void visit(@Nonnull OWLDatatypeRestriction node) {
        node.getDatatype().accept(this);
        OWLDatatype dr = (OWLDatatype)this.getLastObject();
        HashSet<OWLFacetRestriction> restrictions = new HashSet<OWLFacetRestriction>();
        for (OWLFacetRestriction restriction : node.getFacetRestrictions()) {
            restriction.accept(this);
            restrictions.add((OWLFacetRestriction)this.getLastObject());
        }
        this.obj = this.dataFactory.getOWLDatatypeRestriction(dr, restrictions);
    }

    @Override
    public void visit(@Nonnull OWLFacetRestriction node) {
        node.getFacetValue().accept(this);
        OWLLiteral val = (OWLLiteral)this.getLastObject();
        this.obj = this.dataFactory.getOWLFacetRestriction(node.getFacet(), val);
    }

    @Override
    public void visit(@Nonnull OWLLiteral node) {
        OWLLiteral l = this.replacementLiterals.get(node);
        if (l != null) {
            this.obj = l;
            return;
        }
        node.getDatatype().accept(this);
        OWLDatatype dt = (OWLDatatype)this.getLastObject();
        this.obj = node.hasLang() ? this.dataFactory.getOWLLiteral(node.getLiteral(), node.getLang()) : this.dataFactory.getOWLLiteral(node.getLiteral(), dt);
    }

    @Override
    public void visit(@Nonnull OWLDataProperty property) {
        IRI iri = this.getIRI(property);
        this.obj = this.dataFactory.getOWLDataProperty(iri);
    }

    @Override
    public void visit(@Nonnull OWLObjectProperty property) {
        IRI iri = this.getIRI(property);
        this.obj = this.dataFactory.getOWLObjectProperty(iri);
    }

    @Override
    public void visit(@Nonnull OWLObjectInverseOf property) {
        property.getInverse().accept(this);
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)this.getLastObject();
        this.obj = this.dataFactory.getOWLObjectInverseOf(prop);
    }

    @Override
    public void visit(@Nonnull OWLNamedIndividual individual) {
        IRI iri = this.getIRI(individual);
        this.obj = this.dataFactory.getOWLNamedIndividual(iri);
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.obj = ontology;
    }

    @Override
    public void visit(@Nonnull SWRLRule rule) {
        HashSet<SWRLAtom> antecedents = new HashSet<SWRLAtom>();
        HashSet<SWRLAtom> consequents = new HashSet<SWRLAtom>();
        for (SWRLAtom atom : rule.getBody()) {
            atom.accept(this);
            antecedents.add((SWRLAtom)this.getLastObject());
        }
        for (SWRLAtom atom : rule.getHead()) {
            atom.accept(this);
            consequents.add((SWRLAtom)this.getLastObject());
        }
        this.obj = this.dataFactory.getSWRLRule(antecedents, consequents);
    }

    @Override
    public void visit(@Nonnull SWRLClassAtom node) {
        node.getPredicate().accept(this);
        OWLClassExpression desc = (OWLClassExpression)this.getLastObject();
        ((SWRLIArgument)node.getArgument()).accept(this);
        SWRLIArgument atom = (SWRLIArgument)this.getLastObject();
        this.obj = this.dataFactory.getSWRLClassAtom(desc, atom);
    }

    @Override
    public void visit(@Nonnull SWRLDataRangeAtom node) {
        node.getPredicate().accept(this);
        OWLDataRange rng = (OWLDataRange)this.getLastObject();
        ((SWRLDArgument)node.getArgument()).accept(this);
        SWRLDArgument atom = (SWRLDArgument)this.getLastObject();
        this.obj = this.dataFactory.getSWRLDataRangeAtom(rng, atom);
    }

    @Override
    public void visit(@Nonnull SWRLObjectPropertyAtom node) {
        node.getPredicate().accept(this);
        OWLObjectPropertyExpression exp = (OWLObjectPropertyExpression)this.getLastObject();
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        SWRLIArgument arg0 = (SWRLIArgument)this.getLastObject();
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        SWRLIArgument arg1 = (SWRLIArgument)this.getLastObject();
        this.obj = this.dataFactory.getSWRLObjectPropertyAtom(exp, arg0, arg1);
    }

    @Override
    public void visit(@Nonnull SWRLDataPropertyAtom node) {
        node.getPredicate().accept(this);
        OWLDataPropertyExpression exp = (OWLDataPropertyExpression)this.getLastObject();
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        SWRLIArgument arg0 = (SWRLIArgument)this.getLastObject();
        ((SWRLDArgument)node.getSecondArgument()).accept(this);
        SWRLDArgument arg1 = (SWRLDArgument)this.getLastObject();
        this.obj = this.dataFactory.getSWRLDataPropertyAtom(exp, arg0, arg1);
    }

    @Override
    public void visit(@Nonnull SWRLBuiltInAtom node) {
        ArrayList<SWRLDArgument> atomObjects = new ArrayList<SWRLDArgument>();
        for (SWRLDArgument atomObject : node.getArguments()) {
            atomObject.accept(this);
            atomObjects.add((SWRLDArgument)this.getLastObject());
        }
        this.obj = this.dataFactory.getSWRLBuiltInAtom(node.getPredicate(), atomObjects);
    }

    @Override
    public void visit(@Nonnull SWRLDifferentIndividualsAtom node) {
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        SWRLIArgument arg0 = (SWRLIArgument)this.getLastObject();
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        SWRLIArgument arg1 = (SWRLIArgument)this.getLastObject();
        this.obj = this.dataFactory.getSWRLDifferentIndividualsAtom(arg0, arg1);
    }

    @Override
    public void visit(@Nonnull SWRLSameIndividualAtom node) {
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        SWRLIArgument arg0 = (SWRLIArgument)this.getLastObject();
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        SWRLIArgument arg1 = (SWRLIArgument)this.getLastObject();
        this.obj = this.dataFactory.getSWRLSameIndividualAtom(arg0, arg1);
    }

    @Override
    public void visit(@Nonnull SWRLVariable node) {
        node.getIRI().accept(this);
        IRI iri = (IRI)this.getLastObject();
        this.obj = this.dataFactory.getSWRLVariable(iri);
    }

    @Override
    public void visit(@Nonnull SWRLIndividualArgument node) {
        node.getIndividual().accept(this);
        OWLIndividual ind = (OWLIndividual)this.getLastObject();
        this.obj = this.dataFactory.getSWRLIndividualArgument(ind);
    }

    @Override
    public void visit(@Nonnull SWRLLiteralArgument node) {
        node.getLiteral().accept(this);
        OWLLiteral con = (OWLLiteral)this.getLastObject();
        this.obj = this.dataFactory.getSWRLLiteralArgument(con);
    }

    @Override
    public void visit(@Nonnull OWLHasKeyAxiom axiom) {
        axiom.getClassExpression().accept(this);
        OWLClassExpression ce = (OWLClassExpression)this.getLastObject();
        Set<OWLPropertyExpression> props = this.duplicateSet(axiom.getPropertyExpressions());
        this.obj = this.dataFactory.getOWLHasKeyAxiom(ce, props, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLDataIntersectionOf node) {
        Set<OWLDataRange> ranges = this.duplicateSet(node.getOperands());
        this.obj = this.dataFactory.getOWLDataIntersectionOf(ranges);
    }

    @Override
    public void visit(@Nonnull OWLDataUnionOf node) {
        Set<OWLDataRange> ranges = this.duplicateSet(node.getOperands());
        this.obj = this.dataFactory.getOWLDataUnionOf(ranges);
    }

    @Override
    public void visit(@Nonnull OWLAnnotationProperty property) {
        this.obj = this.dataFactory.getOWLAnnotationProperty(this.getIRI(property));
    }

    @Override
    public void visit(@Nonnull OWLAnnotationPropertyDomainAxiom axiom) {
        axiom.getProperty().accept(this);
        OWLAnnotationProperty prop = (OWLAnnotationProperty)this.getLastObject();
        axiom.getDomain().accept(this);
        IRI domain = (IRI)this.getLastObject();
        this.obj = this.dataFactory.getOWLAnnotationPropertyDomainAxiom(prop, domain, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLAnnotationPropertyRangeAxiom axiom) {
        axiom.getProperty().accept(this);
        OWLAnnotationProperty prop = (OWLAnnotationProperty)this.getLastObject();
        axiom.getRange().accept(this);
        IRI range = (IRI)this.getLastObject();
        this.obj = this.dataFactory.getOWLAnnotationPropertyRangeAxiom(prop, range, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLSubAnnotationPropertyOfAxiom axiom) {
        axiom.getSubProperty().accept(this);
        OWLAnnotationProperty sub = (OWLAnnotationProperty)this.getLastObject();
        axiom.getSuperProperty().accept(this);
        OWLAnnotationProperty sup = (OWLAnnotationProperty)this.getLastObject();
        this.obj = this.dataFactory.getOWLSubAnnotationPropertyOfAxiom(sub, sup, this.duplicateAxiomAnnotations(axiom));
    }

    @Override
    public void visit(@Nonnull OWLAnnotation node) {
        node.getProperty().accept(this);
        OWLAnnotationProperty prop = (OWLAnnotationProperty)this.getLastObject();
        node.getValue().accept(this);
        OWLAnnotationValue val = (OWLAnnotationValue)this.getLastObject();
        this.obj = this.dataFactory.getOWLAnnotation(prop, val);
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.obj = this.anonProvider.getOWLAnonymousIndividual(individual.getID().getID());
    }

    @Override
    public void visit(IRI iri) {
        this.obj = iri;
        for (EntityType<?> entityType : EntityType.values()) {
            assert (entityType != null);
            Object entity = this.dataFactory.getOWLEntity(entityType, iri);
            IRI replacementIRI = this.replacementMap.get(entity);
            if (replacementIRI == null) continue;
            this.obj = replacementIRI;
            break;
        }
    }

    @Override
    public void visit(@Nonnull OWLDatatypeDefinitionAxiom axiom) {
        axiom.getDatatype().accept(this);
        OWLDatatype dt = (OWLDatatype)this.getLastObject();
        axiom.getDataRange().accept(this);
        OWLDataRange rng = (OWLDataRange)this.getLastObject();
        this.obj = this.dataFactory.getOWLDatatypeDefinitionAxiom(dt, rng, this.duplicateAxiomAnnotations(axiom));
    }

    @Nonnull
    private <O extends OWLObject> Set<O> duplicateSet(@Nonnull Set<O> objects) {
        HashSet<OWLObject> dup = new HashSet<OWLObject>();
        for (OWLObject o : objects) {
            o.accept(this);
            dup.add((OWLObject)this.getLastObject());
        }
        return dup;
    }
}

