/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.rdf.rdfxml.parser.AbstractState;
import org.semanticweb.owlapi.rdf.rdfxml.parser.NodeElement;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.semanticweb.owlapi.rdf.rdfxml.parser.State;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.xml.sax.Attributes;

class ParseTypeLiteralElement
extends AbstractState
implements State {
    protected final NodeElement nodeElement;
    protected String pIRI;
    @Nullable
    protected String reificationID;
    protected int depth;
    protected StringBuilder m_content;

    @Nonnull
    protected String propertyIRI() {
        return OWLAPIPreconditions.verifyNotNull(this.pIRI);
    }

    ParseTypeLiteralElement(NodeElement nodeElement, @Nonnull RDFParser parser) {
        super(parser);
        this.nodeElement = nodeElement;
    }

    @Override
    public void startElement(String namespaceIRI, String localName, String qName, @Nonnull Attributes atts) {
        if (this.depth == 0) {
            this.pIRI = this.nodeElement.getPropertyIRI(namespaceIRI + localName);
            this.reificationID = this.nodeElement.getReificationID(atts);
            this.m_content = new StringBuilder();
        } else {
            this.m_content.append('<');
            this.m_content.append(qName);
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                this.m_content.append(' ');
                this.m_content.append(atts.getQName(i));
                this.m_content.append("=\"");
                this.m_content.append(atts.getValue(i));
                this.m_content.append('\"');
            }
            this.m_content.append('>');
        }
        ++this.depth;
    }

    @Override
    public void endElement(String namespaceIRI, String localName, String qName) {
        if (this.depth == 1) {
            this.parser.statementWithLiteralValue(this.nodeElement.subjectIRI(), this.propertyIRI(), OWLAPIPreconditions.verifyNotNull(this.m_content.toString()), "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral", this.reificationID);
            this.parser.popState();
        } else {
            this.m_content.append("</");
            this.m_content.append(qName);
            this.m_content.append('>');
        }
        --this.depth;
    }

    @Override
    public void characters(char[] data, int start, int length) {
        this.m_content.append(data, start, length);
    }
}

