/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import aterm.ATermAppl;
import java.util.List;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.taxonomy.printer.ClassTreePrinter;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOptions;

public class PelletRealize
extends PelletCmdApp {
    @Override
    public String getAppCmd() {
        return "pellet realize " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    @Override
    public String getAppId() {
        return "PelletRealize: Compute and display the most specific instances for each class";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = this.getGlobalOptions();
        options.add(this.getLoaderOption());
        options.add(this.getIgnoreImportsOption());
        options.add(this.getInputFormatOption());
        options.add(this.getInferPropValuesOption());
        options.add(this.getInferDataPropValuesOption());
        return options;
    }

    @Override
    public void run() {
        List values;
        ATermAppl name;
        KnowledgeBase kb = this.getKB();
        this.startTask("consistency check");
        boolean isConsistent = kb.isConsistent();
        this.finishTask("consistency check");
        if (!isConsistent) {
            throw new PelletCmdException("Ontology is inconsistent, run \"pellet explain\" to get the reason");
        }
        this.startTask("classification");
        kb.classify();
        this.finishTask("classification");
        this.startTask("realization");
        kb.realize();
        this.finishTask("realization");
        ClassTreePrinter printer = new ClassTreePrinter();
        printer.print(kb.getTaxonomy());
        if (this.options.getOption("infer-prop-values").getValue() != null) {
            for (ATermAppl ind : kb.getIndividuals()) {
                for (Role role : kb.getRBox().getRoles()) {
                    if (role.isAnon() || !role.isObjectRole()) continue;
                    name = role.getName();
                    values = kb.getObjectPropertyValues(name, ind);
                    for (ATermAppl value : values) {
                        System.out.println("PROPINST: " + ind + " " + name + " " + value);
                    }
                }
            }
        }
        if (this.options.getOption("infer-data-prop-values").getValue() != null) {
            for (ATermAppl ind : kb.getIndividuals()) {
                for (Role role : kb.getRBox().getRoles()) {
                    if (role.isAnon() || !role.isDatatypeRole()) continue;
                    name = role.getName();
                    values = kb.getDataPropertyValues(name, ind);
                    for (ATermAppl value : values) {
                        System.out.println("DATAPROPVAL: " + ind + " " + name + " " + value);
                    }
                }
            }
        }
    }
}

