#! /usr/bin/env python

from __future__ import print_function, division
from openturns import *
from otsvm import *

# Instanciate one distribution object
dimension = 2
meanPoint = Point(dimension, 1.0)
meanPoint[0] = 0.5
meanPoint[1] = -0.5
sigma = Point(dimension, 1.0)
sigma[0] = 2.0
sigma[1] = 3.0
R = CorrelationMatrix(dimension)
for i in range(1, dimension):
    R[i, i - 1] = 0.5

# Create a collection of distribution
aCollection = DistributionCollection()

aCollection.add(Normal(meanPoint, sigma, R))
meanPoint += Point(meanPoint.getDimension(), 1.0)
aCollection.add(Normal(meanPoint, sigma, R))
meanPoint += Point(meanPoint.getDimension(), 1.0)
aCollection.add(Normal(meanPoint, sigma, R))

# Instanciate one distribution object
distribution = Mixture(aCollection)

size = 500
sample = distribution.getSample(size)

meanPoint[0] = 10
meanPoint[1] = 10

# Create a collection of distribution
aCollection = DistributionCollection()

aCollection.add(Normal(meanPoint, sigma, R))
meanPoint += Point(meanPoint.getDimension(), 1.0)
aCollection.add(Normal(meanPoint, sigma, R))
meanPoint += Point(meanPoint.getDimension(), 1.0)
aCollection.add(Normal(meanPoint, sigma, R))

# Instanciate one distribution object
distribution = Mixture(aCollection)

sample2 = distribution.getSample(size)
sample.add(sample2)


meanPoint[0] = 3
meanPoint[1] = 12

# Create a collection of distribution
aCollection = DistributionCollection()

aCollection.add(Normal(meanPoint, sigma, R))
meanPoint += Point(meanPoint.getDimension(), 1.0)
aCollection.add(Normal(meanPoint, sigma, R))
meanPoint += Point(meanPoint.getDimension(), 1.0)
aCollection.add(Normal(meanPoint, sigma, R))

# Instanciate one distribution object
distribution = Mixture(aCollection)

sample3 = distribution.getSample(size)
sample.add(sample3)

# Create the cloud
myCloud = Cloud(sample, "blue", "fsquare", "Normal Cloud")
myGraph = Graph("", "x1", "x2", True, "topright", 1.0)
myGraph.add(myCloud)

# myGraph.draw("Sample", 640, 480)

# Check that the correct files have been generated by computing their checksum
# print "bitmap=", myGraph.getBitmap()


kmeans = KMeansClustering(sample, 3)
kmeans.run()

result = kmeans.getCluster()
print("result=", result)

sample1 = Sample(0, 2)
sample2 = Sample(0, 2)
sample3 = Sample(0, 2)

for i in range(1500):
    if (result[i] == 1):
        sample1.add(sample[i])
    if (result[i] == 2):
        sample2.add(sample[i])
    if (result[i] == 0):
        sample3.add(sample[i])


myCloud = Cloud(sample1, "blue", "fsquare", "Normal Cloud")
myCloud2 = Cloud(sample2, "red", "fsquare", "Normal Cloud")
myCloud3 = Cloud(sample3, "green", "fsquare", "Normal Cloud")
myGraph2 = Graph("", "x1", "x2", True, "topright", 1.0)
myGraph2.add(myCloud)
myGraph2.add(myCloud2)
myGraph2.add(myCloud3)

# myGraph2.draw("Kmeans", 640, 480)

# print "bitmap=", myGraph2.getBitmap()
