# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""otsubsetinverse module"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_otsubsetinverse')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_otsubsetinverse')
    _otsubsetinverse = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_otsubsetinverse', [dirname(__file__)])
        except ImportError:
            import _otsubsetinverse
            return _otsubsetinverse
        try:
            _mod = imp.load_module('_otsubsetinverse', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _otsubsetinverse = swig_import_helper()
    del swig_import_helper
else:
    import _otsubsetinverse
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.uncertainty
import openturns.model_copula
import openturns.randomvector
import openturns.dist_bundle1
import openturns.dist_bundle2
import openturns.weightedexperiment
import openturns.classification
import openturns.orthogonalbasis
import openturns.metamodel
import openturns.transformation
import openturns.analytical
import openturns.simulation
import openturns.stattests
import openturns.model_process
class SubsetInverseSamplingResult(openturns.simulation.ProbabilitySimulationResult):
    __swig_setmethods__ = {}
    for _s in [openturns.simulation.ProbabilitySimulationResult]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SubsetInverseSamplingResult, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.simulation.ProbabilitySimulationResult]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SubsetInverseSamplingResult, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otsubsetinverse.SubsetInverseSamplingResult_getClassName(self)


    def getCoefficientOfVariation(self):
        """
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _otsubsetinverse.SubsetInverseSamplingResult_getCoefficientOfVariation(self)


    def __repr__(self):
        return _otsubsetinverse.SubsetInverseSamplingResult___repr__(self)

    def __init__(self, *args):
        this = _otsubsetinverse.new_SubsetInverseSamplingResult(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _otsubsetinverse.delete_SubsetInverseSamplingResult
    __del__ = lambda self: None
SubsetInverseSamplingResult_swigregister = _otsubsetinverse.SubsetInverseSamplingResult_swigregister
SubsetInverseSamplingResult_swigregister(SubsetInverseSamplingResult)

class SubsetInverseSampling(openturns.simulation.SimulationAlgorithm):
    """
    Subset inverse simulation.

    Parameters
    ----------
    event : :class:`~openturns.Event`
        Event we are computing the probability of. The threshold of the event is
        not used.
    targetProbability : float
        The wanted final probability.
    proposalRange : float, optional
        Proposal range length
    conditionalProbability : float, optional
        Value of :math:`P(F_i|F_{i-1})` between successive steps

    Notes
    -----
    The goal is to estimate the threshold of the following target probability :

    .. math::

        P_f = \\int_{\\mathcal D_f} f_{\\uX}(\\ux)\\di{\\ux}\\\\
            = \\int_{\\mathbb R^{n_X}} \\mathbf{1}_{\\{g(\\ux,\\underline{d}) \\:\\leq 0\\: \\}}f_{\\uX}(\\ux)\\di{\\ux}\\\\
            = \\Prob {\\{g(\\uX,\\underline{d}) \\leq q\\}}


    The idea of the subset simulation method is to replace simulating a
    rare failure event in the original probability space by a sequence of
    simulations of more frequent conditional events :math:`F_i` :

    .. math::

        F_1 \\supset F_2 \\supset \\dots \\supset F_m = F


    The original probability estimate rewrites :

    .. math::

        P_f = P(F_m) = P(\\bigcap \\limits_{i=1}^m F_i) = P(F_1) \\prod_{i=2}^m P(F_i|F_{i-1})


    And each conditional subset failure region is chosen by setting the threshold
    :math:`g_i` so that :math:`P(F_i|F_{i-1})` leads to a conditional failure
    probability of order :math:`0.1` :

    .. math::

        F_i =\\Prob {\\{g(\\uX,\\underline{d}) \\leq g_i\\}}


    The conditional samples are generated by the means of Markov Chains,
    using the Metropolis Hastings algorithm.

    :math:`N` being the number of simulations per subset, and :math:`p_{0i}` the
    conditional probability of each subset event, and :math:`\\gamma_i` the
    autocorrelation between Markov chain samples.

    .. math::

        \\delta^2 = \\sum_{i=1}^m \\delta^2_i = \\sum_{i=1}^m (1+\\gamma_i) \\frac{1-p_{0i}}{p_{0i}N}


    The first event :math:`F_1` not being conditional, :math:`\\delta^2_1`
    expresses as the classic Monte Carlo c.o.v.

    Examples
    --------
    >>> import openturns as ot
    >>> import otsubsetinverse as otsi

    >>> ot.RandomGenerator.SetSeed(0)

    Create a performance function with an associated distribution.

    >>> limitState = ot.SymbolicFunction(['u1', 'u2'], ['u1-u2'])
    >>> dim = limitState.getInputDimension()
    >>> mean = ot.Point([7., 2.])
    >>> sigma = ot.Point(dim, 1.0)
    >>> R = ot.IdentityMatrix(dim)
    >>> myDistribution = ot.Normal(mean, sigma, R)
    >>> vect = ot.RandomVector(myDistribution)
    >>> output = ot.RandomVector(limitState, vect)

    Create an event with a fictional threshold value which will not be used.

    >>> myEvent = ot.Event(output, ot.Less(), 0.)

    Define the target probability for which the threshold will be computed.

    >>> targetProbability = 0.0002
    >>> mySS = otsi.SubsetInverseSampling(myEvent, targetProbability)
    >>> mySS.setMaximumOuterSampling(10000)
    >>> mySS.run()

    Get some results.

    >>> ResultSS = mySS.getResult()
    >>> print('Pf = {}'.format(ResultSS.getProbabilityEstimate()))
    Pf = 0.0002
    >>> print('Threshold = {}'.format(mySS.getThresholdPerStep()[-1]))
    Threshold = 0.0202715501987
    >>> print('Threshold confidence length = {}'.format(
    ...                         mySS.getThresholdConfidenceLength(0.90)))
    Threshold confidence length = 0.0244117131807

    See also
    --------
    openturns.Simulation
    """

    __swig_setmethods__ = {}
    for _s in [openturns.simulation.SimulationAlgorithm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SubsetInverseSampling, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.simulation.SimulationAlgorithm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SubsetInverseSampling, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otsubsetinverse.SubsetInverseSampling_getClassName(self)


    def getEvent(self):
        return _otsubsetinverse.SubsetInverseSampling_getEvent(self)

    def getResult(self):
        return _otsubsetinverse.SubsetInverseSampling_getResult(self)

    def setProposalRange(self, proposalRange):
        """
        Proposal range length accessor.

        Parameters
        ----------
        range : float
            Range length.
        """
        return _otsubsetinverse.SubsetInverseSampling_setProposalRange(self, proposalRange)


    def getProposalRange(self):
        """
        Proposal range length accessor.

        Returns
        -------
        range : float
            Range length.
        """
        return _otsubsetinverse.SubsetInverseSampling_getProposalRange(self)


    def setConditionalProbability(self, conditionalProbability):
        """
        Conditional probability accessor.

        Value of :math:`P(F_i|F_{i-1})` between successive steps.

        Parameters
        ----------
        prob : float
            Conditional probability value.
        """
        return _otsubsetinverse.SubsetInverseSampling_setConditionalProbability(self, conditionalProbability)


    def getConditionalProbability(self):
        """
        Conditional probability accessor.

        Value of :math:`P(F_i|F_{i-1})` between successive steps.

        Returns
        -------
        prob : float
            Conditional probability value.
        """
        return _otsubsetinverse.SubsetInverseSampling_getConditionalProbability(self)


    def setTargetProbability(self, targetProbability):
        """
        Final target probability accessor.

        Value of :math:`P(F_m)`.

        Parameters
        ----------
        prob : float
            Final target probability value.
        """
        return _otsubsetinverse.SubsetInverseSampling_setTargetProbability(self, targetProbability)


    def getTargetProbability(self):
        """
        Final target probability accessor.

        Value of :math:`P(F_m)`.

        Returns
        -------
        prob : float
            Final target probability value.
        """
        return _otsubsetinverse.SubsetInverseSampling_getTargetProbability(self)


    def getNumberOfSteps(self):
        """
        Subset steps number accesor.

        Returns
        -------
        n : int
            Number of subset steps.
        """
        return _otsubsetinverse.SubsetInverseSampling_getNumberOfSteps(self)


    def getThresholdConfidenceLength(self, *args):
        """
        Accessor to the confidence length of the threshold.

        Parameters
        ----------
        level : float, :math:`level \\in ]0, 1[`
            Confidence level. By default, it is :math:`0.95`.

        Returns
        -------
        confidenceLength : float
            Length of the confidence interval at the confidence level *level*.
        """
        return _otsubsetinverse.SubsetInverseSampling_getThresholdConfidenceLength(self, *args)


    def getThresholdPerStep(self):
        """
        Threshold accessor.

        Returns
        -------
        threshold : :py:class:`openturns.Point`
            Threshold values.
        """
        return _otsubsetinverse.SubsetInverseSampling_getThresholdPerStep(self)


    def getGammaPerStep(self):
        """
        Autocorrelation accessor.

        Returns
        -------
        prob : :py:class:`openturns.Point`
            Autocorrelation values.
        """
        return _otsubsetinverse.SubsetInverseSampling_getGammaPerStep(self)


    def getCoefficientOfVariationPerStep(self):
        """
        Coefficient of variation per step accessor.

        Returns
        -------
        coef : :py:class:`openturns.Point`
            Coefficient of variation at each subset step.
        """
        return _otsubsetinverse.SubsetInverseSampling_getCoefficientOfVariationPerStep(self)


    def getProbabilityEstimatePerStep(self):
        """
        Probability estimate accessor.

        Returns
        -------
        prob : :py:class:`openturns.Point`
            Probability estimate values.
        """
        return _otsubsetinverse.SubsetInverseSampling_getProbabilityEstimatePerStep(self)


    def getThresholdCoefficientOfVariationPerStep(self):
        """
        Threshold coefficient of variation per step accessor.

        Returns
        -------
        coef : :py:class:`openturns.Point`
            Coefficient of variation at each subset step.
        """
        return _otsubsetinverse.SubsetInverseSampling_getThresholdCoefficientOfVariationPerStep(self)


    def setKeepEventSample(self, keepEventSample):
        """
        Sample storage accessor.

        Parameters
        ----------
        prob : bool
            Whether to keep the event samples.
        """
        return _otsubsetinverse.SubsetInverseSampling_setKeepEventSample(self, keepEventSample)


    def getEventInputSample(self):
        """
        Input sample accessor.

        Returns
        -------
        inputSample : :py:class:`openturns.Sample`
            Input sample.
        """
        return _otsubsetinverse.SubsetInverseSampling_getEventInputSample(self)


    def getEventOutputSample(self):
        """
        Output sample accessor.

        Returns
        -------
        outputSample : :py:class:`openturns.Sample`
            Ouput sample.
        """
        return _otsubsetinverse.SubsetInverseSampling_getEventOutputSample(self)


    def getOutputSample(self):
        """
        All output sample accessor.

        Returns
        -------
        outputSample : :py:class:`openturns.Sample`
            Output sample.
        """
        return _otsubsetinverse.SubsetInverseSampling_getOutputSample(self)


    def getInputSample(self):
        """
        All input sample accessor.

        Returns
        -------
        inputSample : :py:class:`openturns.Sample`
            Input sample.
        """
        return _otsubsetinverse.SubsetInverseSampling_getInputSample(self)


    def setISubset(self, iSubset):
        """
        Conditonal simulation activation accessor.

        Parameters
        ----------
        isubset : bool
            Activate or not the conditional simulation for the first step of the 
            simulation.
        """
        return _otsubsetinverse.SubsetInverseSampling_setISubset(self, iSubset)


    def setBetaMin(self, betaMin):
        """
        Radius of the hypershere accessor.

        Parameters
        ----------
        beta : float
            Radius value of the exclusion hypershere when the conditional simulation is activated.
        """
        return _otsubsetinverse.SubsetInverseSampling_setBetaMin(self, betaMin)


    def run(self):
        """
        Launch simulation.

        Notes
        -----
        It launches the simulation on a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows to use
        efficiently the distribution of the computation as well as it allows to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _otsubsetinverse.SubsetInverseSampling_run(self)


    def __repr__(self):
        return _otsubsetinverse.SubsetInverseSampling___repr__(self)

    def __init__(self, *args):
        this = _otsubsetinverse.new_SubsetInverseSampling(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _otsubsetinverse.delete_SubsetInverseSampling
    __del__ = lambda self: None
SubsetInverseSampling_swigregister = _otsubsetinverse.SubsetInverseSampling_swigregister
SubsetInverseSampling_swigregister(SubsetInverseSampling)
cvar = _otsubsetinverse.cvar
SubsetInverseSampling.DefaultMaximumOuterSampling = _otsubsetinverse.cvar.SubsetInverseSampling_DefaultMaximumOuterSampling
SubsetInverseSampling.DefaultProposalRange = _otsubsetinverse.cvar.SubsetInverseSampling_DefaultProposalRange
SubsetInverseSampling.DefaultConditionalProbability = _otsubsetinverse.cvar.SubsetInverseSampling_DefaultConditionalProbability
SubsetInverseSampling.DefaultBetaMin = _otsubsetinverse.cvar.SubsetInverseSampling_DefaultBetaMin

# This file is compatible with both classic and new-style classes.


