# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""otrobopt module"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _otrobopt
else:
    import _otrobopt

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.uncertainty
import openturns.model_copula
import openturns.randomvector
import openturns.dist_bundle1
import openturns.dist_bundle2
import openturns.weightedexperiment
import openturns.classification
import openturns.orthogonalbasis
import openturns.metamodel
import openturns.transformation
import openturns.analytical
import openturns.simulation
import openturns.stattests
import openturns.model_process
class MeasureEvaluationImplementation(openturns.func.EvaluationImplementation):
    r"""
    Measure evaluation base class.

    Base class for measure function evaluations, allows to define robust
    counterparts of parametric objective or constraint functions.

    See also
    --------
    MeanMeasure, VarianceMeasure, MeanStandardDeviationTradeoffMeasure,
    WorstCaseMeasure, JointChanceMeasure, IndividualChanceMeasure,
    QuantileMeasure, AggregatedMeasure
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.MeasureEvaluationImplementation_getClassName(self)

    def __call__(self, inP):
        return _otrobopt.MeasureEvaluationImplementation___call__(self, inP)

    def setDistribution(self, distribution):
        r"""
        Distribution accessor.

        Parameters
        ----------
        distribution : :py:class:`openturns.Distribution`
            Parameters distribution.
        """
        return _otrobopt.MeasureEvaluationImplementation_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Distribution accessor.

        Returns
        -------
        distribution : :py:class:`openturns.Distribution`
            Parameters distribution.
        """
        return _otrobopt.MeasureEvaluationImplementation_getDistribution(self)

    def setFunction(self, function):
        r"""
        Function accessor.

        Parameters
        ----------
        function : :py:class:`openturns.Function`
            Parametric function.
        """
        return _otrobopt.MeasureEvaluationImplementation_setFunction(self, function)

    def getFunction(self):
        r"""
        Function accessor.

        Returns
        -------
        function : :py:class:`openturns.Function`
            Parametric function.
        """
        return _otrobopt.MeasureEvaluationImplementation_getFunction(self)

    def getInputDimension(self):
        r"""
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _otrobopt.MeasureEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _otrobopt.MeasureEvaluationImplementation_getOutputDimension(self)

    def __repr__(self):
        return _otrobopt.MeasureEvaluationImplementation___repr__(self)

    def __str__(self, *args):
        return _otrobopt.MeasureEvaluationImplementation___str__(self, *args)

    def __init__(self, *args):
        _otrobopt.MeasureEvaluationImplementation_swiginit(self, _otrobopt.new_MeasureEvaluationImplementation(*args))
    __swig_destroy__ = _otrobopt.delete_MeasureEvaluationImplementation

# Register MeasureEvaluationImplementation in _otrobopt:
_otrobopt.MeasureEvaluationImplementation_swigregister(MeasureEvaluationImplementation)

class MeasureEvaluationImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _otrobopt.MeasureEvaluationImplementationTypedInterfaceObject_swiginit(self, _otrobopt.new_MeasureEvaluationImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _otrobopt.MeasureEvaluationImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _otrobopt.MeasureEvaluationImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _otrobopt.MeasureEvaluationImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _otrobopt.MeasureEvaluationImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _otrobopt.MeasureEvaluationImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _otrobopt.delete_MeasureEvaluationImplementationTypedInterfaceObject

# Register MeasureEvaluationImplementationTypedInterfaceObject in _otrobopt:
_otrobopt.MeasureEvaluationImplementationTypedInterfaceObject_swigregister(MeasureEvaluationImplementationTypedInterfaceObject)

class MeasureEvaluation(MeasureEvaluationImplementationTypedInterfaceObject):
    r"""
    Measure evaluation base class.

    Base class for measure function evaluations, allows to define robust
    counterparts of parametric objective or constraint functions.

    See also
    --------
    MeanMeasure, VarianceMeasure, MeanStandardDeviationTradeoffMeasure,
    WorstCaseMeasure, JointChanceMeasure, IndividualChanceMeasure,
    QuantileMeasure, AggregatedMeasure
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    @staticmethod
    def GetClassName():
        return _otrobopt.MeasureEvaluation_GetClassName()

    def getClassName(self):
        return _otrobopt.MeasureEvaluation_getClassName(self)

    def setDistribution(self, distribution):
        r"""
        Distribution accessor.

        Parameters
        ----------
        distribution : :py:class:`openturns.Distribution`
            Parameters distribution.
        """
        return _otrobopt.MeasureEvaluation_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Distribution accessor.

        Returns
        -------
        distribution : :py:class:`openturns.Distribution`
            Parameters distribution.
        """
        return _otrobopt.MeasureEvaluation_getDistribution(self)

    def setFunction(self, function):
        r"""
        Function accessor.

        Parameters
        ----------
        function : :py:class:`openturns.Function`
            Parametric function.
        """
        return _otrobopt.MeasureEvaluation_setFunction(self, function)

    def getFunction(self):
        r"""
        Function accessor.

        Returns
        -------
        function : :py:class:`openturns.Function`
            Parametric function.
        """
        return _otrobopt.MeasureEvaluation_getFunction(self)

    def __call__(self, inP):
        return _otrobopt.MeasureEvaluation___call__(self, inP)

    def __repr__(self):
        return _otrobopt.MeasureEvaluation___repr__(self)

    def __init__(self, *args):
        _otrobopt.MeasureEvaluation_swiginit(self, _otrobopt.new_MeasureEvaluation(*args))
    __swig_destroy__ = _otrobopt.delete_MeasureEvaluation

# Register MeasureEvaluation in _otrobopt:
_otrobopt.MeasureEvaluation_swigregister(MeasureEvaluation)

def MeasureEvaluation_GetClassName():
    return _otrobopt.MeasureEvaluation_GetClassName()

class MeanMeasure(MeasureEvaluationImplementation):
    r"""
    Mean measure function.

    It is built from a parametric function :math:`f` and a distribution :math:`\cD` of density function :math:`p`.


    In case of a continuous distribution:

    .. math::

        M_{f, \cD}(x) = \int_{Supp(\cD)} f(x, \theta) p(\theta) d \theta

    In case of a discrete distribution:

    .. math::

        M_{f, \cD}(x) = \sum_{\theta_i \in Supp(\cD)} f(x, \theta_i) p_i


    Parameters
    ----------
    function : :py:class:`openturns.Function`
        Parametric function
    distribution : :py:class:`openturns.Distribution`
        Distribution of parameters

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.SymbolicFunction(['x', 'theta'], ['x*theta'])
    >>> f = ot.ParametricFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.MeanMeasure(f, thetaDist)
    >>> x = [1.0]
    >>> print(measure(x))
    [2]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.MeanMeasure_getClassName(self)

    def __call__(self, inP):
        return _otrobopt.MeanMeasure___call__(self, inP)

    def __repr__(self):
        return _otrobopt.MeanMeasure___repr__(self)

    def __init__(self, *args):
        _otrobopt.MeanMeasure_swiginit(self, _otrobopt.new_MeanMeasure(*args))
    __swig_destroy__ = _otrobopt.delete_MeanMeasure

# Register MeanMeasure in _otrobopt:
_otrobopt.MeanMeasure_swigregister(MeanMeasure)

class VarianceMeasure(MeasureEvaluationImplementation):
    r"""
    Variance measure function.

    It is built from a parametric function :math:`f` and a distribution :math:`\cD` of density function :math:`p`.

    In case of a continuous distribution:

    .. math::

        \mu = \int_{Supp(\cD)} f(x, \theta) p(\theta) d \theta

        M_{f,\cD}(x) = \int_{Supp(\cD)} f(x, \theta)^2 p(\theta) d \theta - \mu^2

    In case of a discrete distribution:

    .. math::

        \mu = \sum_{\theta_i \in Supp(\cD)} f(x, \theta_i) p_i

        M_{f, \cD}(x) = \sum_{\theta_i \in Supp(\cD)} f(x, \theta_i)^2 p_i - \mu^2


    Parameters
    ----------
    function : :py:class:`openturns.Function`
        Parametric function
    distribution : :py:class:`openturns.Distribution`
        Distribution of parameters

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.SymbolicFunction(['x', 'theta'], ['x*theta'])
    >>> f = ot.ParametricFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.VarianceMeasure(f, thetaDist)
    >>> x = [1.0]
    >>> print(measure(x))
    [0.01]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.VarianceMeasure_getClassName(self)

    def __call__(self, inP):
        return _otrobopt.VarianceMeasure___call__(self, inP)

    def __repr__(self):
        return _otrobopt.VarianceMeasure___repr__(self)

    def __init__(self, *args):
        _otrobopt.VarianceMeasure_swiginit(self, _otrobopt.new_VarianceMeasure(*args))
    __swig_destroy__ = _otrobopt.delete_VarianceMeasure

# Register VarianceMeasure in _otrobopt:
_otrobopt.VarianceMeasure_swigregister(VarianceMeasure)

class MeanStandardDeviationTradeoffMeasure(MeasureEvaluationImplementation):
    r"""
    Mean/variance tradeoff measure function.


    It is built from a parametric function :math:`f` and a distribution :math:`\cD` of density function :math:`p`.

    In case of a continuous distribution:

    .. math::

        \mu_k = \int_{Supp(\cD)} f_k(x, \theta) p(\theta) d \theta

        Var_k = \int_{Supp(\cD)} f_k(x, \theta)^2 p(\theta) d \theta - \mu^2

        M_{f_k, \cD, \alpha_k}(x) = (1-\alpha_k) \mu_k + \alpha_k \sqrt{Var_k}

    In case of a discrete distribution:

    .. math::

        \mu_k = \sum_{\theta_i \in Supp(\cD)} f_k(x, \theta_i) p_i

        Var_k = \sum_{\theta_i \in Supp(\cD)} f_k(x, \theta_i)^2 p_i - {\mu_k}^2

        M_{f_k, \cD, \alpha_k}(x) = (1-\alpha_k) \mu_k + \alpha_k \sqrt{Var_k}


    Parameters
    ----------
    function : :py:class:`openturns.Function`
        Parametric function
    distribution : :py:class:`openturns.Distribution`
        Distribution of parameters
    alpha : sequence of float, :math:`\alpha_k \in [0,1]`
        Tradeoff coefficient

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.SymbolicFunction(['x', 'theta'], ['x*theta'])
    >>> f = ot.ParametricFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.MeanStandardDeviationTradeoffMeasure(f, thetaDist, [0.4])
    >>> x = [1.0]
    >>> print(measure(x))
    [1.24]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.MeanStandardDeviationTradeoffMeasure_getClassName(self)

    def __call__(self, inP):
        return _otrobopt.MeanStandardDeviationTradeoffMeasure___call__(self, inP)

    def setAlpha(self, alpha):
        r"""
        Tradeoff coefficient accessor.

        Parameters
        ----------
        alpha : sequence of  float in :math:`(0,1)`
            Tradeoff coefficient
        """
        return _otrobopt.MeanStandardDeviationTradeoffMeasure_setAlpha(self, alpha)

    def getAlpha(self):
        r"""
        Tradeoff coefficient accessor.

        Returns
        -------
        alpha : sequence of float in :math:`(0,1)`
            Tradeoff coefficient
        """
        return _otrobopt.MeanStandardDeviationTradeoffMeasure_getAlpha(self)

    def __repr__(self):
        return _otrobopt.MeanStandardDeviationTradeoffMeasure___repr__(self)

    def __init__(self, *args):
        _otrobopt.MeanStandardDeviationTradeoffMeasure_swiginit(self, _otrobopt.new_MeanStandardDeviationTradeoffMeasure(*args))
    __swig_destroy__ = _otrobopt.delete_MeanStandardDeviationTradeoffMeasure

# Register MeanStandardDeviationTradeoffMeasure in _otrobopt:
_otrobopt.MeanStandardDeviationTradeoffMeasure_swigregister(MeanStandardDeviationTradeoffMeasure)

class QuantileMeasure(MeasureEvaluationImplementation):
    r"""
    Quantile measure function.

    It is built from a parametric function :math:`f` and a distribution :math:`\cD` of density function :math:`p`.

    .. math::

        M_{f, \cD, \alpha}(x) = \inf \{ s \in \Rset \: | \: \Pset (f(x, \Theta) \leq s) \geq \alpha \}

    Parameters
    ----------
    function : :py:class:`openturns.Function`
        Parametric function
    distribution : :py:class:`openturns.Distribution`
        Distribution of parameters
    alpha : float, in :math:`[0,1]`
        Quantile level

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.SymbolicFunction(['x', 'theta'], ['x*theta'])
    >>> f = ot.ParametricFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.QuantileMeasure(f, thetaDist, 0.99)
    >>> x = [1.0]
    >>> print(measure(x))
    [2.23264]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.QuantileMeasure_getClassName(self)

    def __call__(self, inP):
        return _otrobopt.QuantileMeasure___call__(self, inP)

    def setAlpha(self, alpha):
        r"""
        Quantile level accessor.

        Parameters
        ----------
        alpha : float
            Quantile level
        """
        return _otrobopt.QuantileMeasure_setAlpha(self, alpha)

    def getAlpha(self):
        r"""
        Quantile level accessor.

        Returns
        -------
        alpha : float
            Quantile level
        """
        return _otrobopt.QuantileMeasure_getAlpha(self)

    def __repr__(self):
        return _otrobopt.QuantileMeasure___repr__(self)

    def __init__(self, *args):
        _otrobopt.QuantileMeasure_swiginit(self, _otrobopt.new_QuantileMeasure(*args))
    __swig_destroy__ = _otrobopt.delete_QuantileMeasure

# Register QuantileMeasure in _otrobopt:
_otrobopt.QuantileMeasure_swigregister(QuantileMeasure)

class WorstCaseMeasure(MeasureEvaluationImplementation):
    r"""
    Worst case measure function.

    It is built from a parametric function :math:`f` and a distribution :math:`\cD` of density function :math:`p`.

    In case of a continuous distribution:

    .. math::

        M_{f, \cD}(x) = \inf_{\theta \in Supp(\cD)} f(x, \theta)

    In case of a discrete distribution:

    .. math::

        M_{f, \cD}(x) = \inf_{\theta_i \in Supp(\cD)} f(x, \theta_i)


    Parameters
    ----------
    function : :py:class:`openturns.Function`
        Parametric function
    distribution : :py:class:`openturns.Distribution`
        Distribution of parameters
    isMinimization : bool (optional, defaults to `True`)
        Whether the worst case is the minimization of the criteria

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Uniform(-1.0, 4.0)
    >>> f_base = ot.SymbolicFunction(['x', 'theta'], ['x*theta'])
    >>> f = ot.ParametricFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.WorstCaseMeasure(f, thetaDist, False)
    >>> x = [1.0]
    >>> print(measure(x))
    [4]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.WorstCaseMeasure_getClassName(self)

    def __call__(self, inP):
        return _otrobopt.WorstCaseMeasure___call__(self, inP)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Optimization solver accessor.

        Parameters
        ----------
        solver : :py:class:`openturns.OptimizationAlgorithm`
            Optimization solver
        """
        return _otrobopt.WorstCaseMeasure_setOptimizationAlgorithm(self, solver)

    def getOptimizationAlgorithm(self):
        r"""
        Optimization solver accessor.

        Returns
        -------
        solver : :py:class:`openturns.OptimizationAlgorithm`
            Optimization solver
        """
        return _otrobopt.WorstCaseMeasure_getOptimizationAlgorithm(self)

    def setMinimization(self, minimization):
        r"""
        Minimization flag accessor.

        Parameters
        ----------
        minimization : bool
            Whether the problem is a minimization.
        """
        return _otrobopt.WorstCaseMeasure_setMinimization(self, minimization)

    def isMinimization(self):
        r"""
        Minimization flag accessor.

        Returns
        -------
        minimization : bool
            Whether the problem is a minimization.
        """
        return _otrobopt.WorstCaseMeasure_isMinimization(self)

    def __repr__(self):
        return _otrobopt.WorstCaseMeasure___repr__(self)

    def __init__(self, *args):
        _otrobopt.WorstCaseMeasure_swiginit(self, _otrobopt.new_WorstCaseMeasure(*args))
    __swig_destroy__ = _otrobopt.delete_WorstCaseMeasure

# Register WorstCaseMeasure in _otrobopt:
_otrobopt.WorstCaseMeasure_swigregister(WorstCaseMeasure)

class MeasureEvaluationCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _otrobopt.delete_MeasureEvaluationCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _otrobopt.MeasureEvaluationCollection_clear(self)

    def __len__(self):
        return _otrobopt.MeasureEvaluationCollection___len__(self)

    def __eq__(self, rhs):
        return _otrobopt.MeasureEvaluationCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _otrobopt.MeasureEvaluationCollection___contains__(self, val)

    def __getitem__(self, i):
        return _otrobopt.MeasureEvaluationCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _otrobopt.MeasureEvaluationCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _otrobopt.MeasureEvaluationCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _otrobopt.MeasureEvaluationCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _otrobopt.MeasureEvaluationCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _otrobopt.MeasureEvaluationCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _otrobopt.MeasureEvaluationCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _otrobopt.MeasureEvaluationCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _otrobopt.MeasureEvaluationCollection_find(self, val)

    def __repr__(self):
        return _otrobopt.MeasureEvaluationCollection___repr__(self)

    def __str__(self, *args):
        return _otrobopt.MeasureEvaluationCollection___str__(self, *args)

    def __init__(self, *args):
        _otrobopt.MeasureEvaluationCollection_swiginit(self, _otrobopt.new_MeasureEvaluationCollection(*args))

# Register MeasureEvaluationCollection in _otrobopt:
_otrobopt.MeasureEvaluationCollection_swigregister(MeasureEvaluationCollection)

class AggregatedMeasure(MeasureEvaluationImplementation):
    r"""
    Aggregated measure function.

    Assembles the output of several measure functions.

    Parameters
    ----------
    collection : sequence of :class:`~otrobopt.MeasureEvaluation`
        The measures to aggregate.

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.SymbolicFunction(['x', 'theta'], ['x*theta'])
    >>> f = ot.ParametricFunction(f_base, [1], [1.0])
    >>> measures = [otrobopt.MeanMeasure(f, thetaDist),
    ...             otrobopt.VarianceMeasure(f, thetaDist)]
    >>> measure = otrobopt.AggregatedMeasure(measures)
    >>> x = [1.0]
    >>> print(measure(x))
    [2,0.01]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.AggregatedMeasure_getClassName(self)

    def __call__(self, inP):
        return _otrobopt.AggregatedMeasure___call__(self, inP)

    def setDistribution(self, distribution):
        r"""
        Distribution accessor.

        Parameters
        ----------
        distribution : :py:class:`openturns.Distribution`
            Parameters distribution.
        """
        return _otrobopt.AggregatedMeasure_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Distribution accessor.

        Returns
        -------
        distribution : :py:class:`openturns.Distribution`
            Parameters distribution.
        """
        return _otrobopt.AggregatedMeasure_getDistribution(self)

    def __repr__(self):
        return _otrobopt.AggregatedMeasure___repr__(self)

    def __init__(self, *args):
        _otrobopt.AggregatedMeasure_swiginit(self, _otrobopt.new_AggregatedMeasure(*args))
    __swig_destroy__ = _otrobopt.delete_AggregatedMeasure

# Register AggregatedMeasure in _otrobopt:
_otrobopt.AggregatedMeasure_swigregister(AggregatedMeasure)

class JointChanceMeasure(MeasureEvaluationImplementation):
    r"""
    Joint chance measure function.

    It is built from a parametric function :math:`f` and a distribution :math:`\cD` of density function :math:`p`.

    When the constraint considered is :math:`\Pset (f_k(x, \Theta) \ge 0, \forall k \in K) \geq \alpha`:

    .. math::

        M_{f, \cD, \alpha}(x) = \Pset \left(\bigcap_{k \in K} \{f_k(x, \Theta) \ge 0\}\right) - \alpha

    In case of a continuous distribution:

    .. math::

        M_{f, \cD, \alpha}(x) = \int_{Supp(\cD)} \left( \prod_{k \in K} \mathbf{1}_{f_k(x, \theta) \ge 0} \right) p(\theta) d \theta - \alpha

    In case of a discrete distribution:

    .. math::

        M_{f, \cD, \alpha}(x) = \sum_{\theta_i \in Supp(\cD)}  \left( \prod_{k \in K} \mathbf{1}_{f_k(x, \theta_i) \ge 0} \right) p_i - \alpha

    Parameters
    ----------
    function : :py:class:`openturns.Function`
        Parametric function
    distribution : :py:class:`openturns.Distribution`
        Distribution of parameters
    operator : :py:class:`openturns.ComparisonOperator`
        Comparison operator in front of :math:`\alpha`
    alpha : float in :math:`(0,1)`
        Probability level

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(1.0, 1.0)
    >>> f_base = ot.SymbolicFunction(['x', 'theta'], ['x*theta'])
    >>> f = ot.ParametricFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.JointChanceMeasure(f, thetaDist, ot.GreaterOrEqual(), 0.95)
    >>> x = [1.0]
    >>> print(measure(x))
    [-0.108655]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.JointChanceMeasure_getClassName(self)

    def __call__(self, inP):
        return _otrobopt.JointChanceMeasure___call__(self, inP)

    def setAlpha(self, alpha):
        r"""
        Probability level accessor.

        Parameters
        ----------
        alpha : float in :math:`(0,1)`
            Probability level
        """
        return _otrobopt.JointChanceMeasure_setAlpha(self, alpha)

    def getAlpha(self):
        r"""
        Probability level accessor.

        Returns
        -------
        alpha : float in :math:`(0,1)`
            Probability level
        """
        return _otrobopt.JointChanceMeasure_getAlpha(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                         ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _otrobopt.JointChanceMeasure_getOutputDimension(self)

    def __repr__(self):
        return _otrobopt.JointChanceMeasure___repr__(self)

    def __init__(self, *args):
        _otrobopt.JointChanceMeasure_swiginit(self, _otrobopt.new_JointChanceMeasure(*args))
    __swig_destroy__ = _otrobopt.delete_JointChanceMeasure

# Register JointChanceMeasure in _otrobopt:
_otrobopt.JointChanceMeasure_swigregister(JointChanceMeasure)

class IndividualChanceMeasure(MeasureEvaluationImplementation):
    r"""
    Individual chance measure function.

    It is built from a parametric function :math:`f` and a distribution :math:`\cD` of density function :math:`p`.

    When the constraint considered is :math:`\Pset (f_k(x, \Theta) \ge 0) \geq \alpha_k, \forall k \in K`:

    .. math::

        M_{f_k, \cD, \alpha_k}(x) = \Pset (f_k(x, \theta) \ge 0) - \alpha_k

    In case of a continuous distribution:

    .. math::

        M_{f_k, \cD, \alpha_k}(x) = \int_{Supp(\cD)} \mathbf{1}_{f_k(x, \theta) \ge 0} p(\theta) d \theta - \alpha_k

    In case of a discrete distribution:

    .. math::

        M_{f_k, \cD, \alpha_k}(x) = \sum_{\theta_i \in Supp(\cD)} \mathbf{1}_{f_k(x, \theta_i) \ge 0} p_i - \alpha_k


    Parameters
    ----------
    function : :py:class:`openturns.Function`
        Parametric function
    distribution : :py:class:`openturns.Distribution`
        Distribution of parameters
    operator : :py:class:`openturns.ComparisonOperator`
        Comparison operator in front of :math:`\alpha_k`
    alpha : sequence of float
        Probability levels

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(1.0, 1.0)
    >>> f_base = ot.SymbolicFunction(['x', 'theta'], ['x*theta'])
    >>> f = ot.ParametricFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.IndividualChanceMeasure(f, thetaDist, ot.GreaterOrEqual(), [0.95])
    >>> x = [1.0]
    >>> print(measure(x))
    [-0.108655]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.IndividualChanceMeasure_getClassName(self)

    def __call__(self, inP):
        return _otrobopt.IndividualChanceMeasure___call__(self, inP)

    def setAlpha(self, alpha):
        r"""
        Probability levels accessor.

        Parameters
        ----------
        alpha : sequence of float in :math:`(0,1)`
            Probability levels
        """
        return _otrobopt.IndividualChanceMeasure_setAlpha(self, alpha)

    def getAlpha(self):
        r"""
        Probability levels accessor.

        Returns
        -------
        alpha : sequence of float in :math:`(0,1)`
            Probability levels
        """
        return _otrobopt.IndividualChanceMeasure_getAlpha(self)

    def __repr__(self):
        return _otrobopt.IndividualChanceMeasure___repr__(self)

    def __init__(self, *args):
        _otrobopt.IndividualChanceMeasure_swiginit(self, _otrobopt.new_IndividualChanceMeasure(*args))
    __swig_destroy__ = _otrobopt.delete_IndividualChanceMeasure

# Register IndividualChanceMeasure in _otrobopt:
_otrobopt.IndividualChanceMeasure_swigregister(IndividualChanceMeasure)

class MeasureFunction(openturns.func.FunctionImplementation):
    r"""
    Measure function.

    Parameters
    ----------
    evaluation : :class:`~otrobopt.MeasureEvaluation`
        Measure evaluation

    Examples
    --------
    First define a measure:

    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f = ot.SymbolicFunction(['x', 'theta'], ['x*theta'])
    >>> parametric = ot.ParametricFunction(f, [1], [1.0])
    >>> evaluation = otrobopt.MeanMeasure(parametric, thetaDist)
    >>> function = otrobopt.MeasureFunction(evaluation)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.MeasureFunction_getClassName(self)

    def __call__(self, *args):
        return _otrobopt.MeasureFunction___call__(self, *args)

    def getInputDimension(self):
        r"""
        Accessor to the dimension of the input vector.

        Returns
        -------
        inputDim : int
            Dimension of the input vector :math:`d`.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _otrobopt.MeasureFunction_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Dimension of the output vector :math:`d'`.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.SymbolicFunction(['x1', 'x2'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _otrobopt.MeasureFunction_getOutputDimension(self)

    def __repr__(self):
        return _otrobopt.MeasureFunction___repr__(self)

    def __init__(self, *args):
        _otrobopt.MeasureFunction_swiginit(self, _otrobopt.new_MeasureFunction(*args))
    __swig_destroy__ = _otrobopt.delete_MeasureFunction

# Register MeasureFunction in _otrobopt:
_otrobopt.MeasureFunction_swigregister(MeasureFunction)

class MeasureFactory(openturns.common.PersistentObject):
    r"""
    Discretize a measure function.

    It consists in replacing the distribution :math:`\cD` of the measure by a discrete
    approximation.

    .. math::

        \cD \rightarrow \sum_{i=1}^N \omega_i \delta_{\theta_i}


    Where :math:`\delta_{\theta_i}` is the Dirac measure at :math:`\theta_i`.

    Parameters
    ----------
    experiment : :py:class:`openturns.WeightedExperiment`
        Parameters design of experiment

    Examples
    --------
    First define a measure:

    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.SymbolicFunction(['x', 'theta'], ['x*theta'])
    >>> f = ot.ParametricFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.MeanMeasure(f, thetaDist)


    Then discretize it:

    >>> N = 10
    >>> experiment = ot.LHSExperiment(N)
    >>> factory = otrobopt.MeasureFactory(experiment)
    >>> discretizedMeasure = factory.build(measure)


    Discretize several measures at once:

    >>> coll = [otrobopt.MeanMeasure(f, thetaDist),
    ...         otrobopt.VarianceMeasure(f, thetaDist)]
    >>> discretizedMeasures = factory.buildCollection(coll)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.MeasureFactory_getClassName(self)

    def build(self, measure):
        r"""
        Discretize a measure.

        Parameters
        ----------
        measure : :class:`~otrobopt.MeasureEvaluation`
            Measure

        Returns
        -------
        measure : :class:`~otrobopt.MeasureEvaluation`
            Discretized measure
        """
        return _otrobopt.MeasureFactory_build(self, measure)

    def buildCollection(self, collection):
        r"""
        Discretize several measures.

        Parameters
        ----------
        collection : sequence of :class:`~otrobopt.MeasureEvaluation`
            The measures to discretize.

        Returns
        -------
        measures : sequence of :class:`~otrobopt.MeasureEvaluation`
            Discretized measures
        """
        return _otrobopt.MeasureFactory_buildCollection(self, collection)

    def __repr__(self):
        return _otrobopt.MeasureFactory___repr__(self)

    def __init__(self, *args):
        _otrobopt.MeasureFactory_swiginit(self, _otrobopt.new_MeasureFactory(*args))
    __swig_destroy__ = _otrobopt.delete_MeasureFactory

# Register MeasureFactory in _otrobopt:
_otrobopt.MeasureFactory_swigregister(MeasureFactory)

class RobustOptimizationProblem(openturns.optim.OptimizationProblemImplementation):
    r"""
    Robust optimization problem.

    Must consist at least of one :class:`~otrobopt.MeasureEvaluation`, either on
    the objective or the constraint.

    Available constructors:

        RobustOptimizationProblem(*robustnessMeasure, reliabilityMeasure*)

        RobustOptimizationProblem(*objective, reliabilityMeasure*)

        RobustOptimizationProblem(*robustnessMeasure, inequalityConstraint*)

    Parameters
    ----------
    robustnessMeasure : :class:`~otrobopt.MeasureEvaluation`
        Measure function on the objective.
    reliabilityMeasure : :class:`~otrobopt.MeasureEvaluation`
        Mesure function on the constraints
    objective : :py:class:`openturns.Function`
        Objective function
    inequalityConstraint : :py:class:`openturns.Function`
        Inequality constraint

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt


    Pure robustness problem:

    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.SymbolicFunction(['x1', 'theta'], ['x1*theta+cos(x1+theta)'])
    >>> f = ot.ParametricFunction(f_base, [1], [1.0])
    >>> robustnessMeasure = otrobopt.VarianceMeasure(f, thetaDist) 
    >>> problem = otrobopt.RobustOptimizationProblem(robustnessMeasure, ot.Function())
    >>> algo = ot.Cobyla(problem)
    >>> algo.setStartingPoint([0.0]*robustnessMeasure.getInputDimension())
    >>> algo.run()
    >>> x_et = algo.getResult().getOptimalPoint()
    >>> print(x_et)
    [0.55...]
    >>> J_et = algo.getResult().getOptimalValue()
    >>> print(J_et)
    [3.42652e-05]

    Robustness problem with deterministic constraint:

    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.SymbolicFunction(['x1', 'theta'], ['x1*theta'])
    >>> f = ot.ParametricFunction(f_base, [1], [1.0])
    >>> robustnessMeasure = otrobopt.MeanMeasure(f, thetaDist)
    >>> g = ot.SymbolicFunction(['x1'], ['x1 - 5.0'])
    >>> problem = otrobopt.RobustOptimizationProblem(robustnessMeasure, g)
    >>> algo = ot.Cobyla(problem)
    >>> algo.setStartingPoint([0.0]*robustnessMeasure.getInputDimension())
    >>> algo.run()
    >>> x_et = algo.getResult().getOptimalPoint()
    >>> print(x_et)
    [5]
    >>> J_et = algo.getResult().getOptimalValue()
    >>> print(J_et)
    [10]

    Pure reliability problem:

    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f = ot.SymbolicFunction(['x1'], ['x1+1'])
    >>> g_base = ot.SymbolicFunction(['x1', 'theta'], ['x1+theta'])
    >>> g = ot.ParametricFunction(g_base, [1], [1.0])
    >>> reliabilityMeasure = otrobopt.JointChanceMeasure(g, thetaDist, ot.Greater(), 0.95)
    >>> problem = otrobopt.RobustOptimizationProblem(f, reliabilityMeasure)
    >>> algo = ot.Cobyla(problem)
    >>> algo.setStartingPoint([0.0]*robustnessMeasure.getInputDimension())
    >>> algo.run()
    >>> x_et = algo.getResult().getOptimalPoint()
    >>> print(x_et)
    [-1.83551]
    >>> J_et = algo.getResult().getOptimalValue()
    >>> print(J_et)
    [-0.835515]

    Robustness & reliability problem:

    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.SymbolicFunction(['x1', 'theta'], ['x1*theta'])
    >>> f = ot.ParametricFunction(f_base, [1], [1.0])
    >>> robustnessMeasure = otrobopt.MeanMeasure(f, thetaDist)
    >>> g_base = ot.SymbolicFunction(['x1', 'theta'], ['x1+theta'])
    >>> g = ot.ParametricFunction(g_base, [1], [1.0])
    >>> reliabilityMeasure = otrobopt.JointChanceMeasure(g, thetaDist, ot.Greater(), 0.95)
    >>> problem = otrobopt.RobustOptimizationProblem(robustnessMeasure, reliabilityMeasure)
    >>> algo = ot.Cobyla(problem)
    >>> algo.setStartingPoint([0.0]*robustnessMeasure.getInputDimension())
    >>> algo.run()
    >>> x_et = algo.getResult().getOptimalPoint()
    >>> print(x_et)
    [-1.83551]
    >>> J_et = algo.getResult().getOptimalValue()
    >>> print(J_et)
    [-3.67103]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.RobustOptimizationProblem_getClassName(self)

    def setRobustnessMeasure(self, robustnessMeasure):
        r"""
        Robustness measure accessor.

        The measure on associated to the objective function

        Parameters
        ----------
        robustnessMeasure : :class:`~otrobopt.MeasureEvaluation`
            Measure function on the objective.
        """
        return _otrobopt.RobustOptimizationProblem_setRobustnessMeasure(self, robustnessMeasure)

    def getRobustnessMeasure(self):
        r"""
        Robustness measure accessor.

        The measure on associated to the objective function

        Returns
        -------
        robustnessMeasure : :class:`~otrobopt.MeasureEvaluation`
            Measure function on the objective.
        """
        return _otrobopt.RobustOptimizationProblem_getRobustnessMeasure(self)

    def hasRobustnessMeasure(self):
        r"""
        Robustness measure flag accessor.

        If no robustness measure was set, the problem should have a
        reliability measure.
        The objective is deduced from the robustness measure.

        Returns
        -------
        hasReliabilityMeasure : bool
            Whether a robustness measure was set
        """
        return _otrobopt.RobustOptimizationProblem_hasRobustnessMeasure(self)

    def setReliabilityMeasure(self, reliabilityMeasure):
        r"""
        Reliability measure accessor.

        The measure on associated to the constraint

        Parameters
        ----------
        reliabilityMeasure : :class:`~otrobopt.MeasureEvaluation`
            Mesure function on the constraints
        """
        return _otrobopt.RobustOptimizationProblem_setReliabilityMeasure(self, reliabilityMeasure)

    def getReliabilityMeasure(self):
        r"""
        Reliability measure accessor.

        The measure on associated to the constraint

        Returns
        -------
        reliabilityMeasure : :class:`~otrobopt.MeasureEvaluation`
            Mesure function on the constraints
        """
        return _otrobopt.RobustOptimizationProblem_getReliabilityMeasure(self)

    def hasReliabilityMeasure(self):
        r"""
        Reliability measure flag accessor.

        If no reliability measure was set, the problem should have a
        robustness measure.
        The constraints are deduced from the reliability measure.

        Returns
        -------
        hasReliabilityMeasure : bool
            Whether a reliability measure was set
        """
        return _otrobopt.RobustOptimizationProblem_hasReliabilityMeasure(self)

    def getDistribution(self):
        r"""
        Distribution accessor.

        Returns
        -------
        distribution : :py:class:`openturns.Distribution`
            Parameter distribution
        """
        return _otrobopt.RobustOptimizationProblem_getDistribution(self)

    def __repr__(self):
        return _otrobopt.RobustOptimizationProblem___repr__(self)

    def __init__(self, *args):
        _otrobopt.RobustOptimizationProblem_swiginit(self, _otrobopt.new_RobustOptimizationProblem(*args))
    __swig_destroy__ = _otrobopt.delete_RobustOptimizationProblem

# Register RobustOptimizationProblem in _otrobopt:
_otrobopt.RobustOptimizationProblem_swigregister(RobustOptimizationProblem)

class RobustOptimizationAlgorithm(openturns.optim.OptimizationAlgorithmImplementation):
    r"""
    Robust optimization algorithm base class.

    Operates on a robust optimization problem.

    Parameters
    ----------
    problem : :class:`~otrobopt.RobustOptimizationProblem`
        Robust optimization problem
    solver : :py:class:`openturns.OptimizationAlgorithm`
        Optimization solver

    See also
    --------
    SequentialMonteCarloRobustAlgorithm
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.RobustOptimizationAlgorithm_getClassName(self)

    def setRobustProblem(self, problem):
        r"""
        Robust optimization problem accessor.

        Parameters
        ----------
        problem : :class:`~otrobopt.RobustOptimizationProblem`
            Robust optimization problem
        """
        return _otrobopt.RobustOptimizationAlgorithm_setRobustProblem(self, problem)

    def getRobustProblem(self):
        r"""
        Robust optimization problem accessor.

        Returns
        -------
        problem : :class:`~otrobopt.RobustOptimizationProblem`
            Robust optimization problem
        """
        return _otrobopt.RobustOptimizationAlgorithm_getRobustProblem(self)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Optimization solver accessor.

        Parameters
        ----------
        solver : :py:class:`openturns.OptimizationAlgorithm`
            Optimization solver
        """
        return _otrobopt.RobustOptimizationAlgorithm_setOptimizationAlgorithm(self, solver)

    def getOptimizationAlgorithm(self):
        r"""
        Optimization solver accessor.

        Returns
        -------
        solver : :py:class:`openturns.OptimizationAlgorithm`
            Optimization solver
        """
        return _otrobopt.RobustOptimizationAlgorithm_getOptimizationAlgorithm(self)

    def __repr__(self):
        return _otrobopt.RobustOptimizationAlgorithm___repr__(self)

    def __init__(self, *args):
        _otrobopt.RobustOptimizationAlgorithm_swiginit(self, _otrobopt.new_RobustOptimizationAlgorithm(*args))
    __swig_destroy__ = _otrobopt.delete_RobustOptimizationAlgorithm

# Register RobustOptimizationAlgorithm in _otrobopt:
_otrobopt.RobustOptimizationAlgorithm_swigregister(RobustOptimizationAlgorithm)

class SequentialMonteCarloRobustAlgorithm(RobustOptimizationAlgorithm):
    r"""
    Sequential Monte Carlo robust optimization algorithm.

    Solves a robust optimization problem by alternating discretizing
    measures and solving deterministic problems.

    Measures are discretized using an initial size that can be set with
    :py:meth:`setInitialSamplingSize` and a size increment that is set with
    :py:meth:`setSamplingSizeIncrement`.

    The optimization problems relies on a Multi-Start algorithm from an initial LHS
    experiment and an internal solver that can be set by :py:meth:`setOptimizationAlgorithm`.
    The ResourceMap key `SequentialMonteCarloRobustAlgorithm-ConvergenceFactor`
    can be used to control the convergence criteria of the inner solver.

    The algorithm stops when the number of iterations has been reached or the
    absolute error is small enough.

    Parameters
    ----------
    problem : :class:`~otrobopt.RobustOptimizationProblem`
        Robust optimization problem
    solver : :py:class:`openturns.OptimizationAlgorithm`
        Optimization solver
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_getClassName(self)

    def run(self):
        r"""Launch the optimization."""
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_run(self)

    def setInitialSamplingSize(self, N0):
        r"""
        Initial sampling size accessor.

        Initial size of the discretization of :math:`\theta`.

        Parameters
        ----------
        initialSamplingSize : int
            Initial sampling size
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_setInitialSamplingSize(self, N0)

    def getInitialSamplingSize(self):
        r"""
        Initial sampling size accessor.

        Initial size of the discretization of :math:`\theta`.

        Returns
        -------
        initialSamplingSize : int
            Initial sampling size
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_getInitialSamplingSize(self)

    def setSamplingSizeIncrement(self, samplingSizeIncrement):
        r"""
        Sampling size increment accessor.

        Sampling size increment of :math:`\theta` as a function of the total size at
        the previous iteration.

        Parameters
        ----------
        samplingSizeIncrement : :py:class:`openturns.Function`
            Sampling size increment
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_setSamplingSizeIncrement(self, samplingSizeIncrement)

    def getSamplingSizeIncrement(self):
        r"""
        Sampling size increment accessor.

        Sampling size increment of :math:`\theta` as a function of the total size at
        the previous iteration.

        Returns
        -------
        samplingSizeIncrement : :py:class:`openturns.Function`
            Sampling size increment
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_getSamplingSizeIncrement(self)

    def setInitialSearch(self, initialSearch):
        r"""
        Multi-start number accessor.

        Initial number of start points used.

        Problem bounds must be specified when multi-start is used as start points are
        drawn uniformly into the bounding box using an LHS experiment.

        Parameters
        ----------
        initialSearch : int, 0 by default (no multi-start)
            Multi-start number
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_setInitialSearch(self, initialSearch)

    def getInitialSearch(self):
        r"""
        Multi-start number accessor.

        Initial number of start points used.

        Problem bounds must be specified when multi-start is used as start points are
        drawn uniformly into the bounding box.

        Returns
        -------
        initialSearch : int, 0 by default (no multi-start)
            Multi-start number
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_getInitialSearch(self)

    def getResultCollection(self):
        r"""
        Optimization intermediate results accessor.

        Optimization results at each step.

        Returns
        -------
        resultColl : sequence of :class:`openturns.OptimizationResult`
            List of optimization results
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_getResultCollection(self)

    def getInitialStartingPoints(self):
        r"""
        Multi-start optimization starting points accessor.

        Optimization starting points during the initial search phase.

        Returns
        -------
        startPoints : :class:`openturns.Sample`
            List of optimization starting points
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_getInitialStartingPoints(self)

    def getInitialResultCollection(self):
        r"""
        Multi-start optimization results accessor.

        Optimization results during the initial search phase.

        Returns
        -------
        resultColl : sequence of :class:`openturns.OptimizationResult`
            List of optimization results
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_getInitialResultCollection(self)

    def __repr__(self):
        return _otrobopt.SequentialMonteCarloRobustAlgorithm___repr__(self)

    def __init__(self, *args):
        _otrobopt.SequentialMonteCarloRobustAlgorithm_swiginit(self, _otrobopt.new_SequentialMonteCarloRobustAlgorithm(*args))
    __swig_destroy__ = _otrobopt.delete_SequentialMonteCarloRobustAlgorithm

# Register SequentialMonteCarloRobustAlgorithm in _otrobopt:
_otrobopt.SequentialMonteCarloRobustAlgorithm_swigregister(SequentialMonteCarloRobustAlgorithm)



