%feature("docstring") OTROBOPT::SequentialMonteCarloRobustAlgorithm
"Sequential Monte Carlo robust optimization algorithm.

Solves a robust optimization problem by alternating measure discretizing
measures and solving deterministic problems.

Parameters
----------
problem : :class:`~otrobopt.RobustOptimizationProblem`
    Robust optimization problem
solver : :py:class:`openturns.OptimizationAlgorithm`
    Optimization solver"

// ---------------------------------------------------------------------

%feature("docstring") OTROBOPT::SequentialMonteCarloRobustAlgorithm::setInitialSamplingSize
"Initial sampling size accessor.

Initial size of the discretization of :math:`\\\\theta`.

Parameters
----------
initialSamplingSize : int
    Initial sampling size"

// ---------------------------------------------------------------------

%feature("docstring") OTROBOPT::SequentialMonteCarloRobustAlgorithm::getInitialSamplingSize
"Initial sampling size accessor.

Initial size of the discretization of :math:`\\\\theta`.

Returns
-------
initialSamplingSize : int
    Initial sampling size"

// ---------------------------------------------------------------------

%feature("docstring") OTROBOPT::SequentialMonteCarloRobustAlgorithm::setSamplingSizeIncrement
"Sampling size increment accessor.

Sampling size increment of :math:`\\\\theta` as a function of the total size at
the previous iteration.

Parameters
----------
samplingSizeIncrement : :py:class:`openturns.Function`
    Sampling size increment"

// ---------------------------------------------------------------------

%feature("docstring") OTROBOPT::SequentialMonteCarloRobustAlgorithm::getSamplingSizeIncrement
"Sampling size increment accessor.

Sampling size increment of :math:`\\\\theta` as a function of the total size at
the previous iteration.

Returns
-------
samplingSizeIncrement : :py:class:`openturns.Function`
    Sampling size increment"

// ---------------------------------------------------------------------

%feature("docstring") OTROBOPT::SequentialMonteCarloRobustAlgorithm::setInitialSearch
"Multi-start number accessor.

Initial number of start points used.

Problem bounds must be specified when multi-start is used as start points are
drawned uniformly into the bounding box.

Parameters
----------
initialSearch : int, 0 by default (no multi-start)
    Multi-start number"

// ---------------------------------------------------------------------

%feature("docstring") OTROBOPT::SequentialMonteCarloRobustAlgorithm::getInitialSearch
"Multi-start number accessor.

Initial number of start points used.

Problem bounds must be specified when multi-start is used as start points are
drawned uniformly into the bounding box.

Returns
-------
initialSearch : int, 0 by default (no multi-start)
    Multi-start number"

// ---------------------------------------------------------------------

%feature("docstring") OTROBOPT::SequentialMonteCarloRobustAlgorithm::getInitialResultCollection
"Multi-start optimization results accessor.

Optimization results during the initial search phase.

Returns
-------
resultColl : sequence of :class:`openturns.OptimizationResult`
    List of optimization results"

// ---------------------------------------------------------------------

%feature("docstring") OTROBOPT::SequentialMonteCarloRobustAlgorithm::getInitialStartingPoints
"Multi-start optimization starting points accessor.

Optimization starting points during the initial search phase.

Returns
-------
startPoints : :class:`openturns.Sample`
    List of optimization starting points"

// ---------------------------------------------------------------------

%feature("docstring") OTROBOPT::SequentialMonteCarloRobustAlgorithm::getResultCollection
"Optimization intermediate results accessor.

Optimization results at each step.

Returns
-------
resultColl : sequence of :class:`openturns.OptimizationResult`
    List of optimization results"
