%feature("docstring") OTROBOPT::AggregatedMeasure
"Aggregated measure function.

Assembles the output of several measure functions.

Parameters
----------
collection : sequence of :class:`~otrobopt.MeasureEvaluation`
    The measures to aggregate.

Examples
--------
>>> import openturns as ot
>>> import otrobopt
>>> thetaDist = ot.Normal(2.0, 0.1)
>>> f_base = ot.SymbolicFunction(['x', 'theta'], ['x*theta'])
>>> f = ot.ParametricFunction(f_base, [1], [1.0])
>>> measures = [otrobopt.MeanMeasure(f, thetaDist),
...             otrobopt.VarianceMeasure(f, thetaDist)]
>>> measure = otrobopt.AggregatedMeasure(measures)
>>> x = [1.0]
>>> print(measure(x))
[2,0.01]"

// ---------------------------------------------------------------------

