# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
otrobopt module
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_otrobopt', [dirname(__file__)])
        except ImportError:
            import _otrobopt
            return _otrobopt
        if fp is not None:
            try:
                _mod = imp.load_module('_otrobopt', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _otrobopt = swig_import_helper()
    del swig_import_helper
else:
    import _otrobopt
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.solver
import openturns.algo
import openturns.experiment
import openturns.uncertainty
import openturns.model_copula
import openturns.randomvector
import openturns.dist_bundle1
import openturns.dist_bundle2
import openturns.weightedexperiment
import openturns.classification
import openturns.orthogonalbasis
import openturns.metamodel
import openturns.transformation
import openturns.analytical
import openturns.simulation
import openturns.stattests
import openturns.model_process
class MeasureEvaluationImplementation(openturns.func.NumericalMathEvaluationImplementation):
    """
    Measure evaluation base class.

    Base class for measure function evaluations, allows to define robust
    counterparts of parametric objective or constraint functions.

    See also
    --------
    MeanMeasure, VarianceMeasure, MeanStandardDeviationTradeoffMeasure,
    WorstCaseMeasure, JointChanceMeasure, IndividualChanceMeasure,
    QuantileMeasure, AggregatedMeasure
    """
    __swig_setmethods__ = {}
    for _s in [openturns.func.NumericalMathEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MeasureEvaluationImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.func.NumericalMathEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MeasureEvaluationImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.MeasureEvaluationImplementation_getClassName(self)

    def __call__(self, *args): return _otrobopt.MeasureEvaluationImplementation___call__(self, *args)
    def setDistribution(self, *args):
        """
        Distribution accessor.

        Parameters
        ----------
        distribution : :py:class:`openturns.Distribution`
            Parameters distribution.
        """
        return _otrobopt.MeasureEvaluationImplementation_setDistribution(self, *args)

    def getDistribution(self):
        """
        Distribution accessor.

        Returns
        -------
        distribution : :py:class:`openturns.Distribution`
            Parameters distribution.
        """
        return _otrobopt.MeasureEvaluationImplementation_getDistribution(self)

    def setFunction(self, *args):
        """
        Function accessor.

        Parameters
        ----------
        function : :py:class:`openturns.NumericalMathFunction`
            Parametric function.
        """
        return _otrobopt.MeasureEvaluationImplementation_setFunction(self, *args)

    def getFunction(self):
        """
        Function accessor.

        Returns
        -------
        function : :py:class:`openturns.NumericalMathFunction`
            Parametric function.
        """
        return _otrobopt.MeasureEvaluationImplementation_getFunction(self)

    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _otrobopt.MeasureEvaluationImplementation_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _otrobopt.MeasureEvaluationImplementation_getOutputDimension(self)

    def __repr__(self): return _otrobopt.MeasureEvaluationImplementation___repr__(self)
    def __str__(self, offset=""): return _otrobopt.MeasureEvaluationImplementation___str__(self, offset)
    def __init__(self, *args): 
        this = _otrobopt.new_MeasureEvaluationImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otrobopt.delete_MeasureEvaluationImplementation
    __del__ = lambda self : None;
MeasureEvaluationImplementation_swigregister = _otrobopt.MeasureEvaluationImplementation_swigregister
MeasureEvaluationImplementation_swigregister(MeasureEvaluationImplementation)

class MeasureEvaluationImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MeasureEvaluationImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MeasureEvaluationImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _otrobopt.new_MeasureEvaluationImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _otrobopt.MeasureEvaluationImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _otrobopt.MeasureEvaluationImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _otrobopt.MeasureEvaluationImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _otrobopt.MeasureEvaluationImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _otrobopt.delete_MeasureEvaluationImplementationTypedInterfaceObject
    __del__ = lambda self : None;
MeasureEvaluationImplementationTypedInterfaceObject_swigregister = _otrobopt.MeasureEvaluationImplementationTypedInterfaceObject_swigregister
MeasureEvaluationImplementationTypedInterfaceObject_swigregister(MeasureEvaluationImplementationTypedInterfaceObject)

class MeasureEvaluation(MeasureEvaluationImplementationTypedInterfaceObject):
    """
    Measure evaluation base class.

    Base class for measure function evaluations, allows to define robust
    counterparts of parametric objective or constraint functions.

    See also
    --------
    MeanMeasure, VarianceMeasure, MeanStandardDeviationTradeoffMeasure,
    WorstCaseMeasure, JointChanceMeasure, IndividualChanceMeasure,
    QuantileMeasure, AggregatedMeasure
    """
    __swig_setmethods__ = {}
    for _s in [MeasureEvaluationImplementationTypedInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MeasureEvaluation, name, value)
    __swig_getmethods__ = {}
    for _s in [MeasureEvaluationImplementationTypedInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MeasureEvaluation, name)
    __swig_getmethods__["GetClassName"] = lambda x: _otrobopt.MeasureEvaluation_GetClassName
    if _newclass:GetClassName = staticmethod(_otrobopt.MeasureEvaluation_GetClassName)
    def getClassName(self): return _otrobopt.MeasureEvaluation_getClassName(self)
    def setDistribution(self, *args):
        """
        Distribution accessor.

        Parameters
        ----------
        distribution : :py:class:`openturns.Distribution`
            Parameters distribution.
        """
        return _otrobopt.MeasureEvaluation_setDistribution(self, *args)

    def getDistribution(self):
        """
        Distribution accessor.

        Returns
        -------
        distribution : :py:class:`openturns.Distribution`
            Parameters distribution.
        """
        return _otrobopt.MeasureEvaluation_getDistribution(self)

    def setFunction(self, *args):
        """
        Function accessor.

        Parameters
        ----------
        function : :py:class:`openturns.NumericalMathFunction`
            Parametric function.
        """
        return _otrobopt.MeasureEvaluation_setFunction(self, *args)

    def getFunction(self):
        """
        Function accessor.

        Returns
        -------
        function : :py:class:`openturns.NumericalMathFunction`
            Parametric function.
        """
        return _otrobopt.MeasureEvaluation_getFunction(self)

    def __call__(self, *args): return _otrobopt.MeasureEvaluation___call__(self, *args)
    def __repr__(self): return _otrobopt.MeasureEvaluation___repr__(self)
    def __init__(self, *args): 
        this = _otrobopt.new_MeasureEvaluation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otrobopt.delete_MeasureEvaluation
    __del__ = lambda self : None;
MeasureEvaluation_swigregister = _otrobopt.MeasureEvaluation_swigregister
MeasureEvaluation_swigregister(MeasureEvaluation)

def MeasureEvaluation_GetClassName():
  return _otrobopt.MeasureEvaluation_GetClassName()
MeasureEvaluation_GetClassName = _otrobopt.MeasureEvaluation_GetClassName

class MeanMeasure(MeasureEvaluationImplementation):
    """
    Mean measure function.

    It is built from a parametric function :math:`f` and a distribution :math:`\\cD` of density function :math:`p`.


    In case of a continuous distribution:

    .. math::

        M_{f, \\cD}(x) = \\int_{Supp(\\cD)} f(x, \\theta) p(\\theta) d \\theta

    In case of a discrete distribution:

    .. math::

        M_{f, \\cD}(x) = \\sum_{\\theta_i \\in Supp(\\cD)} f(x, \\theta_i) p_i


    Parameters
    ----------
    function : :py:class:`openturns.NumericalMathFunction`
        Parametric function
    distribution : :py:class:`openturns.Distribution`
        Distribution of parameters

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.NumericalMathFunction(['x', 'theta'], ['y'], ['x*theta'])
    >>> f = ot.NumericalMathFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.MeanMeasure(f, thetaDist)
    >>> x = [1.0]
    >>> print(measure(x))
    [2]
    """
    __swig_setmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MeanMeasure, name, value)
    __swig_getmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MeanMeasure, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.MeanMeasure_getClassName(self)

    def __call__(self, *args): return _otrobopt.MeanMeasure___call__(self, *args)
    def __repr__(self): return _otrobopt.MeanMeasure___repr__(self)
    def __init__(self, *args): 
        this = _otrobopt.new_MeanMeasure(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otrobopt.delete_MeanMeasure
    __del__ = lambda self : None;
MeanMeasure_swigregister = _otrobopt.MeanMeasure_swigregister
MeanMeasure_swigregister(MeanMeasure)

class VarianceMeasure(MeasureEvaluationImplementation):
    """
    Variance measure function.

    It is built from a parametric function :math:`f` and a distribution :math:`\\cD` of density function :math:`p`.

    In case of a continuous distribution:

    .. math::

        \\mu = \\int_{Supp(\\cD)} f(x, \\theta) p(\\theta) d \\theta

        M_{f,\\cD}(x) = \\int_{Supp(\\cD)} f(x, \\theta)^2 p(\\theta) d \\theta - \\mu^2

    In case of a discrete distribution:

    .. math::

        \\mu = \\sum_{\\theta_i \\in Supp(\\cD)} f(x, \\theta_i) p_i

        M_{f, \\cD}(x) = \\sum_{\\theta_i \\in Supp(\\cD)} f(x, \\theta_i)^2 p_i - \\mu^2


    Parameters
    ----------
    function : :py:class:`openturns.NumericalMathFunction`
        Parametric function
    distribution : :py:class:`openturns.Distribution`
        Distribution of parameters

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.NumericalMathFunction(['x', 'theta'], ['y'], ['x*theta'])
    >>> f = ot.NumericalMathFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.VarianceMeasure(f, thetaDist)
    >>> x = [1.0]
    >>> print(measure(x))
    [0.01]
    """
    __swig_setmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, VarianceMeasure, name, value)
    __swig_getmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, VarianceMeasure, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.VarianceMeasure_getClassName(self)

    def __call__(self, *args): return _otrobopt.VarianceMeasure___call__(self, *args)
    def __repr__(self): return _otrobopt.VarianceMeasure___repr__(self)
    def __init__(self, *args): 
        this = _otrobopt.new_VarianceMeasure(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otrobopt.delete_VarianceMeasure
    __del__ = lambda self : None;
VarianceMeasure_swigregister = _otrobopt.VarianceMeasure_swigregister
VarianceMeasure_swigregister(VarianceMeasure)

class MeanStandardDeviationTradeoffMeasure(MeasureEvaluationImplementation):
    """
    Mean/variance tradeoff measure function.


    It is built from a parametric function :math:`f` and a distribution :math:`\\cD` of density function :math:`p`.

    In case of a continuous distribution:

    .. math::

        \\mu_k = \\int_{Supp(\\cD)} f_k(x, \\theta) p(\\theta) d \\theta

        Var_k = \\int_{Supp(\\cD)} f_k(x, \\theta)^2 p(\\theta) d \\theta - \\mu^2

        M_{f_k, \\cD, \\alpha_k}(x) = (1-\\alpha_k) \\mu_k + \\alpha_k \\sqrt{Var_k}

    In case of a discrete distribution:

    .. math::

        \\mu_k = \\sum_{\\theta_i \\in Supp(\\cD)} f_k(x, \\theta_i) p_i

        Var_k = \\sum_{\\theta_i \\in Supp(\\cD)} f_k(x, \\theta_i)^2 p_i - {\\mu_k}^2

        M_{f_k, \\cD, \\alpha_k}(x) = (1-\\alpha_k) \\mu_k + \\alpha_k \\sqrt{Var_k}


    Parameters
    ----------
    function : :py:class:`openturns.NumericalMathFunction`
        Parametric function
    distribution : :py:class:`openturns.Distribution`
        Distribution of parameters
    alpha : sequence of float, :math:`\\alpha_k \\in [0,1]`
        Tradeoff coefficient

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.NumericalMathFunction(['x', 'theta'], ['y'], ['x*theta'])
    >>> f = ot.NumericalMathFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.MeanStandardDeviationTradeoffMeasure(f, thetaDist, [0.4])
    >>> x = [1.0]
    >>> print(measure(x))
    [1.24]
    """
    __swig_setmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MeanStandardDeviationTradeoffMeasure, name, value)
    __swig_getmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MeanStandardDeviationTradeoffMeasure, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.MeanStandardDeviationTradeoffMeasure_getClassName(self)

    def __call__(self, *args): return _otrobopt.MeanStandardDeviationTradeoffMeasure___call__(self, *args)
    def setAlpha(self, *args):
        """
        Tradeoff coefficient accessor.

        Parameters
        ----------
        alpha : sequence of  float in :math:`(0,1)`
            Tradeoff coefficient
        """
        return _otrobopt.MeanStandardDeviationTradeoffMeasure_setAlpha(self, *args)

    def getAlpha(self):
        """
        Tradeoff coefficient accessor.

        Returns
        -------
        alpha : sequence of float in :math:`(0,1)`
            Tradeoff coefficient
        """
        return _otrobopt.MeanStandardDeviationTradeoffMeasure_getAlpha(self)

    def __repr__(self): return _otrobopt.MeanStandardDeviationTradeoffMeasure___repr__(self)
    def __init__(self, *args): 
        this = _otrobopt.new_MeanStandardDeviationTradeoffMeasure(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otrobopt.delete_MeanStandardDeviationTradeoffMeasure
    __del__ = lambda self : None;
MeanStandardDeviationTradeoffMeasure_swigregister = _otrobopt.MeanStandardDeviationTradeoffMeasure_swigregister
MeanStandardDeviationTradeoffMeasure_swigregister(MeanStandardDeviationTradeoffMeasure)

class QuantileMeasure(MeasureEvaluationImplementation):
    """
    Quantile measure function.

    It is built from a parametric function :math:`f` and a distribution :math:`\\cD` of density function :math:`p`.

    .. math::

        M_{f, \\cD, \\alpha}(x) = \\inf \\{ s \\in \\Rset \\: | \\: \\Pset (f(x, \\Theta) \\leq s) \\geq \\alpha \\}

    Parameters
    ----------
    function : :py:class:`openturns.NumericalMathFunction`
        Parametric function
    distribution : :py:class:`openturns.Distribution`
        Distribution of parameters
    alpha : float, in :math:`[0,1]`
        Quantile level

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.NumericalMathFunction(['x', 'theta'], ['y'], ['x*theta'])
    >>> f = ot.NumericalMathFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.QuantileMeasure(f, thetaDist, 0.99)
    >>> x = [1.0]
    >>> print(measure(x))
    [2.23264]
    """
    __swig_setmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, QuantileMeasure, name, value)
    __swig_getmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, QuantileMeasure, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.QuantileMeasure_getClassName(self)

    def __call__(self, *args): return _otrobopt.QuantileMeasure___call__(self, *args)
    def setAlpha(self, *args):
        """
        Quantile level accessor.

        Parameters
        ----------
        alpha : float
            Quantile level
        """
        return _otrobopt.QuantileMeasure_setAlpha(self, *args)

    def getAlpha(self):
        """
        Quantile level accessor.

        Returns
        -------
        alpha : float
            Quantile level
        """
        return _otrobopt.QuantileMeasure_getAlpha(self)

    def __repr__(self): return _otrobopt.QuantileMeasure___repr__(self)
    def __init__(self, *args): 
        this = _otrobopt.new_QuantileMeasure(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otrobopt.delete_QuantileMeasure
    __del__ = lambda self : None;
QuantileMeasure_swigregister = _otrobopt.QuantileMeasure_swigregister
QuantileMeasure_swigregister(QuantileMeasure)

class WorstCaseMeasure(MeasureEvaluationImplementation):
    """
    Worst case measure function.

    It is built from a parametric function :math:`f` and a distribution :math:`\\cD` of density function :math:`p`.

    In case of a continuous distribution:

    .. math::

        M_{f, \\cD}(x) = \\inf_{\\theta \\in Supp(\\cD)} f(x, \\theta)

    In case of a discrete distribution:

    .. math::

        M_{f, \\cD}(x) = \\inf_{\\theta_i \\in Supp(\\cD)} f(x, \\theta_i)


    Parameters
    ----------
    function : :py:class:`openturns.NumericalMathFunction`
        Parametric function
    distribution : :py:class:`openturns.Distribution`
        Distribution of parameters
    isMinimization : bool (optional, defaults to `True`)
        Whether the worst case is the minimization of the criteria

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Uniform(-1.0, 4.0)
    >>> f_base = ot.NumericalMathFunction(['x', 'theta'], ['y'], ['x*theta'])
    >>> f = ot.NumericalMathFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.WorstCaseMeasure(f, thetaDist, False)
    >>> x = [1.0]
    >>> print(measure(x))
    [4]
    """
    __swig_setmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, WorstCaseMeasure, name, value)
    __swig_getmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, WorstCaseMeasure, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.WorstCaseMeasure_getClassName(self)

    def __call__(self, *args): return _otrobopt.WorstCaseMeasure___call__(self, *args)
    def setOptimizationSolver(self, *args):
        """
        Optimization solver accessor.

        Parameters
        ----------
        solver : :py:class:`openturns.OptimizationSolver`
            Optimization solver
        """
        return _otrobopt.WorstCaseMeasure_setOptimizationSolver(self, *args)

    def getOptimizationSolver(self):
        """
        Optimization solver accessor.

        Returns
        -------
        solver : :py:class:`openturns.OptimizationSolver`
            Optimization solver
        """
        return _otrobopt.WorstCaseMeasure_getOptimizationSolver(self)

    def setMinimization(self, *args):
        """
        Minimization flag accessor.

        Parameters
        ----------
        minimization : bool
            Whether the problem is a minimization.
        """
        return _otrobopt.WorstCaseMeasure_setMinimization(self, *args)

    def isMinimization(self):
        """
        Minimization flag accessor.

        Returns
        -------
        minimization : bool
            Whether the problem is a minimization.
        """
        return _otrobopt.WorstCaseMeasure_isMinimization(self)

    def __repr__(self): return _otrobopt.WorstCaseMeasure___repr__(self)
    def __init__(self, *args): 
        this = _otrobopt.new_WorstCaseMeasure(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otrobopt.delete_WorstCaseMeasure
    __del__ = lambda self : None;
WorstCaseMeasure_swigregister = _otrobopt.WorstCaseMeasure_swigregister
WorstCaseMeasure_swigregister(WorstCaseMeasure)

class MeasureEvaluationCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MeasureEvaluationCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MeasureEvaluationCollection, name)
    __swig_destroy__ = _otrobopt.delete_MeasureEvaluationCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _otrobopt.MeasureEvaluationCollection_clear(self)

    def __len__(self): return _otrobopt.MeasureEvaluationCollection___len__(self)
    def __eq__(self, *args): return _otrobopt.MeasureEvaluationCollection___eq__(self, *args)
    def __contains__(self, *args): return _otrobopt.MeasureEvaluationCollection___contains__(self, *args)
    def __getitem__(self, *args): return _otrobopt.MeasureEvaluationCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _otrobopt.MeasureEvaluationCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _otrobopt.MeasureEvaluationCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _otrobopt.MeasureEvaluationCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _otrobopt.MeasureEvaluationCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _otrobopt.MeasureEvaluationCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _otrobopt.MeasureEvaluationCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _otrobopt.MeasureEvaluationCollection_isEmpty(self)

    def __repr__(self): return _otrobopt.MeasureEvaluationCollection___repr__(self)
    def __str__(self, offset=""): return _otrobopt.MeasureEvaluationCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _otrobopt.new_MeasureEvaluationCollection(*args)
        try: self.this.append(this)
        except: self.this = this
MeasureEvaluationCollection_swigregister = _otrobopt.MeasureEvaluationCollection_swigregister
MeasureEvaluationCollection_swigregister(MeasureEvaluationCollection)

class AggregatedMeasure(MeasureEvaluationImplementation):
    """
    Aggregated measure function.

    Assembles the output of several measure functions.

    Parameters
    ----------
    collection : sequence of :class:`~otrobopt.MeasureEvaluation`
        The measures to aggregate.

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.NumericalMathFunction(['x', 'theta'], ['y'], ['x*theta'])
    >>> f = ot.NumericalMathFunction(f_base, [1], [1.0])
    >>> measures = [otrobopt.MeanMeasure(f, thetaDist),
    ...             otrobopt.VarianceMeasure(f, thetaDist)]
    >>> measure = otrobopt.AggregatedMeasure(measures)
    >>> x = [1.0]
    >>> print(measure(x))
    [2,0.01]
    """
    __swig_setmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AggregatedMeasure, name, value)
    __swig_getmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, AggregatedMeasure, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.AggregatedMeasure_getClassName(self)

    def __call__(self, *args): return _otrobopt.AggregatedMeasure___call__(self, *args)
    def setDistribution(self, *args):
        """
        Distribution accessor.

        Parameters
        ----------
        distribution : :py:class:`openturns.Distribution`
            Parameters distribution.
        """
        return _otrobopt.AggregatedMeasure_setDistribution(self, *args)

    def getDistribution(self):
        """
        Distribution accessor.

        Returns
        -------
        distribution : :py:class:`openturns.Distribution`
            Parameters distribution.
        """
        return _otrobopt.AggregatedMeasure_getDistribution(self)

    def __repr__(self): return _otrobopt.AggregatedMeasure___repr__(self)
    def __init__(self, *args): 
        this = _otrobopt.new_AggregatedMeasure(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otrobopt.delete_AggregatedMeasure
    __del__ = lambda self : None;
AggregatedMeasure_swigregister = _otrobopt.AggregatedMeasure_swigregister
AggregatedMeasure_swigregister(AggregatedMeasure)

class JointChanceMeasure(MeasureEvaluationImplementation):
    """
    Joint chance measure function.

    It is built from a parametric function :math:`f` and a distribution :math:`\\cD` of density function :math:`p`.

    When the constraint considered is :math:`\\Pset (f_k(x, \\Theta) \\ge 0, \\forall k \\in K) \\geq \\alpha`:

    .. math::

        M_{f, \\cD, \\alpha}(x) = \\Pset \\left(\\bigcap_{k \\in K} \\{f_k(x, \\Theta) \\ge 0\\}\\right) - \\alpha

    In case of a continuous distribution:

    .. math::

        M_{f, \\cD, \\alpha}(x) = \\int_{Supp(\\cD)} \\left( \\prod_{k \\in K} \\mathbf{1}_{f_k(x, \\theta) \\ge 0} \\right) p(\\theta) d \\theta - \\alpha

    In case of a discrete distribution:

    .. math::

        M_{f, \\cD, \\alpha}(x) = \\sum_{\\theta_i \\in Supp(\\cD)}  \\left( \\prod_{k \\in K} \\mathbf{1}_{f_k(x, \\theta_i) \\ge 0} \\right) p_i - \\alpha

    Parameters
    ----------
    function : :py:class:`openturns.NumericalMathFunction`
        Parametric function
    distribution : :py:class:`openturns.Distribution`
        Distribution of parameters
    operator : :py:class:`openturns.ComparisonOperator`
        Comparison operator in front of :math:`\\alpha`
    alpha : float in :math:`(0,1)`
        Probability level

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(1.0, 1.0)
    >>> f_base = ot.NumericalMathFunction(['x', 'theta'], ['y'], ['x*theta'])
    >>> f = ot.NumericalMathFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.JointChanceMeasure(f, thetaDist, ot.GreaterOrEqual(), 0.95)
    >>> x = [1.0]
    >>> print(measure(x))
    [-0.108655]
    """
    __swig_setmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, JointChanceMeasure, name, value)
    __swig_getmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, JointChanceMeasure, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.JointChanceMeasure_getClassName(self)

    def __call__(self, *args): return _otrobopt.JointChanceMeasure___call__(self, *args)
    def setAlpha(self, *args):
        """
        Probability level accessor.

        Parameters
        ----------
        alpha : float in :math:`(0,1)`
            Probability level
        """
        return _otrobopt.JointChanceMeasure_setAlpha(self, *args)

    def getAlpha(self):
        """
        Probability level accessor.

        Returns
        -------
        alpha : float in :math:`(0,1)`
            Probability level
        """
        return _otrobopt.JointChanceMeasure_getAlpha(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _otrobopt.JointChanceMeasure_getOutputDimension(self)

    def __repr__(self): return _otrobopt.JointChanceMeasure___repr__(self)
    def __init__(self, *args): 
        this = _otrobopt.new_JointChanceMeasure(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otrobopt.delete_JointChanceMeasure
    __del__ = lambda self : None;
JointChanceMeasure_swigregister = _otrobopt.JointChanceMeasure_swigregister
JointChanceMeasure_swigregister(JointChanceMeasure)

class IndividualChanceMeasure(MeasureEvaluationImplementation):
    """
    Individual chance measure function.

    It is built from a parametric function :math:`f` and a distribution :math:`\\cD` of density function :math:`p`.

    When the constraint considered is :math:`\\Pset (f_k(x, \\Theta) \\ge 0) \\geq \\alpha_k, \\forall k \\in K`:

    .. math::

        M_{f_k, \\cD, \\alpha_k}(x) = \\Pset (f_k(x, \\theta) \\ge 0) - \\alpha_k

    In case of a continuous distribution:

    .. math::

        M_{f_k, \\cD, \\alpha_k}(x) = \\int_{Supp(\\cD)} \\mathbf{1}_{f_k(x, \\theta) \\ge 0} p(\\theta) d \\theta - \\alpha_k

    In case of a discrete distribution:

    .. math::

        M_{f_k, \\cD, \\alpha_k}(x) = \\sum_{\\theta_i \\in Supp(\\cD)} \\mathbf{1}_{f_k(x, \\theta_i) \\ge 0} p_i - \\alpha_k


    Parameters
    ----------
    function : :py:class:`openturns.NumericalMathFunction`
        Parametric function
    distribution : :py:class:`openturns.Distribution`
        Distribution of parameters
    operator : :py:class:`openturns.ComparisonOperator`
        Comparison operator in front of :math:`\\alpha_k`
    alpha : sequence of float
        Probability levels

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(1.0, 1.0)
    >>> f_base = ot.NumericalMathFunction(['x', 'theta'], ['y'], ['x*theta'])
    >>> f = ot.NumericalMathFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.IndividualChanceMeasure(f, thetaDist, ot.GreaterOrEqual(), [0.95])
    >>> x = [1.0]
    >>> print(measure(x))
    [-0.108655]
    """
    __swig_setmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IndividualChanceMeasure, name, value)
    __swig_getmethods__ = {}
    for _s in [MeasureEvaluationImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, IndividualChanceMeasure, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.IndividualChanceMeasure_getClassName(self)

    def __call__(self, *args): return _otrobopt.IndividualChanceMeasure___call__(self, *args)
    def setAlpha(self, *args):
        """
        Probability levels accessor.

        Parameters
        ----------
        alpha : sequence of float in :math:`(0,1)`
            Probability levels
        """
        return _otrobopt.IndividualChanceMeasure_setAlpha(self, *args)

    def getAlpha(self):
        """
        Probability levels accessor.

        Returns
        -------
        alpha : sequence of float in :math:`(0,1)`
            Probability levels
        """
        return _otrobopt.IndividualChanceMeasure_getAlpha(self)

    def __repr__(self): return _otrobopt.IndividualChanceMeasure___repr__(self)
    def __init__(self, *args): 
        this = _otrobopt.new_IndividualChanceMeasure(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otrobopt.delete_IndividualChanceMeasure
    __del__ = lambda self : None;
IndividualChanceMeasure_swigregister = _otrobopt.IndividualChanceMeasure_swigregister
IndividualChanceMeasure_swigregister(IndividualChanceMeasure)

class MeasureFunction(openturns.func.NumericalMathFunctionImplementation):
    """
    Measure function.

    Parameters
    ----------
    evaluation : :class:`~otrobopt.MeasureEvaluation`
        Measure evaluation

    Examples
    --------
    First define a measure:

    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f = ot.NumericalMathFunction(['x', 'theta'], ['y'], ['x*theta'])
    >>> parametric = ot.NumericalMathFunction(f, [1], [1.0])
    >>> evaluation = otrobopt.MeanMeasure(parametric, thetaDist)
    >>> function = otrobopt.MeasureFunction(evaluation)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.func.NumericalMathFunctionImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MeasureFunction, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.func.NumericalMathFunctionImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MeasureFunction, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.MeasureFunction_getClassName(self)

    def __call__(self, *args): return _otrobopt.MeasureFunction___call__(self, *args)
    def getInputDimension(self):
        """
        Accessor to the number of the inputs.

        Returns
        -------
        number_inputs : int
            Number of inputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getInputDimension())
        2
        """
        return _otrobopt.MeasureFunction_getInputDimension(self)

    def getOutputDimension(self):
        """
        Accessor to the number of the outputs.

        Returns
        -------
        number_outputs : int
            Number of outputs.

        Examples
        --------
        >>> import openturns as ot
        >>> f = ot.NumericalMathFunction(['x1', 'x2'], ['y'],
        ...                          ['2 * x1^2 + x1 + 8 * x2 + 4 * cos(x1) * x2 + 6'])
        >>> print(f.getOutputDimension())
        1
        """
        return _otrobopt.MeasureFunction_getOutputDimension(self)

    def __repr__(self): return _otrobopt.MeasureFunction___repr__(self)
    def __init__(self, *args): 
        this = _otrobopt.new_MeasureFunction(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otrobopt.delete_MeasureFunction
    __del__ = lambda self : None;
MeasureFunction_swigregister = _otrobopt.MeasureFunction_swigregister
MeasureFunction_swigregister(MeasureFunction)

class MeasureFactory(openturns.common.PersistentObject):
    """
    Discretize a measure function.

    It consists in replacing the distribution :math:`\\cD` of the measure by a discrete
    approximation.

    .. math::

        \\cD \\rightarrow \\sum_{i=1}^N \\omega_i \\delta_{\\theta_i}


    Where :math:`\\delta_{\\theta_i}` is the Dirac measure at :math:`\\theta_i`.

    Parameters
    ----------
    experiment : :py:class:`openturns.WeightedExperiment`
        Parameters design of experiment

    Examples
    --------
    First define a measure:

    >>> import openturns as ot
    >>> import otrobopt
    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.NumericalMathFunction(['x', 'theta'], ['y'], ['x*theta'])
    >>> f = ot.NumericalMathFunction(f_base, [1], [1.0])
    >>> measure = otrobopt.MeanMeasure(f, thetaDist)


    Then discretize it:

    >>> N = 10
    >>> experiment = ot.LHSExperiment(N)
    >>> factory = otrobopt.MeasureFactory(experiment)
    >>> discretizedMeasure = factory.build(measure)


    Discretize several measures at once:

    >>> coll = [otrobopt.MeanMeasure(f, thetaDist),
    ...         otrobopt.VarianceMeasure(f, thetaDist)]
    >>> discretizedMeasures = factory.buildCollection(coll)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MeasureFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MeasureFactory, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.MeasureFactory_getClassName(self)

    def build(self, *args):
        """
        Discretize a measure.

        Parameters
        ----------
        measure : :class:`~otrobopt.MeasureEvaluation`
            Measure

        Returns
        -------
        measure : :class:`~otrobopt.MeasureEvaluation`
            Discretized measure
        """
        return _otrobopt.MeasureFactory_build(self, *args)

    def buildCollection(self, *args):
        """
        Discretize several measures.

        Parameters
        ----------
        collection : sequence of :class:`~otrobopt.MeasureEvaluation`
            The measures to discretize.

        Returns
        -------
        measures : sequence of :class:`~otrobopt.MeasureEvaluation`
            Discretized measures
        """
        return _otrobopt.MeasureFactory_buildCollection(self, *args)

    def __repr__(self): return _otrobopt.MeasureFactory___repr__(self)
    def __init__(self, *args): 
        this = _otrobopt.new_MeasureFactory(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otrobopt.delete_MeasureFactory
    __del__ = lambda self : None;
MeasureFactory_swigregister = _otrobopt.MeasureFactory_swigregister
MeasureFactory_swigregister(MeasureFactory)

class RobustOptimizationProblem(openturns.optim.OptimizationProblemImplementation):
    """
    Robust optimization problem.

    Must consist at least of one :class:`~otrobopt.MeasureEvaluation`, either on
    the objective or the constraint.

    Available constructors:

        RobustOptimizationProblem(*robustnessMeasure, reliabilityMeasure*)

        RobustOptimizationProblem(*objective, reliabilityMeasure*)

        RobustOptimizationProblem(*robustnessMeasure, inequalityConstraint*)

    Parameters
    ----------
    robustnessMeasure : :class:`~otrobopt.MeasureEvaluation`
        Measure function on the objective.
    reliabilityMeasure : :class:`~otrobopt.MeasureEvaluation`
        Mesure function on the constraints
    objective : :py:class:`openturns.NumericalMathFunction`
        Objective function
    inequalityConstraint : :py:class:`openturns.NumericalMathFunction`
        Inequality constraint

    Examples
    --------
    >>> import openturns as ot
    >>> import otrobopt


    Pure robustness problem:

    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.NumericalMathFunction(['x1', 'theta'], ['y1'], ['x1*theta+cos(x1+theta)'])
    >>> f = ot.NumericalMathFunction(f_base, [1], [1.0])
    >>> robustnessMeasure = otrobopt.VarianceMeasure(f, thetaDist) 
    >>> problem = otrobopt.RobustOptimizationProblem(robustnessMeasure, ot.NumericalMathFunction())
    >>> algo = ot.Cobyla(problem)
    >>> algo.setStartingPoint([0.0]*robustnessMeasure.getInputDimension())
    >>> algo.run()
    >>> x_et = algo.getResult().getOptimalPoint()
    >>> print(x_et)
    [0.552012]
    >>> J_et = algo.getResult().getOptimalValue()
    >>> print(J_et)
    [3.42652e-05]

    Robustness problem with deterministic constraint:

    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.NumericalMathFunction(['x1', 'theta'], ['y1'], ['x1*theta'])
    >>> f = ot.NumericalMathFunction(f_base, [1], [1.0])
    >>> robustnessMeasure = otrobopt.MeanMeasure(f, thetaDist)
    >>> g = ot.NumericalMathFunction(['x1'], ['y1'], ['x1 - 5.0'])
    >>> problem = otrobopt.RobustOptimizationProblem(robustnessMeasure, g)
    >>> algo = ot.Cobyla(problem)
    >>> algo.setStartingPoint([0.0]*robustnessMeasure.getInputDimension())
    >>> algo.run()
    >>> x_et = algo.getResult().getOptimalPoint()
    >>> print(x_et)
    [5]
    >>> J_et = algo.getResult().getOptimalValue()
    >>> print(J_et)
    [10]

    Pure reliability problem:

    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f = ot.NumericalMathFunction(['x1'], ['y1'], ['x1+1'])
    >>> g_base = ot.NumericalMathFunction(['x1', 'theta'], ['y1'], ['x1+theta'])
    >>> g = ot.NumericalMathFunction(g_base, [1], [1.0])
    >>> reliabilityMeasure = otrobopt.JointChanceMeasure(g, thetaDist, ot.Greater(), 0.95)
    >>> problem = otrobopt.RobustOptimizationProblem(f, reliabilityMeasure)
    >>> algo = ot.Cobyla(problem)
    >>> algo.setStartingPoint([0.0]*robustnessMeasure.getInputDimension())
    >>> algo.run()
    >>> x_et = algo.getResult().getOptimalPoint()
    >>> print(x_et)
    [-1.83551]
    >>> J_et = algo.getResult().getOptimalValue()
    >>> print(J_et)
    [-0.835515]

    Robustness & reliability problem:

    >>> thetaDist = ot.Normal(2.0, 0.1)
    >>> f_base = ot.NumericalMathFunction(['x1', 'theta'], ['y1'], ['x1*theta'])
    >>> f = ot.NumericalMathFunction(f_base, [1], [1.0])
    >>> robustnessMeasure = otrobopt.MeanMeasure(f, thetaDist)
    >>> g_base = ot.NumericalMathFunction(['x1', 'theta'], ['y1'], ['x1+theta'])
    >>> g = ot.NumericalMathFunction(g_base, [1], [1.0])
    >>> reliabilityMeasure = otrobopt.JointChanceMeasure(g, thetaDist, ot.Greater(), 0.95)
    >>> problem = otrobopt.RobustOptimizationProblem(robustnessMeasure, reliabilityMeasure)
    >>> algo = ot.Cobyla(problem)
    >>> algo.setStartingPoint([0.0]*robustnessMeasure.getInputDimension())
    >>> algo.run()
    >>> x_et = algo.getResult().getOptimalPoint()
    >>> print(x_et)
    [-1.83551]
    >>> J_et = algo.getResult().getOptimalValue()
    >>> print(J_et)
    [-3.67103]
    """
    __swig_setmethods__ = {}
    for _s in [openturns.optim.OptimizationProblemImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RobustOptimizationProblem, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.optim.OptimizationProblemImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, RobustOptimizationProblem, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.RobustOptimizationProblem_getClassName(self)

    def setRobustnessMeasure(self, *args):
        """
        Robustness measure accessor.

        The measure on associated to the objective function

        Parameters
        ----------
        robustnessMeasure : :class:`~otrobopt.MeasureEvaluation`
            Measure function on the objective.
        """
        return _otrobopt.RobustOptimizationProblem_setRobustnessMeasure(self, *args)

    def getRobustnessMeasure(self):
        """
        Robustness measure accessor.

        The measure on associated to the objective function

        Returns
        -------
        robustnessMeasure : :class:`~otrobopt.MeasureEvaluation`
            Measure function on the objective.
        """
        return _otrobopt.RobustOptimizationProblem_getRobustnessMeasure(self)

    def hasRobustnessMeasure(self):
        """
        Robustness measure flag accessor.

        If no robustness measure was set, the problem should have a
        reliability measure.
        The objective is deduced from the robustness measure.

        Returns
        -------
        hasReliabilityMeasure : bool
            Whether a robustness measure was set
        """
        return _otrobopt.RobustOptimizationProblem_hasRobustnessMeasure(self)

    def setReliabilityMeasure(self, *args):
        """
        Reliability measure accessor.

        The measure on associated to the constraint

        Parameters
        ----------
        reliabilityMeasure : :class:`~otrobopt.MeasureEvaluation`
            Mesure function on the constraints
        """
        return _otrobopt.RobustOptimizationProblem_setReliabilityMeasure(self, *args)

    def getReliabilityMeasure(self):
        """
        Reliability measure accessor.

        The measure on associated to the constraint

        Returns
        -------
        reliabilityMeasure : :class:`~otrobopt.MeasureEvaluation`
            Mesure function on the constraints
        """
        return _otrobopt.RobustOptimizationProblem_getReliabilityMeasure(self)

    def hasReliabilityMeasure(self):
        """
        Reliability measure flag accessor.

        If no reliability measure was set, the problem should have a
        robustness measure.
        The constraints are deduced from the reliability measure.

        Returns
        -------
        hasReliabilityMeasure : bool
            Whether a reliability measure was set
        """
        return _otrobopt.RobustOptimizationProblem_hasReliabilityMeasure(self)

    def getDistribution(self):
        """
        Distribution accessor.

        Returns
        -------
        distribution : :py:class:`openturns.Distribution`
            Parameter distribution
        """
        return _otrobopt.RobustOptimizationProblem_getDistribution(self)

    def __repr__(self): return _otrobopt.RobustOptimizationProblem___repr__(self)
    def __init__(self, *args): 
        this = _otrobopt.new_RobustOptimizationProblem(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otrobopt.delete_RobustOptimizationProblem
    __del__ = lambda self : None;
RobustOptimizationProblem_swigregister = _otrobopt.RobustOptimizationProblem_swigregister
RobustOptimizationProblem_swigregister(RobustOptimizationProblem)

class RobustOptimizationAlgorithm(openturns.optim.OptimizationSolverImplementation):
    """
    Robust optimization algorithm base class.

    Operates on a robust optimization problem.

    Parameters
    ----------
    problem : :class:`~otrobopt.RobustOptimizationProblem`
        Robust optimization problem
    solver : :py:class:`openturns.OptimizationSolver`
        Optimization solver

    See also
    --------
    SequentialMonteCarloRobustAlgorithm
    """
    __swig_setmethods__ = {}
    for _s in [openturns.optim.OptimizationSolverImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RobustOptimizationAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.optim.OptimizationSolverImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, RobustOptimizationAlgorithm, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.RobustOptimizationAlgorithm_getClassName(self)

    def setRobustProblem(self, *args):
        """
        Robust optimization problem accessor.

        Parameters
        ----------
        problem : :class:`~otrobopt.RobustOptimizationProblem`
            Robust optimization problem
        """
        return _otrobopt.RobustOptimizationAlgorithm_setRobustProblem(self, *args)

    def getRobustProblem(self):
        """
        Robust optimization problem accessor.

        Returns
        -------
        problem : :class:`~otrobopt.RobustOptimizationProblem`
            Robust optimization problem
        """
        return _otrobopt.RobustOptimizationAlgorithm_getRobustProblem(self)

    def setOptimizationSolver(self, *args):
        """
        Optimization solver accessor.

        Parameters
        ----------
        solver : :py:class:`openturns.OptimizationSolver`
            Optimization solver
        """
        return _otrobopt.RobustOptimizationAlgorithm_setOptimizationSolver(self, *args)

    def getOptimizationSolver(self):
        """
        Optimization solver accessor.

        Returns
        -------
        solver : :py:class:`openturns.OptimizationSolver`
            Optimization solver
        """
        return _otrobopt.RobustOptimizationAlgorithm_getOptimizationSolver(self)

    def __repr__(self): return _otrobopt.RobustOptimizationAlgorithm___repr__(self)
    def __init__(self, *args): 
        this = _otrobopt.new_RobustOptimizationAlgorithm(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otrobopt.delete_RobustOptimizationAlgorithm
    __del__ = lambda self : None;
RobustOptimizationAlgorithm_swigregister = _otrobopt.RobustOptimizationAlgorithm_swigregister
RobustOptimizationAlgorithm_swigregister(RobustOptimizationAlgorithm)

class OptimizationResultCollection(_object):
    """
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.NumericalScalarCollection(2)
    [0,0]
    >>> ot.NumericalScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.NumericalScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.NumericalComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.NumericalComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.NumericalComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimizationResultCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, OptimizationResultCollection, name)
    __swig_destroy__ = _otrobopt.delete_OptimizationResultCollection
    __del__ = lambda self : None;
    def clear(self):
        """
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.clear()
        >>> x
        class=NumericalPoint name=Unnamed dimension=0 values=[]
        """
        return _otrobopt.OptimizationResultCollection_clear(self)

    def __len__(self): return _otrobopt.OptimizationResultCollection___len__(self)
    def __eq__(self, *args): return _otrobopt.OptimizationResultCollection___eq__(self, *args)
    def __contains__(self, *args): return _otrobopt.OptimizationResultCollection___contains__(self, *args)
    def __getitem__(self, *args): return _otrobopt.OptimizationResultCollection___getitem__(self, *args)
    def __setitem__(self, *args): return _otrobopt.OptimizationResultCollection___setitem__(self, *args)
    def __delitem__(self, *args): return _otrobopt.OptimizationResultCollection___delitem__(self, *args)
    def at(self, *args):
        """
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _otrobopt.OptimizationResultCollection_at(self, *args)

    def add(self, *args):
        """
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _otrobopt.OptimizationResultCollection_add(self, *args)

    def getSize(self):
        """
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _otrobopt.OptimizationResultCollection_getSize(self)

    def resize(self, *args):
        """
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _otrobopt.OptimizationResultCollection_resize(self, *args)

    def isEmpty(self):
        """
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.NumericalPoint(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _otrobopt.OptimizationResultCollection_isEmpty(self)

    def __repr__(self): return _otrobopt.OptimizationResultCollection___repr__(self)
    def __str__(self, offset=""): return _otrobopt.OptimizationResultCollection___str__(self, offset)
    def __init__(self, *args): 
        this = _otrobopt.new_OptimizationResultCollection(*args)
        try: self.this.append(this)
        except: self.this = this
OptimizationResultCollection_swigregister = _otrobopt.OptimizationResultCollection_swigregister
OptimizationResultCollection_swigregister(OptimizationResultCollection)

class SequentialMonteCarloRobustAlgorithm(RobustOptimizationAlgorithm):
    """
    Sequential Monte Carlo robust optimization algorithm.

    Solves a robust optimization problem by alternating measure discretizing
    measures and solving deterministic problems.

    Parameters
    ----------
    problem : :class:`~otrobopt.RobustOptimizationProblem`
        Robust optimization problem
    solver : :py:class:`openturns.OptimizationSolver`
        Optimization solver
    """
    __swig_setmethods__ = {}
    for _s in [RobustOptimizationAlgorithm]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SequentialMonteCarloRobustAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [RobustOptimizationAlgorithm]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SequentialMonteCarloRobustAlgorithm, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_getClassName(self)

    def run(self):
        """Launch the optimization."""
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_run(self)

    def setInitialSamplingSize(self, *args):
        """
        Initial sampling size accessor.

        Initial size of the discretization of :math:`\\theta`.

        Parameters
        ----------
        initialSamplingSize : int
            Initial sampling size
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_setInitialSamplingSize(self, *args)

    def getInitialSamplingSize(self):
        """
        Initial sampling size accessor.

        Initial size of the discretization of :math:`\\theta`.

        Returns
        -------
        initialSamplingSize : int
            Initial sampling size
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_getInitialSamplingSize(self)

    def setSamplingSizeIncrement(self, *args):
        """
        Sampling size increment accessor.

        Sampling size increment of :math:`\\theta` as a function of the total size at
        the previous iteration.

        Parameters
        ----------
        samplingSizeIncrement : :py:class:`openturns.NumericalMathFunction`
            Sampling size increment
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_setSamplingSizeIncrement(self, *args)

    def getSamplingSizeIncrement(self):
        """
        Sampling size increment accessor.

        Sampling size increment of :math:`\\theta` as a function of the total size at
        the previous iteration.

        Returns
        -------
        samplingSizeIncrement : :py:class:`openturns.NumericalMathFunction`
            Sampling size increment
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_getSamplingSizeIncrement(self)

    def setInitialSearch(self, *args):
        """
        Multi-start number accessor.

        Initial number of start points used.

        Problem bounds must be specified when multi-start is used as start points are
        drawned uniformly into the bounding box.

        Parameters
        ----------
        initialSearch : int, 0 by default (no multi-start)
            Multi-start number
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_setInitialSearch(self, *args)

    def getInitialSearch(self):
        """
        Multi-start number accessor.

        Initial number of start points used.

        Problem bounds must be specified when multi-start is used as start points are
        drawned uniformly into the bounding box.

        Returns
        -------
        initialSearch : int, 0 by default (no multi-start)
            Multi-start number
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_getInitialSearch(self)

    def getResultCollection(self):
        """
        Optimization intermediate results accessor.

        Optimization results at each step.

        Returns
        -------
        resultColl : sequence of :class:`openturns.OptimizationResult`
            List of optimization results
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_getResultCollection(self)

    def getInitialStartingPoints(self):
        """
        Multi-start optimization starting points accessor.

        Optimization starting points during the initial search phase.

        Returns
        -------
        startPoints : :class:`openturns.NumericalSample`
            List of optimization starting points
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_getInitialStartingPoints(self)

    def getInitialResultCollection(self):
        """
        Multi-start optimization results accessor.

        Optimization results during the initial search phase.

        Returns
        -------
        resultColl : sequence of :class:`openturns.OptimizationResult`
            List of optimization results
        """
        return _otrobopt.SequentialMonteCarloRobustAlgorithm_getInitialResultCollection(self)

    def __repr__(self): return _otrobopt.SequentialMonteCarloRobustAlgorithm___repr__(self)
    def __init__(self, *args): 
        this = _otrobopt.new_SequentialMonteCarloRobustAlgorithm(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otrobopt.delete_SequentialMonteCarloRobustAlgorithm
    __del__ = lambda self : None;
SequentialMonteCarloRobustAlgorithm_swigregister = _otrobopt.SequentialMonteCarloRobustAlgorithm_swigregister
SequentialMonteCarloRobustAlgorithm_swigregister(SequentialMonteCarloRobustAlgorithm)

# This file is compatible with both classic and new-style classes.


