# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""otpmml module"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_otpmml')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_otpmml')
    _otpmml = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_otpmml', [dirname(__file__)])
        except ImportError:
            import _otpmml
            return _otpmml
        try:
            _mod = imp.load_module('_otpmml', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _otpmml = swig_import_helper()
    del swig_import_helper
else:
    import _otpmml
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.uncertainty
import openturns.model_copula
import openturns.randomvector
import openturns.dist_bundle1
import openturns.dist_bundle2
import openturns.weightedexperiment
import openturns.classification
import openturns.orthogonalbasis
import openturns.metamodel
import openturns.transformation
import openturns.analytical
import openturns.simulation
import openturns.stattests
import openturns.model_process
class SamplePersistentCollection(openturns.common.PersistentObject, openturns.typ.SampleCollection):
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject, openturns.typ.SampleCollection]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SamplePersistentCollection, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject, openturns.typ.SampleCollection]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SamplePersistentCollection, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otpmml.SamplePersistentCollection_getClassName(self)


    def __init__(self, *args):
        this = _otpmml.new_SamplePersistentCollection(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __repr__(self):
        return _otpmml.SamplePersistentCollection___repr__(self)

    def __str__(self, *args):
        return _otpmml.SamplePersistentCollection___str__(self, *args)
    __swig_destroy__ = _otpmml.delete_SamplePersistentCollection
    __del__ = lambda self: None
SamplePersistentCollection_swigregister = _otpmml.SamplePersistentCollection_swigregister
SamplePersistentCollection_swigregister(SamplePersistentCollection)

class DAT(openturns.common.Object):
    __swig_setmethods__ = {}
    for _s in [openturns.common.Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DAT, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DAT, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otpmml.DAT_getClassName(self)


    def Import(datFile):
        """
        Import data from `dat` file

        Parameters
        ----------
        filename: string
            file that contains data

        Returns
        -------
        coll : collection
            Collection of Sample, of size 2
            Usually first sample corresponds to input data, second one to output

        Examples
        --------
        >>> import openturns as ot
        >>> import otpmml
        >>> # import collection
        >>> coll = DAT.Import('myData.dat')
        >>> # Get first and second samples
        >>> inputSample, outputSample = tuple(coll)
        """
        return _otpmml.DAT_Import(datFile)

    Import = staticmethod(Import)

    def Export(*args):
        """
        Export data to `dat` file

        Usage
        -----
          DAT.Export(filename, inputSample, outputSample)
          DAT.Export(filename, inputSample)

        Parameters
        ----------
        filename: string
            file that contains data

        inputSample: :class:`~openturns.Sample` or 2d-array like
            Corresponds to input data

        outputSample: :class:`~openturns.Sample` or 2d-array like
            Corresponds to output data

        Examples
        --------
        >>> import openturns as ot
        >>> import otpmml
        >>> # Generate samples
        >>> inputSample = ot.Normal(2).getSample(10)
        >>> outputSample = ot.Function(['x',y'], ['x+y'])(inputSample)
        >>> DAT.Export('myData.dat', inputSample, outputSample)
        """
        return _otpmml.DAT_Export(*args)

    Export = staticmethod(Export)
    __swig_destroy__ = _otpmml.delete_DAT
    __del__ = lambda self: None
DAT_swigregister = _otpmml.DAT_swigregister
DAT_swigregister(DAT)

def DAT_Import(datFile):
    """
    Import data from `dat` file

    Parameters
    ----------
    filename: string
        file that contains data

    Returns
    -------
    coll : collection
        Collection of Sample, of size 2
        Usually first sample corresponds to input data, second one to output

    Examples
    --------
    >>> import openturns as ot
    >>> import otpmml
    >>> # import collection
    >>> coll = DAT.Import('myData.dat')
    >>> # Get first and second samples
    >>> inputSample, outputSample = tuple(coll)
    """
    return _otpmml.DAT_Import(datFile)

def DAT_Export(*args):
    """
    Export data to `dat` file

    Usage
    -----
      DAT.Export(filename, inputSample, outputSample)
      DAT.Export(filename, inputSample)

    Parameters
    ----------
    filename: string
        file that contains data

    inputSample: :class:`~openturns.Sample` or 2d-array like
        Corresponds to input data

    outputSample: :class:`~openturns.Sample` or 2d-array like
        Corresponds to output data

    Examples
    --------
    >>> import openturns as ot
    >>> import otpmml
    >>> # Generate samples
    >>> inputSample = ot.Normal(2).getSample(10)
    >>> outputSample = ot.Function(['x',y'], ['x+y'])(inputSample)
    >>> DAT.Export('myData.dat', inputSample, outputSample)
    """
    return _otpmml.DAT_Export(*args)

class RegressionModel(openturns.common.PersistentObject):
    """
    The class enables to build a regression model from a PMML file.

    Usage
    ------
        model = RegressionModel(filename)
        model = RegressionModel(myLinearLeastSquares)

    Parameters
    ----------
    filename : string
        PMML file that contains the regression model

    myLinearLeastSquares: LinearLeastSquares
        Countains the algorithm for solving linear least squares.

    Examples
    --------
    import openturns as ot
    import otpmml
    model = otpmml.RegressionModel('myRModel.pmml')
    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RegressionModel, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RegressionModel, name)

    def getLinearLeastSquares(self):
        """
        The method returns the LinearLeastSquares arguments

        Returns
        -------
        model : LinearLeastSquares
            Openturns class for linear regression model

        Examples
        --------
        >>> import openturns as ot
        >>> import otpmml
        >>> model = otpmml.RegressionModel('myRModel.pmml')
        >>> linearModel = model.getLinearLeastSquares()
        """
        return _otpmml.RegressionModel_getLinearLeastSquares(self)


    def exportToPMMLFile(self, pmmlFile):
        """
        The method exports the model into a PMML file

        Parameters
        -----------
        filename : string
            PMML File for export.

        Examples
        --------
        >>> import openturns as ot
        >>> import otpmml
        >>> model = otpmml.RegressionModel('myRModel.pmml')
        >>> model.exportToPMMLFile('myModel.pmml')

        """
        return _otpmml.RegressionModel_exportToPMMLFile(self, pmmlFile)


    def __repr__(self):
        return _otpmml.RegressionModel___repr__(self)

    def __init__(self, *args):
        this = _otpmml.new_RegressionModel(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _otpmml.delete_RegressionModel
    __del__ = lambda self: None
RegressionModel_swigregister = _otpmml.RegressionModel_swigregister
RegressionModel_swigregister(RegressionModel)

class NeuralNetwork(openturns.func.Function):
    """

    The class enables to build a neural network model from a PMML file.

    Usage
    ------
        model = NeuralNetwork('myNNModel.pmml')

    Parameters
    ----------
    filename : string
        PMML file that contains the neural network model

    Examples
    --------
    >>> import openturns as ot
    >>> import otpmml
    >>> # load model
    >>> model = otpmml.NeuralNetwork('myNNModel.pmml')

    Notes
    ------
    The result object is of type Function.

    """

    __swig_setmethods__ = {}
    for _s in [openturns.func.Function]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NeuralNetwork, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.func.Function]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NeuralNetwork, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otpmml.NeuralNetwork_getClassName(self)


    def __repr__(self):
        return _otpmml.NeuralNetwork___repr__(self)

    def __str__(self, *args):
        return _otpmml.NeuralNetwork___str__(self, *args)

    def __init__(self, *args):
        this = _otpmml.new_NeuralNetwork(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _otpmml.delete_NeuralNetwork
    __del__ = lambda self: None
NeuralNetwork_swigregister = _otpmml.NeuralNetwork_swigregister
NeuralNetwork_swigregister(NeuralNetwork)

# This file is compatible with both classic and new-style classes.


