%feature("docstring") OTMORRIS::MorrisExperimentGrid
"MorrisExperimentGrid builds experiments for the Morris method starting from full p-levels grid experiments.

Available constructors:

    MorrisExperimentGrid(levels, N)

    MorrisExperimentGrid(levels, interval, N)

Parameters
----------
levels : :py:class:`openturns.Indices`
    Number of levels for a regular grid
N : int
    Number of trajectories
interval : :py:class:`openturns.Interval`
    Bounds of the domain

Notes
-----
With first constructor, we consider that initial experiment is a regular grid defined in :math:`[0,1]^d`.
With second constructor, we consider that initial distribution model is uniform with bounds given by the interval argument. Also, the initial experiment is of type regular.

Examples
--------
>>> import openturns as ot
>>> import otmorris
>>> # Number of trajectories
>>> r = 10
>>> # Define a k-grid level (so delta = 1/(k-1))
>>> k = 5
>>> dim = 3
>>> experiment = otmorris.MorrisExperimentGrid([k] * dim, r)
>>> X = experiment.generate()
"

// ---------------------------------------------------------------------

%feature("docstring") OTMORRIS::MorrisExperimentGrid::getJumpStep
"Get the jump step,  specifying the number of levels for each factor that are increased/decreased for computing the
elementary effects. If not given, it is set to 1 for each factor.

Returns
-------
humpStep : :py:class:`openturns.Indices`
    Number of levels for each factot that are increased/decreased for computating the EE.
"

// ---------------------------------------------------------------------

%feature("docstring") OTMORRIS::MorrisExperimentGrid::setJumpStep
"Set the jump step,  specifying the number of levels for each factor that are increased/decreased for computing the
elementary effects. If not given, it is set to 1 for each factor.


Parameters
----------
humpStep : :py:class:`openturns.Indices`
    Number of levels for each factot that are increased/decreased for computating the EE.

Notes
-----
The final jump step contains only integers, so the parameter argument is converted into a list of integer thanks to the
floor operator.
"

// ---------------------------------------------------------------------
