# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""otmorris module"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_otmorris')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_otmorris')
    _otmorris = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_otmorris', [dirname(__file__)])
        except ImportError:
            import _otmorris
            return _otmorris
        try:
            _mod = imp.load_module('_otmorris', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _otmorris = swig_import_helper()
    del swig_import_helper
else:
    import _otmorris
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.uncertainty
import openturns.model_copula
import openturns.randomvector
import openturns.dist_bundle1
import openturns.dist_bundle2
import openturns.weightedexperiment
import openturns.classification
import openturns.orthogonalbasis
import openturns.metamodel
import openturns.transformation
import openturns.analytical
import openturns.simulation
import openturns.stattests
import openturns.model_process
class Morris(openturns.common.PersistentObject):
    """
    Morris method.

    Available constructors:

        Morris(inputSample, outputSample)

        Morris(levels, N, model, interval)

        Morris(levels, N, model)

        Morris(lhsDesign, N, model, interval)

        Morris(lhsDesign, interval, N)


    Parameters
    ----------
    inputSample : :py:class:`openturns.Sample`
        Experiment generated thanks to the `generate` method of the :class:`~otmorris.MorrisExperiment`

    outputSample : :py:class:`openturns.Sample`
        Response model applied on `inputSample`

    levels : :py:class:`openturns.Indices`
        Number of levels for a regular grid

    N : int
        Number of trajectories

    interval : :py:class:`openturns.Interval`
        Bounds of the domain

    lhsDesign : :py:class:`openturns.Sample`
        Initial design

    model : :py:class:`openturns.Function`
        Response model to be applied on input data



    Notes
    -----
    We note :math:`\\cM:\\Rset^p \\mapsto \\Rset^q` with :math:`\\cM(\\vect{x})= \\vect{y}`.

    The Morris method is a screening method, which is known to be very efficient in case of huge number of input parameters (p >> 1).
    It is a qualitative sensitivity analysis method which is based on design of experiments and allows to identify the few important factors at a cost of r * (p + 1) simulations.
    The experiments are of type OAT (One At Time); i.e. only one parameter vary at a time.

    The method helps to split input parameters into three groups:

     - Those with negligible effects on the output,
     - Those with significant and linear effects on the output,
     - Those with significant and non linear (or with interactions) effects on the
       output.

     The method rely on input designs defined in the hypersphere unit. To sum up the key points of the method, we consider a point named :math:`\\vect{x^*}` in this hypersphere and a parameter :math:`\\delta` (parameter of discretization if we consider a regular experiment for example). Starting from the point, we choose randomly one direction by increasing\\slash decreasing one component one component of the point :math:`\\vect{x^*}` with :math:`\\delta`. Conditionnaly to this direction, we choose then the p-1 directions by randomly selecting one direction at time. We get then a trajectory (path).

    The Morris method rely on the evaluation of elementary effects which are defined as follow:

    .. math::

        d_{i}(\\vect{x}^k) = \\frac{\\cM(x_1^k,\\hdots, x_{i-1}^k, x_i^k + \\delta,\\hdots, x_p^k) - \\cM(x_1^k,\\hdots, x_{i-1}^k, x_i^k,\\hdots, x_p^k)}{\\delta}

    With :math:`N` trajectories, we get the mean and standard deviation of these effects (we consider the mean of absolute mean effects in our case). The mean explains the sensitivity wheras the standard deviation explains the interactions and non linear effects.

    With first constructor, we consider that input experiment has been generated thanks to the :class:`~otmorris.MorrisExperiment` and output is evaluated outside the platform.
    With second constructor, we consider that initial experiment is a regular grid defined in :math:`[0,1]^d`.
    With thirds constructor, we consider that initial distribution model is uniform with bounds given by the interval argument. Also, the initial experiment is of type regular.
    With fourth constructor, we fix the initial design which could be an LHS, an optimal LHS defined in :math:`[0,1]^d`.
    With fifth constructor, we fix the initial design which could be an LHS, an optimal LHS defined in :math:`[0,1]^d`.

    Examples
    --------
    >>> import openturns as ot
    >>> import otmorris
    >>> # Define model
    >>> ot.RandomGenerator.SetSeed(1)
    >>> alpha = ot.DistFunc.rNormal(10)
    >>> beta = ot.DistFunc.rNormal(84)
    >>> gamma = ot.DistFunc.rNormal(280)
    >>> b0 = ot.DistFunc.rNormal()
    >>> model = otmorris.MorrisFunction(alpha, beta, gamma, b0)
    >>> # Number of trajectories
    >>> r = 5
    >>> # Define a k-grid level (so delta = 1/(k-1))
    >>> k = 5
    >>> morris_experiment = otmorris.MorrisExperiment([k] * 20, r)
    >>> X = morris_experiment.generate()
    >>> # Evaluation of the model on the design: evaluation outside OT
    >>> Y = model(X)
    >>> # Evaluation of Morris effects
    >>> morris = otmorris.Morris(X, Y)
    >>> # Get mean/sigma effects
    >>> mean_effects = morris.getMeanElementaryEffects()
    >>> mean_abs_effects = morris.getMeanAbsoluteElementaryEffects()
    >>> sigma_effects = morris.getStandardDeviationElementaryEffects()

    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Morris, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Morris, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otmorris.Morris_getClassName(self)


    def getMeanAbsoluteElementaryEffects(self, outputMarginal=0):
        """
        Get the mean of absolute elementary effects.

        Parameters
        ----------
        marginal : int
            Output marginal of interest

        Returns
        -------
        mean: :py:class:`openturns.Point`
            The mean effects.


        """
        return _otmorris.Morris_getMeanAbsoluteElementaryEffects(self, outputMarginal)


    def getMeanElementaryEffects(self, outputMarginal=0):
        """
        Get the mean of elementary effects.

        Parameters
        ----------
        marginal : int
            Output marginal of interest

        Returns
        -------
        mean: :py:class:`openturns.Point`
            The mean effects.


        """
        return _otmorris.Morris_getMeanElementaryEffects(self, outputMarginal)


    def getStandardDeviationElementaryEffects(self, outputMarginal=0):
        """
        Get the standard deviation of elementary effects.

        Parameters
        ----------
        marginal : int
            Output marginal of interest

        Returns
        -------
        mean: :py:class:`openturns.Point`
            The standard effects

        """
        return _otmorris.Morris_getStandardDeviationElementaryEffects(self, outputMarginal)


    def __repr__(self):
        return _otmorris.Morris___repr__(self)

    def __init__(self, *args):
        this = _otmorris.new_Morris(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _otmorris.delete_Morris
    __del__ = lambda self: None
Morris_swigregister = _otmorris.Morris_swigregister
Morris_swigregister(Morris)



import openturns as ot

class MorrisFunction(ot.OpenTURNSPythonFunction):
    """
    The non-monotonic function of Morris f: R^20 -> R

    Reference:
      M. D. Morris, 1991, Factorial sampling plans for preliminary
      computational experiments,Technometrics, 33, 161--174.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(123)
    >>> b0 = ot.DistFunc.rNormal()
    >>> alpha = ot.DistFunc.rNormal(10)
    >>> beta =  ot.DistFunc.rNormal(6*14)
    >>> gamma =  ot.DistFunc.rNormal(20*14)
    >>> f = ot.Function( MorrisFunction(alpha, beta, gamma, b0) )
    >>> input_sample = ot.ComposedDistribution([ot.Uniform(0,1)] * 20).getSample(20)
    >>> output_sample = f(input_sample)

    """
    def __init__(self, alpha = ot.Point(10), beta = ot.Point(14*6),\
                 gamma = ot.Point(20*14), b0 = 0.0):
        ot.OpenTURNSPythonFunction.__init__(self, 20, 1)
        self.b0 = float(b0)
# Check alpha dimension
        assert(len(alpha) == 10)
        self.b1 = [20] * 10 + list(alpha)
# Check beta and gamma dimension
        assert(len(beta) == 6 * 14)
        assert(len(gamma) == 20 * 14)
        self.b2 = [[0] *20] * 20
        for i in range(6):
            for j in range(6):
                self.b2[i][j] = -15.0
# Tae into account beta
        k = 0
        for i in range(6):
            for j in range(14):
                self.b2[i][j + 6] = beta[k]
                k = k + 1
# Take into account beta
        k = 0
        for i in range(6, 20):
            for j in range(20):
                self.b2[i][j] = gamma[k]

# b3
        self.b3 = [[[0]*20]*20]*20
        for i in range(5):
            for j in range(5):
                for k in range(5):
                    self.b3[i][j][k] = -10.0
# b4
        self.b4 = [[[[0]*20]*20]*20]*20
        for i in range(4):
            for j in range(4):
                for k in range(4):
                    for l in range(4):
                        self.b4[i][j][k][l] = 5

    def _exec(self, x):
        assert (len(x)==20)
        b1 = self.b1
        b2 = self.b2
        b3 = self.b3
        b4 = self.b4
# X is a list, transform it into array
        X = ot.Point(x)
        w = (X - [0.5]*20)*2
        for k in [2,4,6]:
           w[k] = 2.0 * (1.1 * X[k] / (X[k] + 0.1) - 0.5)
        y = 0.0
        y = ot.dot(w, b1)
# Morris function
        for i in range(19):
            for j in range(i + 1, 20):
                y +=  b2[i][j] * w[i] * w[j]
        for i in range(18):
            for j in range(i + 1, 19):
                for k in range(j + 1, 20):
                    y += b3[i][j][k] * w[i] * w[j] * w[k]

        for i in range(17):
            for j in range(i + 1, 18):
                for k in range(j + 1, 20):
                    for l in range(k + 1, 20):
                        y += b4[i][j][k][l] * w[i] * w[j] * w[k] * w[l]

        return [y + self.b0]

class MorrisExperimentImplementationdInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MorrisExperimentImplementationdInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MorrisExperimentImplementationdInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _otmorris.new_MorrisExperimentImplementationdInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _otmorris.MorrisExperimentImplementationdInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _otmorris.MorrisExperimentImplementationdInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _otmorris.MorrisExperimentImplementationdInterfaceObject_getName(self)


    def __eq__(self, other):
        return _otmorris.MorrisExperimentImplementationdInterfaceObject___eq__(self, other)
    __swig_destroy__ = _otmorris.delete_MorrisExperimentImplementationdInterfaceObject
    __del__ = lambda self: None
MorrisExperimentImplementationdInterfaceObject_swigregister = _otmorris.MorrisExperimentImplementationdInterfaceObject_swigregister
MorrisExperimentImplementationdInterfaceObject_swigregister(MorrisExperimentImplementationdInterfaceObject)

class MorrisExperimentImplementation(openturns.weightedexperiment.WeightedExperimentImplementation):
    __swig_setmethods__ = {}
    for _s in [openturns.weightedexperiment.WeightedExperimentImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MorrisExperimentImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.weightedexperiment.WeightedExperimentImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MorrisExperimentImplementation, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otmorris.MorrisExperimentImplementation_getClassName(self)


    def generate(self):
        """
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :py:class:`openturns.Sample`
            Points that constitute the design of experiment, of size :math:`N \\times (p+1)`

        Examples
        --------
        >>> import openturns as ot
        >>> import otmorris
        >>> ot.RandomGenerator.SetSeed(1)
        >>> r = 5
        >>> # Define experiments in [0,1]^2
        >>> morris_experiment = otmorris.MorrisExperiment([3, 3], r)
        >>> X = morris_experiment.generate()


        """
        return _otmorris.MorrisExperimentImplementation_generate(self)


    def __repr__(self):
        return _otmorris.MorrisExperimentImplementation___repr__(self)

    def __init__(self, *args):
        this = _otmorris.new_MorrisExperimentImplementation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _otmorris.delete_MorrisExperimentImplementation
    __del__ = lambda self: None
MorrisExperimentImplementation_swigregister = _otmorris.MorrisExperimentImplementation_swigregister
MorrisExperimentImplementation_swigregister(MorrisExperimentImplementation)

class MorrisExperimentGrid(MorrisExperimentImplementation):
    """
    MorrisExperimentGrid builds experiments for the Morris method starting from full p-levels grid experiments.

    Available constructors:

        MorrisExperimentGrid(levels, N)

        MorrisExperimentGrid(levels, interval, N)

    Parameters
    ----------
    levels : :py:class:`openturns.Indices`
        Number of levels for a regular grid
    N : int
        Number of trajectories
    interval : :py:class:`openturns.Interval`
        Bounds of the domain

    Notes
    -----
    With first constructor, we consider that initial experiment is a regular grid defined in :math:`[0,1]^d`.
    With second constructor, we consider that initial distribution model is uniform with bounds given by the interval argument. Also, the initial experiment is of type regular.

    """

    __swig_setmethods__ = {}
    for _s in [MorrisExperimentImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MorrisExperimentGrid, name, value)
    __swig_getmethods__ = {}
    for _s in [MorrisExperimentImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MorrisExperimentGrid, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otmorris.MorrisExperimentGrid_getClassName(self)


    def generate(self):
        """
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :py:class:`openturns.Sample`
            Points that constitute the design of experiment, of size :math:`N \\times (p+1)`

        Examples
        --------
        >>> import openturns as ot
        >>> import otmorris
        >>> ot.RandomGenerator.SetSeed(1)
        >>> r = 5
        >>> # Define experiments in [0,1]^2
        >>> morris_experiment = otmorris.MorrisExperiment([3, 3], r)
        >>> X = morris_experiment.generate()


        """
        return _otmorris.MorrisExperimentGrid_generate(self)


    def __repr__(self):
        return _otmorris.MorrisExperimentGrid___repr__(self)

    def getJumpStep(self):
        """
        Get the jump step,  specifying the number of levels for each factor that are increased/decreased for computing the
        elementary effects. If not given, it is set to 1 for each factor.

        Returns
        -------
        humpStep : :py:class:`openturns.Indices`
            Number of levels for each factot that are increased/decreased for computating the EE.


        """
        return _otmorris.MorrisExperimentGrid_getJumpStep(self)


    def setJumpStep(self, jumpStep):
        """
        Set the jump step,  specifying the number of levels for each factor that are increased/decreased for computing the
        elementary effects. If not given, it is set to 1 for each factor.


        Parameters
        ----------
        humpStep : :py:class:`openturns.Indices`
            Number of levels for each factot that are increased/decreased for computating the EE.

        Notes
        -----
        The final jump step contains only integers, so the parameter argument is converted into a list of integer thanks to the
        floor operator.

        """
        return _otmorris.MorrisExperimentGrid_setJumpStep(self, jumpStep)


    def __init__(self, *args):
        this = _otmorris.new_MorrisExperimentGrid(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _otmorris.delete_MorrisExperimentGrid
    __del__ = lambda self: None
MorrisExperimentGrid_swigregister = _otmorris.MorrisExperimentGrid_swigregister
MorrisExperimentGrid_swigregister(MorrisExperimentGrid)

class MorrisExperimentLHSdInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MorrisExperimentLHSdInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MorrisExperimentLHSdInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _otmorris.new_MorrisExperimentLHSdInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _otmorris.MorrisExperimentLHSdInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _otmorris.MorrisExperimentLHSdInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _otmorris.MorrisExperimentLHSdInterfaceObject_getName(self)


    def __eq__(self, other):
        return _otmorris.MorrisExperimentLHSdInterfaceObject___eq__(self, other)
    __swig_destroy__ = _otmorris.delete_MorrisExperimentLHSdInterfaceObject
    __del__ = lambda self: None
MorrisExperimentLHSdInterfaceObject_swigregister = _otmorris.MorrisExperimentLHSdInterfaceObject_swigregister
MorrisExperimentLHSdInterfaceObject_swigregister(MorrisExperimentLHSdInterfaceObject)

class MorrisExperimentLHS(MorrisExperimentImplementation):
    """
    MorrisExperimentLHS builds experiments for the Morris method using a centered LHS design as input starting.

    Available constructors:

        MorrisExperiment(lhsDesign, N)

        MorrisExperiment(lhsDesign, interval, N)

    Parameters
    ----------
    lhsDesign : :py:class:`openturns.Sample`
        Initial design
    interval : :py:class:`openturns.Interval`
        Bounds of the domain
    N : int
        Number of trajectories

    Notes
    -----
    With the first constructor, we fix the initial design which could be an LHS, an optimal LHS defined in :math:`[0,1]^d`.
    With the second constructor LHS design and bounds are required.

    """

    __swig_setmethods__ = {}
    for _s in [MorrisExperimentImplementation]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MorrisExperimentLHS, name, value)
    __swig_getmethods__ = {}
    for _s in [MorrisExperimentImplementation]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MorrisExperimentLHS, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otmorris.MorrisExperimentLHS_getClassName(self)


    def generate(self):
        """
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :py:class:`openturns.Sample`
            Points that constitute the design of experiment, of size :math:`N \\times (p+1)`

        Examples
        --------
        >>> import openturns as ot
        >>> import otmorris
        >>> ot.RandomGenerator.SetSeed(1)
        >>> r = 5
        >>> # Define experiments in [0,1]^2
        >>> morris_experiment = otmorris.MorrisExperiment([3, 3], r)
        >>> X = morris_experiment.generate()


        """
        return _otmorris.MorrisExperimentLHS_generate(self)


    def __repr__(self):
        return _otmorris.MorrisExperimentLHS___repr__(self)

    def __init__(self, *args):
        this = _otmorris.new_MorrisExperimentLHS(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _otmorris.delete_MorrisExperimentLHS
    __del__ = lambda self: None
MorrisExperimentLHS_swigregister = _otmorris.MorrisExperimentLHS_swigregister
MorrisExperimentLHS_swigregister(MorrisExperimentLHS)

class MorrisExperimentImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MorrisExperimentImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MorrisExperimentImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _otmorris.new_MorrisExperimentImplementationTypedInterfaceObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _otmorris.MorrisExperimentImplementationTypedInterfaceObject_getImplementation(self, *args)


    def setName(self, name):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _otmorris.MorrisExperimentImplementationTypedInterfaceObject_setName(self, name)


    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _otmorris.MorrisExperimentImplementationTypedInterfaceObject_getName(self)


    def __eq__(self, other):
        return _otmorris.MorrisExperimentImplementationTypedInterfaceObject___eq__(self, other)
    __swig_destroy__ = _otmorris.delete_MorrisExperimentImplementationTypedInterfaceObject
    __del__ = lambda self: None
MorrisExperimentImplementationTypedInterfaceObject_swigregister = _otmorris.MorrisExperimentImplementationTypedInterfaceObject_swigregister
MorrisExperimentImplementationTypedInterfaceObject_swigregister(MorrisExperimentImplementationTypedInterfaceObject)

class MorrisExperiment(MorrisExperimentImplementationdInterfaceObject):
    """
    MorrisExperiment builds experiments for the Morris method.

    """

    __swig_setmethods__ = {}
    for _s in [MorrisExperimentImplementationdInterfaceObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MorrisExperiment, name, value)
    __swig_getmethods__ = {}
    for _s in [MorrisExperimentImplementationdInterfaceObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MorrisExperiment, name)
    if _newclass:
        GetClassName = staticmethod(_otmorris.MorrisExperiment_GetClassName)
    else:
        GetClassName = _otmorris.MorrisExperiment_GetClassName

    def getClassName(self):
        return _otmorris.MorrisExperiment_getClassName(self)

    def generate(self):
        """
        Generate points according to the type of the experiment.

        Returns
        -------
        sample : :py:class:`openturns.Sample`
            Points that constitute the design of experiment, of size :math:`N \\times (p+1)`

        Examples
        --------
        >>> import openturns as ot
        >>> import otmorris
        >>> ot.RandomGenerator.SetSeed(1)
        >>> r = 5
        >>> # Define experiments in [0,1]^2
        >>> morris_experiment = otmorris.MorrisExperiment([3, 3], r)
        >>> X = morris_experiment.generate()


        """
        return _otmorris.MorrisExperiment_generate(self)


    def __repr__(self):
        return _otmorris.MorrisExperiment___repr__(self)

    def __init__(self, *args):
        this = _otmorris.new_MorrisExperiment(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _otmorris.delete_MorrisExperiment
    __del__ = lambda self: None
MorrisExperiment_swigregister = _otmorris.MorrisExperiment_swigregister
MorrisExperiment_swigregister(MorrisExperiment)

def MorrisExperiment_GetClassName():
    return _otmorris.MorrisExperiment_GetClassName()
MorrisExperiment_GetClassName = _otmorris.MorrisExperiment_GetClassName

# This file is compatible with both classic and new-style classes.


