%define OTMORRIS_MorrisExperiment_doc
"MorrisExperiment builds experiments for the Morris method.
"
%enddef
%feature("docstring") OTMORRIS::MorrisExperiment
OTMORRIS_MorrisExperiment_doc

// ---------------------------------------------------------------------
%define OTMORRIS_MorrisExperiment_generate_doc
"Generate points according to the type of the experiment.

Returns
-------
sample : :py:class:`openturns.NumericalSample`
    Points that constitute the design of experiment, of size :math:`N \\\\times (p+1)`

Examples
--------
>>> import openturns as ot
>>> import otmorris
>>> ot.RandomGenerator.SetSeed(1)
>>> r = 5
>>> # Define experiments in [0,1]^2
>>> morris_experiment = otmorris.MorrisExperiment([3, 3], r)
>>> X = morris_experiment.generate()

"
%enddef

%feature("docstring") OTMORRIS::MorrisExperimentImplementation::generate
OTMORRIS_MorrisExperiment_generate_doc
