# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""otlm module"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_otlm')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_otlm')
    _otlm = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_otlm', [dirname(__file__)])
        except ImportError:
            import _otlm
            return _otlm
        try:
            _mod = imp.load_module('_otlm', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _otlm = swig_import_helper()
    del swig_import_helper
else:
    import _otlm
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.uncertainty
import openturns.model_copula
import openturns.randomvector
import openturns.dist_bundle1
import openturns.dist_bundle2
import openturns.weightedexperiment
import openturns.classification
import openturns.orthogonalbasis
import openturns.metamodel
import openturns.transformation
import openturns.analytical
import openturns.simulation
import openturns.stattests
import openturns.model_process
class MonomialFactory(openturns.orthogonalbasis.OrthogonalUniVariatePolynomialFactory):
    """
    Canonical monomial univariate polynomial family.

    Available constructor:
        MonomialFactory()

    Notes
    -----
    Any sequence of orthogonal polynomials has a recurrence formula relating any
    three consecutive polynomials as follows:

    .. math::

        P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \\quad 1 < i

    The recurrence coefficients for the monomials come analytically and
    read:

    .. math::

        \\begin{array}{rcl}
            a_i & = & 1 \\\\
            b_i & = & 0 \\\\
            c_i & = & 0
        \\end{array}, \\quad 1 < i

    See also
    --------
    StandardDistributionPolynomialFactory

    Examples
    --------
    >>> import otlm
    >>> monomial_factory = otlm.MonomialFactory()
    >>> for i in range(3):
    ...     print(monomial_factory.build(i))
    1
    X
    X^2
    """

    __swig_setmethods__ = {}
    for _s in [openturns.orthogonalbasis.OrthogonalUniVariatePolynomialFactory]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MonomialFactory, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.orthogonalbasis.OrthogonalUniVariatePolynomialFactory]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MonomialFactory, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlm.MonomialFactory_getClassName(self)


    def getRecurrenceCoefficients(self, n):
        """
        Accessor to the recurrence coefficients of the :math:`k`-th order.

        Of the orthogonal univariate polynomial.

        Parameters
        ----------
        k : int, :math:`0 \\leq k`
            Polynomial order.

        Notes
        -----
        Any sequence of orthogonal polynomials has a recurrence formula relating any
        three consecutive polynomials as follows:

        .. math::

            P_{-1}=0, P_0=1, P_{n + 1} = (a_n x + b_n) P_n + c_n P_{n - 1}, \\quad n > 1

        Returns
        -------
        recurrence_coefficients : :class:`~openturns.Point`
            The recurrence coefficients of the :math:`k`-th order orthogonal
            univariate polynomial.

        Examples
        --------
        >>> import openturns as ot
        >>> polynomial_factory = ot.HermiteFactory()
        >>> print(polynomial_factory.getRecurrenceCoefficients(3))
        [0.5,0,-0.866025]
        """
        return _otlm.MonomialFactory_getRecurrenceCoefficients(self, n)


    def __repr__(self):
        return _otlm.MonomialFactory___repr__(self)

    def __init__(self, *args):
        this = _otlm.new_MonomialFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _otlm.delete_MonomialFactory
    __del__ = lambda self: None
MonomialFactory_swigregister = _otlm.MonomialFactory_swigregister
MonomialFactory_swigregister(MonomialFactory)

class LinearModelResult(openturns.metamodel.MetaModelResult):
    """
    The LinearModelResult class is created through the method getResult of a LinearModelAlgorithm.


    Available constructors:
        LinearModelResult(*inputSample, basis, design, outputSample, metaModel, trendCoefficients, formula, coefficientsNames, sampleResiduals, diagonalGramInverse, leverages, cookDistances*)


    Parameters
    ----------
    inputSample, outputSample : :class:`~openturns.Sample`
        The input and output samples of a model.
    metaModel : :class:`~openturns.Function`
        The meta model.
    basis : :class:`~openturns.Basis`
        Functional basis to estimate the trend.
    design : :class:`~openturns.Matrix`
        The design matrix math:`X`.
    trendCoefficients : :class:`~openturns.Point`
        The trend coeffients associated to the linearmodel. 
    formula : :class:`~openturns.String` 
         The formula description. 
    coefficientsNames : :class:`~openturns.Description` 
         The coefficients names of the basis.  
    sampleResiduals : :class:`~openturns.Point`
        The residual errors.
    diagonalGramInverse : :class:`~openturns.Point`
        The diagonal of the Gram inverse matrix.
    leverages : :class:`~openturns.Point`
        The leverage score. 
    cookDistances : :class:`~openturns.Point`
        The cook's distances.


    See Also
    --------
    LinearModel, LinearModelAlgorithm

    """

    __swig_setmethods__ = {}
    for _s in [openturns.metamodel.MetaModelResult]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearModelResult, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.metamodel.MetaModelResult]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearModelResult, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlm.LinearModelResult_getClassName(self)


    def __repr__(self):
        return _otlm.LinearModelResult___repr__(self)

    def getInputSample(self):
        """
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            The Xsample which had been passed to the constructor.
        """
        return _otlm.LinearModelResult_getInputSample(self)


    def getOutputSample(self):
        """
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            The Ysample which had been passed to the constructor.
        """
        return _otlm.LinearModelResult_getOutputSample(self)


    def getFittedSample(self):
        """
        Accessor to the fitted sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`

        """
        return _otlm.LinearModelResult_getFittedSample(self)


    def getTrendCoefficients(self):
        """
        Accessor to the coefficients of the linear model of the trend.

        Returns
        -------
        beta : :class:`~openturns.Point`

        """
        return _otlm.LinearModelResult_getTrendCoefficients(self)


    def getFormula(self):
        """
        Accessor to the formula.

        Returns
        -------
        condensedFormula : :class:`~openturns.String`

        """
        return _otlm.LinearModelResult_getFormula(self)


    def getCoefficientsNames(self):
        """
        Accessor to the coefficients names.

        Returns
        -------
        coefficientsNames : :class:`~openturns.Description`

        """
        return _otlm.LinearModelResult_getCoefficientsNames(self)


    def getSampleResiduals(self):
        """
        Accessor to the residuals.

        Returns
        -------
        sampleResiduals : :class:`~openturns.Sample`

        """
        return _otlm.LinearModelResult_getSampleResiduals(self)


    def getStandardizedResiduals(self):
        """
        Accessor to the standardized residuals.

        Returns
        -------
        standardizedResiduals : :class:`~openturns.Sample`

        """
        return _otlm.LinearModelResult_getStandardizedResiduals(self)


    def getLeverages(self):
        """
        Accessor to the leverages.

        Returns
        -------
        leverages : :class:`~openturns.Point`

        """
        return _otlm.LinearModelResult_getLeverages(self)


    def getDiagonalGramInverse(self):
        """
        Accessor to the diagonal gram inverse matrix.

        Returns
        -------
        diagonalGramInverse : :class:`~openturns.Point`

        """
        return _otlm.LinearModelResult_getDiagonalGramInverse(self)


    def getCookDistances(self):
        """
        Accessor to the cook's distances.

        Returns
        -------
        cookDistances : :class:`~openturns.Point`

        """
        return _otlm.LinearModelResult_getCookDistances(self)


    def __init__(self, *args):
        this = _otlm.new_LinearModelResult(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _otlm.delete_LinearModelResult
    __del__ = lambda self: None
LinearModelResult_swigregister = _otlm.LinearModelResult_swigregister
LinearModelResult_swigregister(LinearModelResult)

class LinearModelAlgorithm(openturns.metamodel.MetaModelAlgorithm):
    """
    Class used to create a linear model from numerical samples.

    **Available usages**:

        LinearModelAlgorithm(Xsample, Ysample)

        LinearModelAlgorithm(Xsample, basis, Ysample)

    See Also
    --------
    LinearModel, LinearModelResult

    Notes
    -----
    This class is used in order to create a linear model from numerical samples. The
    linear regression model between the scalar variable :math:`Y` and the :math:`n`
    -dimensional one :math:`\\vect{X} = (X_i)_{i \\leq n}` writes as follows:

    .. math::

        \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

    where :math:`\\epsilon` is the residual, supposed to follow the standard Normal
    distribution.

    Each coefficient :math:`a_i` is evaluated from both samples :math:`Ysample` and
    :math:`Xsample` and is accompagnied by a confidence interval and a p-value (which
    tests if they are significantly different from 0.0).

    This class enables to test the quality of the model. It provides only numerical
    tests. If :math:`X` is scalar, a graphical validation test exists, that draws
    the residual couples :math:`(\\epsilon_i, \\epsilon_{i+1})`, where the residual
    :math:`\\epsilon_i` is evaluated on the samples :math:`(Xsample, Ysample)`:
    :math:`\\epsilon_i  = Ysample_i - \\tilde{Y}_i` with
    :math:`\\tilde{Y}_i = a_0 + a_1 + Xsample_i`. The OpenTURNS method is 
    :class:`~openturns.VisualTest_DrawLinearModelResidual`.

    """

    __swig_setmethods__ = {}
    for _s in [openturns.metamodel.MetaModelAlgorithm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearModelAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.metamodel.MetaModelAlgorithm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearModelAlgorithm, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlm.LinearModelAlgorithm_getClassName(self)


    def __repr__(self):
        return _otlm.LinearModelAlgorithm___repr__(self)

    def getInputSample(self):
        """
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            The Xsample which had been passed to the constructor.
        """
        return _otlm.LinearModelAlgorithm_getInputSample(self)


    def getOutputSample(self):
        """
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            The Ysample which had been passed to the constructor.
        """
        return _otlm.LinearModelAlgorithm_getOutputSample(self)


    def getBasis(self):
        """
        Accessor to the input basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`
            The basis which had been passed to the constructor.
        """
        return _otlm.LinearModelAlgorithm_getBasis(self)


    def run(self):
        """
        Compute the response surfaces.

        Notes
        -----
        It computes the response surfaces and creates a
        :class:`~openturns.MetaModelResult` structure containing all the results.
        """
        return _otlm.LinearModelAlgorithm_run(self)


    def getResult(self):
        """
        Accessor to the computed linear model.

        Returns
        -------
        result : :class:`~otlm.LinearModelResult`
            The linear model built from numerical samples, along with other useful informations.
        """
        return _otlm.LinearModelAlgorithm_getResult(self)


    def __init__(self, *args):
        this = _otlm.new_LinearModelAlgorithm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _otlm.delete_LinearModelAlgorithm
    __del__ = lambda self: None
LinearModelAlgorithm_swigregister = _otlm.LinearModelAlgorithm_swigregister
LinearModelAlgorithm_swigregister(LinearModelAlgorithm)

class LinearModelAnalysis(openturns.common.PersistentObject):
    """
    Class used to analyse a linear model.

    **Available usages**:

        LinearModelAnalysis(linearModelResult)

    See Also
    --------
    LinearModelResult

    Notes
    -----
    This class is used in order to create a linear model from numerical samples. The
    linear regression model between the scalar variable :math:`Y` and the :math:`n`
    -dimensional one :math:`\\vect{X} = (X_i)_{i \\leq n}` writes as follows:

    .. math::

        \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

    where :math:`\\epsilon` is the residual, supposed to follow the standard Normal
    distribution.

    Each coefficient :math:`a_i` is evaluated from both samples :math:`Ysample` and
    :math:`Xsample` and is accompagnied by a confidence interval and a p-value (which
    tests if they are significantly different from 0.0).

    This class enables to test the quality of the model. It provides only numerical
    tests. If :math:`X` is scalar, a graphical validation test exists, that draws
    the residual couples :math:`(\\epsilon_i, \\epsilon_{i+1})`, where the residual
    :math:`\\epsilon_i` is evaluated on the samples :math:`(Xsample, Ysample)`:
    :math:`\\epsilon_i  = Ysample_i - \\tilde{Y}_i` with
    :math:`\\tilde{Y}_i = a_0 + \\sum_{j=1}^{n} a_j \\ (Xsample)_{ij}`. The OpenTURNS method is
    :class:`~openturns.VisualTest_DrawLinearModelResidual`.

    By default, labels of the 3 most significant points are displayed on graphs.
    This number can be changed by modifying the ResourceMap key
    (``LinearModelAnalysis-Identifiers``).

    Examples
    --------
    >>> import openturns as ot
    >>> import otlm
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> Xsample = distribution.getSample(30)
    >>> func = ot.SymbolicFunction(['x'], ['2 * x + 1'])
    >>> Ysample = func(Xsample) + ot.Normal().getSample(30)
    >>> algo = otlm.LinearModelAlgorithm(Ysample, Xsample)
    >>> result = algo.getResult()
    >>> analysis = otlm.LinearModelAnalysis(result)

    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearModelAnalysis, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearModelAnalysis, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlm.LinearModelAnalysis_getClassName(self)


    def __repr__(self):
        return _otlm.LinearModelAnalysis___repr__(self)

    def __str__(self, *args):
        return _otlm.LinearModelAnalysis___str__(self, *args)

    def getLinearModelResult(self):
        """
        Accessor to the linear model result.

        Returns
        -------
        linearModelResult : :class:`~openturns.LinearModelResult`
            The  linear model result which had been passed to the constructor.
        """
        return _otlm.LinearModelAnalysis_getLinearModelResult(self)


    def getFormula(self):
        """
        Accessor to the formula.

        Returns
        -------
        condensedFormula : :class:`~openturns.String`

        """
        return _otlm.LinearModelAnalysis_getFormula(self)


    def getCoefficientsNames(self):
        """
        Accessor to the coefficients names.

        Returns
        -------
        coefficientsNames : :class:`~openturns.Description`

        """
        return _otlm.LinearModelAnalysis_getCoefficientsNames(self)


    def getResiduals(self):
        """
        Accessor to the residuals.

        Returns
        -------
        sampleResiduals : :class:`~openturns.Sample`

        """
        return _otlm.LinearModelAnalysis_getResiduals(self)


    def getStandardizedResiduals(self):
        """
        Accessor to the standardized residuals.

        Returns
        -------
        standardizedResiduals : :class:`~openturns.Sample`

        """
        return _otlm.LinearModelAnalysis_getStandardizedResiduals(self)


    def getCoefficientsEstimates(self):
        """
        Accessor to the coefficients of the linear model of the trend.

        Returns
        -------
        beta : :class:`~openturns.Sample`

        """
        return _otlm.LinearModelAnalysis_getCoefficientsEstimates(self)


    def getCoefficientsStandardErrors(self):
        """
        Accessor to the coefficients of standard error.

        Returns
        -------
        standardErrors : :class:`~openturns.Sample`

        """
        return _otlm.LinearModelAnalysis_getCoefficientsStandardErrors(self)


    def getCoefficientsTScores(self):
        """
        Accessor to the coefficients of linear expansion over their standard error.

        Returns
        -------
        tScores : :class:`~openturns.Sample`

        """
        return _otlm.LinearModelAnalysis_getCoefficientsTScores(self)


    def getCoefficientsPValues(self):
        """
        Accessor to the coefficients of the p values.

        Returns
        -------
        pValues : :class:`~openturns.Sample`

        """
        return _otlm.LinearModelAnalysis_getCoefficientsPValues(self)


    def getLeverages(self):
        """
        Accessor to the leverages.

        Returns
        -------
        leverages : :class:`~openturns.Point`

        """
        return _otlm.LinearModelAnalysis_getLeverages(self)


    def getCookDistances(self):
        """
        Accessor to the cook's distances.

        Returns
        -------
        cookDistances : :class:`~openturns.Point`

        """
        return _otlm.LinearModelAnalysis_getCookDistances(self)


    def getDegreesOfFreedom(self):
        """
        Accessor to the number of degrees of freedom.

        Returns
        -------
        dof : :class:`~openturns.UnsignedInteger`

        """
        return _otlm.LinearModelAnalysis_getDegreesOfFreedom(self)


    def getRSquared(self):
        """
        Accessor to the R-squared test.

        Returns
        -------
        rSquared : :class:`~openturns.NumericalScalar`

        """
        return _otlm.LinearModelAnalysis_getRSquared(self)


    def getAdjustedRSquared(self):
        """
        Accessor to the Adjusted R-squared test.

        Returns
        -------
        adjustedRSquared : :class:`~openturns.NumericalScalar`

        """
        return _otlm.LinearModelAnalysis_getAdjustedRSquared(self)


    def getFisherScore(self):
        """
        Accessor to the Fisher test.

        Returns
        -------
        fisherScore : :class:`~openturns.NumericalScalar`

        """
        return _otlm.LinearModelAnalysis_getFisherScore(self)


    def getFisherPValue(self):
        """
        Accessor to the Fisher p value.

        Returns
        -------
        fisherPValue : :class:`~openturns.NumericalScalar`

        """
        return _otlm.LinearModelAnalysis_getFisherPValue(self)


    def getNormalityTestResultKolmogorovSmirnov(self):
        """
        Performs Kolmogorov test to check Gaussian assumption of the model (null hypothesis).
        It is accepted when p-value is low.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Test result class.


        Notes
        -----
        We check that the residual is Gaussian thanks to :class:`~openturns.FittingTest::Kolmogorov`.
        """
        return _otlm.LinearModelAnalysis_getNormalityTestResultKolmogorovSmirnov(self)


    def getNormalityTestResultAndersonDarling(self):
        """
        Performs Anderson-Darling test to check Gaussian assumption of the model (null hypothesis).
        It is accepted when p-value is low.

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Test result class.


        Notes
        -----
        We check that the residual is Gaussian thanks to :class:`~openturns.NormalityTest::AndersonDarling`.
        """
        return _otlm.LinearModelAnalysis_getNormalityTestResultAndersonDarling(self)


    def getNormalityTestResultChiSquared(self):
        """
        Performs Pearson Chi-2 statistical test to check Gaussian assumption of the model

        Returns
        -------
        testResult : :class:`~openturns.TestResult`
            Test result class.

        Notes
        -----
        The Chi-Square test is a goodness of fit test which objective is to check the normality assumption (null hypothesis) of residuals (and thus the model).
        It is accepted when p-value is low.

        From a dataset :math:`\\epsilon=(\\epsilon_1,...,\\epsilon_k)` of size :math:`k` (residual set), we define :math:`nClasses` classes
        where :math:`nClasses := 2\\ k^{\\frac{2}{5}}`.

        Under the normality hypothesis, we compute cumulative function of the :math:`\\epsilon` set (mean and standard
        deviation of the underlying normal distribution derived from the dataset). The interval :math:`[0, 1]` is then splitted
        onto :math:`nClasses` intervals.

        For the Chi-Square test, two major elements are to be considered:

         - :math:`C_{i}` is the number of counted observations in the class :math:`i`
         - :math:`E_{i}` is the number of expected observations in the class :math:`i`

        Using the cumulative information, we count number of elements in each class (:math:`C_{i}`).
        Also, under the null hypothesis, the different classes are equiprobable ( :math:`E_{i}\\ =\\ E\\ =\\frac{k}{nClasses}`.

        From the previous values per class, we compute the Pearson test statistic :math:`P=\\sum_{i=1}^{nClasses} \\frac{C_{i} - E_{i})^{2}}{E_{i}}`.

        Finally, the p-value is computed thanks to a chi-square distribution with :math:`dof` degrees of freedom, where
        :math:`dof` is adjusted thanks to the boolean ResourceMap key (``LinearModelAnalysis-ChiSquareAdjust``).
        If key is set to *True*, degree of freedom is :math:`nClasses - 3`. Otherwise it is :math:`nClasses - 1`
        It is recommended to test with both *True* and *False* values.
        """
        return _otlm.LinearModelAnalysis_getNormalityTestResultChiSquared(self)


    def drawResidualsVsFitted(self):
        """
        Accessor to plot of residuals versus fitted values.

        Returns
        -------
        graph : :class:`~openturns.Graph`

        """
        return _otlm.LinearModelAnalysis_drawResidualsVsFitted(self)


    def drawScaleLocation(self):
        """
        Accessor to a Scale-Location plot of sqrt(abs(residuals)) versus fitted values.

        Returns
        -------
        graph : :class:`~openturns.Graph`

        """
        return _otlm.LinearModelAnalysis_drawScaleLocation(self)


    def drawQQplot(self):
        """
        Accessor to plot a Normal quantiles-quantiles plot of standardized residuals.

        Returns
        -------
        graph : :class:`~openturns.Graph`

        """
        return _otlm.LinearModelAnalysis_drawQQplot(self)


    def drawCookDistance(self):
        """
        Accessor to plot of Cook's distances versus row labels.

        Returns
        -------
        graph : :class:`~openturns.Graph`

        """
        return _otlm.LinearModelAnalysis_drawCookDistance(self)


    def drawResidualsVsLeverages(self):
        """
        Accessor to plot of residuals versus leverages that adds bands corresponding to Cook's distances of 0.5 and 1.

        Returns
        -------
        graph : :class:`~openturns.Graph`

        """
        return _otlm.LinearModelAnalysis_drawResidualsVsLeverages(self)


    def drawCookVsLeverages(self):
        """
        Accessor to plot of Cook's distances versus leverage/(1-leverage). 

        Returns
        -------
        graph : :class:`~openturns.Graph`

        """
        return _otlm.LinearModelAnalysis_drawCookVsLeverages(self)


    def __init__(self, *args):
        this = _otlm.new_LinearModelAnalysis(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _otlm.delete_LinearModelAnalysis
    __del__ = lambda self: None
LinearModelAnalysis_swigregister = _otlm.LinearModelAnalysis_swigregister
LinearModelAnalysis_swigregister(LinearModelAnalysis)

class LinearModelStepwiseAlgorithm(openturns.common.PersistentObject):
    """
    Class used to create a linear model from numerical samples.

    **Available usages**:

        LinearModelStepwiseAlgorithm()

        LinearModelStepwiseAlgorithm(*inputSample, basis, outputSample, minimalIndices, isForward, penalty, maximumIterationNumber*)

        LinearModelStepwiseAlgorithm(*inputSample, basis, outputSample, minimalIndices, startIndices, penalty, maximumIterationNumber*)

    Parameters
    ----------
    inputSample, outputSample : :class:`~openturns.Sample`
        The input and output samples of a model.
    basis : :class:`~openturns.Basis`
        Functional basis to estimate the trend.
    minimalIndices : :class:`~openturns.Indices`
        The indices of minimal model
    isForward : :class:`~openturns.Bool`
          the boolean value used for the stepwise regression method direction FORWARD and BACKWARD. 
    startIndices : :class:`~openturns.Indices`
         The indices of start model used for the stepwise regression method direction BOTH.
    penalty : :class:`~openturns.NumericalScalar`
         The multiple of the degrees of freedom used for the penalty of the stepwise regression method : 
         - 2      Akaike   information criterion (AIC)
         - log(n) Bayesian information criterion (BIC)  
    maximumIterationNumber : :class:`~openturns.UnsignedInteger`
         The maximum number of iterations of the stepwise regression method. 


    See Also
    --------
    LinearModel, LinearModelResult

    Notes
    -----
    This class is used in order to create a linear model from numerical samples, by using
    the stepwise method. The linear regression model between the scalar variable :math:`Y`
    and the :math:`n`-dimensional one :math:`\\vect{X} = (X_i)_{i \\leq n}` writes as follows:

    .. math::

        \\tilde{Y} = a_0 + \\sum_{i=1}^n a_i X_i + \\epsilon

    where :math:`\\epsilon` is the residual, supposed to follow the standard Normal
    distribution.

    Each coefficient :math:`a_i` is evaluated from both samples :math:`Ysample` and
    :math:`Xsample` and is accompagnied by a confidence interval and a p-value (which
    tests if they are significantly different from 0.0).

    By default, input sample is normalized.  It is possible to set Resource key
    (``LinearModelStepwiseAlgorithm-normalize``) to *False* in order to discard
    this normalization.

    This class enables to test the quality of the model. It provides only numerical
    tests. If :math:`X` is scalar, a graphical validation test exists, that draws
    the residual couples :math:`(\\epsilon_i, \\epsilon_{i+1})`, where the residual
    :math:`\\epsilon_i` is evaluated on the samples :math:`(Xsample, Ysample)`:
    :math:`\\epsilon_i  = Ysample_i - \\tilde{Y}_i` with
    :math:`\\tilde{Y}_i = a_0 + a_1 + Xsample_i`. The OpenTURNS method is 
    :class:`~openturns.VisualTest_DrawLinearModelResidual`.

    """

    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearModelStepwiseAlgorithm, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearModelStepwiseAlgorithm, name)

    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlm.LinearModelStepwiseAlgorithm_getClassName(self)

    BACKWARD = _otlm.LinearModelStepwiseAlgorithm_BACKWARD
    BOTH = _otlm.LinearModelStepwiseAlgorithm_BOTH
    FORWARD = _otlm.LinearModelStepwiseAlgorithm_FORWARD

    def __repr__(self):
        return _otlm.LinearModelStepwiseAlgorithm___repr__(self)

    def __str__(self, *args):
        return _otlm.LinearModelStepwiseAlgorithm___str__(self, *args)

    def getInputSample(self):
        return _otlm.LinearModelStepwiseAlgorithm_getInputSample(self)

    def getOutputSample(self):
        return _otlm.LinearModelStepwiseAlgorithm_getOutputSample(self)

    def getDirection(self):
        return _otlm.LinearModelStepwiseAlgorithm_getDirection(self)

    def getPenalty(self):
        return _otlm.LinearModelStepwiseAlgorithm_getPenalty(self)

    def getMaximumIterationNumber(self):
        return _otlm.LinearModelStepwiseAlgorithm_getMaximumIterationNumber(self)

    def getFormula(self):
        return _otlm.LinearModelStepwiseAlgorithm_getFormula(self)

    def run(self):
        return _otlm.LinearModelStepwiseAlgorithm_run(self)

    def getResult(self):
        return _otlm.LinearModelStepwiseAlgorithm_getResult(self)

    def __init__(self, *args):
        this = _otlm.new_LinearModelStepwiseAlgorithm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _otlm.delete_LinearModelStepwiseAlgorithm
    __del__ = lambda self: None
LinearModelStepwiseAlgorithm_swigregister = _otlm.LinearModelStepwiseAlgorithm_swigregister
LinearModelStepwiseAlgorithm_swigregister(LinearModelStepwiseAlgorithm)

# This file is compatible with both classic and new-style classes.


