%feature("docstring") OTLM::MonomialFactory
"Canonical monomial univariate polynomial family.

Available constructor:
    MonomialFactory()

Notes
-----
Any sequence of orthogonal polynomials has a recurrence formula relating any
three consecutive polynomials as follows:

.. math::

    P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \\\\quad 1 < i

The recurrence coefficients for the monomials come analytically and
read:

.. math::

    \\\\begin{array}{rcl}
        a_i & = & 1 \\\\\\\\
        b_i & = & 0 \\\\\\\\
        c_i & = & 0
    \\\\end{array}, \\\\quad 1 < i

See also
--------
StandardDistributionPolynomialFactory

Examples
--------
>>> import otlm
>>> monomial_factory = otlm.MonomialFactory()
>>> for i in range(3):
...     print(monomial_factory.build(i))
1
X
X^2"
