%feature("docstring") OTLM::LinearModelAlgorithm
"Class used to create a linear model from numerical samples.

**Available usages**:

    LinearModelAlgorithm(Xsample, Ysample)

    LinearModelAlgorithm(Xsample, basis, Ysample)

See Also
--------
LinearModel, LinearModelResult

Notes
-----
This class is used in order to create a linear model from numerical samples. The
linear regression model between the scalar variable :math:`Y` and the :math:`n`
-dimensional one :math:`\\\\vect{X} = (X_i)_{i \\\\leq n}` writes as follows:

.. math::

    \\\\tilde{Y} = a_0 + \\\\sum_{i=1}^n a_i X_i + \\\\epsilon

where :math:`\\\\epsilon` is the residual, supposed to follow the standard Normal
distribution.

Each coefficient :math:`a_i` is evaluated from both samples :math:`Ysample` and
:math:`Xsample` and is accompagnied by a confidence interval and a p-value (which
tests if they are significantly different from 0.0).

This class enables to test the quality of the model. It provides only numerical
tests. If :math:`X` is scalar, a graphical validation test exists, that draws
the residual couples :math:`(\\\\epsilon_i, \\\\epsilon_{i+1})`, where the residual
:math:`\\\\epsilon_i` is evaluated on the samples :math:`(Xsample, Ysample)`:
:math:`\\\\epsilon_i  = Ysample_i - \\\\tilde{Y}_i` with
:math:`\\\\tilde{Y}_i = a_0 + a_1 + Xsample_i`. The OpenTURNS method is 
:class:`~openturns.VisualTest_DrawLinearModelResidual`.
"

// ---------------------------------------------------------------------

%feature("docstring") OTLM::LinearModelAlgorithm::getInputSample
"Accessor to the input sample.

Returns
-------
inputSample : :class:`~openturns.Sample`
    The Xsample which had been passed to the constructor."

// ---------------------------------------------------------------------

%feature("docstring") OTLM::LinearModelAlgorithm::getBasis
"Accessor to the input basis.

Returns
-------
basis : :class:`~openturns.Basis`
    The basis which had been passed to the constructor."

// ---------------------------------------------------------------------

%feature("docstring") OTLM::LinearModelAlgorithm::getOutputSample
"Accessor to the output sample.

Returns
-------
outputSample : :class:`~openturns.Sample`
    The Ysample which had been passed to the constructor."

// ---------------------------------------------------------------------

%feature("docstring") OTLM::LinearModelAlgorithm::getResult
"Accessor to the computed linear model.

Returns
-------
result : :class:`~otlm.LinearModelResult`
    The linear model built from numerical samples, along with other useful informations."

