# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.11
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
otlhs module
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_otlhs', [dirname(__file__)])
        except ImportError:
            import _otlhs
            return _otlhs
        if fp is not None:
            try:
                _mod = imp.load_module('_otlhs', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _otlhs = swig_import_helper()
    del swig_import_helper
else:
    import _otlhs
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.solver
import openturns.algo
import openturns.experiment
import openturns.uncertainty
import openturns.model_copula
import openturns.randomvector
import openturns.dist_bundle1
import openturns.dist_bundle2
import openturns.weightedexperiment
import openturns.classification
import openturns.orthogonalbasis
import openturns.metamodel
import openturns.transformation
import openturns.analytical
import openturns.simulation
import openturns.stattests
import openturns.model_process
class LHSDesign(openturns.common.PersistentObject):
    """
    LHS class generate design of experimients according to Latin Hypercube (LHS) technique.

    Available constructor:
        LHSDesign( bounds, size)

        LHSDesign( bounds, size, centeredDesign)

    Parameters
    ----------
    bounds : :class:`~openturns.Interval`
        Bounds of the uniform distributions.
    size : int
        Size of the design.
    centeredDesign :  bool
        Fix if design is centered on each selected strata (True) or if it is radomly genererated in the strata.
        Default value is False

    Notes
    -----
    We suppose a multivariate distribution with uniform and independent marginals.
    The class enables to define aLHS design according to this distribution.

    Examples
    --------

    >>> import openturns as ot
    >>> import otlhs
    >>> # Fix the uniform bounds
    >>> # We fix lower bounds = [-1,-2,-3]
    >>> # and upper bounds = [1,2,3]
    >>> bounds = ot.Interval([-1,-2,-3], [1,2,3])
    >>> size = 100 # size of the design
    >>> lhsGenerate = otlhs.LHSDesign(bounds, size)

    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHSDesign, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LHSDesign, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlhs.LHSDesign_getClassName(self)

    def getBounds(self): return _otlhs.LHSDesign_getBounds(self)
    def getSize(self): return _otlhs.LHSDesign_getSize(self)
    def isCenteredDesign(self): return _otlhs.LHSDesign_isCenteredDesign(self)
    def generate(self):
        """
        The generate method builds a design.
        Each call of the method selects randomly a new starta and returns a design with fixed type (centered, random)

        Returns
        -------
        design : :class:`~openturns.NumericalSample`
            A design of experimient

        Examples
        --------
        >>> import openturns as ot
        >>> import otlhs
        >>> # Fix the uniform bounds
        >>> # We fix lower bounds = [-1,-2,-3]
        >>> # and upper bounds = [1,2,3]
        >>> bounds = ot.Interval([-1,-2,-3], [1,2,3])
        >>> size = 100 # size of the design
        >>> lhsGenerate = otlhs.LHSDesign(bounds, size)
        >>> # Get a design
        >>> design = lhsGenerate.generate()
        >>> # Generate a new design
        >>> newDesign = lhsGenerate.generate()
        """
        return _otlhs.LHSDesign_generate(self)

    def __repr__(self): return _otlhs.LHSDesign___repr__(self)
    def __init__(self, *args): 
        this = _otlhs.new_LHSDesign(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_LHSDesign
    __del__ = lambda self : None;
LHSDesign_swigregister = _otlhs.LHSDesign_swigregister
LHSDesign_swigregister(LHSDesign)

class LHSResult(openturns.common.PersistentObject):
    """
    LHSResult resumes an LHS optimization using Monte Carlo or Simulated Annealing algorithms

    Available constructor:
        LHSResult(bounds, spaceFilling, nRestart);

    Parameters
    ----------
    bounds : :class:`~openturns.Interval`
        Bounds of the uniform distributions.
    spaceFilling : :class:`~otlhs.SpaceFilling`
        The space filling criteria used by optimization algorithm
    nRestart : int
        The number of restarts performed by optimization algorithm

    Notes
    -----

    This class is not built by hand, but returned by optimization algorithms.

    Examples
    --------
    >>> import openturns as ot
    >>> import otlhs
    >>> lhs = otlhs.LHSDesign(ot.Interval(3), 100)
    >>> profile = otlhs.GeometricProfile()
    >>> spaceFilling = otlhs.SpaceFillingC2()
    >>> # Optim algo
    >>> algo = otlhs.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
    >>> # Get LHSResult
    >>> result = algo.generate()

    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHSResult, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LHSResult, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlhs.LHSResult_getClassName(self)

    def getBounds(self):
        """
        Returns the bounds of the underlying distribution

        Returns
        -------
        bounds : :class:`~openturns.Interval`
            Bounds of the uniform distributions.

        Examples
        --------
        >>> import openturns as ot
        >>> import otlhs
        >>> lhs = otlhs.LHSDesign(ot.Interval(3), 100)
        >>> profile = otlhs.GeometricProfile()
        >>> spaceFilling = otlhs.SpaceFillingPhiP(10)
        >>> # Optim algo
        >>> algo = otlhs.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
        >>> # Get LHSResult
        >>> result = algo.generate()
        >>> bounds = result.getBounds()
        """
        return _otlhs.LHSResult_getBounds(self)

    def getNumberOfRestarts(self): return _otlhs.LHSResult_getNumberOfRestarts(self)
    def getOptimalDesign(self, *args):
        """
        Returns the optimal design

        Returns
        -------
        design : :class:`~openturns.NumericalSample`
            The design that optimizes the criterion.

        Examples
        --------
        >>> import openturns as ot
        >>> import otlhs
        >>> lhs = otlhs.LHSDesign(ot.Interval(3), 100)
        >>> spaceFilling = otlhs.SpaceFillingPhiP(10)
        >>> # By Monte Carlo
        >>> algoMC = otlhs.MonteCarloLHS(lhs, 100000, spaceFilling)
        >>> # Get LHSResult
        >>> resultMC = algoMC.generate()
        >>> optimalDesignMC = resultMC.getOptimalDesign()
        >>> # By simulated annealing, with restart
        >>> profile = otlhs.GeometricProfile()
        >>> algoSA = otlhs.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
        >>> # Get LHSResult
        >>> resultSA = algoSA.generate(50)
        >>> optimalDesignSA = resultSA.getOptimalDesign()
        >>> # Get optimal results for all restarts
        >>> optimRestart = [resultSA.getOptimalDesign(i) for i in range(resultSA.getNumberOfRestarts())]
        """
        return _otlhs.LHSResult_getOptimalDesign(self, *args)

    def getOptimalValue(self, *args): return _otlhs.LHSResult_getOptimalValue(self, *args)
    def getAlgoHistory(self, *args):
        """
        Returns internal values computed during optimization algorithm.

        Returns
        -------
        history : :class:`~openturns.NumericalPoint`
            Some internal values computed during optimization algorithm.
            SimulatedAnnealingLHS stores criterion value, temperature
            and probability at each iteration.

        Examples
        --------
        >>> import openturns as ot
        >>> import otlhs
        >>> lhs = otlhs.LHSDesign(ot.Interval(3), 100)
        >>> profile = otlhs.GeometricProfile()
        >>> spaceFilling = otlhs.SpaceFillingPhiP(50)
        >>> algoSA = otlhs.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
        >>> # Get LHSResult
        >>> resultSA = algoSA.generate(50)
        >>> criterionHistory = resultSA.getAlgoHistory()
        """
        return _otlhs.LHSResult_getAlgoHistory(self, *args)

    def getC2(self, *args):
        """
        Returns the C2 criterion evaluated on the optimal design

        Returns
        -------
        c2 : float
            The C2 criterion.

        Examples
        --------
        >>> import openturns as ot
        >>> import otlhs
        >>> lhs = otlhs.LHSDesign(ot.Interval(3), 100)
        >>> profile = otlhs.GeometricProfile()
        >>> spaceFilling = otlhs.SpaceFillingPhiP(50)
        >>> algoSA = otlhs.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
        >>> # Get LHSResult
        >>> resultSA = algoSA.generate()
        >>> c2 = resultSA.getC2()
        """
        return _otlhs.LHSResult_getC2(self, *args)

    def getPhiP(self, *args):
        """
        Returns the PhiP criterion evaluated on the optimal design

        Returns
        -------
        phiP : float
            The PhiP criterion.

        Examples
        --------
        >>> import openturns as ot
        >>> import otlhs
        >>> lhs = otlhs.LHSDesign(ot.Interval(3), 100)
        >>> profile = otlhs.GeometricProfile()
        >>> spaceFilling = otlhs.SpaceFillingPhiP(50)
        >>> algoSA = otlhs.SimulatedAnnealingLHS(lhs, profile, spaceFilling)
        >>> # Get LHSResult
        >>> resultSA = algoSA.generate()
        >>> phip = resultSA.getPhiP()
        """
        return _otlhs.LHSResult_getPhiP(self, *args)

    def getMinDist(self, *args): return _otlhs.LHSResult_getMinDist(self, *args)
    def drawHistoryCriterion(self, *args): return _otlhs.LHSResult_drawHistoryCriterion(self, *args)
    def drawHistoryProbability(self, *args): return _otlhs.LHSResult_drawHistoryProbability(self, *args)
    def drawHistoryTemperature(self, *args): return _otlhs.LHSResult_drawHistoryTemperature(self, *args)
    def add(self, *args): return _otlhs.LHSResult_add(self, *args)
    def __repr__(self): return _otlhs.LHSResult___repr__(self)
    def __init__(self, *args): 
        this = _otlhs.new_LHSResult(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_LHSResult
    __del__ = lambda self : None;
LHSResult_swigregister = _otlhs.LHSResult_swigregister
LHSResult_swigregister(LHSResult)

class PlotDesigndInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PlotDesigndInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, PlotDesigndInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _otlhs.new_PlotDesigndInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _otlhs.PlotDesigndInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _otlhs.PlotDesigndInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _otlhs.PlotDesigndInterfaceObject_getName(self)

    def __eq__(self, *args): return _otlhs.PlotDesigndInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _otlhs.delete_PlotDesigndInterfaceObject
    __del__ = lambda self : None;
PlotDesigndInterfaceObject_swigregister = _otlhs.PlotDesigndInterfaceObject_swigregister
PlotDesigndInterfaceObject_swigregister(PlotDesigndInterfaceObject)

class PlotDesign(openturns.graph.DrawableImplementation):
    """
    The class builds a drawable argument of type `Pairs`. It represents the projection of design on 2D space using traditional scatter plots.
    Additionaly, the subdivision of the range is done and a grid is drawn in order to demonstrate the LHS behaviour.

    Available constructor:
      PlotDesign(data, bounds, Nx, Ny, title)

      PlotDesign(data, bounds, Nx, Ny)

      PlotDesign(lhsResult, Nx, Ny, title)

      PlotDesign(lhsResult, Nx, Ny)

    Parameters
    ----------
    data : :class:`~openturns.NumericalSample` or 2d array like
        Design to plot
    lhsResult : :class:`~otlhs.LHSResult`
        Result class of LHS optimization
    bounds : :class:`~openturns.Interval`
        Bounds of the underlying uniform distributions.
    Nx : int
        Number of subdivision on x axis
        Default value corresponds to Nx = size of data
    Ny : int
        Number of subdivision on y axis
        Default value corresponds to Ny = size of data
    title :  string
        Name of the graph
        Default value is an empty string

    Notes
    -----
    Even if PlotDesign is a drawable object, `Show` method could not be applied because there is no particular specification
    for this kind of drawable. Report to otlhs.plotdesign.PyPlotDesign

    Examples
    --------
    >>> import openturns as ot
    >>> import otlhs
    >>> # Design is a here a Normal sample
    >>> design = ot.ComposedDistribution(3* [ot.Uniform()]).getSample(10)
    >> # Fix bounds
    >>> bounds = ot.Interval(3)
    >>> # Plot the design
    >>> plot = otlhs.PlotDesign(design, bounds, 10, 10)
    >>> # Nx and Ny not fixed ==> Nx=Ny=10
    >>> plot = otlhs.PlotDesign(design, bounds)
    >>> g = ot.Graph()
    >>> g.add(plot)
    >>> g.draw('myDesign', 640, 480, ot.GraphImplementation.PDF)
    """
    __swig_setmethods__ = {}
    for _s in [openturns.graph.DrawableImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PlotDesign, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.graph.DrawableImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, PlotDesign, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlhs.PlotDesign_getClassName(self)

    def __repr__(self): return _otlhs.PlotDesign___repr__(self)
    def getData(self):
        """
        The method returns data used for scatter plots

        Returns
        -------
        data : :class:`~openturns.NumericalSample`
            Used data for plots

        Examples
        --------
        >>> import openturns as ot
        >>> import otlhs
        >>> # Design is a here a Normal sample
        >>> design = ot.ComposedDistribution(3* [ot.Uniform()]).getSample(100)
        >> # Fix bounds
        >>> bounds = ot.Interval(3)
        >>> # Fix Nx, Ny
        >>> Nx, Ny = 20, 20
        >>> # Plot the design
        >>> plot = otlhs.PlotDesign(design, bounds, Nx, Ny)
        >>> # Get data
        >>> data = plot.getData()
        """
        return _otlhs.PlotDesign_getData(self)

    def getLabels(self):
        """
        The method returns the labels of the drawable.

        Returns
        -------
        labels : :class:`~openturns.Description`
            Used labels

        Examples
        --------
        >>> import openturns as ot
        >>> import otlhs
        >>> # Design is a here a Normal sample
        >>> design = ot.ComposedDistribution(3* [ot.Uniform()]).getSample(100)
        >> # Fix bounds
        >>> bounds = ot.Interval(3)
        >>> # Fix Nx, Ny
        >>> Nx, Ny = 20, 20
        >>> # Plot the design
        >>> plot = otlhs.PlotDesign(design, bounds, Nx, Ny)
        >>> # Get labels
        >>> labels = plot.getLabels()
        """
        return _otlhs.PlotDesign_getLabels(self)

    def setLabels(self, *args):
        """
        The method returns the labels of the drawable.

        Parameters
        ----------
        labels : :class:`~openturns.Description`
            Labels to use

        Examples
        --------
        >>> import openturns as ot
        >>> import otlhs
        >>> # Design is a here a Normal sample
        >>> design = ot.ComposedDistribution(3* [ot.Uniform()]).getSample(100)
        >> # Fix bounds
        >>> bounds = ot.Interval(3)
        >>> # Fix Nx, Ny
        >>> Nx, Ny = 20, 20
        >>> # Plot the design
        >>> plot = otlhs.PlotDesign(design, bounds, Nx, Ny)
        >>> # Set labels
        >>> plot.setLabels(['X1','X2', 'X3'])
        """
        return _otlhs.PlotDesign_setLabels(self, *args)

    def getTitle(self):
        """
        The method returns the title of the drawable.

        Returns
        -------
        title : string
            Used title

        Examples
        --------
        >>> import openturns as ot
        >>> import otlhs
        >>> # Design is a here a Normal sample
        >>> design = ot.ComposedDistribution(3* [ot.Uniform()]).getSample(100)
        >> # Fix bounds
        >>> bounds = ot.Interval(3)
        >>> # Fix Nx, Ny
        >>> Nx, Ny = 20, 20
        >>> # Plot the design
        >>> plot = otlhs.PlotDesign(design, bounds, Nx, Ny)
        >>> # Get title
        >>> title = plot.getTitle()
        """
        return _otlhs.PlotDesign_getTitle(self)

    def setTitle(self, *args):
        """
        The method returns the title of the drawable.

        Parameters
        ----------
        title : string
            Title to fix

        Examples
        --------
        >>> import openturns as ot
        >>> import otlhs
        >>> # Design is a here a Normal sample
        >>> design = ot.ComposedDistribution(3* [ot.Uniform()]).getSample(100)
        >> # Fix bounds
        >>> bounds = ot.Interval(3)
        >>> # Fix Nx, Ny
        >>> Nx, Ny = 20, 20
        >>> # Plot the design
        >>> plot = otlhs.PlotDesign(design, bounds, Nx, Ny)
        >>> # Set the title
        >>> plot.setTitle('My data experiment')
        """
        return _otlhs.PlotDesign_setTitle(self, *args)

    def draw(self):
        """
        The method returns the draw command used for plots.

        Returns
        -------
        title : string
            Used draw command

        Examples
        --------
        >>> import openturns as ot
        >>> import otlhs
        >>> # Design is a here a Normal sample
        >>> design = ot.ComposedDistribution(3* [ot.Uniform()]).getSample(100)
        >> # Fix bounds
        >>> bounds = ot.Interval(3)
        >>> # Fix Nx, Ny
        >>> Nx, Ny = 20, 20
        >>> # Plot the design
        >>> plot = otlhs.PlotDesign(design, bounds, Nx, Ny)
        >>> # Get draw command
        >>> draw = plot.draw()
        """
        return _otlhs.PlotDesign_draw(self)

    def buildDefaultLabels(self):
        """
        The method builds default labels if design does not have its own description

        """
        return _otlhs.PlotDesign_buildDefaultLabels(self)

    def clean(self):
        """Clean all the temporary data created by :meth:`draw` method."""
        return _otlhs.PlotDesign_clean(self)

    def __init__(self, *args): 
        this = _otlhs.new_PlotDesign(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_PlotDesign
    __del__ = lambda self : None;
PlotDesign_swigregister = _otlhs.PlotDesign_swigregister
PlotDesign_swigregister(PlotDesign)

class TemperatureProfileImplementationdInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TemperatureProfileImplementationdInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, TemperatureProfileImplementationdInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _otlhs.new_TemperatureProfileImplementationdInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _otlhs.TemperatureProfileImplementationdInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _otlhs.TemperatureProfileImplementationdInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _otlhs.TemperatureProfileImplementationdInterfaceObject_getName(self)

    def __eq__(self, *args): return _otlhs.TemperatureProfileImplementationdInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _otlhs.delete_TemperatureProfileImplementationdInterfaceObject
    __del__ = lambda self : None;
TemperatureProfileImplementationdInterfaceObject_swigregister = _otlhs.TemperatureProfileImplementationdInterfaceObject_swigregister
TemperatureProfileImplementationdInterfaceObject_swigregister(TemperatureProfileImplementationdInterfaceObject)

class TemperatureProfileImplementation(openturns.common.PersistentObject):
    """
    Defines a temperature profile.

    Notes
    -----
    The temperature profile is used in simulated annealing context

    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TemperatureProfileImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, TemperatureProfileImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlhs.TemperatureProfileImplementation_getClassName(self)

    def __call__(self, *args):
        """
        Compute the temperature T(i)

        Parameters
        ----------
        i:  int
            The index for whome we seek temperature

        Returns
        -------
        temperature:  float
            The temperature
        """
        return _otlhs.TemperatureProfileImplementation___call__(self, *args)

    def getT0(self): return _otlhs.TemperatureProfileImplementation_getT0(self)
    def getIMax(self): return _otlhs.TemperatureProfileImplementation_getIMax(self)
    def __repr__(self): return _otlhs.TemperatureProfileImplementation___repr__(self)
    def __init__(self, *args): 
        this = _otlhs.new_TemperatureProfileImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_TemperatureProfileImplementation
    __del__ = lambda self : None;
TemperatureProfileImplementation_swigregister = _otlhs.TemperatureProfileImplementation_swigregister
TemperatureProfileImplementation_swigregister(TemperatureProfileImplementation)

class TemperatureProfileImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TemperatureProfileImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, TemperatureProfileImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _otlhs.new_TemperatureProfileImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _otlhs.TemperatureProfileImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _otlhs.TemperatureProfileImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _otlhs.TemperatureProfileImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _otlhs.TemperatureProfileImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _otlhs.delete_TemperatureProfileImplementationTypedInterfaceObject
    __del__ = lambda self : None;
TemperatureProfileImplementationTypedInterfaceObject_swigregister = _otlhs.TemperatureProfileImplementationTypedInterfaceObject_swigregister
TemperatureProfileImplementationTypedInterfaceObject_swigregister(TemperatureProfileImplementationTypedInterfaceObject)

class TemperatureProfile(TemperatureProfileImplementationdInterfaceObject):
    """
    Defines a temperature profile.

    Notes
    -----
    The temperature profile is used in simulated annealing context

    """
    __swig_setmethods__ = {}
    for _s in [TemperatureProfileImplementationdInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TemperatureProfile, name, value)
    __swig_getmethods__ = {}
    for _s in [TemperatureProfileImplementationdInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, TemperatureProfile, name)
    __swig_getmethods__["GetClassName"] = lambda x: _otlhs.TemperatureProfile_GetClassName
    if _newclass:GetClassName = staticmethod(_otlhs.TemperatureProfile_GetClassName)
    def getClassName(self): return _otlhs.TemperatureProfile_getClassName(self)
    def __call__(self, *args): return _otlhs.TemperatureProfile___call__(self, *args)
    def getT0(self): return _otlhs.TemperatureProfile_getT0(self)
    def getIMax(self): return _otlhs.TemperatureProfile_getIMax(self)
    def __repr__(self): return _otlhs.TemperatureProfile___repr__(self)
    def __init__(self, *args): 
        this = _otlhs.new_TemperatureProfile(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_TemperatureProfile
    __del__ = lambda self : None;
TemperatureProfile_swigregister = _otlhs.TemperatureProfile_swigregister
TemperatureProfile_swigregister(TemperatureProfile)

def TemperatureProfile_GetClassName():
  return _otlhs.TemperatureProfile_GetClassName()
TemperatureProfile_GetClassName = _otlhs.TemperatureProfile_GetClassName

class GeometricProfile(TemperatureProfileImplementation):
    """
    Geometric temperature profile

    Available constructor:
      GeometricProfile()

      GeometricProfile(T0, c, iMax)


    Parameters
    ----------
    T0 : float
        Initial temperature
    c : float
        The geometric ratio
        Should be in ]0,1[
    iMax : int
        Number of maximal iterations

    Notes
    -----
    The temperature write:

    .. math::
        :nowrap:

        \\begin{equation*}
            T(i) = T_0 * c^{i} \\in [0,iMax]
        \\end{equation*}

    Examples
    --------

    >>> import openturns as ot
    >>> import otlhs
    >>> # Define a profile
    >>> T0 = 10.0
    >>> iMax = 100
    >>> c = 0.90
    >>> geometricProfile = otlhs.GeometricProfile(T0, c iMax)

    """
    __swig_setmethods__ = {}
    for _s in [TemperatureProfileImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GeometricProfile, name, value)
    __swig_getmethods__ = {}
    for _s in [TemperatureProfileImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, GeometricProfile, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlhs.GeometricProfile_getClassName(self)

    def __call__(self, *args):
        """
        Compute the temperature T(i)

        Parameters
        ----------
        i:  int
            The index for whome we seek temperature

        Returns
        -------
        temperature:  float
            The temperature

        Examples
        --------

        >>> import openturns as ot
        >>> import otlhs
        >>> # Define a profile
        >>> T0 = 10.0
        >>> iMax = 100
        >>> c = 0.90
        >>> geometricProfile = otlhs.GeometricProfile(T0, c iMax)
        >>> temperature = geometricProfile(5)
        >>> print(temperature)
        5.9049
        """
        return _otlhs.GeometricProfile___call__(self, *args)

    def __repr__(self): return _otlhs.GeometricProfile___repr__(self)
    def __init__(self, *args): 
        this = _otlhs.new_GeometricProfile(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_GeometricProfile
    __del__ = lambda self : None;
GeometricProfile_swigregister = _otlhs.GeometricProfile_swigregister
GeometricProfile_swigregister(GeometricProfile)

class LinearProfile(TemperatureProfileImplementation):
    """
    Linear temperature profile

    Available constructor:
      LinearProfile(T0, iMax)


    Parameters
    ----------
    T0 : float
        Initial temperature
    iMax : int
        Number of maximal iterations

    Notes
    -----
    The temperature write:

    .. math::
        :nowrap:

        \\begin{equation*}
            T(i) = T_0*(1 - \\frac{i}{iMax}), i \\in [0,iMax]
        \\end{equation*}

    Examples
    --------

    >>> import openturns as ot
    >>> import otlhs
    >>> # Define a profile
    >>> T0 = 10.0
    >>> iMax = 100
    >>> linearProfile = otlhs.LinearProfile(T0, iMax)

    """
    __swig_setmethods__ = {}
    for _s in [TemperatureProfileImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearProfile, name, value)
    __swig_getmethods__ = {}
    for _s in [TemperatureProfileImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearProfile, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlhs.LinearProfile_getClassName(self)

    def __call__(self, *args):
        """
        Compute the temperature T(i)

        Parameters
        ----------
        i:  int
            The index for whome we seek temperature

        Returns
        -------
        temperature:  float
            The temperature

        Examples
        --------

        >>> import openturns as ot
        >>> import otlhs
        >>> # Define a profile
        >>> T0 = 10.0
        >>> iMax = 100
        >>> linearProfile = otlhs.LinearProfile(T0, iMax)
        >>> temperature = linearProfile(10)
        >>> print(temperature)
        9.0
        """
        return _otlhs.LinearProfile___call__(self, *args)

    def __repr__(self): return _otlhs.LinearProfile___repr__(self)
    def __init__(self, *args): 
        this = _otlhs.new_LinearProfile(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_LinearProfile
    __del__ = lambda self : None;
LinearProfile_swigregister = _otlhs.LinearProfile_swigregister
LinearProfile_swigregister(LinearProfile)

class SpaceFillingImplementationdInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpaceFillingImplementationdInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpaceFillingImplementationdInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _otlhs.new_SpaceFillingImplementationdInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _otlhs.SpaceFillingImplementationdInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _otlhs.SpaceFillingImplementationdInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _otlhs.SpaceFillingImplementationdInterfaceObject_getName(self)

    def __eq__(self, *args): return _otlhs.SpaceFillingImplementationdInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _otlhs.delete_SpaceFillingImplementationdInterfaceObject
    __del__ = lambda self : None;
SpaceFillingImplementationdInterfaceObject_swigregister = _otlhs.SpaceFillingImplementationdInterfaceObject_swigregister
SpaceFillingImplementationdInterfaceObject_swigregister(SpaceFillingImplementationdInterfaceObject)

class SpaceFillingImplementation(openturns.common.PersistentObject):
    """
    Space filling computation

    Notes
    -----
    Compute a space filling criterion for a design, e.g. a metric that underlines how points fill the uniform space.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpaceFillingImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpaceFillingImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlhs.SpaceFillingImplementation_getClassName(self)

    def evaluate(self, *args):
        """
        Compute the criterion for a specific design

        Parameters
        ----------
        design:  :class:`~openturns.NumericalSample` or 2d array like
            The design

        Returns
        -------
        value:  float
            The computed criterion
        """
        return _otlhs.SpaceFillingImplementation_evaluate(self, *args)

    def isMinimizationProblem(self): return _otlhs.SpaceFillingImplementation_isMinimizationProblem(self)
    def __repr__(self): return _otlhs.SpaceFillingImplementation___repr__(self)
    def perturbLHS(self, *args):
        """
        Intentionaly not documented
        Do not use
        """
        return _otlhs.SpaceFillingImplementation_perturbLHS(self, *args)

    def __init__(self, *args): 
        this = _otlhs.new_SpaceFillingImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_SpaceFillingImplementation
    __del__ = lambda self : None;
SpaceFillingImplementation_swigregister = _otlhs.SpaceFillingImplementation_swigregister
SpaceFillingImplementation_swigregister(SpaceFillingImplementation)

class SpaceFillingImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpaceFillingImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpaceFillingImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _otlhs.new_SpaceFillingImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _otlhs.SpaceFillingImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _otlhs.SpaceFillingImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _otlhs.SpaceFillingImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _otlhs.SpaceFillingImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _otlhs.delete_SpaceFillingImplementationTypedInterfaceObject
    __del__ = lambda self : None;
SpaceFillingImplementationTypedInterfaceObject_swigregister = _otlhs.SpaceFillingImplementationTypedInterfaceObject_swigregister
SpaceFillingImplementationTypedInterfaceObject_swigregister(SpaceFillingImplementationTypedInterfaceObject)

class SpaceFilling(SpaceFillingImplementationdInterfaceObject):
    """
    Space filling computation

    Notes
    -----
    Compute a space filling criterion for a design, e.g. a metric that underlines how points fill the uniform space.
    """
    __swig_setmethods__ = {}
    for _s in [SpaceFillingImplementationdInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpaceFilling, name, value)
    __swig_getmethods__ = {}
    for _s in [SpaceFillingImplementationdInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpaceFilling, name)
    __swig_getmethods__["GetClassName"] = lambda x: _otlhs.SpaceFilling_GetClassName
    if _newclass:GetClassName = staticmethod(_otlhs.SpaceFilling_GetClassName)
    def getClassName(self): return _otlhs.SpaceFilling_getClassName(self)
    def evaluate(self, *args):
        """
        Compute the criterion for a specific design

        Parameters
        ----------
        design:  :class:`~openturns.NumericalSample` or 2d array like
            The design

        Returns
        -------
        value:  float
            The computed criterion
        """
        return _otlhs.SpaceFilling_evaluate(self, *args)

    def isMinimizationProblem(self): return _otlhs.SpaceFilling_isMinimizationProblem(self)
    def __repr__(self): return _otlhs.SpaceFilling___repr__(self)
    def perturbLHS(self, *args):
        """
        Intentionaly not documented
        Do not use
        """
        return _otlhs.SpaceFilling_perturbLHS(self, *args)

    def __init__(self, *args): 
        this = _otlhs.new_SpaceFilling(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_SpaceFilling
    __del__ = lambda self : None;
SpaceFilling_swigregister = _otlhs.SpaceFilling_swigregister
SpaceFilling_swigregister(SpaceFilling)

def SpaceFilling_GetClassName():
  return _otlhs.SpaceFilling_GetClassName()
SpaceFilling_GetClassName = _otlhs.SpaceFilling_GetClassName

class SpaceFillingC2(SpaceFillingImplementation):
    """
    Space filling C2 (centered L2-discrepancy) computation

    Notes
    -----
    Compute the centered L2 discrepancy:

    .. math::
        :nowrap:

        \\begin{multline*}
        C^2(X_{d}^N) = \\left(\\frac{13}{12}\\right)^{d} - \\frac{2}{N} \\sum_{i=1}^{N} \\prod_{k=1}^{d} \\left( 1 + \\frac{1}{2} |x_k^{(i)} - 0.5| - \\frac{1}{2} |x_k^{(i)} - 0.5|^2 \\right)\\\\
                 + \\frac{1}{N^2} \\sum_{i,j=1}^{N} \\prod_{k=1}^{d} \\left( 1 + \\frac{1}{2} |x_k^{(i)} - 0.5| + \\frac{1}{2} |x_k^{(j)} - 0.5| - \\frac{1}{2} |x_k^{(i)} - x_k^{(j)}| \\right)
        \\end{multline*}

    """
    __swig_setmethods__ = {}
    for _s in [SpaceFillingImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpaceFillingC2, name, value)
    __swig_getmethods__ = {}
    for _s in [SpaceFillingImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpaceFillingC2, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlhs.SpaceFillingC2_getClassName(self)

    def evaluate(self, *args):
        """
        Compute the C2 criterion for a specific design

        Parameters
        ----------
        design:  :class:`~openturns.NumericalSample` or 2d array like
            The design

        Returns
        -------
        crit:  float
            The C2 criterion

        Examples
        --------

        >>> import openturns as ot
        >>> import otlhs
        >>> # Build an LHS using openturns class
        >>> lhs = ot.LHSExperiment(100)
        >>> design = lhs.generate()
        >>> # Compute the C2 criterion
        >>> crit = otlhs.SpaceFillingC2().evaluate(design)
        """
        return _otlhs.SpaceFillingC2_evaluate(self, *args)

    def __repr__(self): return _otlhs.SpaceFillingC2___repr__(self)
    def perturbLHS(self, *args):
        """
        Intentionaly not documented
        Do not use
        """
        return _otlhs.SpaceFillingC2_perturbLHS(self, *args)

    def __init__(self, *args): 
        this = _otlhs.new_SpaceFillingC2(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_SpaceFillingC2
    __del__ = lambda self : None;
SpaceFillingC2_swigregister = _otlhs.SpaceFillingC2_swigregister
SpaceFillingC2_swigregister(SpaceFillingC2)

class SpaceFillingMinDist(SpaceFillingImplementation):
    """
    Space filling minimal distance criterion

    Notes
    -----
    Compute the minimal distance of sample points

    """
    __swig_setmethods__ = {}
    for _s in [SpaceFillingImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpaceFillingMinDist, name, value)
    __swig_getmethods__ = {}
    for _s in [SpaceFillingImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpaceFillingMinDist, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlhs.SpaceFillingMinDist_getClassName(self)

    def __repr__(self): return _otlhs.SpaceFillingMinDist___repr__(self)
    def evaluate(self, *args):
        """
        Compute the MinDist criterion for a specific design

        Parameters
        ----------
        design:  :class:`~openturns.NumericalSample` or 2d array like
            The design

        Returns
        -------
        crit:  float
            The MinDist criterion

        Examples
        --------

        >>> import openturns as ot
        >>> import otlhs
        >>> # Build an LHS using openturns class
        >>> lhs = ot.LHSExperiment(100)
        >>> design = lhs.generate()
        >>> # Compute the MinDist criterion
        >>> crit = otlhs.SpaceFillingMinDist().evaluate(design)
        """
        return _otlhs.SpaceFillingMinDist_evaluate(self, *args)

    def __init__(self, *args): 
        this = _otlhs.new_SpaceFillingMinDist(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_SpaceFillingMinDist
    __del__ = lambda self : None;
SpaceFillingMinDist_swigregister = _otlhs.SpaceFillingMinDist_swigregister
SpaceFillingMinDist_swigregister(SpaceFillingMinDist)

class SpaceFillingPhiP(SpaceFillingImplementation):
    """
    Space filling PhiP

    Parameters
    ----------
    p : int
        Parameter for parametrizing the criterion 

    Notes
    -----
    Computes the criterion:

    .. math::
        :nowrap:

        \\begin{equation*}
          \\phi_p(X) = \\sum_{i=1}^{j} \\sum_{j=1}^{n} \\left( |x^{(i)} - x^{(j)}|^{-p} \\right)^{\\frac{1}{p}}
        \\end{equation*}

    This criterion is knwon to converge to mindist (minimal distance between two distinct elements of the design) criterion when p tends to infinity.

    """
    __swig_setmethods__ = {}
    for _s in [SpaceFillingImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SpaceFillingPhiP, name, value)
    __swig_getmethods__ = {}
    for _s in [SpaceFillingImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SpaceFillingPhiP, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlhs.SpaceFillingPhiP_getClassName(self)

    def evaluate(self, *args):
        """
        Compute the PhiP criterion for a specific design

        Parameters
        ----------
        design:  :class:`~openturns.NumericalSample` or 2d array like
            The design

        Returns
        -------
        crit:  float
            The phiP criterion

        Examples
        --------

        >>> import openturns as ot
        >>> import otlhs
        >>> # Build an LHS using openturns class
        >>> lhs = ot.LHSExperiment(100)
        >>> design = lhs.generate()
        >>> # Compute the PhiP criterion
        >>> crit = otlhs.SpaceFillingPhiP(50).evaluate(design)
        """
        return _otlhs.SpaceFillingPhiP_evaluate(self, *args)

    def __repr__(self): return _otlhs.SpaceFillingPhiP___repr__(self)
    def perturbLHS(self, *args):
        """
        Intentionaly not documented
        Do not use
        """
        return _otlhs.SpaceFillingPhiP_perturbLHS(self, *args)

    def __init__(self, *args): 
        this = _otlhs.new_SpaceFillingPhiP(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_SpaceFillingPhiP
    __del__ = lambda self : None;
SpaceFillingPhiP_swigregister = _otlhs.SpaceFillingPhiP_swigregister
SpaceFillingPhiP_swigregister(SpaceFillingPhiP)

class OptimalLHSImplementationdInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimalLHSImplementationdInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimalLHSImplementationdInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _otlhs.new_OptimalLHSImplementationdInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _otlhs.OptimalLHSImplementationdInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _otlhs.OptimalLHSImplementationdInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _otlhs.OptimalLHSImplementationdInterfaceObject_getName(self)

    def __eq__(self, *args): return _otlhs.OptimalLHSImplementationdInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _otlhs.delete_OptimalLHSImplementationdInterfaceObject
    __del__ = lambda self : None;
OptimalLHSImplementationdInterfaceObject_swigregister = _otlhs.OptimalLHSImplementationdInterfaceObject_swigregister
OptimalLHSImplementationdInterfaceObject_swigregister(OptimalLHSImplementationdInterfaceObject)

class OptimalLHSImplementation(openturns.common.PersistentObject):
    """
    OptimalLHS class.

    Notes
    -----
    Perform the generation of optimal LHS designs.
    """
    __swig_setmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimalLHSImplementation, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.PersistentObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimalLHSImplementation, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlhs.OptimalLHSImplementation_getClassName(self)

    def getLHS(self):
        """
        Returns the LHSDesign

        Returns
        -------
        value:  :class:`~otlhs.LHSDesign`
               Result the factory that builds initial design to be optimized
        """
        return _otlhs.OptimalLHSImplementation_getLHS(self)

    def getSpaceFilling(self):
        """
        Returns the Space Filling criterion to be optimized

        Returns
        -------
        value:  :class:`~otlhs.SpaceFilling`
               Criterion function to be optimized
        """
        return _otlhs.OptimalLHSImplementation_getSpaceFilling(self)

    def generate(self):
        """
        Generate an optimal design

        Returns
        -------
        value:  :class:`~otlhs.LHSResult`
               Result of generation that contains the optimal design, some criteria and history
        """
        return _otlhs.OptimalLHSImplementation_generate(self)

    def __repr__(self): return _otlhs.OptimalLHSImplementation___repr__(self)
    def __init__(self, *args): 
        this = _otlhs.new_OptimalLHSImplementation(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_OptimalLHSImplementation
    __del__ = lambda self : None;
OptimalLHSImplementation_swigregister = _otlhs.OptimalLHSImplementation_swigregister
OptimalLHSImplementation_swigregister(OptimalLHSImplementation)

class OptimalLHSImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    __swig_setmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimalLHSImplementationTypedInterfaceObject, name, value)
    __swig_getmethods__ = {}
    for _s in [openturns.common.InterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimalLHSImplementationTypedInterfaceObject, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _otlhs.new_OptimalLHSImplementationTypedInterfaceObject(*args)
        try: self.this.append(this)
        except: self.this = this
    def getImplementation(self, *args):
        """
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _otlhs.OptimalLHSImplementationTypedInterfaceObject_getImplementation(self, *args)

    def setName(self, *args):
        """
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _otlhs.OptimalLHSImplementationTypedInterfaceObject_setName(self, *args)

    def getName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _otlhs.OptimalLHSImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, *args): return _otlhs.OptimalLHSImplementationTypedInterfaceObject___eq__(self, *args)
    __swig_destroy__ = _otlhs.delete_OptimalLHSImplementationTypedInterfaceObject
    __del__ = lambda self : None;
OptimalLHSImplementationTypedInterfaceObject_swigregister = _otlhs.OptimalLHSImplementationTypedInterfaceObject_swigregister
OptimalLHSImplementationTypedInterfaceObject_swigregister(OptimalLHSImplementationTypedInterfaceObject)

class OptimalLHS(OptimalLHSImplementationdInterfaceObject):
    """
    OptimalLHS class.

    Notes
    -----
    Perform the generation of optimal LHS designs.
    """
    __swig_setmethods__ = {}
    for _s in [OptimalLHSImplementationdInterfaceObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OptimalLHS, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimalLHSImplementationdInterfaceObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, OptimalLHS, name)
    __swig_getmethods__["GetClassName"] = lambda x: _otlhs.OptimalLHS_GetClassName
    if _newclass:GetClassName = staticmethod(_otlhs.OptimalLHS_GetClassName)
    def getClassName(self): return _otlhs.OptimalLHS_getClassName(self)
    def getLHS(self):
        """
        Returns the LHSDesign

        Returns
        -------
        value:  :class:`~otlhs.LHSDesign`
               Result the factory that builds initial design to be optimized
        """
        return _otlhs.OptimalLHS_getLHS(self)

    def getSpaceFilling(self):
        """
        Returns the Space Filling criterion to be optimized

        Returns
        -------
        value:  :class:`~otlhs.SpaceFilling`
               Criterion function to be optimized
        """
        return _otlhs.OptimalLHS_getSpaceFilling(self)

    def generate(self): return _otlhs.OptimalLHS_generate(self)
    def __repr__(self): return _otlhs.OptimalLHS___repr__(self)
    def __init__(self, *args): 
        this = _otlhs.new_OptimalLHS(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_OptimalLHS
    __del__ = lambda self : None;
OptimalLHS_swigregister = _otlhs.OptimalLHS_swigregister
OptimalLHS_swigregister(OptimalLHS)

def OptimalLHS_GetClassName():
  return _otlhs.OptimalLHS_GetClassName()
OptimalLHS_GetClassName = _otlhs.OptimalLHS_GetClassName

class MonteCarloLHS(OptimalLHSImplementation):
    """
    MonteCarloLHS class.
     
    Performs the optimization of an LHS using MonteCarlo simulations.

    Usage
    -----
        MonteCarloLHS(lhsDesign, N)
        MonteCarloLHS(lhsDesign, N, spaceFilling)

    Parameters
    ----------

    lhsDesign: LHSDesign
         Factory that generate designs

    N : int
        Number of simulations

    spaceFilling: SpaceFilling
        Criterion to be optimized
        Default spaceFilling is MinDist

    Notes
    -----
    MonteCarloLHS generate N designs using lhsDesign and returns the optimal one with respect to spaceFilling

    Examples
    --------
    >>> import openturns as ot
    >>> import otlhs
    >>> dimension = 3
    >>> bounds = ot.Interval(dimension)
    >>> size = 100
    >>> # Build standard randomized LHS algorithm
    >>> lhsDesign = otlhs.LHSDesign(bounds, size)
    >>> # Defining space fillings
    >>> spaceFilling = otlhs.SpaceFillingC2()
    >>> # RandomBruteForce MonteCarlo with N designs (LHS with C2 optimization)
    >>> N = 10000
    >>> optimalLHSAlgorithm = otlhs.MonteCarloLHS(lhsDesign, N, spaceFilling)

    """
    __swig_setmethods__ = {}
    for _s in [OptimalLHSImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MonteCarloLHS, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimalLHSImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, MonteCarloLHS, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlhs.MonteCarloLHS_getClassName(self)

    def generate(self):
        """
        Generate an optimal design

        Returns
        -------
        value:  :class:`~otlhs.LHSResult`
               Result of generation that contains the optimal design, some criteria and history
        """
        return _otlhs.MonteCarloLHS_generate(self)

    def __repr__(self): return _otlhs.MonteCarloLHS___repr__(self)
    def __init__(self, *args): 
        this = _otlhs.new_MonteCarloLHS(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_MonteCarloLHS
    __del__ = lambda self : None;
MonteCarloLHS_swigregister = _otlhs.MonteCarloLHS_swigregister
MonteCarloLHS_swigregister(MonteCarloLHS)

class SimulatedAnnealingLHS(OptimalLHSImplementation):
    """
    SimulatedAnnealingLHS class

    Performs the optimization of an LHS using simulated annealing algorithm.

    Usage
    -----
        SimulatedAnnealingLHS(lhsDesign)
        SimulatedAnnealingLHS(lhsDesign, profile)
        SimulatedAnnealingLHS(lhsDesign, profile, spaceFilling)
        SimulatedAnnealingLHS(initialDesign, bounds)
        SimulatedAnnealingLHS(initialDesign, bounds, profile)
        SimulatedAnnealingLHS(initialDesign, bounds, profile, spaceFilling)

    Parameters
    ----------

    lhsDesign: LHSDesign
        Factory that generate designs

    initialDesign: 2d-array sequence
        Initial design to be optimized

    bounds : Interval
        Bounds of designs

    profile: TemperatureProfile
        Temperature profile used by the simulated annealing algorithm
        Default one is GeometricProfile

    spaceFilling: SpaceFilling
        Criterion to be optimized
        Default one is SpaceFillingMinDist

    Notes
    -----

    With the first constructor, the initial design is generated thanks to lhsDesign. With the second usage, we fix it.
    Starting from this design, a new design is obtained by permuting one random coordinate of two randomly chosen elements; by construction, this design is also an LHS design. 
    If the new design is better than the previous one, it is kept.  
    If it is worse, it may anyway be kept with some probability, which depends on how these designs compare, but also on a temperature profile 
    T which decreases over time.  This means that jumping away from local extrema becomes less probable over time.

    Examples
    --------
    >>> import openturns as ot
    >>> import otlhs
    >>> dimension = 3
    >>> bounds = ot.Interval(dimension)
    >>> size = 100
    >>> # Build standard randomized LHS algorithm
    >>> lhsDesign = otlhs.LHSDesign(bounds, size)
    >>> # Defining space fillings
    >>> spaceFilling = otlhs.SpaceFillingC2()
    >>> # Geometric profile
    >>> geomProfile = otlhs.GeometricProfile(10.0, 0.95, 2000)
    >>> # Simulated Annealing LHS with geometric temperature profile, C2 optimization
    >>> optimalLHSAlgorithm = otlhs.SimulatedAnnealingLHS(lhs, geomProfile, spaceFilling)
    """
    __swig_setmethods__ = {}
    for _s in [OptimalLHSImplementation]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SimulatedAnnealingLHS, name, value)
    __swig_getmethods__ = {}
    for _s in [OptimalLHSImplementation]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, SimulatedAnnealingLHS, name)
    def getClassName(self):
        """
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _otlhs.SimulatedAnnealingLHS_getClassName(self)

    def generate(self, nRestart=0):
        """
        Generate an optimal design

        Returns
        -------
        value:  :class:`~otlhs.LHSResult`
               Result of generation that contains the optimal design, some criteria and history
        """
        return _otlhs.SimulatedAnnealingLHS_generate(self, nRestart)

    def __repr__(self): return _otlhs.SimulatedAnnealingLHS___repr__(self)
    def __init__(self, *args): 
        this = _otlhs.new_SimulatedAnnealingLHS(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _otlhs.delete_SimulatedAnnealingLHS
    __del__ = lambda self : None;
SimulatedAnnealingLHS_swigregister = _otlhs.SimulatedAnnealingLHS_swigregister
SimulatedAnnealingLHS_swigregister(SimulatedAnnealingLHS)

# This file is compatible with both classic and new-style classes.


