%define OTLHS_SpaceFillingPhiP_doc
"Space filling PhiP

Parameters
----------
p : int
    Parameter for parametrizing the criterion 

Notes
-----
Computes the criterion:

.. math::
    :nowrap:

    \\\\begin{equation*}
      \\\\phi_p(X) = \\\\sum_{i=1}^{j} \\\\sum_{j=1}^{n} \\\\left( |x^{(i)} - x^{(j)}|^{-p} \\\\right)^{\\\\frac{1}{p}}
    \\\\end{equation*}

This criterion is knwon to converge to mindist (minimal distance between two distinct elements of the design) criterion when p tends to infinity.
"

%enddef
%feature("docstring") OTLHS::SpaceFillingPhiP
OTLHS_SpaceFillingPhiP_doc
// ---------------------------------------------------------------------
%define OTLHS_SpaceFillingPhiP_evaluate_doc
"Compute the PhiP criterion for a specific design

Parameters
----------
design:  :class:`~openturns.NumericalSample` or 2d array like
    The design

Returns
-------
crit:  float
    The phiP criterion

Examples
--------

>>> import openturns as ot
>>> import otlhs
>>> # Build an LHS using openturns class
>>> lhs = ot.LHSExperiment(100)
>>> design = lhs.generate()
>>> # Compute the PhiP criterion
>>> crit = otlhs.SpaceFillingPhiP(50).evaluate(design)"
%enddef
%feature("docstring") OTLHS::SpaceFillingPhiP::evaluate
OTLHS_SpaceFillingPhiP_evaluate_doc
// ---------------------------------------------------------------------
