/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import java.util.TreeSet;
import org.hipparchus.FieldElement;
import org.hipparchus.complex.Complex;
import org.hipparchus.complex.ComplexComparator;
import org.hipparchus.linear.ComplexEigenDecomposition;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.RealMatrix;

public class OrderedComplexEigenDecomposition
extends ComplexEigenDecomposition {
    public OrderedComplexEigenDecomposition(RealMatrix matrix) {
        super(matrix);
        int ij;
        FieldMatrix<Complex> D = this.getD();
        FieldMatrix<Complex> V = this.getV();
        TreeSet<Complex> eigenValues = new TreeSet<Complex>(new ComplexComparator());
        for (ij = 0; ij < matrix.getRowDimension(); ++ij) {
            eigenValues.add(D.getEntry(ij, ij));
        }
        for (ij = 0; ij < matrix.getRowDimension() - 1; ++ij) {
            Complex compCurrent;
            Complex eigValue = eigenValues.pollFirst();
            int currentIndex = -1;
            for (currentIndex = ij; currentIndex < matrix.getRowDimension() && !eigValue.equals(compCurrent = D.getEntry(currentIndex, currentIndex)); ++currentIndex) {
            }
            if (ij == currentIndex) continue;
            Complex previousValue = D.getEntry(ij, ij);
            D.setEntry(ij, ij, eigValue);
            D.setEntry(currentIndex, currentIndex, previousValue);
            FieldElement[] previousColumnV = (Complex[])V.getColumn(ij);
            V.setColumn(ij, (Complex[])V.getColumn(currentIndex));
            V.setColumn(currentIndex, previousColumnV);
        }
        this.checkDefinition(matrix);
    }

    @Override
    public FieldMatrix<Complex> getVT() {
        return this.getV().transpose();
    }
}

