/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.frames.LOFType;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

class GNSSAttitudeContext
implements TimeStamped {
    private static final PVCoordinates PLUS_Y = new PVCoordinates(Vector3D.PLUS_J, Vector3D.ZERO, Vector3D.ZERO);
    private static final PVCoordinates MINUS_Z = new PVCoordinates(Vector3D.MINUS_K, Vector3D.ZERO, Vector3D.ZERO);
    private static final double BETA_SIGN_CHANGE_PROTECTION = FastMath.toRadians((double)0.07);
    private static final int ORDER = 2;
    private final TimeStampedPVCoordinates svPV;
    private final FieldPVCoordinates<DerivativeStructure> svPVDS;
    private final DerivativeStructure beta;
    private final DerivativeStructure svbCos;
    private final TimeStampedAngularCoordinates nominalYaw;
    private final FieldRotation<DerivativeStructure> nominalYawDS;
    private double muRate;
    private double cNight;
    private double cNoon;
    private DerivativeStructure delta;
    private double halfSpan;
    private AbsoluteDate turnStart;
    private AbsoluteDate turnEnd;

    GNSSAttitudeContext(TimeStampedPVCoordinates sunPV, TimeStampedPVCoordinates svPV) throws OrekitException {
        FieldPVCoordinates<DerivativeStructure> sunPVDS = sunPV.toDerivativeStructurePV(2);
        this.svPV = svPV;
        this.svPVDS = svPV.toDerivativeStructurePV(2);
        this.svbCos = ((DerivativeStructure)FieldVector3D.dotProduct(sunPVDS.getPosition(), this.svPVDS.getPosition())).divide(((DerivativeStructure)sunPVDS.getPosition().getNorm()).multiply((DerivativeStructure)this.svPVDS.getPosition().getNorm()));
        this.beta = ((DerivativeStructure)FieldVector3D.angle(sunPVDS.getPosition(), this.svPVDS.getMomentum())).negate().add(1.5707963267948966);
        this.nominalYaw = new TimeStampedAngularCoordinates(svPV.getDate(), svPV.normalize(), PVCoordinates.crossProduct(sunPV, svPV).normalize(), MINUS_Z, PLUS_Y, 1.0E-9);
        this.nominalYawDS = this.nominalYaw.toDerivativeStructureRotation(2);
        this.muRate = svPV.getAngularVelocity().getNorm();
    }

    @Override
    public AbsoluteDate getDate() {
        return this.svPV.getDate();
    }

    public double getSVBcos() {
        return this.svbCos.getValue();
    }

    public double getBeta() {
        return this.beta.getValue();
    }

    public DerivativeStructure getBetaDS() {
        return this.beta;
    }

    public double getSecuredBeta() {
        return FastMath.abs((double)this.beta.getReal()) < BETA_SIGN_CHANGE_PROTECTION ? this.beta.taylor(new double[]{-this.timeSinceTurnStart(this.getDate())}) : this.getBeta();
    }

    public TimeStampedAngularCoordinates getNominalYaw() {
        return this.nominalYaw;
    }

    public double yawAngle() {
        Vector3D xSat = this.nominalYaw.getRotation().revert().applyTo(Vector3D.PLUS_I);
        return FastMath.copySign((double)Vector3D.angle((Vector3D)this.svPV.getVelocity(), (Vector3D)xSat), (double)(-this.beta.getReal()));
    }

    public DerivativeStructure yawAngleDS() {
        FieldVector3D xSat = this.nominalYawDS.revert().applyTo(Vector3D.PLUS_I);
        return (DerivativeStructure)FastMath.copySign((RealFieldElement)FieldVector3D.angle((Vector3D)this.svPV.getVelocity(), (FieldVector3D)xSat), (double)(-this.beta.getReal()));
    }

    public boolean setUpTurnRegion(double cosNight, double cosNoon) {
        this.cNight = cosNight;
        this.cNoon = cosNoon;
        if (this.svbCos.getValue() < this.cNight) {
            DerivativeStructure absDelta = this.inOrbitPlaneAbsoluteAngle(this.svbCos.acos().negate().add(Math.PI));
            this.delta = (DerivativeStructure)FastMath.copySign((RealFieldElement)absDelta, (double)(-absDelta.getPartialDerivative(new int[]{1})));
            return true;
        }
        if (this.svbCos.getValue() > this.cNoon) {
            DerivativeStructure absDelta = this.inOrbitPlaneAbsoluteAngle(this.svbCos.acos());
            this.delta = (DerivativeStructure)FastMath.copySign((RealFieldElement)absDelta, (double)(-absDelta.getPartialDerivative(new int[]{1})));
            return true;
        }
        return false;
    }

    public double getDelta() {
        return this.delta.getValue();
    }

    public DerivativeStructure getDeltaDS() {
        return this.delta;
    }

    public boolean inSunSide() {
        return this.svbCos.getValue() > 0.0;
    }

    public double getYawStart(double sunBeta) {
        return this.computePhi(sunBeta, FastMath.copySign((double)this.halfSpan, (double)this.svbCos.getValue()));
    }

    public double getYawEnd(double sunBeta) {
        return this.computePhi(sunBeta, FastMath.copySign((double)this.halfSpan, (double)(-this.svbCos.getValue())));
    }

    public double yawRate(double sunBeta) {
        return (this.getYawEnd(sunBeta) - this.getYawStart(sunBeta)) / this.getTurnDuration();
    }

    public double getMuRate() {
        return this.muRate;
    }

    private DerivativeStructure inOrbitPlaneAbsoluteAngle(DerivativeStructure angle) {
        return (DerivativeStructure)FastMath.acos((RealFieldElement)((DerivativeStructure)FastMath.cos((RealFieldElement)angle)).divide((DerivativeStructure)FastMath.cos((RealFieldElement)this.beta)));
    }

    public double inOrbitPlaneAbsoluteAngle(double angle) {
        return FastMath.acos((double)(FastMath.cos((double)angle) / FastMath.cos((double)this.beta.getReal())));
    }

    public double computePhi(double sunBeta, double inOrbitPlaneAngle) {
        return FastMath.atan2((double)(-FastMath.tan((double)sunBeta)), (double)FastMath.sin((double)inOrbitPlaneAngle));
    }

    public void setHalfSpan(double halfSpan) {
        this.halfSpan = halfSpan;
        this.turnStart = this.svPV.getDate().shiftedBy((this.delta.getValue() - halfSpan) / this.muRate);
        this.turnEnd = this.svPV.getDate().shiftedBy((this.delta.getValue() + halfSpan) / this.muRate);
    }

    public boolean inTurnTimeRange(AbsoluteDate date, double endMargin) {
        return date.durationFrom(this.turnStart) > 0.0 && date.durationFrom(this.turnEnd) < endMargin;
    }

    public double getTurnDuration() {
        return 2.0 * this.halfSpan / this.muRate;
    }

    public double timeSinceTurnStart(AbsoluteDate date) {
        return date.durationFrom(this.turnStart);
    }

    public TimeStampedAngularCoordinates turnCorrectedAttitude(double yaw, double yawDot) {
        return this.turnCorrectedAttitude(this.beta.getFactory().build(new double[]{yaw, yawDot, 0.0}));
    }

    public TimeStampedAngularCoordinates turnCorrectedAttitude(DerivativeStructure yaw) {
        DerivativeStructure nominalAngle = this.yawAngleDS();
        TimeStampedAngularCoordinates correction = new TimeStampedAngularCoordinates(this.nominalYaw.getDate(), (FieldRotation<DerivativeStructure>)new FieldRotation(FieldVector3D.getPlusK((Field)nominalAngle.getField()), (RealFieldElement)yaw.subtract(nominalAngle), RotationConvention.VECTOR_OPERATOR));
        return correction.addOffset(this.getNominalYaw());
    }

    public TimeStampedAngularCoordinates orbitNormalYaw() {
        Transform t = LOFType.VVLH.transformFromInertial(this.svPV.getDate(), this.svPV);
        return new TimeStampedAngularCoordinates(this.svPV.getDate(), t.getRotation(), t.getRotationRate(), t.getRotationAcceleration());
    }
}

