/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.files.ccsds.ODMMetaData;
import org.orekit.files.ccsds.OGMFile;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class OPMFile
extends OGMFile {
    private final ODMMetaData metaData = new ODMMetaData(this);
    private Vector3D position;
    private Vector3D velocity;
    private List<Maneuver> maneuvers = new ArrayList<Maneuver>();

    OPMFile() {
    }

    @Override
    public ODMMetaData getMetaData() {
        return this.metaData;
    }

    public Vector3D getPosition() {
        return this.position;
    }

    void setPosition(Vector3D position) {
        this.position = position;
    }

    public Vector3D getVelocity() {
        return this.velocity;
    }

    void setVelocity(Vector3D velocity) {
        this.velocity = velocity;
    }

    public int getNbManeuvers() {
        return this.maneuvers.size();
    }

    public List<Maneuver> getManeuvers() {
        return Collections.unmodifiableList(this.maneuvers);
    }

    public Maneuver getManeuver(int index) {
        return this.maneuvers.get(index);
    }

    void addManeuver(Maneuver maneuver) {
        this.maneuvers.add(maneuver);
    }

    public boolean getHasManeuver() {
        return !this.maneuvers.isEmpty();
    }

    public List<String> getMetaDataComment() {
        return this.metaData.getComment();
    }

    public PVCoordinates getPVCoordinates() {
        return new PVCoordinates(this.getPosition(), this.getVelocity());
    }

    public CartesianOrbit generateCartesianOrbit() throws OrekitException {
        this.setMuUsed();
        return new CartesianOrbit(this.getPVCoordinates(), this.metaData.getFrame(), this.getEpoch(), this.getMuUsed());
    }

    public KeplerianOrbit generateKeplerianOrbit() throws OrekitException {
        this.setMuUsed();
        if (this.hasKeplerianElements()) {
            return new KeplerianOrbit(this.getA(), this.getE(), this.getI(), this.getPa(), this.getRaan(), this.getAnomaly(), this.getAnomalyType(), this.metaData.getFrame(), this.getEpoch(), this.getMuUsed());
        }
        return new KeplerianOrbit(this.getPVCoordinates(), this.metaData.getFrame(), this.getEpoch(), this.getMuUsed());
    }

    public SpacecraftState generateSpacecraftState() throws OrekitException {
        return new SpacecraftState((Orbit)this.generateCartesianOrbit(), this.getMass());
    }

    public static class Maneuver {
        private AbsoluteDate epochIgnition;
        private LOFType refLofType;
        private Frame refFrame;
        private double duration;
        private double deltaMass;
        private Vector3D dV = Vector3D.ZERO;
        private List<String> comment = Collections.emptyList();

        public AbsoluteDate getEpochIgnition() {
            return this.epochIgnition;
        }

        void setEpochIgnition(AbsoluteDate epochIgnition) {
            this.epochIgnition = epochIgnition;
        }

        public LOFType getRefLofType() {
            return this.refLofType;
        }

        public void setRefLofType(LOFType refLofType) {
            this.refLofType = refLofType;
            this.refFrame = null;
        }

        public Frame getRefFrame() {
            return this.refFrame;
        }

        public void setRefFrame(Frame refFrame) {
            this.refLofType = null;
            this.refFrame = refFrame;
        }

        public double getDuration() {
            return this.duration;
        }

        public void setDuration(double duration) {
            this.duration = duration;
        }

        public double getDeltaMass() {
            return this.deltaMass;
        }

        public void setDeltaMass(double deltaMass) {
            this.deltaMass = deltaMass;
        }

        public Vector3D getDV() {
            return this.dV;
        }

        public void setdV(Vector3D dV) {
            this.dV = dV;
        }

        public List<String> getComment() {
            return Collections.unmodifiableList(this.comment);
        }

        public void setComment(List<String> comment) {
            this.comment = new ArrayList<String>(comment);
        }
    }
}

