/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldStateInterpolator;

class EulerFieldStateInterpolator<T extends RealFieldElement<T>>
extends RungeKuttaFieldStateInterpolator<T> {
    EulerFieldStateInterpolator(Field<T> field, boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> mapper) {
        super(field, forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected EulerFieldStateInterpolator<T> create(Field<T> newField, boolean newForward, T[][] newYDotK, FieldODEStateAndDerivative<T> newGlobalPreviousState, FieldODEStateAndDerivative<T> newGlobalCurrentState, FieldODEStateAndDerivative<T> newSoftPreviousState, FieldODEStateAndDerivative<T> newSoftCurrentState, FieldEquationsMapper<T> newMapper) {
        return new EulerFieldStateInterpolator(newField, newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> mapper, T time, T theta, T thetaH, T oneMinusThetaH) {
        RealFieldElement[] interpolatedDerivatives;
        RealFieldElement[] interpolatedState;
        if (this.getGlobalPreviousState() != null && theta.getReal() <= 0.5) {
            interpolatedState = this.previousStateLinearCombination(new RealFieldElement[]{thetaH});
            interpolatedDerivatives = this.derivativeLinearCombination(new RealFieldElement[]{(RealFieldElement)time.getField().getOne()});
        } else {
            interpolatedState = this.currentStateLinearCombination(new RealFieldElement[]{(RealFieldElement)oneMinusThetaH.negate()});
            interpolatedDerivatives = this.derivativeLinearCombination(new RealFieldElement[]{(RealFieldElement)time.getField().getOne()});
        }
        return mapper.mapStateAndDerivative((RealFieldElement)time, interpolatedState, interpolatedDerivatives);
    }
}

