/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.io.Serializable;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.DecompositionSolver;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.QRDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AngularCoordinates
implements TimeShiftable<AngularCoordinates>,
Serializable {
    public static final AngularCoordinates IDENTITY = new AngularCoordinates(Rotation.IDENTITY, Vector3D.ZERO, Vector3D.ZERO);
    private static final long serialVersionUID = 20140414L;
    private final Rotation rotation;
    private final Vector3D rotationRate;
    private final Vector3D rotationAcceleration;

    public AngularCoordinates() {
        this(Rotation.IDENTITY, Vector3D.ZERO, Vector3D.ZERO);
    }

    public AngularCoordinates(Rotation rotation, Vector3D rotationRate) {
        this(rotation, rotationRate, Vector3D.ZERO);
    }

    public AngularCoordinates(Rotation rotation, Vector3D rotationRate, Vector3D rotationAcceleration) {
        this.rotation = rotation;
        this.rotationRate = rotationRate;
        this.rotationAcceleration = rotationAcceleration;
    }

    public AngularCoordinates(PVCoordinates u1, PVCoordinates u2, PVCoordinates v1, PVCoordinates v2, double tolerance) throws OrekitException {
        try {
            this.rotation = new Rotation(u1.getPosition(), u2.getPosition(), v1.getPosition(), v2.getPosition());
            Vector3D ru1Dot = this.rotation.applyTo(u1.getVelocity());
            Vector3D ru2Dot = this.rotation.applyTo(u2.getVelocity());
            this.rotationRate = AngularCoordinates.inverseCrossProducts(v1.getPosition(), ru1Dot.subtract((Vector)v1.getVelocity()), v2.getPosition(), ru2Dot.subtract((Vector)v2.getVelocity()), tolerance);
            Vector3D ru1DotDot = this.rotation.applyTo(u1.getAcceleration());
            Vector3D oDotv1 = Vector3D.crossProduct((Vector3D)this.rotationRate, (Vector3D)v1.getVelocity());
            Vector3D oov1 = Vector3D.crossProduct((Vector3D)this.rotationRate, (Vector3D)Vector3D.crossProduct((Vector3D)this.rotationRate, (Vector3D)v1.getPosition()));
            Vector3D c1 = new Vector3D(1.0, ru1DotDot, -2.0, oDotv1, -1.0, oov1, -1.0, v1.getAcceleration());
            Vector3D ru2DotDot = this.rotation.applyTo(u2.getAcceleration());
            Vector3D oDotv2 = Vector3D.crossProduct((Vector3D)this.rotationRate, (Vector3D)v2.getVelocity());
            Vector3D oov2 = Vector3D.crossProduct((Vector3D)this.rotationRate, (Vector3D)Vector3D.crossProduct((Vector3D)this.rotationRate, (Vector3D)v2.getPosition()));
            Vector3D c2 = new Vector3D(1.0, ru2DotDot, -2.0, oDotv2, -1.0, oov2, -1.0, v2.getAcceleration());
            this.rotationAcceleration = AngularCoordinates.inverseCrossProducts(v1.getPosition(), c1, v2.getPosition(), c2, tolerance);
        }
        catch (MathRuntimeException mrte) {
            throw new OrekitException(mrte);
        }
    }

    public AngularCoordinates(PVCoordinates u, PVCoordinates v) throws OrekitException {
        this((FieldRotation<DerivativeStructure>)new FieldRotation(u.toDerivativeStructureVector(2), v.toDerivativeStructureVector(2)));
    }

    public AngularCoordinates(FieldRotation<DerivativeStructure> r) {
        double q0 = ((DerivativeStructure)r.getQ0()).getReal();
        double q1 = ((DerivativeStructure)r.getQ1()).getReal();
        double q2 = ((DerivativeStructure)r.getQ2()).getReal();
        double q3 = ((DerivativeStructure)r.getQ3()).getReal();
        this.rotation = new Rotation(q0, q1, q2, q3, false);
        if (((DerivativeStructure)r.getQ0()).getOrder() >= 1) {
            double q0Dot = ((DerivativeStructure)r.getQ0()).getPartialDerivative(new int[]{1});
            double q1Dot = ((DerivativeStructure)r.getQ1()).getPartialDerivative(new int[]{1});
            double q2Dot = ((DerivativeStructure)r.getQ2()).getPartialDerivative(new int[]{1});
            double q3Dot = ((DerivativeStructure)r.getQ3()).getPartialDerivative(new int[]{1});
            this.rotationRate = new Vector3D(2.0 * MathArrays.linearCombination((double)(-q1), (double)q0Dot, (double)q0, (double)q1Dot, (double)q3, (double)q2Dot, (double)(-q2), (double)q3Dot), 2.0 * MathArrays.linearCombination((double)(-q2), (double)q0Dot, (double)(-q3), (double)q1Dot, (double)q0, (double)q2Dot, (double)q1, (double)q3Dot), 2.0 * MathArrays.linearCombination((double)(-q3), (double)q0Dot, (double)q2, (double)q1Dot, (double)(-q1), (double)q2Dot, (double)q0, (double)q3Dot));
            if (((DerivativeStructure)r.getQ0()).getOrder() >= 2) {
                double q0DotDot = ((DerivativeStructure)r.getQ0()).getPartialDerivative(new int[]{2});
                double q1DotDot = ((DerivativeStructure)r.getQ1()).getPartialDerivative(new int[]{2});
                double q2DotDot = ((DerivativeStructure)r.getQ2()).getPartialDerivative(new int[]{2});
                double q3DotDot = ((DerivativeStructure)r.getQ3()).getPartialDerivative(new int[]{2});
                this.rotationAcceleration = new Vector3D(2.0 * MathArrays.linearCombination((double)(-q1), (double)q0DotDot, (double)q0, (double)q1DotDot, (double)q3, (double)q2DotDot, (double)(-q2), (double)q3DotDot), 2.0 * MathArrays.linearCombination((double)(-q2), (double)q0DotDot, (double)(-q3), (double)q1DotDot, (double)q0, (double)q2DotDot, (double)q1, (double)q3DotDot), 2.0 * MathArrays.linearCombination((double)(-q3), (double)q0DotDot, (double)q2, (double)q1DotDot, (double)(-q1), (double)q2DotDot, (double)q0, (double)q3DotDot));
            } else {
                this.rotationAcceleration = Vector3D.ZERO;
            }
        } else {
            this.rotationRate = Vector3D.ZERO;
            this.rotationAcceleration = Vector3D.ZERO;
        }
    }

    private static Vector3D inverseCrossProducts(Vector3D v1, Vector3D c1, Vector3D v2, Vector3D c2, double tolerance) throws MathIllegalArgumentException {
        Vector3D omega;
        double v12 = v1.getNormSq();
        double v1n = FastMath.sqrt((double)v12);
        double v22 = v2.getNormSq();
        double v2n = FastMath.sqrt((double)v22);
        double threshold = tolerance * FastMath.max((double)v1n, (double)v2n);
        try {
            RealMatrix m = MatrixUtils.createRealMatrix((int)6, (int)3);
            m.setEntry(0, 1, v1.getZ());
            m.setEntry(0, 2, -v1.getY());
            m.setEntry(1, 0, -v1.getZ());
            m.setEntry(1, 2, v1.getX());
            m.setEntry(2, 0, v1.getY());
            m.setEntry(2, 1, -v1.getX());
            m.setEntry(3, 1, v2.getZ());
            m.setEntry(3, 2, -v2.getY());
            m.setEntry(4, 0, -v2.getZ());
            m.setEntry(4, 2, v2.getX());
            m.setEntry(5, 0, v2.getY());
            m.setEntry(5, 1, -v2.getX());
            RealVector rhs = MatrixUtils.createRealVector((double[])new double[]{c1.getX(), c1.getY(), c1.getZ(), c2.getX(), c2.getY(), c2.getZ()});
            DecompositionSolver solver = new QRDecomposition(m, threshold).getSolver();
            RealVector v = solver.solve(rhs);
            omega = new Vector3D(v.getEntry(0), v.getEntry(1), v.getEntry(2));
        }
        catch (MathIllegalArgumentException miae) {
            if (miae.getSpecifier() == LocalizedCoreFormats.SINGULAR_MATRIX) {
                double c12 = c1.getNormSq();
                double c1n = FastMath.sqrt((double)c12);
                double c22 = c2.getNormSq();
                double c2n = FastMath.sqrt((double)c22);
                if (c1n <= threshold && c2n <= threshold) {
                    return Vector3D.ZERO;
                }
                if (v1n <= threshold && c1n >= threshold) {
                    throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE, new Object[]{c1n, 0, true});
                }
                if (v2n <= threshold && c2n >= threshold) {
                    throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE, new Object[]{c2n, 0, true});
                }
                if (Vector3D.crossProduct((Vector3D)v1, (Vector3D)v2).getNorm() <= threshold && v12 > threshold) {
                    omega = new Vector3D(1.0 / v12, Vector3D.crossProduct((Vector3D)v1, (Vector3D)c1));
                }
                throw miae;
            }
            throw miae;
        }
        double d1 = Vector3D.distance((Vector3D)Vector3D.crossProduct((Vector3D)omega, (Vector3D)v1), (Vector3D)c1);
        if (d1 > threshold) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE, new Object[]{d1, 0, true});
        }
        double d2 = Vector3D.distance((Vector3D)Vector3D.crossProduct((Vector3D)omega, (Vector3D)v2), (Vector3D)c2);
        if (d2 > threshold) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE, new Object[]{d2, 0, true});
        }
        return omega;
    }

    public FieldRotation<DerivativeStructure> toDerivativeStructureRotation(int order) throws OrekitException {
        DerivativeStructure q3DS;
        DerivativeStructure q2DS;
        DerivativeStructure q1DS;
        DerivativeStructure q0DS;
        double q0 = this.rotation.getQ0();
        double q1 = this.rotation.getQ1();
        double q2 = this.rotation.getQ2();
        double q3 = this.rotation.getQ3();
        double oX = this.rotationRate.getX();
        double oY = this.rotationRate.getY();
        double oZ = this.rotationRate.getZ();
        double q0Dot = 0.5 * MathArrays.linearCombination((double)(-q1), (double)oX, (double)(-q2), (double)oY, (double)(-q3), (double)oZ);
        double q1Dot = 0.5 * MathArrays.linearCombination((double)q0, (double)oX, (double)(-q3), (double)oY, (double)q2, (double)oZ);
        double q2Dot = 0.5 * MathArrays.linearCombination((double)q3, (double)oX, (double)q0, (double)oY, (double)(-q1), (double)oZ);
        double q3Dot = 0.5 * MathArrays.linearCombination((double)(-q2), (double)oX, (double)q1, (double)oY, (double)q0, (double)oZ);
        double oXDot = this.rotationAcceleration.getX();
        double oYDot = this.rotationAcceleration.getY();
        double oZDot = this.rotationAcceleration.getZ();
        double q0DotDot = -0.5 * MathArrays.linearCombination((double[])new double[]{q1, q2, q3, q1Dot, q2Dot, q3Dot}, (double[])new double[]{oXDot, oYDot, oZDot, oX, oY, oZ});
        double q1DotDot = 0.5 * MathArrays.linearCombination((double[])new double[]{q0, q2, -q3, q0Dot, q2Dot, -q3Dot}, (double[])new double[]{oXDot, oZDot, oYDot, oX, oZ, oY});
        double q2DotDot = 0.5 * MathArrays.linearCombination((double[])new double[]{q0, q3, -q1, q0Dot, q3Dot, -q1Dot}, (double[])new double[]{oYDot, oXDot, oZDot, oY, oX, oZ});
        double q3DotDot = 0.5 * MathArrays.linearCombination((double[])new double[]{q0, q1, -q2, q0Dot, q1Dot, -q2Dot}, (double[])new double[]{oZDot, oYDot, oXDot, oZ, oY, oX});
        switch (order) {
            case 0: {
                DSFactory factory = new DSFactory(1, order);
                q0DS = factory.build(new double[]{q0});
                q1DS = factory.build(new double[]{q1});
                q2DS = factory.build(new double[]{q2});
                q3DS = factory.build(new double[]{q3});
                break;
            }
            case 1: {
                DSFactory factory = new DSFactory(1, order);
                q0DS = factory.build(new double[]{q0, q0Dot});
                q1DS = factory.build(new double[]{q1, q1Dot});
                q2DS = factory.build(new double[]{q2, q2Dot});
                q3DS = factory.build(new double[]{q3, q3Dot});
                break;
            }
            case 2: {
                DSFactory factory = new DSFactory(1, order);
                q0DS = factory.build(new double[]{q0, q0Dot, q0DotDot});
                q1DS = factory.build(new double[]{q1, q1Dot, q1DotDot});
                q2DS = factory.build(new double[]{q2, q2Dot, q2DotDot});
                q3DS = factory.build(new double[]{q3, q3Dot, q3DotDot});
                break;
            }
            default: {
                throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_DERIVATION_ORDER, order);
            }
        }
        return new FieldRotation((RealFieldElement)q0DS, (RealFieldElement)q1DS, (RealFieldElement)q2DS, (RealFieldElement)q3DS, false);
    }

    public static Vector3D estimateRate(Rotation start, Rotation end, double dt) {
        Rotation evolution = start.compose(end.revert(), RotationConvention.VECTOR_OPERATOR);
        return new Vector3D(evolution.getAngle() / dt, evolution.getAxis(RotationConvention.VECTOR_OPERATOR));
    }

    public AngularCoordinates revert() {
        return new AngularCoordinates(this.rotation.revert(), this.rotation.applyInverseTo(this.rotationRate).negate(), this.rotation.applyInverseTo(this.rotationAcceleration).negate());
    }

    @Override
    public AngularCoordinates shiftedBy(double dt) {
        double rate = this.rotationRate.getNorm();
        Rotation rateContribution = rate == 0.0 ? Rotation.IDENTITY : new Rotation(this.rotationRate, rate * dt, RotationConvention.FRAME_TRANSFORM);
        AngularCoordinates linearPart = new AngularCoordinates(rateContribution.compose(this.rotation, RotationConvention.VECTOR_OPERATOR), this.rotationRate);
        double acc = this.rotationAcceleration.getNorm();
        if (acc == 0.0) {
            return linearPart;
        }
        AngularCoordinates quadraticContribution = new AngularCoordinates(new Rotation(this.rotationAcceleration, 0.5 * acc * dt * dt, RotationConvention.FRAME_TRANSFORM), new Vector3D(dt, this.rotationAcceleration), this.rotationAcceleration);
        return quadraticContribution.addOffset(linearPart);
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Vector3D getRotationRate() {
        return this.rotationRate;
    }

    public Vector3D getRotationAcceleration() {
        return this.rotationAcceleration;
    }

    public AngularCoordinates addOffset(AngularCoordinates offset) {
        Vector3D rOmega = this.rotation.applyTo(offset.rotationRate);
        Vector3D rOmegaDot = this.rotation.applyTo(offset.rotationAcceleration);
        return new AngularCoordinates(this.rotation.compose(offset.rotation, RotationConvention.VECTOR_OPERATOR), this.rotationRate.add((Vector)rOmega), new Vector3D(1.0, this.rotationAcceleration, 1.0, rOmegaDot, -1.0, Vector3D.crossProduct((Vector3D)this.rotationRate, (Vector3D)rOmega)));
    }

    public AngularCoordinates subtractOffset(AngularCoordinates offset) {
        return this.addOffset(offset.revert());
    }

    public PVCoordinates applyTo(PVCoordinates pv) {
        Vector3D transformedP = this.rotation.applyTo(pv.getPosition());
        Vector3D crossP = Vector3D.crossProduct((Vector3D)this.rotationRate, (Vector3D)transformedP);
        Vector3D transformedV = this.rotation.applyTo(pv.getVelocity()).subtract((Vector)crossP);
        Vector3D crossV = Vector3D.crossProduct((Vector3D)this.rotationRate, (Vector3D)transformedV);
        Vector3D crossCrossP = Vector3D.crossProduct((Vector3D)this.rotationRate, (Vector3D)crossP);
        Vector3D crossDotP = Vector3D.crossProduct((Vector3D)this.rotationAcceleration, (Vector3D)transformedP);
        Vector3D transformedA = new Vector3D(1.0, this.rotation.applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new PVCoordinates(transformedP, transformedV, transformedA);
    }

    public TimeStampedPVCoordinates applyTo(TimeStampedPVCoordinates pv) {
        Vector3D transformedP = this.getRotation().applyTo(pv.getPosition());
        Vector3D crossP = Vector3D.crossProduct((Vector3D)this.getRotationRate(), (Vector3D)transformedP);
        Vector3D transformedV = this.getRotation().applyTo(pv.getVelocity()).subtract((Vector)crossP);
        Vector3D crossV = Vector3D.crossProduct((Vector3D)this.getRotationRate(), (Vector3D)transformedV);
        Vector3D crossCrossP = Vector3D.crossProduct((Vector3D)this.getRotationRate(), (Vector3D)crossP);
        Vector3D crossDotP = Vector3D.crossProduct((Vector3D)this.getRotationAcceleration(), (Vector3D)transformedP);
        Vector3D transformedA = new Vector3D(1.0, this.getRotation().applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new TimeStampedPVCoordinates(pv.getDate(), transformedP, transformedV, transformedA);
    }

    public <T extends RealFieldElement<T>> FieldPVCoordinates<T> applyTo(FieldPVCoordinates<T> pv) {
        FieldVector3D transformedP = FieldRotation.applyTo((Rotation)this.rotation, pv.getPosition());
        FieldVector3D crossP = FieldVector3D.crossProduct((Vector3D)this.rotationRate, (FieldVector3D)transformedP);
        FieldVector3D transformedV = FieldRotation.applyTo((Rotation)this.rotation, pv.getVelocity()).subtract(crossP);
        FieldVector3D crossV = FieldVector3D.crossProduct((Vector3D)this.rotationRate, (FieldVector3D)transformedV);
        FieldVector3D crossCrossP = FieldVector3D.crossProduct((Vector3D)this.rotationRate, (FieldVector3D)crossP);
        FieldVector3D crossDotP = FieldVector3D.crossProduct((Vector3D)this.rotationAcceleration, (FieldVector3D)transformedP);
        FieldVector3D transformedA = new FieldVector3D(1.0, FieldRotation.applyTo((Rotation)this.rotation, pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new FieldPVCoordinates(transformedP, transformedV, transformedA);
    }

    public <T extends RealFieldElement<T>> TimeStampedFieldPVCoordinates<T> applyTo(TimeStampedFieldPVCoordinates<T> pv) {
        FieldVector3D transformedP = FieldRotation.applyTo((Rotation)this.rotation, pv.getPosition());
        FieldVector3D crossP = FieldVector3D.crossProduct((Vector3D)this.rotationRate, (FieldVector3D)transformedP);
        FieldVector3D transformedV = FieldRotation.applyTo((Rotation)this.rotation, pv.getVelocity()).subtract(crossP);
        FieldVector3D crossV = FieldVector3D.crossProduct((Vector3D)this.rotationRate, (FieldVector3D)transformedV);
        FieldVector3D crossCrossP = FieldVector3D.crossProduct((Vector3D)this.rotationRate, (FieldVector3D)crossP);
        FieldVector3D crossDotP = FieldVector3D.crossProduct((Vector3D)this.rotationAcceleration, (FieldVector3D)transformedP);
        FieldVector3D transformedA = new FieldVector3D(1.0, FieldRotation.applyTo((Rotation)this.rotation, pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new TimeStampedFieldPVCoordinates<T>(pv.getDate(), transformedP, transformedV, transformedA);
    }

    public double[][] getModifiedRodrigues(double sign) {
        double q0 = sign * this.getRotation().getQ0();
        double q1 = sign * this.getRotation().getQ1();
        double q2 = sign * this.getRotation().getQ2();
        double q3 = sign * this.getRotation().getQ3();
        double oX = this.getRotationRate().getX();
        double oY = this.getRotationRate().getY();
        double oZ = this.getRotationRate().getZ();
        double oXDot = this.getRotationAcceleration().getX();
        double oYDot = this.getRotationAcceleration().getY();
        double oZDot = this.getRotationAcceleration().getZ();
        double q0Dot = 0.5 * MathArrays.linearCombination((double)(-q1), (double)oX, (double)(-q2), (double)oY, (double)(-q3), (double)oZ);
        double q1Dot = 0.5 * MathArrays.linearCombination((double)q0, (double)oX, (double)(-q3), (double)oY, (double)q2, (double)oZ);
        double q2Dot = 0.5 * MathArrays.linearCombination((double)q3, (double)oX, (double)q0, (double)oY, (double)(-q1), (double)oZ);
        double q3Dot = 0.5 * MathArrays.linearCombination((double)(-q2), (double)oX, (double)q1, (double)oY, (double)q0, (double)oZ);
        double q0DotDot = -0.5 * MathArrays.linearCombination((double[])new double[]{q1, q2, q3, q1Dot, q2Dot, q3Dot}, (double[])new double[]{oXDot, oYDot, oZDot, oX, oY, oZ});
        double q1DotDot = 0.5 * MathArrays.linearCombination((double[])new double[]{q0, q2, -q3, q0Dot, q2Dot, -q3Dot}, (double[])new double[]{oXDot, oZDot, oYDot, oX, oZ, oY});
        double q2DotDot = 0.5 * MathArrays.linearCombination((double[])new double[]{q0, q3, -q1, q0Dot, q3Dot, -q1Dot}, (double[])new double[]{oYDot, oXDot, oZDot, oY, oX, oZ});
        double q3DotDot = 0.5 * MathArrays.linearCombination((double[])new double[]{q0, q1, -q2, q0Dot, q1Dot, -q2Dot}, (double[])new double[]{oZDot, oYDot, oXDot, oZ, oY, oX});
        double inv = 1.0 / (1.0 + q0);
        double mTwoInvQ0Dot = -2.0 * inv * q0Dot;
        double r1 = inv * q1;
        double r2 = inv * q2;
        double r3 = inv * q3;
        double mInvR1 = -inv * r1;
        double mInvR2 = -inv * r2;
        double mInvR3 = -inv * r3;
        double r1Dot = MathArrays.linearCombination((double)inv, (double)q1Dot, (double)mInvR1, (double)q0Dot);
        double r2Dot = MathArrays.linearCombination((double)inv, (double)q2Dot, (double)mInvR2, (double)q0Dot);
        double r3Dot = MathArrays.linearCombination((double)inv, (double)q3Dot, (double)mInvR3, (double)q0Dot);
        double r1DotDot = MathArrays.linearCombination((double)inv, (double)q1DotDot, (double)mTwoInvQ0Dot, (double)r1Dot, (double)mInvR1, (double)q0DotDot);
        double r2DotDot = MathArrays.linearCombination((double)inv, (double)q2DotDot, (double)mTwoInvQ0Dot, (double)r2Dot, (double)mInvR2, (double)q0DotDot);
        double r3DotDot = MathArrays.linearCombination((double)inv, (double)q3DotDot, (double)mTwoInvQ0Dot, (double)r3Dot, (double)mInvR3, (double)q0DotDot);
        return new double[][]{{r1, r2, r3}, {r1Dot, r2Dot, r3Dot}, {r1DotDot, r2DotDot, r3DotDot}};
    }

    public static AngularCoordinates createFromModifiedRodrigues(double[][] r) {
        double rSquared = r[0][0] * r[0][0] + r[0][1] * r[0][1] + r[0][2] * r[0][2];
        double oPQ0 = 2.0 / (1.0 + rSquared);
        double q0 = oPQ0 - 1.0;
        double q1 = oPQ0 * r[0][0];
        double q2 = oPQ0 * r[0][1];
        double q3 = oPQ0 * r[0][2];
        double oPQ02 = oPQ0 * oPQ0;
        double q0Dot = -oPQ02 * MathArrays.linearCombination((double)r[0][0], (double)r[1][0], (double)r[0][1], (double)r[1][1], (double)r[0][2], (double)r[1][2]);
        double q1Dot = oPQ0 * r[1][0] + r[0][0] * q0Dot;
        double q2Dot = oPQ0 * r[1][1] + r[0][1] * q0Dot;
        double q3Dot = oPQ0 * r[1][2] + r[0][2] * q0Dot;
        double oX = 2.0 * MathArrays.linearCombination((double)(-q1), (double)q0Dot, (double)q0, (double)q1Dot, (double)q3, (double)q2Dot, (double)(-q2), (double)q3Dot);
        double oY = 2.0 * MathArrays.linearCombination((double)(-q2), (double)q0Dot, (double)(-q3), (double)q1Dot, (double)q0, (double)q2Dot, (double)q1, (double)q3Dot);
        double oZ = 2.0 * MathArrays.linearCombination((double)(-q3), (double)q0Dot, (double)q2, (double)q1Dot, (double)(-q1), (double)q2Dot, (double)q0, (double)q3Dot);
        double q0DotDot = (1.0 - q0) / oPQ0 * q0Dot * q0Dot - oPQ02 * MathArrays.linearCombination((double)r[0][0], (double)r[2][0], (double)r[0][1], (double)r[2][1], (double)r[0][2], (double)r[2][2]) - (q1Dot * q1Dot + q2Dot * q2Dot + q3Dot * q3Dot);
        double q1DotDot = MathArrays.linearCombination((double)oPQ0, (double)r[2][0], (double)(2.0 * r[1][0]), (double)q0Dot, (double)r[0][0], (double)q0DotDot);
        double q2DotDot = MathArrays.linearCombination((double)oPQ0, (double)r[2][1], (double)(2.0 * r[1][1]), (double)q0Dot, (double)r[0][1], (double)q0DotDot);
        double q3DotDot = MathArrays.linearCombination((double)oPQ0, (double)r[2][2], (double)(2.0 * r[1][2]), (double)q0Dot, (double)r[0][2], (double)q0DotDot);
        double oXDot = 2.0 * MathArrays.linearCombination((double)(-q1), (double)q0DotDot, (double)q0, (double)q1DotDot, (double)q3, (double)q2DotDot, (double)(-q2), (double)q3DotDot);
        double oYDot = 2.0 * MathArrays.linearCombination((double)(-q2), (double)q0DotDot, (double)(-q3), (double)q1DotDot, (double)q0, (double)q2DotDot, (double)q1, (double)q3DotDot);
        double oZDot = 2.0 * MathArrays.linearCombination((double)(-q3), (double)q0DotDot, (double)q2, (double)q1DotDot, (double)(-q1), (double)q2DotDot, (double)q0, (double)q3DotDot);
        return new AngularCoordinates(new Rotation(q0, q1, q2, q3, false), new Vector3D(oX, oY, oZ), new Vector3D(oXDot, oYDot, oZDot));
    }
}

