/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.CircularOrbit;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;

public class PositionAngleDetector
extends AbstractDetector<PositionAngleDetector> {
    private static final long serialVersionUID = 20150825L;
    private final OrbitType orbitType;
    private final PositionAngle positionAngle;
    private final double angle;
    private double sign;
    private double previousDelta;

    public PositionAngleDetector(OrbitType orbitType, PositionAngle positionAngle, double angle) throws OrekitIllegalArgumentException {
        this(600.0, 1.0E-6, orbitType, positionAngle, angle);
    }

    public PositionAngleDetector(double maxCheck, double threshold, OrbitType orbitType, PositionAngle positionAngle, double angle) throws OrekitIllegalArgumentException {
        this(maxCheck, threshold, 100, new StopOnIncreasing(), orbitType, positionAngle, angle);
    }

    private PositionAngleDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super PositionAngleDetector> handler, OrbitType orbitType, PositionAngle positionAngle, double angle) throws OrekitIllegalArgumentException {
        super(maxCheck, threshold, maxIter, handler);
        if (orbitType == OrbitType.CARTESIAN) {
            String sep = ", ";
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_TYPE_NOT_ALLOWED, new Object[]{orbitType, (Object)((Object)OrbitType.KEPLERIAN) + ", " + (Object)((Object)OrbitType.CIRCULAR) + ", " + (Object)((Object)OrbitType.EQUINOCTIAL)});
        }
        this.orbitType = orbitType;
        this.positionAngle = positionAngle;
        this.angle = angle;
        this.sign = 1.0;
        this.previousDelta = Double.NaN;
    }

    @Override
    protected PositionAngleDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super PositionAngleDetector> newHandler) {
        return new PositionAngleDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.orbitType, this.positionAngle, this.angle);
    }

    public OrbitType getOrbitType() {
        return this.orbitType;
    }

    public PositionAngle getPositionAngle() {
        return this.positionAngle;
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public double g(SpacecraftState s) throws OrekitException {
        double currentAngle;
        switch (this.orbitType) {
            case KEPLERIAN: {
                currentAngle = ((KeplerianOrbit)this.orbitType.convertType(s.getOrbit())).getAnomaly(this.positionAngle);
                break;
            }
            case CIRCULAR: {
                currentAngle = ((CircularOrbit)this.orbitType.convertType(s.getOrbit())).getAlpha(this.positionAngle);
                break;
            }
            case EQUINOCTIAL: {
                currentAngle = ((EquinoctialOrbit)this.orbitType.convertType(s.getOrbit())).getL(this.positionAngle);
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
        double delta = MathUtils.normalizeAngle((double)(this.sign * (currentAngle - this.angle)), (double)0.0);
        if (FastMath.abs((double)(delta - this.previousDelta)) > Math.PI) {
            this.sign = -this.sign;
            delta = MathUtils.normalizeAngle((double)(this.sign * (currentAngle - this.angle)), (double)0.0);
        }
        this.previousDelta = delta;
        return delta;
    }
}

