/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.hipparchus.ode.AbstractIntegrator;
import org.hipparchus.ode.nonstiff.DormandPrince853Integrator;
import org.orekit.errors.OrekitException;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.conversion.ODEIntegratorBuilder;
import org.orekit.propagation.numerical.NumericalPropagator;

public class DormandPrince853IntegratorBuilder
implements ODEIntegratorBuilder {
    private final double minStep;
    private final double maxStep;
    private final double dP;

    public DormandPrince853IntegratorBuilder(double minStep, double maxStep, double dP) {
        this.minStep = minStep;
        this.maxStep = maxStep;
        this.dP = dP;
    }

    @Override
    public AbstractIntegrator buildIntegrator(Orbit orbit, OrbitType orbitType) throws OrekitException {
        double[][] tol = NumericalPropagator.tolerances(this.dP, orbit, orbitType);
        return new DormandPrince853Integrator(this.minStep, this.maxStep, tol[0], tol[1]);
    }
}

