/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.analytical.gnss.GPSOrbitalElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.PVCoordinates;

public class GPSPropagator
extends AbstractAnalyticalPropagator {
    private static final double GPS_AV = 7.2921151467E-5;
    private static final double GPS_CYCLE_DURATION = 6.193152E8;
    private static final double A;
    private static final double B;
    private final GPSOrbitalElements gpsOrbit;
    private final double mass;
    private final Frame eci;
    private final Frame ecef;
    private final DSFactory factory;

    private GPSPropagator(Builder builder) {
        super(builder.attitudeProvider);
        this.gpsOrbit = builder.orbit;
        this.setStartDate(this.gpsOrbit.getDate());
        this.mass = builder.mass;
        this.eci = builder.eci;
        this.ecef = builder.ecef;
        this.factory = new DSFactory(1, 2);
    }

    public PVCoordinates propagateInEcef(AbsoluteDate date) {
        DerivativeStructure tk = this.factory.variable(0, this.getTk(date));
        DerivativeStructure mk = tk.multiply(this.gpsOrbit.getMeanMotion()).add(this.gpsOrbit.getM0());
        DerivativeStructure ek = this.getEccentricAnomaly(mk);
        DerivativeStructure vk = this.getTrueAnomaly(ek);
        DerivativeStructure phik = vk.add(this.gpsOrbit.getPa());
        DerivativeStructure twoPhik = phik.multiply(2);
        DerivativeStructure c2phi = twoPhik.cos();
        DerivativeStructure s2phi = twoPhik.sin();
        DerivativeStructure dphik = c2phi.multiply(this.gpsOrbit.getCuc()).add(s2phi.multiply(this.gpsOrbit.getCus()));
        DerivativeStructure drk = c2phi.multiply(this.gpsOrbit.getCrc()).add(s2phi.multiply(this.gpsOrbit.getCrs()));
        DerivativeStructure dik = c2phi.multiply(this.gpsOrbit.getCic()).add(s2phi.multiply(this.gpsOrbit.getCis()));
        DerivativeStructure uk = phik.add(dphik);
        DerivativeStructure rk = ek.cos().multiply(-this.gpsOrbit.getE()).add(1.0).multiply(this.gpsOrbit.getSma()).add(drk);
        DerivativeStructure ik = tk.multiply(this.gpsOrbit.getIDot()).add(this.gpsOrbit.getI0()).add(dik);
        DerivativeStructure cik = ik.cos();
        DerivativeStructure xk = uk.cos().multiply(rk);
        DerivativeStructure yk = uk.sin().multiply(rk);
        DerivativeStructure omk = tk.multiply(this.gpsOrbit.getOmegaDot() - 7.2921151467E-5).add(this.gpsOrbit.getOmega0() - 7.2921151467E-5 * this.gpsOrbit.getTime());
        DerivativeStructure comk = omk.cos();
        DerivativeStructure somk = omk.sin();
        FieldVector3D positionwithDerivatives = new FieldVector3D((RealFieldElement)xk.multiply(comk).subtract(yk.multiply(somk).multiply(cik)), (RealFieldElement)xk.multiply(somk).add(yk.multiply(comk).multiply(cik)), (RealFieldElement)yk.multiply(ik.sin()));
        return new PVCoordinates((FieldVector3D<DerivativeStructure>)positionwithDerivatives);
    }

    private double getTk(AbsoluteDate date) {
        double tk;
        for (tk = date.durationFrom(this.gpsOrbit.getDate()); tk > 3.096576E8; tk -= 6.193152E8) {
        }
        while (tk < -3.096576E8) {
            tk += 6.193152E8;
        }
        return tk;
    }

    private DerivativeStructure getEccentricAnomaly(DerivativeStructure mk) {
        DerivativeStructure ek;
        double[] mlDerivatives = mk.getAllDerivatives();
        mlDerivatives[0] = MathUtils.normalizeAngle((double)mlDerivatives[0], (double)0.0);
        DerivativeStructure reducedM = mk.getFactory().build(mlDerivatives);
        if (FastMath.abs((double)reducedM.getValue()) < 0.16666666666666666) {
            ek = FastMath.abs((double)reducedM.getValue()) < Precision.SAFE_MIN ? reducedM : reducedM.add(reducedM.multiply(6).cbrt().subtract(reducedM).multiply(this.gpsOrbit.getE()));
        } else if (reducedM.getValue() < 0.0) {
            DerivativeStructure w = reducedM.add(Math.PI);
            ek = reducedM.add(w.multiply(-A).divide(w.subtract(B)).subtract(Math.PI).subtract(reducedM).multiply(this.gpsOrbit.getE()));
        } else {
            DerivativeStructure minusW = reducedM.subtract(Math.PI);
            ek = reducedM.add(minusW.multiply(A).divide(minusW.add(B)).add(Math.PI).subtract(reducedM).multiply(this.gpsOrbit.getE()));
        }
        double e1 = 1.0 - this.gpsOrbit.getE();
        boolean noCancellationRisk = e1 + ek.getValue() * ek.getValue() / 6.0 >= 0.1;
        for (int j = 0; j < 2; ++j) {
            DerivativeStructure fd;
            DerivativeStructure f;
            DerivativeStructure fdd = ek.sin().multiply(this.gpsOrbit.getE());
            DerivativeStructure fddd = ek.cos().multiply(this.gpsOrbit.getE());
            if (noCancellationRisk) {
                f = ek.subtract(fdd).subtract(reducedM);
                fd = fddd.subtract(1.0).negate();
            } else {
                f = this.eMeSinE(ek).subtract(reducedM);
                DerivativeStructure s = ek.multiply(0.5).sin();
                fd = s.multiply(s).multiply(2.0 * this.gpsOrbit.getE()).add(e1);
            }
            DerivativeStructure dee = f.multiply(fd).divide(f.multiply(0.5).multiply(fdd).subtract(fd.multiply(fd)));
            DerivativeStructure w = fd.add(dee.multiply(0.5).multiply(fdd.add(dee.multiply(fdd).divide(3.0))));
            fd = fd.add(dee.multiply(fdd.add(dee.multiply(0.5).multiply(fdd))));
            ek = ek.subtract(f.subtract(dee.multiply(fd.subtract(w))).divide(fd));
        }
        ek = ek.add(mk.getValue() - reducedM.getValue());
        return ek;
    }

    private DerivativeStructure eMeSinE(DerivativeStructure E) {
        DerivativeStructure x = E.sin().multiply(1.0 - this.gpsOrbit.getE());
        DerivativeStructure mE2 = E.negate().multiply(E);
        DerivativeStructure term = E;
        DerivativeStructure d = (DerivativeStructure)E.getField().getZero();
        DerivativeStructure x0 = d.add(Double.NaN);
        while (x.getValue() != x0.getValue()) {
            d = d.add(2.0);
            term = term.multiply(mE2.divide(d.multiply(d.add(1.0))));
            x0 = x;
            x = x.subtract(term);
        }
        return x;
    }

    private DerivativeStructure getTrueAnomaly(DerivativeStructure ek) {
        DerivativeStructure svk = ek.sin().multiply(FastMath.sqrt((double)(1.0 - this.gpsOrbit.getE() * this.gpsOrbit.getE())));
        DerivativeStructure cvk = ek.cos().subtract(this.gpsOrbit.getE());
        return svk.atan2(cvk);
    }

    public static double getMU() {
        return 3.986005E14;
    }

    public GPSOrbitalElements getGPSOrbitalElements() {
        return this.gpsOrbit;
    }

    public Frame getECI() {
        return this.eci;
    }

    public Frame getECEF() {
        return this.ecef;
    }

    @Override
    public Frame getFrame() {
        return this.eci;
    }

    @Override
    public void resetInitialState(SpacecraftState state) throws OrekitException {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) throws OrekitException {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.mass;
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) throws OrekitException {
        PVCoordinates pvaInECEF = this.propagateInEcef(date);
        PVCoordinates pvaInECI = this.ecef.getTransformTo(this.eci, date).transformPVCoordinates(pvaInECEF);
        return new CartesianOrbit(pvaInECI, this.eci, date, 3.986005E14);
    }

    static {
        double k1 = 11.42477796076938;
        double k2 = 2.141592653589793;
        double k3 = 17.84955592153876;
        A = 1.2043347651023166;
        B = 4.64788969626918;
    }

    public static class Builder {
        private final GPSOrbitalElements orbit;
        private AttitudeProvider attitudeProvider = Propagator.DEFAULT_LAW;
        private double mass = 1000.0;
        private Frame eci = null;
        private Frame ecef = null;

        public Builder(GPSOrbitalElements gpsOrbElt) throws OrekitException {
            this.orbit = gpsOrbElt;
            this.eci = FramesFactory.getEME2000();
            this.ecef = FramesFactory.getITRF(IERSConventions.IERS_2010, true);
        }

        public Builder attitudeProvider(AttitudeProvider userProvider) {
            this.attitudeProvider = userProvider;
            return this;
        }

        public Builder mass(double userMass) {
            this.mass = userMass;
            return this;
        }

        public Builder eci(Frame inertial) {
            this.eci = inertial;
            return this;
        }

        public Builder ecef(Frame bodyFixed) {
            this.ecef = bodyFixed;
            return this;
        }

        public GPSPropagator build() {
            return new GPSPropagator(this);
        }
    }
}

