/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldOrbit;
import org.orekit.propagation.FieldAbstractPropagator;
import org.orekit.propagation.FieldAdditionalStateProvider;
import org.orekit.propagation.FieldBoundedPropagator;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.FieldEventState;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.sampling.FieldOrekitStepInterpolator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public abstract class FieldAbstractAnalyticalPropagator<T extends RealFieldElement<T>>
extends FieldAbstractPropagator<T> {
    private FieldPVCoordinatesProvider<T> pvProvider;
    private FieldAbsoluteDate<T> lastPropagationStart;
    private FieldAbsoluteDate<T> lastPropagationEnd;
    private boolean statesInitialized;
    private boolean isLastStep;
    private final Collection<FieldEventState<?, T>> eventsStates;

    protected FieldAbstractAnalyticalPropagator(Field<T> field, AttitudeProvider attitudeProvider) {
        super(field);
        this.setAttitudeProvider(attitudeProvider);
        this.pvProvider = new FieldLocalPVProvider();
        this.lastPropagationStart = FieldAbsoluteDate.getPastInfinity(field);
        this.lastPropagationEnd = FieldAbsoluteDate.getFutureInfinity(field);
        this.statesInitialized = false;
        this.eventsStates = new ArrayList();
    }

    @Override
    public FieldBoundedPropagator<T> getGeneratedEphemeris() {
        return new FieldBoundedPropagatorView(this.lastPropagationStart, this.lastPropagationEnd);
    }

    @Override
    public Collection<FieldEventDetector<T>> getEventsDetectors() {
        ArrayList list = new ArrayList();
        for (FieldEventState<?, T> state : this.eventsStates) {
            list.add(state.getEventDetector());
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public void clearEventsDetectors() {
        this.eventsStates.clear();
    }

    @Override
    public FieldSpacecraftState<T> propagate(FieldAbsoluteDate<T> start, FieldAbsoluteDate<T> target) throws OrekitException {
        try {
            this.lastPropagationStart = start;
            T dt = target.durationFrom(start);
            double epsilon = FastMath.ulp((double)dt.getReal());
            FieldSpacecraftState<T> state = this.updateAdditionalStates(this.basicPropagate(start));
            Object stepSize = this.getMode() == 1 ? (Double.isNaN(this.getFixedStepSize().getReal()) ? (RealFieldElement)((RealFieldElement)state.getKeplerianPeriod().divide(100.0)).copySign(dt) : (RealFieldElement)this.getFixedStepSize().copySign(dt)) : dt;
            for (FieldEventState<?, T> es : this.eventsStates) {
                es.init(state, target);
            }
            if (this.getStepHandler() != null) {
                this.getStepHandler().init(state, target);
            }
            this.statesInitialized = false;
            this.isLastStep = false;
            do {
                FieldSpacecraftState<T> previous = state;
                FieldAbsoluteDate<T> t = previous.getDate().shiftedBy(stepSize);
                if (dt.getReal() == 0.0 || dt.getReal() > 0.0 ^ t.compareTo(target) <= 0) {
                    t = target;
                }
                FieldSpacecraftState<T> current = this.updateAdditionalStates(this.basicPropagate(t));
                FieldBasicStepInterpolator interpolator = new FieldBasicStepInterpolator(dt.getReal() >= 0.0, previous, current);
                state = this.acceptStep(interpolator, target, epsilon);
            } while (!this.isLastStep);
            this.lastPropagationEnd = state.getDate();
            this.setStartDate(state.getDate());
            return state;
        }
        catch (OrekitException pe) {
            throw pe;
        }
        catch (MathRuntimeException mrte) {
            throw OrekitException.unwrap(mrte);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected FieldSpacecraftState<T> acceptStep(FieldBasicStepInterpolator interpolator, FieldAbsoluteDate<T> target, double epsilon) throws OrekitException, MathRuntimeException {
        FieldSpacecraftState previous = interpolator.getPreviousState();
        FieldSpacecraftState current = interpolator.getCurrentState();
        if (!this.statesInitialized) {
            if (!this.eventsStates.isEmpty()) {
                for (FieldEventState<?, T> state : this.eventsStates) {
                    state.reinitializeBegin(interpolator);
                }
            }
            this.statesInitialized = true;
        }
        final int orderingSign = interpolator.isForward() ? 1 : -1;
        PriorityQueue<Object> occurringEvents = new PriorityQueue<Object>(new Comparator<FieldEventState<?, T>>(){

            @Override
            public int compare(FieldEventState<?, T> es0, FieldEventState<?, T> es1) {
                return orderingSign * es0.getEventDate().compareTo(es1.getEventDate());
            }
        });
        for (FieldEventState<?, T> state : this.eventsStates) {
            if (!state.evaluateStep(interpolator)) continue;
            occurringEvents.add(state);
        }
        FieldBasicStepInterpolator restricted = interpolator;
        block2: while (true) {
            if (!occurringEvents.isEmpty()) {
                FieldSpacecraftState resetState;
                void var11_14;
                FieldEventState currentEvent = (FieldEventState)occurringEvents.poll();
                FieldSpacecraftState fieldSpacecraftState = restricted.getInterpolatedState(currentEvent.getEventDate());
                for (FieldEventState state : this.eventsStates) {
                    if (state == currentEvent || !state.tryAdvance(fieldSpacecraftState, interpolator)) continue;
                    occurringEvents.add(currentEvent);
                    occurringEvents.remove(state);
                    occurringEvents.add(state);
                    continue block2;
                }
                FieldEventState.EventOccurrence occurrence = currentEvent.doEvent(fieldSpacecraftState);
                FieldEventHandler.Action action = occurrence.getAction();
                boolean bl = this.isLastStep = action == FieldEventHandler.Action.STOP;
                if (this.isLastStep) {
                    FieldSpacecraftState fieldSpacecraftState2 = interpolator.getInterpolatedState(occurrence.getStopDate());
                    restricted = new FieldBasicStepInterpolator(restricted.isForward(), previous, fieldSpacecraftState2);
                }
                if (this.getStepHandler() != null) {
                    this.getStepHandler().handleStep(restricted, this.isLastStep);
                }
                if (this.isLastStep) {
                    return var11_14;
                }
                if ((action == FieldEventHandler.Action.RESET_DERIVATIVES || action == FieldEventHandler.Action.RESET_STATE) && (resetState = occurrence.getNewState()) != null) {
                    this.resetIntermediateState(resetState, interpolator.isForward());
                    return resetState;
                }
                previous = var11_14;
                if (!currentEvent.evaluateStep(restricted = new FieldBasicStepInterpolator(restricted.isForward(), var11_14, current))) continue;
                occurringEvents.add(currentEvent);
                continue;
            }
            for (FieldEventState fieldEventState : this.eventsStates) {
                if (!fieldEventState.tryAdvance(current, interpolator)) continue;
                occurringEvents.add(fieldEventState);
            }
            if (occurringEvents.isEmpty()) break;
        }
        Object remaining = target.durationFrom(current.getDate());
        if (interpolator.isForward()) {
            this.isLastStep = remaining.getReal() < epsilon;
        } else {
            boolean bl = this.isLastStep = remaining.getReal() > -epsilon;
        }
        if (this.getStepHandler() != null) {
            this.getStepHandler().handleStep(interpolator, this.isLastStep);
        }
        return current;
    }

    protected abstract T getMass(FieldAbsoluteDate<T> var1) throws OrekitException;

    public FieldPVCoordinatesProvider<T> getPvProvider() {
        return this.pvProvider;
    }

    @Override
    public <D extends FieldEventDetector<T>> void addEventDetector(D detector) {
        this.eventsStates.add(new FieldEventState(detector));
    }

    protected abstract void resetIntermediateState(FieldSpacecraftState<T> var1, boolean var2) throws OrekitException;

    protected abstract FieldOrbit<T> propagateOrbit(FieldAbsoluteDate<T> var1) throws OrekitException;

    protected FieldSpacecraftState<T> basicPropagate(FieldAbsoluteDate<T> date) throws OrekitException {
        try {
            FieldOrbit<T> orbit = this.propagateOrbit(date);
            FieldAttitude<T> attitude = this.getAttitudeProvider().getAttitude(this.pvProvider, date, orbit.getFrame());
            return new FieldSpacecraftState<T>(orbit, attitude, this.getMass(date));
        }
        catch (OrekitException oe) {
            throw new OrekitException(oe);
        }
    }

    private class FieldBasicStepInterpolator
    implements FieldOrekitStepInterpolator<T> {
        private final FieldSpacecraftState<T> previousState;
        private final FieldSpacecraftState<T> currentState;
        private final boolean forward;

        FieldBasicStepInterpolator(boolean isForward, FieldSpacecraftState<T> previousState, FieldSpacecraftState<T> currentState) {
            this.forward = isForward;
            this.previousState = previousState;
            this.currentState = currentState;
        }

        @Override
        public FieldSpacecraftState<T> getPreviousState() {
            return this.previousState;
        }

        @Override
        public FieldSpacecraftState<T> getCurrentState() {
            return this.currentState;
        }

        @Override
        public FieldSpacecraftState<T> getInterpolatedState(FieldAbsoluteDate<T> date) throws OrekitException {
            FieldSpacecraftState basicState = FieldAbstractAnalyticalPropagator.this.basicPropagate(date);
            return FieldAbstractAnalyticalPropagator.this.updateAdditionalStates(basicState);
        }

        @Override
        public boolean isForward() {
            return this.forward;
        }
    }

    private class FieldBoundedPropagatorView
    extends FieldAbstractAnalyticalPropagator<T>
    implements FieldBoundedPropagator<T> {
        private final FieldAbsoluteDate<T> minDate;
        private final FieldAbsoluteDate<T> maxDate;

        FieldBoundedPropagatorView(FieldAbsoluteDate<T> startDate, FieldAbsoluteDate<T> endDate) {
            super(startDate.durationFrom(endDate).getField(), FieldAbstractAnalyticalPropagator.this.getAttitudeProvider());
            if (startDate.compareTo(endDate) <= 0) {
                this.minDate = startDate;
                this.maxDate = endDate;
            } else {
                this.minDate = endDate;
                this.maxDate = startDate;
            }
            try {
                for (FieldAdditionalStateProvider provider : FieldAbstractAnalyticalPropagator.this.getAdditionalStateProviders()) {
                    this.addAdditionalStateProvider(provider);
                }
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(null);
            }
        }

        @Override
        public FieldAbsoluteDate<T> getMinDate() {
            return this.minDate;
        }

        @Override
        public FieldAbsoluteDate<T> getMaxDate() {
            return this.maxDate;
        }

        @Override
        protected FieldOrbit<T> propagateOrbit(FieldAbsoluteDate<T> target) throws OrekitException {
            return FieldAbstractAnalyticalPropagator.this.propagateOrbit(target);
        }

        @Override
        public T getMass(FieldAbsoluteDate<T> date) throws OrekitException {
            return FieldAbstractAnalyticalPropagator.this.getMass(date);
        }

        @Override
        public TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> date, Frame frame) throws OrekitException {
            return this.propagate(date).getPVCoordinates(frame);
        }

        @Override
        public void resetInitialState(FieldSpacecraftState<T> state) throws OrekitException {
            FieldAbstractAnalyticalPropagator.this.resetInitialState(state);
        }

        @Override
        protected void resetIntermediateState(FieldSpacecraftState<T> state, boolean forward) throws OrekitException {
            FieldAbstractAnalyticalPropagator.this.resetIntermediateState(state, forward);
        }

        @Override
        public FieldSpacecraftState<T> getInitialState() throws OrekitException {
            return FieldAbstractAnalyticalPropagator.this.getInitialState();
        }

        @Override
        public Frame getFrame() {
            return FieldAbstractAnalyticalPropagator.this.getFrame();
        }
    }

    private class FieldLocalPVProvider
    implements FieldPVCoordinatesProvider<T> {
        private FieldLocalPVProvider() {
        }

        @Override
        public TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> date, Frame frame) throws OrekitException {
            return FieldAbstractAnalyticalPropagator.this.propagateOrbit(date).getPVCoordinates(frame);
        }
    }
}

