/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.attitudes.LofOffset;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeInterpolable;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.time.FieldTimeStamped;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldSpacecraftState<T extends RealFieldElement<T>>
implements FieldTimeStamped<T>,
FieldTimeShiftable<FieldSpacecraftState<T>, T>,
FieldTimeInterpolable<FieldSpacecraftState<T>, T> {
    private static final double DEFAULT_MASS = 1000.0;
    private static final double DATE_INCONSISTENCY_THRESHOLD = 1.0E-7;
    private final FieldOrbit<T> orbit;
    private final FieldAttitude<T> attitude;
    private final T mass;
    private final Map<String, T[]> additional;

    public FieldSpacecraftState(FieldOrbit<T> orbit) throws OrekitException {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), (RealFieldElement)((RealFieldElement)orbit.getA().getField().getZero()).add(1000.0), null);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, FieldAttitude<T> attitude) throws IllegalArgumentException {
        this(orbit, attitude, (RealFieldElement)((RealFieldElement)orbit.getA().getField().getZero()).add(1000.0), null);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, T mass) throws OrekitException {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), mass, null);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, FieldAttitude<T> attitude, T mass) throws IllegalArgumentException {
        this(orbit, attitude, mass, null);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, Map<String, T[]> additional) throws OrekitException {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), (RealFieldElement)((RealFieldElement)orbit.getA().getField().getZero()).add(1000.0), additional);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, FieldAttitude<T> attitude, Map<String, T[]> additional) throws IllegalArgumentException {
        this(orbit, attitude, (RealFieldElement)((RealFieldElement)orbit.getA().getField().getZero()).add(1000.0), additional);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, T mass, Map<String, T[]> additional) throws OrekitException {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), mass, additional);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, FieldAttitude<T> attitude, T mass, Map<String, T[]> additional) throws IllegalArgumentException {
        this.checkConsistency(orbit, attitude);
        this.orbit = orbit;
        this.attitude = attitude;
        this.mass = mass;
        if (additional == null) {
            this.additional = Collections.emptyMap();
        } else {
            this.additional = new HashMap<String, T[]>(additional.size());
            for (Map.Entry<String, T[]> entry : additional.entrySet()) {
                this.additional.put(entry.getKey(), (T[])((RealFieldElement[])entry.getValue()).clone());
            }
        }
    }

    public FieldSpacecraftState(Field<T> field, SpacecraftState state) {
        RealFieldElement[] stateDotF;
        double[] stateD = new double[6];
        double[] stateDotD = state.getOrbit().hasDerivatives() ? new double[6] : null;
        state.getOrbit().getType().mapOrbitToArray(state.getOrbit(), PositionAngle.TRUE, stateD, stateDotD);
        RealFieldElement[] stateF = (RealFieldElement[])MathArrays.buildArray(field, (int)6);
        for (int i = 0; i < stateD.length; ++i) {
            stateF[i] = (RealFieldElement)((RealFieldElement)field.getZero()).add(stateD[i]);
        }
        if (stateDotD == null) {
            stateDotF = null;
        } else {
            stateDotF = (RealFieldElement[])MathArrays.buildArray(field, (int)6);
            for (int i = 0; i < stateDotD.length; ++i) {
                stateDotF[i] = (RealFieldElement)((RealFieldElement)field.getZero()).add(stateDotD[i]);
            }
        }
        FieldAbsoluteDate<T> dateF = new FieldAbsoluteDate<T>(field, state.getDate());
        this.orbit = state.getOrbit().getType().mapArrayToOrbit(stateF, stateDotF, PositionAngle.TRUE, dateF, state.getMu(), state.getFrame());
        this.attitude = new FieldAttitude<T>(field, state.getAttitude());
        this.mass = (RealFieldElement)((RealFieldElement)field.getZero()).add(state.getMass());
        Map<String, double[]> additionalD = state.getAdditionalStates();
        if (additionalD.isEmpty()) {
            this.additional = Collections.emptyMap();
        } else {
            this.additional = new HashMap<String, T[]>(additionalD.size());
            for (Map.Entry<String, double[]> entry : additionalD.entrySet()) {
                RealFieldElement[] array = (RealFieldElement[])MathArrays.buildArray(field, (int)entry.getValue().length);
                for (int k = 0; k < array.length; ++k) {
                    array[k] = (RealFieldElement)((RealFieldElement)field.getZero()).add(entry.getValue()[k]);
                }
                this.additional.put(entry.getKey(), array);
            }
        }
    }

    @SafeVarargs
    public final FieldSpacecraftState<T> addAdditionalState(String name, T ... value) {
        HashMap<String, T[]> newMap = new HashMap<String, T[]>(this.additional.size() + 1);
        newMap.putAll(this.additional);
        newMap.put(name, (T[])value.clone());
        return new FieldSpacecraftState<T>(this.orbit, this.attitude, this.mass, newMap);
    }

    private void checkConsistency(FieldOrbit<T> orbitN, FieldAttitude<T> attitudeN) throws IllegalArgumentException {
        if (((RealFieldElement)orbitN.getDate().durationFrom(attitudeN.getDate()).abs()).getReal() > 1.0E-7) {
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_AND_ATTITUDE_DATES_MISMATCH, orbitN.getDate(), attitudeN.getDate());
        }
        if (orbitN.getFrame() != attitudeN.getReferenceFrame()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.FRAMES_MISMATCH, orbitN.getFrame().getName(), attitudeN.getReferenceFrame().getName());
        }
    }

    @Override
    public FieldSpacecraftState<T> shiftedBy(double dt) {
        return new FieldSpacecraftState<T>((FieldOrbit)this.orbit.shiftedBy(dt), this.attitude.shiftedBy(dt), this.mass, this.additional);
    }

    @Override
    public FieldSpacecraftState<T> shiftedBy(T dt) {
        return new FieldSpacecraftState<T>(this.orbit.shiftedBy((RealFieldElement)dt), this.attitude.shiftedBy((RealFieldElement)dt), this.mass, this.additional);
    }

    @Override
    public FieldSpacecraftState<T> interpolate(FieldAbsoluteDate<T> date, Stream<FieldSpacecraftState<T>> sample) throws OrekitException {
        HashMap<String, T[]> interpolatedAdditional;
        ArrayList orbits = new ArrayList();
        ArrayList attitudes = new ArrayList();
        FieldHermiteInterpolator massInterpolator = new FieldHermiteInterpolator();
        HashMap<String, FieldHermiteInterpolator> additionalInterpolators = new HashMap<String, FieldHermiteInterpolator>(this.additional.size());
        for (String name : this.additional.keySet()) {
            additionalInterpolators.put(name, new FieldHermiteInterpolator());
        }
        try {
            sample.forEach(state -> {
                try {
                    T deltaT = state.getDate().durationFrom(date);
                    orbits.add(state.getOrbit());
                    attitudes.add(state.getAttitude());
                    RealFieldElement[] mm = (RealFieldElement[])MathArrays.buildArray((Field)this.orbit.getA().getField(), (int)1);
                    mm[0] = state.getMass();
                    massInterpolator.addSamplePoint(deltaT, (FieldElement[][])new RealFieldElement[][]{mm});
                    for (Map.Entry entry : additionalInterpolators.entrySet()) {
                        ((FieldHermiteInterpolator)entry.getValue()).addSamplePoint(deltaT, (FieldElement[][])new RealFieldElement[][]{state.getAdditionalState((String)entry.getKey())});
                    }
                }
                catch (OrekitException oe) {
                    throw new OrekitExceptionWrapper(oe);
                }
            });
        }
        catch (OrekitExceptionWrapper oew) {
            throw oew.getException();
        }
        FieldOrbit interpolatedOrbit = (FieldOrbit)this.orbit.interpolate(date, orbits);
        FieldAttitude interpolatedAttitude = (FieldAttitude)this.attitude.interpolate(date, attitudes);
        RealFieldElement interpolatedMass = ((RealFieldElement[])massInterpolator.value((FieldElement)this.orbit.getA().getField().getZero()))[0];
        if (this.additional.isEmpty()) {
            interpolatedAdditional = null;
        } else {
            interpolatedAdditional = new HashMap<String, T[]>(this.additional.size());
            for (Map.Entry entry : additionalInterpolators.entrySet()) {
                interpolatedAdditional.put((String)entry.getKey(), (T[])((FieldHermiteInterpolator)entry.getValue()).value((FieldElement)this.orbit.getA().getField().getZero()));
            }
        }
        return new FieldSpacecraftState<RealFieldElement>(interpolatedOrbit, interpolatedAttitude, interpolatedMass, interpolatedAdditional);
    }

    public FieldOrbit<T> getOrbit() {
        return this.orbit;
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this.orbit.getDate();
    }

    public Frame getFrame() {
        return this.orbit.getFrame();
    }

    public boolean hasAdditionalState(String name) {
        return this.additional.containsKey(name);
    }

    public void ensureCompatibleAdditionalStates(FieldSpacecraftState<T> state) throws OrekitException, MathIllegalArgumentException {
        for (Map.Entry<String, T[]> entry : this.additional.entrySet()) {
            RealFieldElement[] other = (RealFieldElement[])state.additional.get(entry.getKey());
            if (other == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, entry.getKey());
            }
            if (other.length == ((RealFieldElement[])entry.getValue()).length) continue;
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{other.length, ((RealFieldElement[])entry.getValue()).length});
        }
        if (state.additional.size() > this.additional.size()) {
            for (String name : state.additional.keySet()) {
                if (this.additional.containsKey(name)) continue;
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, name);
            }
        }
    }

    public T[] getAdditionalState(String name) throws OrekitException {
        if (!this.additional.containsKey(name)) {
            throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, name);
        }
        return (RealFieldElement[])((RealFieldElement[])this.additional.get(name)).clone();
    }

    public Map<String, T[]> getAdditionalStates() {
        return Collections.unmodifiableMap(this.additional);
    }

    public FieldTransform<T> toTransform() {
        FieldAbsoluteDate<T> date = this.orbit.getDate();
        return new FieldTransform<T>(date, new FieldTransform<T>(date, this.orbit.getPVCoordinates().negate()), new FieldTransform<T>(date, this.attitude.getOrientation()));
    }

    public double getMu() {
        return this.orbit.getMu();
    }

    public T getKeplerianPeriod() {
        return this.orbit.getKeplerianPeriod();
    }

    public T getKeplerianMeanMotion() {
        return this.orbit.getKeplerianMeanMotion();
    }

    public T getA() {
        return this.orbit.getA();
    }

    public T getEquinoctialEx() {
        return this.orbit.getEquinoctialEx();
    }

    public T getEquinoctialEy() {
        return this.orbit.getEquinoctialEy();
    }

    public T getHx() {
        return this.orbit.getHx();
    }

    public T getHy() {
        return this.orbit.getHy();
    }

    public T getLv() {
        return this.orbit.getLv();
    }

    public T getLE() {
        return this.orbit.getLE();
    }

    public T getLM() {
        return this.orbit.getLM();
    }

    public T getE() {
        return this.orbit.getE();
    }

    public T getI() {
        return this.orbit.getI();
    }

    public TimeStampedFieldPVCoordinates<T> getPVCoordinates() {
        return this.orbit.getPVCoordinates();
    }

    public TimeStampedFieldPVCoordinates<T> getPVCoordinates(Frame outputFrame) throws OrekitException {
        return this.orbit.getPVCoordinates(outputFrame);
    }

    public FieldAttitude<T> getAttitude() {
        return this.attitude;
    }

    public T getMass() {
        return this.mass;
    }

    public SpacecraftState toSpacecraftState() {
        Map<String, double[]> map;
        if (this.additional.isEmpty()) {
            map = Collections.emptyMap();
        } else {
            map = new HashMap(this.additional.size());
            for (Map.Entry<String, T[]> entry : this.additional.entrySet()) {
                double[] array = new double[((RealFieldElement[])entry.getValue()).length];
                for (int k = 0; k < array.length; ++k) {
                    array[k] = ((RealFieldElement[])entry.getValue())[k].getReal();
                }
                map.put(entry.getKey(), array);
            }
        }
        return new SpacecraftState(this.orbit.toOrbit(), this.attitude.toAttitude(), this.mass.getReal(), map);
    }
}

