/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import java.util.Collection;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.GeoMagneticField;
import org.orekit.models.earth.GeoMagneticModelLoader;

public class GeoMagneticFieldFactory {
    private static TreeMap<Integer, GeoMagneticField> igrfModels = null;
    private static TreeMap<Integer, GeoMagneticField> wmmModels = null;

    private GeoMagneticFieldFactory() {
    }

    public static GeoMagneticField getField(FieldModel type, double year) throws OrekitException {
        switch (type) {
            case WMM: {
                return GeoMagneticFieldFactory.getWMM(year);
            }
            case IGRF: {
                return GeoMagneticFieldFactory.getIGRF(year);
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.NON_EXISTENT_GEOMAGNETIC_MODEL, type.name(), year);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoMagneticField getIGRF(double year) throws OrekitException {
        Class<GeoMagneticFieldFactory> clazz = GeoMagneticFieldFactory.class;
        synchronized (GeoMagneticFieldFactory.class) {
            if (igrfModels == null) {
                igrfModels = GeoMagneticFieldFactory.loadModels("^IGRF\\.COF$");
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return GeoMagneticFieldFactory.getModel(FieldModel.IGRF, igrfModels, year);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoMagneticField getWMM(double year) throws OrekitException {
        Class<GeoMagneticFieldFactory> clazz = GeoMagneticFieldFactory.class;
        synchronized (GeoMagneticFieldFactory.class) {
            if (wmmModels == null) {
                wmmModels = GeoMagneticFieldFactory.loadModels("^WMM\\.COF$");
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return GeoMagneticFieldFactory.getModel(FieldModel.WMM, wmmModels, year);
        }
    }

    private static TreeMap<Integer, GeoMagneticField> loadModels(String supportedNames) throws OrekitException {
        Collection<GeoMagneticField> models;
        TreeMap<Integer, GeoMagneticField> loadedModels = null;
        GeoMagneticModelLoader loader = new GeoMagneticModelLoader();
        DataProvidersManager.getInstance().feed(supportedNames, loader);
        if (!loader.stillAcceptsData() && (models = loader.getModels()) != null) {
            loadedModels = new TreeMap<Integer, GeoMagneticField>();
            for (GeoMagneticField model : models) {
                int epoch = (int)FastMath.round((double)(model.getEpoch() * 100.0));
                loadedModels.put(epoch, model);
            }
        }
        if (loadedModels == null || loadedModels.size() == 0) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_RESOURCE, supportedNames);
        }
        return loadedModels;
    }

    private static GeoMagneticField getModel(FieldModel type, TreeMap<Integer, GeoMagneticField> models, double year) throws OrekitException {
        int epochKey = (int)(year * 100.0);
        NavigableMap<Integer, GeoMagneticField> head = models.headMap(epochKey, true);
        if (head.isEmpty()) {
            throw new OrekitException((Localizable)OrekitMessages.NON_EXISTENT_GEOMAGNETIC_MODEL, type.name(), year);
        }
        GeoMagneticField model = models.get(head.lastKey());
        if (model.getEpoch() < year) {
            if (model.supportsTimeTransform()) {
                model = model.transformModel(year);
            } else {
                NavigableMap<Integer, GeoMagneticField> tail = models.tailMap(epochKey, false);
                if (tail.isEmpty()) {
                    throw new OrekitException((Localizable)OrekitMessages.NON_EXISTENT_GEOMAGNETIC_MODEL, type.name(), year);
                }
                GeoMagneticField secondModel = models.get(tail.firstKey());
                if (secondModel != model) {
                    model = model.transformModel(secondModel, year);
                }
            }
        }
        return model;
    }

    public static enum FieldModel {
        WMM,
        IGRF;

    }
}

