/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.AbstractGNSSAttitudeProvider;
import org.orekit.gnss.attitude.GNSSAttitudeContext;
import org.orekit.gnss.attitude.GNSSFieldAttitudeContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class GPSBlockIIA
extends AbstractGNSSAttitudeProvider {
    private static final long serialVersionUID = 20171114L;
    private static final double NIGHT_TURN_LIMIT = FastMath.toRadians((double)166.75);
    private static final double YAW_BIAS = FastMath.toRadians((double)0.5);
    private static final double[] YAW_RATES = new double[]{0.1211, 0.1339, 0.123, 0.1233, 0.118, 0.1266, 0.1269, 0.1033, 0.1278, 0.0978, 0.2, 0.199, 0.2, 0.0815, 0.1303, 0.0838, 0.1401, 0.1069, 0.098, 0.103, 0.1366, 0.1025, 0.114, 0.1089, 0.1001, 0.1227, 0.1194, 0.126, 0.1228, 0.1165, 0.0969, 0.114};
    private final double END_MARGIN = 1800.0;
    private final double yawRate;

    public GPSBlockIIA(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame, int prnNumber) {
        super(validityStart, validityEnd, sun, inertialFrame);
        this.yawRate = FastMath.toRadians((double)YAW_RATES[prnNumber - 1]);
    }

    @Override
    protected TimeStampedAngularCoordinates correctedYaw(GNSSAttitudeContext context) {
        double aNoon = FastMath.atan((double)(context.getMuRate() / this.yawRate));
        double aNight = NIGHT_TURN_LIMIT;
        double cNoon = FastMath.cos((double)aNoon);
        double cNight = FastMath.cos((double)aNight);
        if (context.setUpTurnRegion(cNight, cNoon)) {
            double absBeta = FastMath.abs((double)context.getBeta());
            context.setHalfSpan(context.inSunSide() ? absBeta * FastMath.sqrt((double)(aNoon / absBeta - 1.0)) : context.inOrbitPlaneAbsoluteAngle(aNight - Math.PI));
            if (context.inTurnTimeRange(context.getDate(), 1800.0)) {
                double linearPhi;
                double phiDot;
                double beta = context.getSecuredBeta();
                double phiStart = context.getYawStart(beta);
                double dtStart = context.timeSinceTurnStart(context.getDate());
                if (context.inSunSide()) {
                    if (beta > 0.0 && beta < YAW_BIAS) {
                        phiDot = FastMath.copySign((double)this.yawRate, (double)beta);
                        linearPhi = phiStart + phiDot * dtStart;
                    } else {
                        phiDot = -FastMath.copySign((double)this.yawRate, (double)beta);
                        linearPhi = phiStart + phiDot * dtStart;
                    }
                } else {
                    double dtEnd = dtStart - context.getTurnDuration();
                    if (dtEnd < 0.0) {
                        phiDot = this.yawRate;
                        linearPhi = phiStart + phiDot * dtStart;
                    } else {
                        phiDot = this.yawRate;
                        double phiEnd = phiStart + phiDot * context.getTurnDuration();
                        double deltaPhi = context.yawAngle() - phiEnd;
                        if (FastMath.abs((double)(deltaPhi / phiDot)) <= dtEnd) {
                            return context.getNominalYaw();
                        }
                        linearPhi = phiEnd + FastMath.copySign((double)(this.yawRate * dtEnd), (double)deltaPhi);
                    }
                }
                return context.turnCorrectedAttitude(linearPhi, phiDot);
            }
        }
        return context.getNominalYaw();
    }

    @Override
    protected <T extends RealFieldElement<T>> TimeStampedFieldAngularCoordinates<T> correctedYaw(GNSSFieldAttitudeContext<T> context) {
        Field<T> field = context.getDate().getField();
        RealFieldElement aNoon = FastMath.atan((RealFieldElement)((RealFieldElement)context.getMuRate().divide(this.yawRate)));
        RealFieldElement aNight = (RealFieldElement)((RealFieldElement)field.getZero()).add(NIGHT_TURN_LIMIT);
        double cNoon = FastMath.cos((double)aNoon.getReal());
        double cNight = FastMath.cos((double)aNight.getReal());
        if (context.setUpTurnRegion(cNight, cNoon)) {
            RealFieldElement absBeta = FastMath.abs(context.getBeta());
            context.setHalfSpan(context.inSunSide() ? (RealFieldElement)absBeta.multiply((Object)FastMath.sqrt((RealFieldElement)((RealFieldElement)((RealFieldElement)aNoon.divide((Object)absBeta)).subtract(1.0)))) : context.inOrbitPlaneAbsoluteAngle((RealFieldElement)aNight.subtract(Math.PI)));
            if (context.inTurnTimeRange(context.getDate(), 1800.0)) {
                RealFieldElement linearPhi;
                RealFieldElement phiDot;
                T beta = context.getSecuredBeta();
                T phiStart = context.getYawStart((RealFieldElement)beta);
                T dtStart = context.timeSinceTurnStart(context.getDate());
                if (context.inSunSide()) {
                    if (beta.getReal() > 0.0 && beta.getReal() < YAW_BIAS) {
                        phiDot = (RealFieldElement)((RealFieldElement)field.getZero()).add(FastMath.copySign((double)this.yawRate, (double)beta.getReal()));
                        linearPhi = (RealFieldElement)phiStart.add(phiDot.multiply(dtStart));
                    } else {
                        phiDot = (RealFieldElement)((RealFieldElement)field.getZero()).add(-FastMath.copySign((double)this.yawRate, (double)beta.getReal()));
                        linearPhi = (RealFieldElement)phiStart.add(phiDot.multiply(dtStart));
                    }
                } else {
                    RealFieldElement dtEnd = (RealFieldElement)dtStart.subtract(context.getTurnDuration());
                    if (dtEnd.getReal() < 0.0) {
                        phiDot = (RealFieldElement)((RealFieldElement)field.getZero()).add(this.yawRate);
                        linearPhi = (RealFieldElement)phiStart.add(phiDot.multiply(dtStart));
                    } else {
                        phiDot = (RealFieldElement)((RealFieldElement)field.getZero()).add(this.yawRate);
                        RealFieldElement phiEnd = (RealFieldElement)phiStart.add(phiDot.multiply(context.getTurnDuration()));
                        RealFieldElement deltaPhi = (RealFieldElement)context.yawAngle().subtract((Object)phiEnd);
                        if (FastMath.abs((double)((RealFieldElement)deltaPhi.divide((Object)phiDot)).getReal()) <= dtEnd.getReal()) {
                            return context.getNominalYaw();
                        }
                        linearPhi = (RealFieldElement)phiEnd.add(((RealFieldElement)dtEnd.multiply(this.yawRate)).copySign((Object)deltaPhi));
                    }
                }
                return context.turnCorrectedAttitude(linearPhi, phiDot);
            }
        }
        return context.getNominalYaw();
    }
}

