/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.antenna;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.gnss.antenna.PhaseCenterVariationFunction;

public class FrequencyPattern {
    private final Vector3D eccentricities;
    private final PhaseCenterVariationFunction phaseCenterVariationFunction;

    protected FrequencyPattern(Vector3D eccentricities, PhaseCenterVariationFunction phaseCenterVariationFunction) {
        this.eccentricities = eccentricities;
        this.phaseCenterVariationFunction = phaseCenterVariationFunction;
    }

    public Vector3D getEccentricities() {
        return this.eccentricities;
    }

    public double getPhaseCenterVariation(Vector3D direction) {
        return this.phaseCenterVariationFunction.value(1.5707963267948966 - direction.getDelta(), direction.getAlpha());
    }
}

