/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.antenna;

import java.util.Map;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.gnss.Frequency;
import org.orekit.gnss.antenna.FrequencyPattern;

public class Antenna {
    private final String type;
    private final String sinexCode;
    private final Map<Frequency, FrequencyPattern> patterns;

    protected Antenna(String type, String sinexCode, Map<Frequency, FrequencyPattern> patterns) {
        this.type = type;
        this.sinexCode = sinexCode;
        this.patterns = patterns;
    }

    public String getType() {
        return this.type;
    }

    public String getSinexCode() {
        return this.sinexCode;
    }

    public Vector3D getEccentricities(Frequency frequency) {
        return this.patterns.get((Object)frequency).getEccentricities();
    }

    public double getPhaseCenterVariation(Frequency frequency, Vector3D direction) {
        return this.patterns.get((Object)frequency).getPhaseCenterVariation(direction);
    }
}

