/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.util.HashMap;
import java.util.Map;
import org.orekit.gnss.Frequency;
import org.orekit.gnss.MeasurementType;
import org.orekit.gnss.SatelliteSystem;

public enum ObservationType {
    C1(MeasurementType.PSEUDO_RANGE, Frequency.G01, Frequency.R01, Frequency.C01, Frequency.S01),
    C2(MeasurementType.PSEUDO_RANGE, Frequency.G02, Frequency.R02),
    C5(MeasurementType.PSEUDO_RANGE, Frequency.G05, Frequency.E05, Frequency.S05),
    C6(MeasurementType.PSEUDO_RANGE, Frequency.E06),
    C7(MeasurementType.PSEUDO_RANGE, Frequency.E07),
    C8(MeasurementType.PSEUDO_RANGE, Frequency.E08),
    P1(MeasurementType.PSEUDO_RANGE, Frequency.G01, Frequency.R01),
    P2(MeasurementType.PSEUDO_RANGE, Frequency.G02, Frequency.R02),
    L1(MeasurementType.CARRIER_PHASE, Frequency.G01, Frequency.R01, Frequency.C01, Frequency.S01),
    L2(MeasurementType.CARRIER_PHASE, Frequency.G02, Frequency.R02),
    L5(MeasurementType.CARRIER_PHASE, Frequency.G05, Frequency.E05, Frequency.S05),
    L6(MeasurementType.CARRIER_PHASE, Frequency.E06),
    L7(MeasurementType.CARRIER_PHASE, Frequency.E07),
    L8(MeasurementType.CARRIER_PHASE, Frequency.E08),
    D1(MeasurementType.DOPPLER, Frequency.G01, Frequency.R01, Frequency.C01, Frequency.S01),
    D2(MeasurementType.DOPPLER, Frequency.G02, Frequency.R02),
    D5(MeasurementType.DOPPLER, Frequency.G05, Frequency.E05, Frequency.S05),
    D6(MeasurementType.DOPPLER, Frequency.E06),
    D7(MeasurementType.DOPPLER, Frequency.E07),
    D8(MeasurementType.DOPPLER, Frequency.E08),
    S1(MeasurementType.SIGNAL_STRENGTH, Frequency.G01, Frequency.R01, Frequency.C01, Frequency.S01),
    S2(MeasurementType.SIGNAL_STRENGTH, Frequency.G02, Frequency.R02),
    S5(MeasurementType.SIGNAL_STRENGTH, Frequency.G05, Frequency.E05, Frequency.S05),
    S6(MeasurementType.SIGNAL_STRENGTH, Frequency.E06),
    S7(MeasurementType.SIGNAL_STRENGTH, Frequency.E07),
    S8(MeasurementType.SIGNAL_STRENGTH, Frequency.E08),
    C1A(MeasurementType.PSEUDO_RANGE, Frequency.E01),
    C1B(MeasurementType.PSEUDO_RANGE, Frequency.E01),
    C1C(MeasurementType.PSEUDO_RANGE, Frequency.G01, Frequency.R01, Frequency.E01, Frequency.S01, Frequency.J01),
    C1I(MeasurementType.PSEUDO_RANGE, Frequency.B01),
    C1L(MeasurementType.PSEUDO_RANGE, Frequency.G01, Frequency.J01),
    C1M(MeasurementType.PSEUDO_RANGE, Frequency.G01),
    C1P(MeasurementType.PSEUDO_RANGE, Frequency.G01, Frequency.R01),
    C1Q(MeasurementType.PSEUDO_RANGE, Frequency.B01),
    C1S(MeasurementType.PSEUDO_RANGE, Frequency.G01, Frequency.J01),
    C1W(MeasurementType.PSEUDO_RANGE, Frequency.G01),
    C1X(MeasurementType.PSEUDO_RANGE, Frequency.G01, Frequency.E01, Frequency.J01),
    C1Y(MeasurementType.PSEUDO_RANGE, Frequency.G01),
    C1Z(MeasurementType.PSEUDO_RANGE, Frequency.E01, Frequency.J01),
    C2C(MeasurementType.PSEUDO_RANGE, Frequency.G02, Frequency.R02),
    C2D(MeasurementType.PSEUDO_RANGE, Frequency.G01),
    C2I(MeasurementType.PSEUDO_RANGE, Frequency.B01),
    C2L(MeasurementType.PSEUDO_RANGE, Frequency.G02, Frequency.J02),
    C2M(MeasurementType.PSEUDO_RANGE, Frequency.G02),
    C2P(MeasurementType.PSEUDO_RANGE, Frequency.G02, Frequency.R02),
    C2Q(MeasurementType.PSEUDO_RANGE, Frequency.B01),
    C2S(MeasurementType.PSEUDO_RANGE, Frequency.G02, Frequency.J02),
    C2W(MeasurementType.PSEUDO_RANGE, Frequency.G02),
    C2X(MeasurementType.PSEUDO_RANGE, Frequency.G02, Frequency.J02),
    C2Y(MeasurementType.PSEUDO_RANGE, Frequency.G02),
    C5I(MeasurementType.PSEUDO_RANGE, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    C5Q(MeasurementType.PSEUDO_RANGE, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    C5X(MeasurementType.PSEUDO_RANGE, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    C6A(MeasurementType.PSEUDO_RANGE, Frequency.E06),
    C6B(MeasurementType.PSEUDO_RANGE, Frequency.E06),
    C6C(MeasurementType.PSEUDO_RANGE, Frequency.E06),
    C6I(MeasurementType.PSEUDO_RANGE, Frequency.B03),
    C6Q(MeasurementType.PSEUDO_RANGE, Frequency.B03),
    C6X(MeasurementType.PSEUDO_RANGE, Frequency.E06, Frequency.J06, Frequency.B03),
    C6Z(MeasurementType.PSEUDO_RANGE, Frequency.E06),
    C7I(MeasurementType.PSEUDO_RANGE, Frequency.E07, Frequency.B02),
    C7Q(MeasurementType.PSEUDO_RANGE, Frequency.E07, Frequency.B02),
    C7X(MeasurementType.PSEUDO_RANGE, Frequency.E07, Frequency.B02),
    C8I(MeasurementType.PSEUDO_RANGE, Frequency.E08),
    C8Q(MeasurementType.PSEUDO_RANGE, Frequency.E08),
    C8X(MeasurementType.PSEUDO_RANGE, Frequency.E08),
    D1A(MeasurementType.DOPPLER, Frequency.E01),
    D1B(MeasurementType.DOPPLER, Frequency.E01),
    D1C(MeasurementType.DOPPLER, Frequency.G01, Frequency.R01, Frequency.E01, Frequency.S01, Frequency.J01),
    D1I(MeasurementType.DOPPLER, Frequency.B01),
    D1L(MeasurementType.DOPPLER, Frequency.G01, Frequency.J01),
    D1M(MeasurementType.DOPPLER, Frequency.G02),
    D1N(MeasurementType.DOPPLER, Frequency.G01),
    D1P(MeasurementType.DOPPLER, Frequency.G02, Frequency.R02),
    D1S(MeasurementType.DOPPLER, Frequency.G01, Frequency.J01),
    D1W(MeasurementType.DOPPLER, Frequency.G01),
    D1X(MeasurementType.DOPPLER, Frequency.G01, Frequency.E01, Frequency.J01),
    D1Y(MeasurementType.DOPPLER, Frequency.G01),
    D1Z(MeasurementType.DOPPLER, Frequency.E01, Frequency.J01),
    D2C(MeasurementType.DOPPLER, Frequency.G02, Frequency.R02),
    D2D(MeasurementType.DOPPLER, Frequency.G01),
    D2I(MeasurementType.DOPPLER, Frequency.B01),
    D2L(MeasurementType.DOPPLER, Frequency.G02, Frequency.J02),
    D2M(MeasurementType.DOPPLER, Frequency.G02),
    D2N(MeasurementType.DOPPLER, Frequency.G02),
    D2P(MeasurementType.DOPPLER, Frequency.G02, Frequency.R02),
    D2Q(MeasurementType.DOPPLER, Frequency.B01),
    D2S(MeasurementType.DOPPLER, Frequency.G02, Frequency.J02),
    D2W(MeasurementType.DOPPLER, Frequency.G02),
    D2X(MeasurementType.DOPPLER, Frequency.G02, Frequency.J02),
    D2Y(MeasurementType.DOPPLER, Frequency.G02),
    D5I(MeasurementType.DOPPLER, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    D5Q(MeasurementType.DOPPLER, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    D5X(MeasurementType.DOPPLER, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    D6A(MeasurementType.DOPPLER, Frequency.E06),
    D6B(MeasurementType.DOPPLER, Frequency.E06),
    D6C(MeasurementType.DOPPLER, Frequency.E06),
    D6I(MeasurementType.DOPPLER, Frequency.B03),
    D6Q(MeasurementType.DOPPLER, Frequency.B03),
    D6X(MeasurementType.DOPPLER, Frequency.E06, Frequency.J06, Frequency.B03),
    D6Z(MeasurementType.DOPPLER, Frequency.E06),
    D7I(MeasurementType.DOPPLER, Frequency.E07, Frequency.B02),
    D7Q(MeasurementType.DOPPLER, Frequency.E07, Frequency.B02),
    D7X(MeasurementType.DOPPLER, Frequency.E07, Frequency.B02),
    D8I(MeasurementType.DOPPLER, Frequency.E08),
    D8Q(MeasurementType.DOPPLER, Frequency.E08),
    D8X(MeasurementType.DOPPLER, Frequency.E08),
    L1A(MeasurementType.CARRIER_PHASE, Frequency.E01),
    L1B(MeasurementType.CARRIER_PHASE, Frequency.E01),
    L1C(MeasurementType.CARRIER_PHASE, Frequency.G01, Frequency.R01, Frequency.E01, Frequency.S01, Frequency.J01),
    L1I(MeasurementType.CARRIER_PHASE, Frequency.B01),
    L1L(MeasurementType.CARRIER_PHASE, Frequency.G01, Frequency.J01),
    L1M(MeasurementType.CARRIER_PHASE, Frequency.G02),
    L1N(MeasurementType.CARRIER_PHASE, Frequency.G01),
    L1P(MeasurementType.CARRIER_PHASE, Frequency.G02, Frequency.R02),
    L1S(MeasurementType.CARRIER_PHASE, Frequency.G01, Frequency.J01),
    L1W(MeasurementType.CARRIER_PHASE, Frequency.G01),
    L1X(MeasurementType.CARRIER_PHASE, Frequency.G01, Frequency.E01, Frequency.J01),
    L1Y(MeasurementType.CARRIER_PHASE, Frequency.G01),
    L1Z(MeasurementType.CARRIER_PHASE, Frequency.E01, Frequency.J01),
    L2C(MeasurementType.CARRIER_PHASE, Frequency.G02, Frequency.R02),
    L2D(MeasurementType.CARRIER_PHASE, Frequency.G01),
    L2I(MeasurementType.CARRIER_PHASE, Frequency.B01),
    L2L(MeasurementType.CARRIER_PHASE, Frequency.G02, Frequency.J02),
    L2M(MeasurementType.CARRIER_PHASE, Frequency.G02),
    L2N(MeasurementType.CARRIER_PHASE, Frequency.G02),
    L2P(MeasurementType.CARRIER_PHASE, Frequency.G02, Frequency.R02),
    L2Q(MeasurementType.CARRIER_PHASE, Frequency.B01),
    L2S(MeasurementType.CARRIER_PHASE, Frequency.G02, Frequency.J02),
    L2W(MeasurementType.CARRIER_PHASE, Frequency.G02),
    L2X(MeasurementType.CARRIER_PHASE, Frequency.G02, Frequency.J02),
    L2Y(MeasurementType.CARRIER_PHASE, Frequency.G02),
    L5I(MeasurementType.CARRIER_PHASE, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    L5Q(MeasurementType.CARRIER_PHASE, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    L5X(MeasurementType.CARRIER_PHASE, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    L6A(MeasurementType.CARRIER_PHASE, Frequency.E06),
    L6B(MeasurementType.CARRIER_PHASE, Frequency.E06),
    L6C(MeasurementType.CARRIER_PHASE, Frequency.E06),
    L6I(MeasurementType.CARRIER_PHASE, Frequency.B03),
    L6Q(MeasurementType.CARRIER_PHASE, Frequency.B03),
    L6X(MeasurementType.CARRIER_PHASE, Frequency.E06, Frequency.J06, Frequency.B03),
    L6Z(MeasurementType.CARRIER_PHASE, Frequency.E06),
    L7I(MeasurementType.CARRIER_PHASE, Frequency.E07, Frequency.B02),
    L7Q(MeasurementType.CARRIER_PHASE, Frequency.E07, Frequency.B02),
    L7X(MeasurementType.CARRIER_PHASE, Frequency.E07, Frequency.B02),
    L8I(MeasurementType.CARRIER_PHASE, Frequency.E08),
    L8Q(MeasurementType.CARRIER_PHASE, Frequency.E08),
    L8X(MeasurementType.CARRIER_PHASE, Frequency.E08),
    S1A(MeasurementType.SIGNAL_STRENGTH, Frequency.E01),
    S1B(MeasurementType.SIGNAL_STRENGTH, Frequency.E01),
    S1C(MeasurementType.SIGNAL_STRENGTH, Frequency.G01, Frequency.R01, Frequency.E01, Frequency.S01, Frequency.J01),
    S1I(MeasurementType.SIGNAL_STRENGTH, Frequency.B01),
    S1L(MeasurementType.SIGNAL_STRENGTH, Frequency.G01, Frequency.J01),
    S1M(MeasurementType.SIGNAL_STRENGTH, Frequency.G02),
    S1N(MeasurementType.SIGNAL_STRENGTH, Frequency.G01),
    S1P(MeasurementType.SIGNAL_STRENGTH, Frequency.G02, Frequency.R02),
    S1S(MeasurementType.SIGNAL_STRENGTH, Frequency.G01, Frequency.J01),
    S1W(MeasurementType.SIGNAL_STRENGTH, Frequency.G01),
    S1X(MeasurementType.SIGNAL_STRENGTH, Frequency.G01, Frequency.E01, Frequency.J01),
    S1Y(MeasurementType.SIGNAL_STRENGTH, Frequency.G01),
    S1Z(MeasurementType.SIGNAL_STRENGTH, Frequency.E01, Frequency.J01),
    S2C(MeasurementType.SIGNAL_STRENGTH, Frequency.G02, Frequency.R02),
    S2D(MeasurementType.SIGNAL_STRENGTH, Frequency.G01),
    S2I(MeasurementType.SIGNAL_STRENGTH, Frequency.B01),
    S2L(MeasurementType.SIGNAL_STRENGTH, Frequency.G02, Frequency.J02),
    S2M(MeasurementType.SIGNAL_STRENGTH, Frequency.G02),
    S2N(MeasurementType.SIGNAL_STRENGTH, Frequency.G02),
    S2P(MeasurementType.SIGNAL_STRENGTH, Frequency.G02, Frequency.R02),
    S2Q(MeasurementType.SIGNAL_STRENGTH, Frequency.B01),
    S2S(MeasurementType.SIGNAL_STRENGTH, Frequency.G02, Frequency.J02),
    S2W(MeasurementType.SIGNAL_STRENGTH, Frequency.G02),
    S2X(MeasurementType.SIGNAL_STRENGTH, Frequency.G02, Frequency.J02),
    S2Y(MeasurementType.SIGNAL_STRENGTH, Frequency.G02),
    S5I(MeasurementType.SIGNAL_STRENGTH, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    S5Q(MeasurementType.SIGNAL_STRENGTH, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    S5X(MeasurementType.SIGNAL_STRENGTH, Frequency.G05, Frequency.E05, Frequency.S05, Frequency.J05),
    S6A(MeasurementType.SIGNAL_STRENGTH, Frequency.E06),
    S6B(MeasurementType.SIGNAL_STRENGTH, Frequency.E06),
    S6C(MeasurementType.SIGNAL_STRENGTH, Frequency.E06),
    S6I(MeasurementType.SIGNAL_STRENGTH, Frequency.B03),
    S6Q(MeasurementType.SIGNAL_STRENGTH, Frequency.B03),
    S6X(MeasurementType.SIGNAL_STRENGTH, Frequency.E06, Frequency.J06, Frequency.B03),
    S6Z(MeasurementType.SIGNAL_STRENGTH, Frequency.E06),
    S7I(MeasurementType.SIGNAL_STRENGTH, Frequency.E07, Frequency.B02),
    S7Q(MeasurementType.SIGNAL_STRENGTH, Frequency.E07, Frequency.B02),
    S7X(MeasurementType.SIGNAL_STRENGTH, Frequency.E07, Frequency.B02),
    S8I(MeasurementType.SIGNAL_STRENGTH, Frequency.E08),
    S8Q(MeasurementType.SIGNAL_STRENGTH, Frequency.E08),
    S8X(MeasurementType.SIGNAL_STRENGTH, Frequency.E08);

    private final MeasurementType type;
    private final Map<SatelliteSystem, Frequency> frequencies;

    private ObservationType(MeasurementType type, Frequency ... frequencies) {
        this.type = type;
        this.frequencies = new HashMap<SatelliteSystem, Frequency>(frequencies.length);
        for (Frequency f : frequencies) {
            this.frequencies.put(f.getSatelliteSystem(), f);
        }
    }

    public MeasurementType getMeasurementType() {
        return this.type;
    }

    public Frequency getFrequency(SatelliteSystem system) {
        return this.frequencies.get((Object)system);
    }
}

