/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.hipparchus.RealFieldElement;
import org.orekit.bodies.CelestialBodyFactory;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.BulletinAFilesLoader;
import org.orekit.frames.BulletinBFilesLoader;
import org.orekit.frames.CIRFProvider;
import org.orekit.frames.EME2000Provider;
import org.orekit.frames.EOPBasedTransformProvider;
import org.orekit.frames.EOPC04FilesLoader;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.EOPHistoryLoader;
import org.orekit.frames.EclipticProvider;
import org.orekit.frames.FactoryManagedFrame;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.GTODProvider;
import org.orekit.frames.ITRFProvider;
import org.orekit.frames.ITRFVersion;
import org.orekit.frames.InterpolatingTransformProvider;
import org.orekit.frames.MODProvider;
import org.orekit.frames.Predefined;
import org.orekit.frames.RapidDataAndPredictionColumnsLoader;
import org.orekit.frames.RapidDataAndPredictionXMLLoader;
import org.orekit.frames.ShiftingTransformProvider;
import org.orekit.frames.TEMEProvider;
import org.orekit.frames.TIRFProvider;
import org.orekit.frames.TODProvider;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.frames.VEISProvider;
import org.orekit.frames.VersionedITRF;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.OrekitConfiguration;

public class FramesFactory {
    public static final String RAPID_DATA_PREDICTION_COLUMNS_1980_FILENAME = "^finals\\.[^.]*$";
    public static final String RAPID_DATA_PREDICTION_XML_1980_FILENAME = "^finals\\..*\\.xml$";
    public static final String EOPC04_1980_FILENAME = "^eopc04_\\d\\d\\.(\\d\\d)$";
    public static final String BULLETINB_1980_FILENAME = "^bulletinb(_IAU1980)?((-\\d\\d\\d\\.txt)|(\\.\\d\\d\\d))$";
    public static final String RAPID_DATA_PREDICITON_COLUMNS_2000_FILENAME = "^finals2000A\\.[^.]*$";
    public static final String RAPID_DATA_PREDICITON_XML_2000_FILENAME = "^finals2000A\\..*\\.xml$";
    public static final String EOPC04_2000_FILENAME = "^eopc04_\\d\\d_IAU2000\\.(\\d\\d)$";
    public static final String BULLETINB_2000_FILENAME = "^bulletinb(_IAU2000)?((-\\d\\d\\d\\.txt)|(\\.\\d\\d\\d))$";
    public static final String BULLETINA_FILENAME = "^bulletina-[ivxlcdm]+-\\d\\d\\d\\.txt$";
    private static transient Map<Predefined, FactoryManagedFrame> FRAMES = new HashMap<Predefined, FactoryManagedFrame>();
    private static transient Map<ITRFKey, VersionedITRF> VERSIONED_ITRF_FRAMES = new HashMap<ITRFKey, VersionedITRF>();
    private static final Map<IERSConventions, List<EOPHistoryLoader>> EOP_HISTORY_LOADERS = new HashMap<IERSConventions, List<EOPHistoryLoader>>();
    private static double EOP_CONTINUITY_THRESHOLD = 432000.0;

    private FramesFactory() {
    }

    public static void addDefaultEOP1980HistoryLoaders(String rapidDataColumnsSupportedNames, String rapidDataXMLSupportedNames, String eopC04SupportedNames, String bulletinBSupportedNames, String bulletinASupportedNames) {
        String rapidColNames = rapidDataColumnsSupportedNames == null ? RAPID_DATA_PREDICTION_COLUMNS_1980_FILENAME : rapidDataColumnsSupportedNames;
        FramesFactory.addEOPHistoryLoader(IERSConventions.IERS_1996, new RapidDataAndPredictionColumnsLoader(false, rapidColNames));
        String rapidXmlNames = rapidDataXMLSupportedNames == null ? RAPID_DATA_PREDICTION_XML_1980_FILENAME : rapidDataXMLSupportedNames;
        FramesFactory.addEOPHistoryLoader(IERSConventions.IERS_1996, new RapidDataAndPredictionXMLLoader(rapidXmlNames));
        String eopcNames = eopC04SupportedNames == null ? EOPC04_1980_FILENAME : eopC04SupportedNames;
        FramesFactory.addEOPHistoryLoader(IERSConventions.IERS_1996, new EOPC04FilesLoader(eopcNames));
        String bulBNames = bulletinBSupportedNames == null ? BULLETINB_1980_FILENAME : bulletinBSupportedNames;
        FramesFactory.addEOPHistoryLoader(IERSConventions.IERS_1996, new BulletinBFilesLoader(bulBNames));
        String bulANames = bulletinASupportedNames == null ? BULLETINA_FILENAME : bulletinASupportedNames;
        FramesFactory.addEOPHistoryLoader(IERSConventions.IERS_1996, new BulletinAFilesLoader(bulANames));
    }

    public static void addDefaultEOP2000HistoryLoaders(String rapidDataColumnsSupportedNames, String rapidDataXMLSupportedNames, String eopC04SupportedNames, String bulletinBSupportedNames, String bulletinASupportedNames) {
        String rapidColNames = rapidDataColumnsSupportedNames == null ? RAPID_DATA_PREDICITON_COLUMNS_2000_FILENAME : rapidDataColumnsSupportedNames;
        FramesFactory.addEOPHistoryLoader(IERSConventions.IERS_2003, new RapidDataAndPredictionColumnsLoader(true, rapidColNames));
        FramesFactory.addEOPHistoryLoader(IERSConventions.IERS_2010, new RapidDataAndPredictionColumnsLoader(true, rapidColNames));
        String rapidXmlNames = rapidDataXMLSupportedNames == null ? RAPID_DATA_PREDICITON_XML_2000_FILENAME : rapidDataXMLSupportedNames;
        FramesFactory.addEOPHistoryLoader(IERSConventions.IERS_2003, new RapidDataAndPredictionXMLLoader(rapidXmlNames));
        FramesFactory.addEOPHistoryLoader(IERSConventions.IERS_2010, new RapidDataAndPredictionXMLLoader(rapidXmlNames));
        String eopcNames = eopC04SupportedNames == null ? EOPC04_2000_FILENAME : eopC04SupportedNames;
        FramesFactory.addEOPHistoryLoader(IERSConventions.IERS_2003, new EOPC04FilesLoader(eopcNames));
        FramesFactory.addEOPHistoryLoader(IERSConventions.IERS_2010, new EOPC04FilesLoader(eopcNames));
        String bulBNames = bulletinBSupportedNames == null ? BULLETINB_2000_FILENAME : bulletinBSupportedNames;
        FramesFactory.addEOPHistoryLoader(IERSConventions.IERS_2003, new BulletinBFilesLoader(bulBNames));
        FramesFactory.addEOPHistoryLoader(IERSConventions.IERS_2010, new BulletinBFilesLoader(bulBNames));
        String bulANames = bulletinASupportedNames == null ? BULLETINA_FILENAME : bulletinASupportedNames;
        FramesFactory.addEOPHistoryLoader(IERSConventions.IERS_2003, new BulletinAFilesLoader(bulANames));
        FramesFactory.addEOPHistoryLoader(IERSConventions.IERS_2010, new BulletinAFilesLoader(bulANames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEOPHistoryLoader(IERSConventions conventions, EOPHistoryLoader loader) {
        Map<IERSConventions, List<EOPHistoryLoader>> map = EOP_HISTORY_LOADERS;
        synchronized (map) {
            if (!EOP_HISTORY_LOADERS.containsKey((Object)conventions)) {
                EOP_HISTORY_LOADERS.put(conventions, new ArrayList());
            }
            EOP_HISTORY_LOADERS.get((Object)conventions).add(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearEOPHistoryLoaders() {
        Map<IERSConventions, List<EOPHistoryLoader>> map = EOP_HISTORY_LOADERS;
        synchronized (map) {
            EOP_HISTORY_LOADERS.clear();
        }
    }

    public static void setEOPContinuityThreshold(double threshold) {
        EOP_CONTINUITY_THRESHOLD = threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EOPHistory getEOPHistory(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
        Map<IERSConventions, List<EOPHistoryLoader>> map = EOP_HISTORY_LOADERS;
        synchronized (map) {
            if (EOP_HISTORY_LOADERS.isEmpty()) {
                FramesFactory.addDefaultEOP2000HistoryLoaders(null, null, null, null, null);
                FramesFactory.addDefaultEOP1980HistoryLoaders(null, null, null, null, null);
            }
            OrekitException pendingException = null;
            TreeSet<TimeStamped> data = new TreeSet<TimeStamped>(new ChronologicalComparator());
            if (EOP_HISTORY_LOADERS.containsKey((Object)conventions)) {
                for (EOPHistoryLoader loader : EOP_HISTORY_LOADERS.get((Object)conventions)) {
                    try {
                        loader.fillHistory(conventions.getNutationCorrectionConverter(), data);
                    }
                    catch (OrekitException oe) {
                        pendingException = oe;
                    }
                }
            }
            if (data.isEmpty() && pendingException != null) {
                throw pendingException;
            }
            EOPHistory history = new EOPHistory(conventions, data, simpleEOP);
            history.checkEOPContinuity(EOP_CONTINUITY_THRESHOLD);
            return history;
        }
    }

    public static Frame getFrame(Predefined factoryKey) throws OrekitException {
        switch (factoryKey) {
            case GCRF: {
                return FramesFactory.getGCRF();
            }
            case ICRF: {
                return FramesFactory.getICRF();
            }
            case ECLIPTIC_CONVENTIONS_1996: {
                return FramesFactory.getEcliptic(IERSConventions.IERS_1996);
            }
            case ECLIPTIC_CONVENTIONS_2003: {
                return FramesFactory.getEcliptic(IERSConventions.IERS_2003);
            }
            case ECLIPTIC_CONVENTIONS_2010: {
                return FramesFactory.getEcliptic(IERSConventions.IERS_2010);
            }
            case EME2000: {
                return FramesFactory.getEME2000();
            }
            case ITRF_CIO_CONV_2010_SIMPLE_EOP: {
                return FramesFactory.getITRF(IERSConventions.IERS_2010, true);
            }
            case ITRF_CIO_CONV_2010_ACCURATE_EOP: {
                return FramesFactory.getITRF(IERSConventions.IERS_2010, false);
            }
            case ITRF_CIO_CONV_2003_SIMPLE_EOP: {
                return FramesFactory.getITRF(IERSConventions.IERS_2003, true);
            }
            case ITRF_CIO_CONV_2003_ACCURATE_EOP: {
                return FramesFactory.getITRF(IERSConventions.IERS_2003, false);
            }
            case ITRF_CIO_CONV_1996_SIMPLE_EOP: {
                return FramesFactory.getITRF(IERSConventions.IERS_1996, true);
            }
            case ITRF_CIO_CONV_1996_ACCURATE_EOP: {
                return FramesFactory.getITRF(IERSConventions.IERS_1996, false);
            }
            case ITRF_EQUINOX_CONV_2010_SIMPLE_EOP: {
                return FramesFactory.getITRFEquinox(IERSConventions.IERS_2010, true);
            }
            case ITRF_EQUINOX_CONV_2010_ACCURATE_EOP: {
                return FramesFactory.getITRFEquinox(IERSConventions.IERS_2010, false);
            }
            case ITRF_EQUINOX_CONV_2003_SIMPLE_EOP: {
                return FramesFactory.getITRFEquinox(IERSConventions.IERS_2003, true);
            }
            case ITRF_EQUINOX_CONV_2003_ACCURATE_EOP: {
                return FramesFactory.getITRFEquinox(IERSConventions.IERS_2003, false);
            }
            case ITRF_EQUINOX_CONV_1996_SIMPLE_EOP: {
                return FramesFactory.getITRFEquinox(IERSConventions.IERS_1996, true);
            }
            case ITRF_EQUINOX_CONV_1996_ACCURATE_EOP: {
                return FramesFactory.getITRFEquinox(IERSConventions.IERS_1996, false);
            }
            case TIRF_CONVENTIONS_2010_SIMPLE_EOP: {
                return FramesFactory.getTIRF(IERSConventions.IERS_2010, true);
            }
            case TIRF_CONVENTIONS_2010_ACCURATE_EOP: {
                return FramesFactory.getTIRF(IERSConventions.IERS_2010, false);
            }
            case TIRF_CONVENTIONS_2003_SIMPLE_EOP: {
                return FramesFactory.getTIRF(IERSConventions.IERS_2003, true);
            }
            case TIRF_CONVENTIONS_2003_ACCURATE_EOP: {
                return FramesFactory.getTIRF(IERSConventions.IERS_2003, false);
            }
            case TIRF_CONVENTIONS_1996_SIMPLE_EOP: {
                return FramesFactory.getTIRF(IERSConventions.IERS_1996, true);
            }
            case TIRF_CONVENTIONS_1996_ACCURATE_EOP: {
                return FramesFactory.getTIRF(IERSConventions.IERS_1996, false);
            }
            case CIRF_CONVENTIONS_2010_ACCURATE_EOP: {
                return FramesFactory.getCIRF(IERSConventions.IERS_2010, false);
            }
            case CIRF_CONVENTIONS_2010_SIMPLE_EOP: {
                return FramesFactory.getCIRF(IERSConventions.IERS_2010, true);
            }
            case CIRF_CONVENTIONS_2003_ACCURATE_EOP: {
                return FramesFactory.getCIRF(IERSConventions.IERS_2003, false);
            }
            case CIRF_CONVENTIONS_2003_SIMPLE_EOP: {
                return FramesFactory.getCIRF(IERSConventions.IERS_2003, true);
            }
            case CIRF_CONVENTIONS_1996_ACCURATE_EOP: {
                return FramesFactory.getCIRF(IERSConventions.IERS_1996, false);
            }
            case CIRF_CONVENTIONS_1996_SIMPLE_EOP: {
                return FramesFactory.getCIRF(IERSConventions.IERS_1996, true);
            }
            case VEIS_1950: {
                return FramesFactory.getVeis1950();
            }
            case GTOD_WITHOUT_EOP_CORRECTIONS: {
                return FramesFactory.getGTOD(IERSConventions.IERS_1996, false, true);
            }
            case GTOD_CONVENTIONS_2010_ACCURATE_EOP: {
                return FramesFactory.getGTOD(IERSConventions.IERS_2010, true, false);
            }
            case GTOD_CONVENTIONS_2010_SIMPLE_EOP: {
                return FramesFactory.getGTOD(IERSConventions.IERS_2010, true, true);
            }
            case GTOD_CONVENTIONS_2003_ACCURATE_EOP: {
                return FramesFactory.getGTOD(IERSConventions.IERS_2003, true, false);
            }
            case GTOD_CONVENTIONS_2003_SIMPLE_EOP: {
                return FramesFactory.getGTOD(IERSConventions.IERS_2003, true, true);
            }
            case GTOD_CONVENTIONS_1996_ACCURATE_EOP: {
                return FramesFactory.getGTOD(IERSConventions.IERS_1996, true, false);
            }
            case GTOD_CONVENTIONS_1996_SIMPLE_EOP: {
                return FramesFactory.getGTOD(IERSConventions.IERS_1996, true, true);
            }
            case TOD_WITHOUT_EOP_CORRECTIONS: {
                return FramesFactory.getTOD(IERSConventions.IERS_1996, false, true);
            }
            case TOD_CONVENTIONS_2010_ACCURATE_EOP: {
                return FramesFactory.getTOD(IERSConventions.IERS_2010, true, false);
            }
            case TOD_CONVENTIONS_2010_SIMPLE_EOP: {
                return FramesFactory.getTOD(IERSConventions.IERS_2010, true, true);
            }
            case TOD_CONVENTIONS_2003_ACCURATE_EOP: {
                return FramesFactory.getTOD(IERSConventions.IERS_2003, true, false);
            }
            case TOD_CONVENTIONS_2003_SIMPLE_EOP: {
                return FramesFactory.getTOD(IERSConventions.IERS_2003, true, true);
            }
            case TOD_CONVENTIONS_1996_ACCURATE_EOP: {
                return FramesFactory.getTOD(IERSConventions.IERS_1996, true, false);
            }
            case TOD_CONVENTIONS_1996_SIMPLE_EOP: {
                return FramesFactory.getTOD(IERSConventions.IERS_1996, true, true);
            }
            case MOD_WITHOUT_EOP_CORRECTIONS: {
                return FramesFactory.getMOD(IERSConventions.IERS_1996, false);
            }
            case MOD_CONVENTIONS_2010: {
                return FramesFactory.getMOD(IERSConventions.IERS_2010, true);
            }
            case MOD_CONVENTIONS_2003: {
                return FramesFactory.getMOD(IERSConventions.IERS_2003, true);
            }
            case MOD_CONVENTIONS_1996: {
                return FramesFactory.getMOD(IERSConventions.IERS_1996, true);
            }
            case TEME: {
                return FramesFactory.getTEME();
            }
        }
        throw new OrekitInternalError(null);
    }

    public static Frame getGCRF() {
        return Frame.getRoot();
    }

    public static Frame getICRF() throws OrekitException {
        return CelestialBodyFactory.getSolarSystemBarycenter().getInertiallyOrientedFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Frame getEcliptic(IERSConventions conventions) throws OrekitException {
        Class<FramesFactory> clazz = FramesFactory.class;
        synchronized (FramesFactory.class) {
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = Predefined.ECLIPTIC_CONVENTIONS_1996;
                    break;
                }
                case IERS_2003: {
                    factoryKey = Predefined.ECLIPTIC_CONVENTIONS_2003;
                    break;
                }
                case IERS_2010: {
                    factoryKey = Predefined.ECLIPTIC_CONVENTIONS_2010;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            FactoryManagedFrame parent = FramesFactory.getMOD(conventions);
            FactoryManagedFrame frame = FRAMES.get((Object)factoryKey);
            if (frame == null) {
                frame = new FactoryManagedFrame((Frame)parent, (TransformProvider)new EclipticProvider(conventions), true, factoryKey);
                FRAMES.put(factoryKey, frame);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FactoryManagedFrame getEME2000() {
        Class<FramesFactory> clazz = FramesFactory.class;
        synchronized (FramesFactory.class) {
            FactoryManagedFrame frame = FRAMES.get((Object)Predefined.EME2000);
            if (frame == null) {
                frame = new FactoryManagedFrame(FramesFactory.getGCRF(), (TransformProvider)new EME2000Provider(), true, Predefined.EME2000);
                FRAMES.put(Predefined.EME2000, frame);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FactoryManagedFrame getITRF(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
        Class<FramesFactory> clazz = FramesFactory.class;
        synchronized (FramesFactory.class) {
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = simpleEOP ? Predefined.ITRF_CIO_CONV_1996_SIMPLE_EOP : Predefined.ITRF_CIO_CONV_1996_ACCURATE_EOP;
                    break;
                }
                case IERS_2003: {
                    factoryKey = simpleEOP ? Predefined.ITRF_CIO_CONV_2003_SIMPLE_EOP : Predefined.ITRF_CIO_CONV_2003_ACCURATE_EOP;
                    break;
                }
                case IERS_2010: {
                    factoryKey = simpleEOP ? Predefined.ITRF_CIO_CONV_2010_SIMPLE_EOP : Predefined.ITRF_CIO_CONV_2010_ACCURATE_EOP;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            FactoryManagedFrame frame = FRAMES.get((Object)factoryKey);
            if (frame == null) {
                FactoryManagedFrame tirfFrame = FramesFactory.getTIRF(conventions, simpleEOP);
                TIRFProvider tirfProvider = (TIRFProvider)tirfFrame.getTransformProvider();
                frame = new FactoryManagedFrame((Frame)tirfFrame, (TransformProvider)new ITRFProvider(tirfProvider.getEOPHistory()), false, factoryKey);
                FRAMES.put(factoryKey, frame);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return frame;
        }
    }

    public static FactoryManagedFrame getTIRF(IERSConventions conventions) throws OrekitException {
        return FramesFactory.getTIRF(conventions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionedITRF getITRF(ITRFVersion version, IERSConventions conventions, boolean simpleEOP) throws OrekitException {
        Class<FramesFactory> clazz = FramesFactory.class;
        synchronized (FramesFactory.class) {
            ITRFKey key = new ITRFKey(version, conventions, simpleEOP);
            VersionedITRF frame = VERSIONED_ITRF_FRAMES.get(key);
            if (frame == null) {
                FactoryManagedFrame rawITRF = FramesFactory.getITRF(conventions, simpleEOP);
                frame = new VersionedITRF(rawITRF.getParent(), version, (ITRFProvider)rawITRF.getTransformProvider(), version.toString().replace('_', '-') + "/" + rawITRF.getName());
                VERSIONED_ITRF_FRAMES.put(key, frame);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FactoryManagedFrame getTIRF(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
        Class<FramesFactory> clazz = FramesFactory.class;
        synchronized (FramesFactory.class) {
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = simpleEOP ? Predefined.TIRF_CONVENTIONS_1996_SIMPLE_EOP : Predefined.TIRF_CONVENTIONS_1996_ACCURATE_EOP;
                    break;
                }
                case IERS_2003: {
                    factoryKey = simpleEOP ? Predefined.TIRF_CONVENTIONS_2003_SIMPLE_EOP : Predefined.TIRF_CONVENTIONS_2003_ACCURATE_EOP;
                    break;
                }
                case IERS_2010: {
                    factoryKey = simpleEOP ? Predefined.TIRF_CONVENTIONS_2010_SIMPLE_EOP : Predefined.TIRF_CONVENTIONS_2010_ACCURATE_EOP;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            FactoryManagedFrame frame = FRAMES.get((Object)factoryKey);
            if (frame == null) {
                FactoryManagedFrame cirf = FramesFactory.getCIRF(conventions, simpleEOP);
                ShiftingTransformProvider cirfInterpolating = (ShiftingTransformProvider)cirf.getTransformProvider();
                CIRFProvider cirfRaw = (CIRFProvider)cirfInterpolating.getRawProvider();
                EOPHistory eopHistory = cirfRaw.getEOPHistory();
                frame = new FactoryManagedFrame((Frame)cirf, (TransformProvider)new TIRFProvider(eopHistory), false, factoryKey);
                FRAMES.put(factoryKey, frame);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FactoryManagedFrame getCIRF(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
        Class<FramesFactory> clazz = FramesFactory.class;
        synchronized (FramesFactory.class) {
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = simpleEOP ? Predefined.CIRF_CONVENTIONS_1996_SIMPLE_EOP : Predefined.CIRF_CONVENTIONS_1996_ACCURATE_EOP;
                    break;
                }
                case IERS_2003: {
                    factoryKey = simpleEOP ? Predefined.CIRF_CONVENTIONS_2003_SIMPLE_EOP : Predefined.CIRF_CONVENTIONS_2003_ACCURATE_EOP;
                    break;
                }
                case IERS_2010: {
                    factoryKey = simpleEOP ? Predefined.CIRF_CONVENTIONS_2010_SIMPLE_EOP : Predefined.CIRF_CONVENTIONS_2010_ACCURATE_EOP;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            FactoryManagedFrame frame = FRAMES.get((Object)factoryKey);
            if (frame == null) {
                EOPHistory eopHistory = FramesFactory.getEOPHistory(conventions, simpleEOP);
                ShiftingTransformProvider shifting = new ShiftingTransformProvider(new CIRFProvider(eopHistory), CartesianDerivativesFilter.USE_PVA, AngularDerivativesFilter.USE_R, 6, 3600.0, OrekitConfiguration.getCacheSlotsNumber(), 3.15576E7, 2592000.0);
                frame = new FactoryManagedFrame(FramesFactory.getGCRF(), (TransformProvider)shifting, true, factoryKey);
                FRAMES.put(factoryKey, frame);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FactoryManagedFrame getVeis1950() throws OrekitException {
        Class<FramesFactory> clazz = FramesFactory.class;
        synchronized (FramesFactory.class) {
            Predefined factoryKey = Predefined.VEIS_1950;
            FactoryManagedFrame frame = FRAMES.get((Object)factoryKey);
            if (frame == null) {
                frame = new FactoryManagedFrame((Frame)FramesFactory.getGTOD(IERSConventions.IERS_1996, false, true), (TransformProvider)new VEISProvider(), true, factoryKey);
                FRAMES.put(factoryKey, frame);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FactoryManagedFrame getITRFEquinox(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
        Class<FramesFactory> clazz = FramesFactory.class;
        synchronized (FramesFactory.class) {
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = simpleEOP ? Predefined.ITRF_EQUINOX_CONV_1996_SIMPLE_EOP : Predefined.ITRF_EQUINOX_CONV_1996_ACCURATE_EOP;
                    break;
                }
                case IERS_2003: {
                    factoryKey = simpleEOP ? Predefined.ITRF_EQUINOX_CONV_2003_SIMPLE_EOP : Predefined.ITRF_EQUINOX_CONV_2003_ACCURATE_EOP;
                    break;
                }
                case IERS_2010: {
                    factoryKey = simpleEOP ? Predefined.ITRF_EQUINOX_CONV_2010_SIMPLE_EOP : Predefined.ITRF_EQUINOX_CONV_2010_ACCURATE_EOP;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            FactoryManagedFrame frame = FRAMES.get((Object)factoryKey);
            if (frame == null) {
                FactoryManagedFrame gtod = FramesFactory.getGTOD(conventions, true, simpleEOP);
                ShiftingTransformProvider gtodShifting = (ShiftingTransformProvider)gtod.getTransformProvider();
                GTODProvider gtodRaw = (GTODProvider)gtodShifting.getRawProvider();
                EOPHistory eopHistory = gtodRaw.getEOPHistory();
                frame = new FactoryManagedFrame((Frame)gtod, (TransformProvider)new ITRFProvider(eopHistory), false, factoryKey);
                FRAMES.put(factoryKey, frame);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return frame;
        }
    }

    public static FactoryManagedFrame getGTOD(boolean applyEOPCorr) throws OrekitException {
        return FramesFactory.getGTOD(IERSConventions.IERS_1996, applyEOPCorr, true);
    }

    public static FactoryManagedFrame getGTOD(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
        return FramesFactory.getGTOD(conventions, true, simpleEOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FactoryManagedFrame getGTOD(IERSConventions conventions, boolean applyEOPCorr, boolean simpleEOP) throws OrekitException {
        Class<FramesFactory> clazz = FramesFactory.class;
        synchronized (FramesFactory.class) {
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = applyEOPCorr ? (simpleEOP ? Predefined.GTOD_CONVENTIONS_1996_SIMPLE_EOP : Predefined.GTOD_CONVENTIONS_1996_ACCURATE_EOP) : Predefined.GTOD_WITHOUT_EOP_CORRECTIONS;
                    break;
                }
                case IERS_2003: {
                    factoryKey = simpleEOP ? Predefined.GTOD_CONVENTIONS_2003_SIMPLE_EOP : Predefined.GTOD_CONVENTIONS_2003_ACCURATE_EOP;
                    break;
                }
                case IERS_2010: {
                    factoryKey = simpleEOP ? Predefined.GTOD_CONVENTIONS_2010_SIMPLE_EOP : Predefined.GTOD_CONVENTIONS_2010_ACCURATE_EOP;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            FactoryManagedFrame frame = FRAMES.get((Object)factoryKey);
            if (frame == null) {
                FactoryManagedFrame tod = FramesFactory.getTOD(conventions, applyEOPCorr, simpleEOP);
                ShiftingTransformProvider todInterpolating = (ShiftingTransformProvider)tod.getTransformProvider();
                TODProvider todRaw = (TODProvider)todInterpolating.getRawProvider();
                EOPHistory eopHistory = todRaw.getEOPHistory();
                GTODProvider gtodRaw = new GTODProvider(conventions, eopHistory);
                ShiftingTransformProvider gtodShifting = new ShiftingTransformProvider(gtodRaw, CartesianDerivativesFilter.USE_PVA, AngularDerivativesFilter.USE_R, todInterpolating.getGridPoints(), todInterpolating.getStep(), OrekitConfiguration.getCacheSlotsNumber(), 3.15576E7, 2592000.0);
                frame = new FactoryManagedFrame((Frame)tod, (TransformProvider)gtodShifting, false, factoryKey);
                FRAMES.put(factoryKey, frame);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return frame;
        }
    }

    public static FactoryManagedFrame getTOD(boolean applyEOPCorr) throws OrekitException {
        return FramesFactory.getTOD(IERSConventions.IERS_1996, applyEOPCorr, false);
    }

    public static FactoryManagedFrame getTOD(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
        return FramesFactory.getTOD(conventions, true, simpleEOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FactoryManagedFrame getTOD(IERSConventions conventions, boolean applyEOPCorr, boolean simpleEOP) throws OrekitException {
        Class<FramesFactory> clazz = FramesFactory.class;
        synchronized (FramesFactory.class) {
            int pointsPerDay;
            int interpolationPoints;
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = applyEOPCorr ? (simpleEOP ? Predefined.TOD_CONVENTIONS_1996_SIMPLE_EOP : Predefined.TOD_CONVENTIONS_1996_ACCURATE_EOP) : Predefined.TOD_WITHOUT_EOP_CORRECTIONS;
                    break;
                }
                case IERS_2003: {
                    factoryKey = simpleEOP ? Predefined.TOD_CONVENTIONS_2003_SIMPLE_EOP : Predefined.TOD_CONVENTIONS_2003_ACCURATE_EOP;
                    break;
                }
                case IERS_2010: {
                    factoryKey = simpleEOP ? Predefined.TOD_CONVENTIONS_2010_SIMPLE_EOP : Predefined.TOD_CONVENTIONS_2010_ACCURATE_EOP;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            if (applyEOPCorr) {
                interpolationPoints = 6;
                pointsPerDay = 24;
            } else {
                interpolationPoints = 6;
                pointsPerDay = 8;
            }
            FactoryManagedFrame frame = FRAMES.get((Object)factoryKey);
            if (frame == null) {
                EOPHistory eopHistory = applyEOPCorr ? FramesFactory.getEOPHistory(conventions, simpleEOP) : null;
                ShiftingTransformProvider shifting = new ShiftingTransformProvider(new TODProvider(conventions, eopHistory), CartesianDerivativesFilter.USE_PVA, AngularDerivativesFilter.USE_R, interpolationPoints, 86400.0 / (double)pointsPerDay, OrekitConfiguration.getCacheSlotsNumber(), 3.15576E7, 2592000.0);
                frame = new FactoryManagedFrame((Frame)FramesFactory.getMOD(conventions, applyEOPCorr), (TransformProvider)shifting, true, factoryKey);
                FRAMES.put(factoryKey, frame);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return frame;
        }
    }

    public static FactoryManagedFrame getMOD(boolean applyEOPCorr) throws OrekitException {
        return FramesFactory.getMOD(IERSConventions.IERS_1996, applyEOPCorr);
    }

    public static FactoryManagedFrame getMOD(IERSConventions conventions) throws OrekitException {
        return FramesFactory.getMOD(conventions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FactoryManagedFrame getMOD(IERSConventions conventions, boolean applyEOPCorr) throws OrekitException {
        Class<FramesFactory> clazz = FramesFactory.class;
        synchronized (FramesFactory.class) {
            Frame parent;
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = applyEOPCorr ? Predefined.MOD_CONVENTIONS_1996 : Predefined.MOD_WITHOUT_EOP_CORRECTIONS;
                    parent = applyEOPCorr ? FramesFactory.getGCRF() : FramesFactory.getEME2000();
                    break;
                }
                case IERS_2003: {
                    factoryKey = Predefined.MOD_CONVENTIONS_2003;
                    parent = FramesFactory.getEME2000();
                    break;
                }
                case IERS_2010: {
                    factoryKey = Predefined.MOD_CONVENTIONS_2010;
                    parent = FramesFactory.getEME2000();
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            FactoryManagedFrame frame = FRAMES.get((Object)factoryKey);
            if (frame == null) {
                frame = new FactoryManagedFrame(parent, (TransformProvider)new MODProvider(conventions), true, factoryKey);
                FRAMES.put(factoryKey, frame);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FactoryManagedFrame getTEME() throws OrekitException {
        Class<FramesFactory> clazz = FramesFactory.class;
        synchronized (FramesFactory.class) {
            Predefined factoryKey = Predefined.TEME;
            FactoryManagedFrame frame = FRAMES.get((Object)factoryKey);
            if (frame == null) {
                FactoryManagedFrame tod = FramesFactory.getTOD(IERSConventions.IERS_1996, false, true);
                ShiftingTransformProvider todShifting = (ShiftingTransformProvider)tod.getTransformProvider();
                TEMEProvider temeRaw = new TEMEProvider(IERSConventions.IERS_1996, null);
                ShiftingTransformProvider temeShifting = new ShiftingTransformProvider(temeRaw, CartesianDerivativesFilter.USE_PVA, AngularDerivativesFilter.USE_R, todShifting.getGridPoints(), todShifting.getStep(), OrekitConfiguration.getCacheSlotsNumber(), 3.15576E7, 2592000.0);
                frame = new FactoryManagedFrame((Frame)tod, (TransformProvider)temeShifting, true, factoryKey);
                FRAMES.put(factoryKey, frame);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return frame;
        }
    }

    public static Transform getNonInterpolatingTransform(Frame from, Frame to, AbsoluteDate date) throws OrekitException {
        Frame currentF;
        Frame currentT;
        Frame frame = currentT = from.getDepth() > to.getDepth() ? to : to.getAncestor(to.getDepth() - from.getDepth());
        for (currentF = from.getDepth() > to.getDepth() ? from.getAncestor(from.getDepth() - to.getDepth()) : from; currentF != currentT; currentF = currentF.getParent(), currentT = currentT.getParent()) {
        }
        Frame common = currentF;
        Transform commonToOrigin = Transform.IDENTITY;
        for (Frame frame2 = from; frame2 != common; frame2 = frame2.getParent()) {
            commonToOrigin = new Transform(date, FramesFactory.peel(frame2.getTransformProvider()).getTransform(date), commonToOrigin);
        }
        Transform commonToDestination = Transform.IDENTITY;
        for (Frame frame3 = to; frame3 != common; frame3 = frame3.getParent()) {
            commonToDestination = new Transform(date, FramesFactory.peel(frame3.getTransformProvider()).getTransform(date), commonToDestination);
        }
        return new Transform(date, commonToOrigin.getInverse(), commonToDestination);
    }

    public static <T extends RealFieldElement<T>> FieldTransform<T> getNonInterpolatingTransform(Frame from, Frame to, FieldAbsoluteDate<T> date) throws OrekitException {
        Frame currentF;
        Frame currentT;
        Frame frame = currentT = from.getDepth() > to.getDepth() ? to : to.getAncestor(to.getDepth() - from.getDepth());
        for (currentF = from.getDepth() > to.getDepth() ? from.getAncestor(from.getDepth() - to.getDepth()) : from; currentF != currentT; currentF = currentF.getParent(), currentT = currentT.getParent()) {
        }
        Frame common = currentF;
        FieldTransform<T> commonToOrigin = FieldTransform.getIdentity(date.getField());
        for (Frame frame2 = from; frame2 != common; frame2 = frame2.getParent()) {
            commonToOrigin = new FieldTransform<T>(date, FramesFactory.peel(frame2.getTransformProvider()).getTransform(date), commonToOrigin);
        }
        FieldTransform<T> commonToDestination = FieldTransform.getIdentity(date.getField());
        for (Frame frame3 = to; frame3 != common; frame3 = frame3.getParent()) {
            commonToDestination = new FieldTransform<T>(date, FramesFactory.peel(frame3.getTransformProvider()).getTransform(date), commonToDestination);
        }
        return new FieldTransform<T>(date, commonToOrigin.getInverse(), commonToDestination);
    }

    public static EOPHistory findEOP(Frame start) {
        for (Frame frame = start; frame != null; frame = frame.getParent()) {
            TransformProvider peeled = frame.getTransformProvider();
            boolean peeling = true;
            while (peeling) {
                if (peeled instanceof InterpolatingTransformProvider) {
                    peeled = ((InterpolatingTransformProvider)peeled).getRawProvider();
                    continue;
                }
                if (peeled instanceof ShiftingTransformProvider) {
                    peeled = ((ShiftingTransformProvider)peeled).getRawProvider();
                    continue;
                }
                if (peeled instanceof EOPBasedTransformProvider && ((EOPBasedTransformProvider)peeled).getEOPHistory() != null) {
                    return ((EOPBasedTransformProvider)peeled).getEOPHistory();
                }
                peeling = false;
            }
        }
        return null;
    }

    private static TransformProvider peel(TransformProvider provider) throws OrekitException {
        TransformProvider peeled = provider;
        boolean peeling = true;
        while (peeling) {
            if (peeled instanceof InterpolatingTransformProvider) {
                peeled = ((InterpolatingTransformProvider)peeled).getRawProvider();
                continue;
            }
            if (peeled instanceof ShiftingTransformProvider) {
                peeled = ((ShiftingTransformProvider)peeled).getRawProvider();
                continue;
            }
            if (peeled instanceof EOPBasedTransformProvider && ((EOPBasedTransformProvider)peeled).getEOPHistory() != null && ((EOPBasedTransformProvider)peeled).getEOPHistory().usesInterpolation()) {
                peeled = ((EOPBasedTransformProvider)peeled).getNonInterpolatingProvider();
                continue;
            }
            peeling = false;
        }
        return peeled;
    }

    private static class ITRFKey
    implements Serializable {
        private static final long serialVersionUID = 20180412L;
        private final ITRFVersion version;
        private final IERSConventions conventions;
        private final boolean simpleEOP;

        ITRFKey(ITRFVersion version, IERSConventions conventions, boolean simpleEOP) {
            this.version = version;
            this.conventions = conventions;
            this.simpleEOP = simpleEOP;
        }

        public int hashCode() {
            return (this.version.ordinal() << 5) + (this.conventions.ordinal() << 1) + (this.simpleEOP ? 0 : 1);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof ITRFKey) {
                ITRFKey key = (ITRFKey)other;
                return this.version == key.version && this.conventions == key.conventions && this.simpleEOP == key.simpleEOP;
            }
            return false;
        }
    }
}

