/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public enum OceanLoadDeformationCoefficients {
    IERS_1996{

        @Override
        public double[] getCoefficients() {
            return new double[]{0.0, 0.0, -0.3075, -0.195, -0.132, -0.1032, -0.0892};
        }
    }
    ,
    IERS_2003{

        @Override
        public double[] getCoefficients() {
            return new double[]{0.0, 0.0, -0.3075, -0.195, -0.132, -0.1032, -0.0892};
        }
    }
    ,
    IERS_2010{

        @Override
        public double[] getCoefficients() {
            return new double[]{0.0, 0.0, -0.3075, -0.195, -0.132, -0.1032, -0.0892};
        }
    }
    ,
    GEGOUT{
        private static final String RESOURCE_NAME = "/assets/org/orekit/fic.love.kp.gegout";
        private static final String INTEGER_TYPE_PATTERN = "[-+]?\\p{Digit}+";
        private static final String REAL_TYPE_PATTERN = "[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?";

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public double[] getCoefficients() throws OrekitException {
            InputStream stream = OceanLoadDeformationCoefficients.class.getResourceAsStream(RESOURCE_NAME);
            if (stream == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, RESOURCE_NAME);
            }
            StringBuilder builder = new StringBuilder("^\\p{Space}*");
            builder.append("(").append(INTEGER_TYPE_PATTERN).append(")");
            builder.append("\\p{Space}+");
            builder.append("(").append(REAL_TYPE_PATTERN).append(")");
            builder.append("\\p{Space}*$");
            Pattern regularLinePattern = Pattern.compile(builder.toString());
            int lineNumber = 0;
            String line = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                lineNumber = 0;
                int maxDegree = 0;
                HashMap<Integer, Double> map = new HashMap<Integer, Double>();
                line = reader.readLine();
                while (line != null) {
                    ++lineNumber;
                    Matcher regularMatcher = regularLinePattern.matcher(line);
                    if (regularMatcher.matches()) {
                        int degree = Integer.parseInt(regularMatcher.group(1));
                        double coefficient = Double.parseDouble(regularMatcher.group(2));
                        map.put(degree, coefficient);
                        maxDegree = FastMath.max((int)maxDegree, (int)degree);
                    }
                    line = reader.readLine();
                }
                double[] coefficients = new double[maxDegree + 1];
                for (Map.Entry entry : map.entrySet()) {
                    coefficients[((Integer)entry.getKey()).intValue()] = (Double)entry.getValue();
                }
                Object object = coefficients;
                return object;
            }
            catch (NumberFormatException nfe) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, RESOURCE_NAME, line);
            }
            catch (IOException ioe) {
                throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
            }
        }
    };


    public abstract double[] getCoefficients() throws OrekitException;
}

